;-------------------------------------------------;
;   EDGENET ROUTINE - TWIN OF COMMAND EDGESURF    ;
;-------------------------------------------------;
;   Author : Marko Ribar, d.i.a. (architect)      ;
;   Copyright (C) - All rights reserved, 11.2019. ;
;-------------------------------------------------;
;   You have permission to copy any part of code  ;
;   with guarantee that this header will be       ;
;   present in material that is modified or       ;
;   partly remained the same as in this routine   ;
;   version. If header is removed, you are        ;
;   responsible to mention author and link from   ;
;   where the code is publiced with explicit      ;
;   mark that material is copyrighted and is not  ;
;   for further distribution or selling or base   ;
;   for gaining any material or any other benefit ;
;   than for learning and study and eventual      ;
;   improvement of its present functionality.     ;
;-------------------------------------------------;
(defun c:edgenet-newest (/ *error* *adoc* reversecurve oldheavyfit2lw etouchchk eorientfix v1v2-i1i2 e1f e2f e3f e4f e1 e2 e3 e4 c1 c2 c3 c4 c1f c2f c3f c4f m n dxe1 dxe2 dxe3 dxe4 k j p1 p2 p3 p4 i1 i2 i3 i4 i13 i42 p13 p42 p pl pmsh)
(vl-load-com)
(defun *error* (m)
  (if (and e1f (not (vlax-erased-p e1))) (entdel e1))
  (if (and e2f (not (vlax-erased-p e2))) (entdel e2))
  (if (and e3f (not (vlax-erased-p e3))) (entdel e3))
  (if (and e4f (not (vlax-erased-p e4))) (entdel e4))
  (if (and c1f (not (vlax-erased-p c1))) (entdel c1))
  (if (and c2f (not (vlax-erased-p c2))) (entdel c2))
  (if (and c3f (not (vlax-erased-p c3))) (entdel c3))
  (if (and c4f (not (vlax-erased-p c4))) (entdel c4))
  (vla-endundomark *adoc*)
  (vla-regen *adoc* acactiveviewport)
  (if m (prompt m))
  (princ)
)
(defun reversecurve (curve / rlw r3dp rhpl rspl rhel rli rell)
  (defun rlw (LW / E X1 X2 X3 X4 X5 X6)
    ;; by ElpanovEvgeniy
    (if (= (cdr (assoc 0 (setq e (entget lw)))) "LWPOLYLINE")
      (progn
        (foreach a1 e
          (cond ((= (car a1) 10) (setq x2 (cons a1 x2)))
                ((= (car a1) 40) (setq x4 (cons (cons 41 (cdr a1)) x4)))
                ((= (car a1) 41) (setq x3 (cons (cons 40 (cdr a1)) x3)))
                ((= (car a1) 42) (setq x5 (cons (cons 42 (- (cdr a1))) x5)))
                ((= (car a1) 210) (setq x6 (cons a1 x6)))
                (t (setq x1 (cons a1 x1)))
          )
        )
        (entmod (append (reverse x1)
                  (append (apply 'append
                            (apply 'mapcar
                              (cons 'list
                                (list x2
                                  (cdr (reverse (cons (car x3) (reverse x3))))
                                  (cdr (reverse (cons (car x4) (reverse x4))))
                                  (cdr (reverse (cons (car x5) (reverse x5))))
                                )
                              )
                            )
                          )
                          x6
                  )
                )
        )
        (entupd lw)
      )
    )
  )
  ;; Reverse HELIX - Marko Ribar, d.i.a.
  (defun rhel (hel / enx enx1 enx2 v x1 x2 x3)
    (if (= (cdr (assoc 0 (setq enx (entget hel)))) "HELIX")
      (progn
        (setq enx1 (reverse (cdr (member '(100 . "AcDbHelix") (reverse enx)))) enx2 (member '(100 . "AcDbHelix") enx))
        (foreach a1 enx1
          (cond
            ((= (car a1) 40) (setq x2 (cons a1 x2)))
            ((= (car a1) 10) (setq x3 (cons a1 x3)))
            (t (setq x1 (cons a1 x1)))
          )
        )
        (setq enx2 (subst (cons 40 (distance (cdr (assoc 10 enx2)) (cdr (assoc 11 enx2)))) (assoc 40 enx2) enx2) enx2 (subst (cons 10 (mapcar '+ (cdr (assoc 10 enx2)) (mapcar '* (cdr (assoc 12 enx2)) (list (* (cdr (assoc 41 enx2)) (cdr (assoc 42 enx2))) (* (cdr (assoc 41 enx2)) (cdr (assoc 42 enx2))) (* (cdr (assoc 41 enx2)) (cdr (assoc 42 enx2))))))) (assoc 10 enx2) enx2) enx2 (subst (cons 11 (cdr (car x3))) (assoc 11 enx2) enx2) enx2 (subst (cons 12 (mapcar '- (cdr (assoc 12 enx2)))) (assoc 12 enx2) enx2))
        (entmod (append (reverse x1) (mapcar '(lambda (x) (cons 40 (- (cdar x2) (cdr x)))) x2) x3 enx2))
        (entupd hel)
      )
    )
  )
  ;; Reverse LINE - Marko Ribar, d.i.a.
  (defun rli (li / enx sp ep)
    (if (= (cdr (assoc 0 (setq enx (entget li)))) "LINE")
      (progn
        (setq sp (cdr (assoc 10 enx)) ep (cdr (assoc 11 enx)) enx (subst (cons 10 ep) (assoc 10 enx) enx) enx (subst (cons 11 sp) (assoc 11 enx) enx))
        (entmod enx)
        (entupd li)
      )
    )
  )
  ;; Reverse SPLINE - Marko Ribar, d.i.a.
  (defun rspl (spl / enx x12 x13 x1 x2 x3 x4 x5)
    (if (= (cdr (assoc 0 (setq enx (entget spl)))) "SPLINE")
      (progn
        (foreach a1 enx
          (cond
            ((= (car a1) 12) (setq x13 (cons (cons 13 (mapcar '- (cdr a1))) x13)))
            ((= (car a1) 13) (setq x12 (cons (cons 12 (mapcar '- (cdr a1))) x12)))
            ((= (car a1) 40) (setq x2 (cons a1 x2)))
            ((= (car a1) 10) (setq x3 (cons a1 x3)))
            ((= (car a1) 41) (setq x4 (cons a1 x4)))
            ((= (car a1) 11) (setq x5 (cons a1 x5)))
            (t (setq x1 (cons a1 x1)))
          )
        )
        (entmod (append (reverse x1) x12 x13 (mapcar '(lambda (x) (cons 40 (- (cdar x2) (cdr x)))) x2) (if x4 (apply 'append (mapcar '(lambda (a b) (list a b)) x3 x4)) x3) x5))
        (entupd spl)
      )
    )
  )
  ;; Reverse 3DPOLYLINE - Marko Ribar, d.i.a.
  (defun r3dp (3dp / r3dppol typ)
    (defun r3dppol (3dp / v p pl sfa var)
      (setq v 3dp)
      (while (= (cdr (assoc 0 (entget (setq v (entnext v))))) "VERTEX")
        (setq p (cdr (assoc 10 (entget v))) pl (cons p pl))
      )
      (setq pl (apply 'append pl) sfa (vlax-make-safearray vlax-vbdouble (cons 0 (1- (length pl)))))
      (vlax-safearray-fill sfa pl)
      (setq var (vlax-make-variant sfa))
      (vla-put-coordinates (vlax-ename->vla-object 3dp) var)
      (entupd 3dp)
    )
    (setq typ (vla-get-type (vlax-ename->vla-object 3dp)))
    (vla-put-type (vlax-ename->vla-object 3dp) acsimplepoly)
    (r3dppol 3dp)
    (if typ (vla-put-type (vlax-ename->vla-object 3dp) typ))
    (entupd 3dp)
  )
  ;; Reverse old heavy 2d POLYLINE - Marko Ribar, d.i.a. - sub functions by Roy at Theswamp.org
  (defun rhpl (hpl / KGA_List_Divide_3 KGA_List_IndexSeqMakeLength KGA_Geom_PolylineReverse)
    (defun KGA_List_Divide_3 (lst / ret)
      (repeat (/ (length lst) 3)
        (setq ret (cons (list (car lst) (cadr lst) (caddr lst)) ret) lst (cdddr lst))
      )
      (reverse ret)
    )
    ; Make a zero based list of integers.
    (defun KGA_List_IndexSeqMakeLength (len / ret)
      (repeat (rem len 4)
        (setq ret (cons (setq len (1- len)) ret))
      )
      (repeat (/ len 4)
        (setq ret (vl-list* (- len 4) (- len 3) (- len 2) (- len 1) ret) len (- len 4))
      )
      ret
    )
    ; Obj must be an "AcDb2dPolyline" of the acsimplepoly type or an "AcDbPolyline".
    (defun KGA_Geom_PolylineReverse (obj / typ bulgeLst idxLst ptLst widLst conWid v vx)
      (setq typ (vla-get-type obj))
      (vla-put-type obj acsimplepoly)
      (setq ptLst (KGA_List_Divide_3 (vlax-get obj 'coordinates)) idxLst (KGA_List_IndexSeqMakeLength (1+ (length ptLst))) v (vlax-vla-object->ename obj))
      (while (= (cdr (assoc 0 (setq vx (entget (setq v (entnext v)))))) "VERTEX")
        (setq widLst (cons (list (cdr (assoc 40 vx)) (cdr (assoc 41 vx))) widLst) bulgeLst (cons (cdr (assoc 42 vx)) bulgeLst))
      )
      (if (vl-catch-all-error-p (setq conWid (vl-catch-all-apply 'vla-get-constantwidth (list obj))))
        (mapcar
         '(lambda (idx pt bulge widSub) (vla-put-coordinate obj idx (vlax-3d-point pt)) (vla-setbulge obj idx (- bulge)) (vla-setwidth obj idx (cadr widSub) (car widSub))) idxLst (reverse ptLst) (append (cdr bulgeLst) (list (car bulgeLst))) (append (cdr widLst) (list (car widLst)))
        )
        (progn
          (mapcar
           '(lambda (idx pt bulge widSub) (vla-put-coordinate obj idx (vlax-3d-point pt)) (vla-setbulge obj idx (- bulge))) idxLst (reverse ptLst) (append (cdr bulgeLst) (list (car bulgeLst)))
          )
          (vla-put-constantwidth obj conWid)
        )
      )
      (if typ (vla-put-type obj typ))
    )
    (KGA_Geom_PolylineReverse (vlax-ename->vla-object hpl))
    (entupd hpl)
  )
  (defun rell (ell / ELL:point->param ellx ocs p1 p2 dxf dxf41 dxf42)
    (defun ELL:point->param ( dxf pnt / ang ocs )
      (setq ocs (cdr (assoc 210 dxf))
            ang (- (angle (trans (cdr (assoc 10 dxf)) 0 ocs) (trans pnt 0 ocs))
                   (angle '(0.0 0.0) (trans (cdr (assoc 11 dxf)) 0 ocs))
                )
      )
      (atan (sin ang) (* (cdr (assoc 40 dxf)) (cos ang)))
    )
    (setq ellx (entget ell))
    (setq ocs (cdr (assoc 210 ellx)))
    (setq p1 (vlax-curve-getstartpoint ell) p2 (vlax-curve-getendpoint ell))
    (setq dxf (list (assoc 10 ellx) (assoc 11 ellx) (assoc 40 ellx) (cons 210 (mapcar '- ocs))))
    (setq dxf41 (ELL:point->param dxf p2) dxf42 (ELL:point->param dxf p1))
    (setq ellx (subst (cons 41 dxf41) (assoc 41 ellx) ellx))
    (setq ellx (subst (cons 42 dxf42) (assoc 42 ellx) ellx))
    (setq ellx (subst (cons 210 (mapcar '- ocs)) (assoc 210 ellx) ellx))
    (entupd (cdr (assoc -1 (entmod ellx))))
  )
  (cond
    ((= (cdr (assoc 100 (reverse (entget curve)))) "AcDbLine") (rli curve))
    ((= (cdr (assoc 100 (reverse (entget curve)))) "AcDbHelix") (rhel curve))
    ((= (cdr (assoc 100 (reverse (entget curve)))) "AcDb2dPolyline") (rhpl curve))
    ((= (cdr (assoc 100 (reverse (entget curve)))) "AcDb3dPolyline") (r3dp curve))
    ((= (cdr (assoc 100 (reverse (entget curve)))) "AcDbPolyline") (rlw curve))
    ((= (cdr (assoc 100 (reverse (entget curve)))) "AcDbSpline") (rspl curve))
    ((= (cdr (assoc 100 (reverse (entget curve)))) "AcDbEllipse") (rell curve))
  )
)
(defun oldheavyfit2lw (pl / ss pea)
  (vl-cmdf "_.EXPLODE" pl)
  (while (< 0 (getvar 'cmdactive)) (vl-cmdf ""))
  (setq ss (ssget "_P") pea (getvar 'peditaccept))
  (setvar 'peditaccept 1)
  (vl-cmdf "_.PEDIT" "_M" ss "" "_J" "_J" "_E" 0.0)
  (while (< 0 (getvar 'cmdactive)) (vl-cmdf ""))
  (setvar 'peditaccept pea)
  (entlast)
)
(defun etouchchk (e1 e2 e3 e4 / unique pe1s pe1e pe2s pe2e pe3s pe3e pe4s pe4e)
  (defun unique (l) (if l (cons (car l) (unique (vl-remove-if '(lambda (x) (equal (car l) x 1e-6)) l)))))
  (setq pe1s (vlax-curve-getstartpoint e1) pe1e (vlax-curve-getendpoint e1) pe2s (vlax-curve-getstartpoint e2) pe2e (vlax-curve-getendpoint e2) pe3s (vlax-curve-getstartpoint e3) pe3e (vlax-curve-getendpoint e3) pe4s (vlax-curve-getstartpoint e4) pe4e (vlax-curve-getendpoint e4))
  (if (= (length (unique (list pe1s pe1e pe2s pe2e))) 4) (progn (prompt "\nEdge 1 doesn't touch edge 2... Quitting...") (exit)))
  (if (= (length (unique (list pe2s pe2e pe3s pe3e))) 4) (progn (prompt "\nEdge 2 doesn't touch edge 3... Quitting...") (exit)))
  (if (= (length (unique (list pe3s pe3e pe4s pe4e))) 4) (progn (prompt "\nEdge 3 doesn't touch edge 4... Quitting...") (exit)))
  (if (= (length (unique (list pe4s pe4e pe1s pe1e))) 4) (progn (prompt "\nEdge 4 doesn't touch edge 1... Quitting...") (exit)))
)
(defun eorientfix (e1 e2 e3 e4 / cmde pe1s pe1e pe2s pe2e pe3s pe3e pe4s pe4e)
  (setq cmde (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (cond
    ((and (equal (vlax-curve-getstartpoint e1) (vlax-curve-getendpoint e1) 1e-6) (vl-every '(lambda (e) (not (equal (vlax-curve-getstartpoint e) (vlax-curve-getendpoint e)))) (list e2 e3 e4)))
     (if (not (equal (vlax-curve-getstartpoint e2) (vlax-curve-getendpoint e1) 1e-6)) (reversecurve e2))
     (if (not (equal (vlax-curve-getstartpoint e3) (vlax-curve-getendpoint e2) 1e-6)) (reversecurve e3))
     (if (not (equal (vlax-curve-getstartpoint e4) (vlax-curve-getendpoint e3) 1e-6)) (reversecurve e4))
    )
    ((and (equal (vlax-curve-getstartpoint e2) (vlax-curve-getendpoint e2) 1e-6) (vl-every '(lambda (e) (not (equal (vlax-curve-getstartpoint e) (vlax-curve-getendpoint e)))) (list e1 e3 e4)))
     (if (not (equal (vlax-curve-getstartpoint e3) (vlax-curve-getendpoint e2) 1e-6)) (reversecurve e3))
     (if (not (equal (vlax-curve-getstartpoint e4) (vlax-curve-getendpoint e3) 1e-6)) (reversecurve e4))
     (if (not (equal (vlax-curve-getendpoint e1) (vlax-curve-getendpoint e2) 1e-6)) (reversecurve e1))
    )
    ((and (equal (vlax-curve-getstartpoint e3) (vlax-curve-getendpoint e3) 1e-6) (vl-every '(lambda (e) (not (equal (vlax-curve-getstartpoint e) (vlax-curve-getendpoint e)))) (list e1 e2 e4)))
     (if (not (equal (vlax-curve-getstartpoint e4) (vlax-curve-getendpoint e3) 1e-6)) (reversecurve e4))
     (if (not (equal (vlax-curve-getstartpoint e1) (vlax-curve-getendpoint e4) 1e-6)) (reversecurve e1))
     (if (not (equal (vlax-curve-getstartpoint e2) (vlax-curve-getendpoint e1) 1e-6)) (reversecurve e2))
    )
    ((and (equal (vlax-curve-getstartpoint e4) (vlax-curve-getendpoint e4) 1e-6) (vl-every '(lambda (e) (not (equal (vlax-curve-getstartpoint e) (vlax-curve-getendpoint e)))) (list e1 e2 e3)))
     (if (not (equal (vlax-curve-getstartpoint e1) (vlax-curve-getendpoint e4) 1e-6)) (reversecurve e1))
     (if (not (equal (vlax-curve-getstartpoint e2) (vlax-curve-getendpoint e1) 1e-6)) (reversecurve e2))
     (if (not (equal (vlax-curve-getstartpoint e3) (vlax-curve-getendpoint e2) 1e-6)) (reversecurve e3))
    )
    ((and (equal (vlax-curve-getstartpoint e1) (vlax-curve-getendpoint e1) 1e-6) (equal (vlax-curve-getstartpoint e3) (vlax-curve-getendpoint e3) 1e-6) (vl-every '(lambda (e) (not (equal (vlax-curve-getstartpoint e) (vlax-curve-getendpoint e)))) (list e2 e4)))
     (if (not (equal (vlax-curve-getstartpoint e2) (vlax-curve-getendpoint e1) 1e-6)) (reversecurve e2))
     (if (not (equal (vlax-curve-getendpoint e4) (vlax-curve-getendpoint e1) 1e-6)) (reversecurve e4))
    )
    ((and (equal (vlax-curve-getstartpoint e2) (vlax-curve-getendpoint e2) 1e-6) (equal (vlax-curve-getstartpoint e4) (vlax-curve-getendpoint e4) 1e-6) (vl-every '(lambda (e) (not (equal (vlax-curve-getstartpoint e) (vlax-curve-getendpoint e)))) (list e1 e3)))
     (if (not (equal (vlax-curve-getstartpoint e1) (vlax-curve-getendpoint e4) 1e-6)) (reversecurve e1))
     (if (not (equal (vlax-curve-getstartpoint e3) (vlax-curve-getendpoint e2) 1e-6)) (reversecurve e3))
    )
    ( t
      (setq pe1s (vlax-curve-getstartpoint e1) pe1e (vlax-curve-getendpoint e1) pe2s (vlax-curve-getstartpoint e2) pe2e (vlax-curve-getendpoint e2))
      (if (or (and (not (equal pe1e pe2s 1e-6)) (equal pe1e pe2e 1e-6)) (and (not (equal pe1s pe2e 1e-6)) (equal pe1s pe2s 1e-6))) (progn (reversecurve e2) (setq pe2s (vlax-curve-getstartpoint e2) pe2e (vlax-curve-getendpoint e2))))
      (setq pe3s (vlax-curve-getstartpoint e3) pe3e (vlax-curve-getendpoint e3))
      (if (or (and (not (equal pe2e pe3s 1e-6)) (equal pe2e pe3e 1e-6)) (and (not (equal pe2s pe3e 1e-6)) (equal pe2s pe3s 1e-6))) (progn (reversecurve e3) (setq pe3s (vlax-curve-getstartpoint e3) pe3e (vlax-curve-getendpoint e3))))
      (setq pe4s (vlax-curve-getstartpoint e4) pe4e (vlax-curve-getendpoint e4))
      (if (or (and (not (equal pe3e pe4s 1e-6)) (equal pe3e pe4e 1e-6)) (and (not (equal pe3s pe4e 1e-6)) (equal pe3s pe4s 1e-6))) (reversecurve e4))
    )
  )
  (setvar 'cmdecho cmde)
)
(defun v1v2-i1i2 (v1 v2 i1 i2 / v1i1 v2i2)
  (setq v1i1 (mapcar '(lambda ( v ) (* v i1)) v1) v2i2 (mapcar '(lambda ( v ) (* v i2)) v2))
  (mapcar '(lambda ( a b ) (+ a b)) v1i1 v2i2)
)
 
(vla-startundomark (setq *adoc* (vla-get-activedocument (vlax-get-acad-object))))
(while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 1st edge of NET...") (not (setq c1 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c1 (vlax-curve-isclosed (ssname c1 0))))
  (prompt "\nMissed or picked curve isn't open... Please pick 1st edge again and press ENTER ...")
  (textscr)
)
(if c1 (progn (setq c1 (ssname c1 0)) (redraw c1 3)))
(setq c1 (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object c1))) c1f t)
(setq e1 c1)
(cond
  ((= (cdr (assoc 0 (entget e1))) "ARC") (vl-cmdf "_.PEDIT" e1 "") (setq e1 (entlast) e1f t))
  ((and (= (cdr (assoc 0 (entget e1))) "POLYLINE") (or (= (cdr (assoc 70 (entget e1))) 0) (= (cdr (assoc 70 (entget e1))) 128))) (vl-cmdf "_.CONVERTPOLY" "_L" e1 ""))
  ((and (= (cdr (assoc 0 (entget e1))) "POLYLINE") (or (= (cdr (assoc 70 (entget e1))) 3) (= (cdr (assoc 70 (entget e1))) 130))) (setq e1 (oldheavyfit2lw e1) e1f t))
  ((and (= (cdr (assoc 0 (entget e1))) "POLYLINE") (/= (cdr (assoc 70 (entget e1))) 8)) (vl-cmdf "_.SPLINEDIT" e1 "") (while (< 0 (getvar 'cmdactive)) (vl-cmdf "")) (if (not (eq e1 (entlast))) (setq e1 (entlast) e1f t)))
)
(while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 2nd edge of NET...") (not (setq c2 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c2 (vlax-curve-isclosed (ssname c2 0))))
  (prompt "\nMissed or picked curve isn't open... Please pick 2nd edge again and press ENTER ...")
  (textscr)
)
(if c2 (progn (setq c2 (ssname c2 0)) (redraw c2 3)))
(setq c2 (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object c2))) c2f t)
(setq e2 c2)
(cond
  ((= (cdr (assoc 0 (entget e2))) "ARC") (vl-cmdf "_.PEDIT" e2 "") (setq e2 (entlast) e2f t))
  ((and (= (cdr (assoc 0 (entget e2))) "POLYLINE") (or (= (cdr (assoc 70 (entget e2))) 0) (= (cdr (assoc 70 (entget e2))) 128))) (vl-cmdf "_.CONVERTPOLY" "_L" e2 ""))
  ((and (= (cdr (assoc 0 (entget e2))) "POLYLINE") (or (= (cdr (assoc 70 (entget e2))) 3) (= (cdr (assoc 70 (entget e2))) 130))) (setq e2 (oldheavyfit2lw e2) e2f t))
  ((and (= (cdr (assoc 0 (entget e2))) "POLYLINE") (/= (cdr (assoc 70 (entget e2))) 8)) (vl-cmdf "_.SPLINEDIT" e2 "") (while (< 0 (getvar 'cmdactive)) (vl-cmdf "")) (if (not (eq e2 (entlast))) (setq e2 (entlast) e2f t)))
)
(while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 3rd edge of NET...") (not (setq c3 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c3 (vlax-curve-isclosed (ssname c3 0))))
  (prompt "\nMissed or picked curve isn't open... Please pick 3rd edge again and press ENTER ...")
  (textscr)
)
(if c3 (progn (setq c3 (ssname c3 0)) (redraw c3 3)))
(setq c3 (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object c3))) c3f t)
(setq e3 c3)
(cond
  ((= (cdr (assoc 0 (entget e3))) "ARC") (vl-cmdf "_.PEDIT" e3 "") (setq e3 (entlast) e3f t))
  ((and (= (cdr (assoc 0 (entget e3))) "POLYLINE") (or (= (cdr (assoc 70 (entget e3))) 0) (= (cdr (assoc 70 (entget e3))) 128))) (vl-cmdf "_.CONVERTPOLY" "_L" e3 ""))
  ((and (= (cdr (assoc 0 (entget e3))) "POLYLINE") (or (= (cdr (assoc 70 (entget e3))) 3) (= (cdr (assoc 70 (entget e3))) 130))) (setq e3 (oldheavyfit2lw e3) e3f t))
  ((and (= (cdr (assoc 0 (entget e3))) "POLYLINE") (/= (cdr (assoc 70 (entget e3))) 8)) (vl-cmdf "_.SPLINEDIT" e3 "") (while (< 0 (getvar 'cmdactive)) (vl-cmdf "")) (if (not (eq e3 (entlast))) (setq e3 (entlast) e3f t)))
)
(while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 4th edge of NET...") (not (setq c4 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c4 (vlax-curve-isclosed (ssname c4 0))))
  (prompt "\nMissed or picked curve isn't open... Please pick 4th edge again and press ENTER ...")
  (textscr)
)
(if c4 (progn (setq c4 (ssname c4 0)) (redraw c4 3)))
(setq c4 (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object c4))) c4f t)
(setq e4 c4)
(cond
  ((= (cdr (assoc 0 (entget e4))) "ARC") (vl-cmdf "_.PEDIT" e4 "") (setq e4 (entlast) e4f t))
  ((and (= (cdr (assoc 0 (entget e4))) "POLYLINE") (or (= (cdr (assoc 70 (entget e4))) 0) (= (cdr (assoc 70 (entget e4))) 128))) (vl-cmdf "_.CONVERTPOLY" "_L" e4 ""))
  ((and (= (cdr (assoc 0 (entget e4))) "POLYLINE") (or (= (cdr (assoc 70 (entget e4))) 3) (= (cdr (assoc 70 (entget e4))) 130))) (setq e4 (oldheavyfit2lw e4) e4f t))
  ((and (= (cdr (assoc 0 (entget e4))) "POLYLINE") (/= (cdr (assoc 70 (entget e4))) 8)) (vl-cmdf "_.SPLINEDIT" e4 "") (while (< 0 (getvar 'cmdactive)) (vl-cmdf "")) (if (not (eq e4 (entlast))) (setq e4 (entlast) e4f t)))
)
(etouchchk e1 e2 e3 e4)
(if (or (equal (vlax-curve-getstartpoint e1) (vlax-curve-getstartpoint e2) 1e-6) (equal (vlax-curve-getstartpoint e1) (vlax-curve-getendpoint e2) 1e-6))
  (mapcar 'set '(e1 e2 e3 e4) (list e1 e4 e3 e2))
)
(eorientfix e1 e2 e3 e4)
(initget 7) (setq m (getint "\nSpecify M number : ")) (initget 7) (setq n (getint "\nSpecify N number : "))
(setq dxe1 (/ (vlax-curve-getdistatparam e1 (vlax-curve-getendparam e1)) m) dxe2 (/ (vlax-curve-getdistatparam e2 (vlax-curve-getendparam e2)) n) dxe3 (/ (vlax-curve-getdistatparam e3 (vlax-curve-getendparam e3)) m) dxe4 (/ (vlax-curve-getdistatparam e4 (vlax-curve-getendparam e4)) n))
(setq k -1)
(repeat (1+ n)
  (setq k (1+ k) j -1)
  (repeat (1+ m)
    (setq j (1+ j))
    (cond
      ((= k 0) (setq p (vl-catch-all-apply 'vlax-curve-getpointatdist (list e1 (* dxe1 j)))) (if (or (null p) (vl-catch-all-error-p p)) (setq p (vlax-curve-getendpoint e1))))
      ((= j m) (setq p (vl-catch-all-apply 'vlax-curve-getpointatdist (list e2 (* dxe2 k)))) (if (or (null p) (vl-catch-all-error-p p)) (setq p (vlax-curve-getendpoint e2))))
      ((= k n) (setq p (vl-catch-all-apply 'vlax-curve-getpointatdist (list e3 (* dxe3 (- m j))))) (if (or (null p) (vl-catch-all-error-p p)) (setq p (vlax-curve-getendpoint e3))))
      ((= j 0) (setq p (vl-catch-all-apply 'vlax-curve-getpointatdist (list e4 (* dxe4 (- n k))))) (if (or (null p) (vl-catch-all-error-p p)) (setq p (vlax-curve-getendpoint e4))))
      ( t
        (setq p1 (vl-catch-all-apply 'vlax-curve-getpointatdist (list e1 (* dxe1 j))) p2 (vl-catch-all-apply 'vlax-curve-getpointatdist (list e2 (* dxe2 k))) p3 (vl-catch-all-apply 'vlax-curve-getpointatdist (list e3 (* dxe3 (- m j)))) p4 (vl-catch-all-apply 'vlax-curve-getpointatdist (list e4 (* dxe4 (- n k)))))
        (if (or (null p1) (vl-catch-all-error-p p1)) (setq p1 (vlax-curve-getendpoint e1))) (if (or (null p2) (vl-catch-all-error-p p2)) (setq p2 (vlax-curve-getendpoint e2))) (if (or (null p3) (vl-catch-all-error-p p3)) (setq p3 (vlax-curve-getendpoint e3))) (if (or (null p4) (vl-catch-all-error-p p4)) (setq p4 (vlax-curve-getendpoint e4)))
        (setq i1 (/ (- m j) (float m)) i2 (/ (- n k) (float n)) i3 (/ j (float m)) i4 (/ k (float n)))
        (setq p13 (v1v2-i1i2 p1 p3 i2 i4) p42 (v1v2-i1i2 p4 p2 i1 i3))
        (setq i13 (expt (+ (expt (/ (abs (- (/ n 2.0) k)) (/ n 2.0)) 2.0) 10.0) 40.0))
        (setq i42 (expt (+ (expt (/ (abs (- (/ m 2.0) j)) (/ m 2.0)) 2.0) 10.0) 40.0))
        (setq p (mapcar '(lambda ( a b ) (+ a b)) (mapcar '(lambda ( x ) (* x (/ i13 (+ i13 i42)))) p13) (mapcar '(lambda ( x ) (* x (/ i42 (+ i13 i42)))) p42)))
      )
    )
    (setq pl (cons p pl))
  )
)
(setq pmsh (entmakex (list '(0 . "POLYLINE") '(100 . "AcDbEntity") '(100 . "AcDbPolygonMesh") '(66 . 1) '(10 0.0 0.0 0.0) '(70 . 16) '(40 . 0.0) '(41 . 0.0) '(210 0.0 0.0 1.0) (cons 71 (1+ n)) (cons 72 (1+ m)) '(73 . 0) '(74 . 0) '(75 . 0))))
(foreach p pl
  (entmake (list '(0 . "VERTEX") '(100 . "AcDbEntity") '(100 . "AcDbVertex") '(100 . "AcDbPolygonMeshVertex") (cons 10 p) '(40 . 0.0) '(41 . 0.0) '(42 . 0.0) '(70 . 64) '(50 . 0.0) '(71 . 0) '(72 . 0) '(73 . 0) '(74 . 0)))
)
(entmake (list '(0 . "SEQEND") '(100 . "AcDbEntity") (cons -2 pmsh)))
(*error* nil)
)