(defun c:edgesurf-newest-surf ( / *error* *adoc* cmd c1 c2 c3 c4 m n st1 st2 el surf coords pl i l ll entlst ch)

  (or (not (vl-catch-all-error-p (vl-catch-all-apply 'vlax-get-acad-object nil))) (vl-load-com))

  (defun *error* (m)
    (if st1 (setvar 'surftab1 st1))
    (if st2 (setvar 'surftab2 st2))
    (if cmd (setvar 'cmdecho cmd))
    (vla-endundomark *adoc*)
    (vla-regen *adoc* acactiveviewport)
    (if m (prompt (strcat "\n" m)))
    (princ)
  )

  (vla-startundomark (setq *adoc* (vla-get-activedocument (vlax-get-acad-object))))
  (setq cmd (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 1st edge of NET...") (not (setq c1 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c1 (vlax-curve-isclosed (ssname c1 0))))
    (prompt "\nMissed or picked curve isn't open... Please pick 1st edge again and press ENTER ...")
    (textscr)
  )
  (if c1 (progn (setq c1 (ssname c1 0)) (redraw c1 3)))
  (while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 2nd edge of NET...") (not (setq c2 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c2 (vlax-curve-isclosed (ssname c2 0))))
    (prompt "\nMissed or picked curve isn't open... Please pick 2nd edge again and press ENTER ...")
    (textscr)
  )
  (if c2 (progn (setq c2 (ssname c2 0)) (redraw c2 3)))
  (while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 3rd edge of NET...") (not (setq c3 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c3 (vlax-curve-isclosed (ssname c3 0))))
    (prompt "\nMissed or picked curve isn't open... Please pick 3rd edge again and press ENTER ...")
    (textscr)
  )
  (if c3 (progn (setq c3 (ssname c3 0)) (redraw c3 3)))
  (while (or (prompt "\nPick OPEN edge drawn in CCW direction and press ENTER - 4th edge of NET...") (not (setq c4 (ssget "_:L" '((0 . "*POLYLINE,SPLINE,LINE,HELIX,ARC,ELLIPSE"))))) (if c4 (vlax-curve-isclosed (ssname c4 0))))
    (prompt "\nMissed or picked curve isn't open... Please pick 4th edge again and press ENTER ...")
    (textscr)
  )
  (if c4 (progn (setq c4 (ssname c4 0)) (redraw c4 3)))
  (initget 7) (setq m (getint "\nSpecify M number : ")) (initget 7) (setq n (getint "\nSpecify N number : "))
  (setq st1 (getvar 'surftab1) st2 (getvar 'surftab2))
  (mapcar 'setvar (list 'surftab1 'surftab2) (list m n))
  (setq el (entlast))
  (vl-cmdf "_.edgesurf" c1 c2 c3 c4)
  (while (< 0 (getvar 'cmdactive))
    (vl-cmdf "")
  )
  (if (not (eq el (setq surf (entlast))))
    (progn
      (setq coords (safearray-value (variant-value (vla-get-coordinates (vlax-ename->vla-object surf)))))
      (repeat (/ (length coords) 3)
        (setq pl (cons (list (car coords) (cadr coords) (caddr coords)) pl))
        (setq coords (cdddr coords))
      )
      (setq pl (reverse pl))
      (setq i -1)
      (repeat (1+ m)
        (repeat (1+ n)
          (setq l (cons (nth (setq i (1+ i)) pl) l))
        )
        (setq ll (cons l ll) l nil)
      )
      (foreach l ll
        (vl-cmdf "_.spline")
        (foreach p l
          (vl-cmdf "_non" p)
        )
        (while (< 0 (getvar 'cmdactive))
          (vl-cmdf "")
        )
        (setq entlst (cons (entlast) entlst))
      )
      (setq su (getvar 'surfu))
      (setvar 'surfu (1- m))
      (setq sv (getvar 'surfv))
      (setvar 'surfv (1- n))
      (vl-cmdf "_.loft" "_mo" "_su")
      (foreach c entlst
        (vl-cmdf c)
      )
      (while (< 0 (getvar 'cmdactive))
        (vl-cmdf "")
      )
      (if (= (strcase (getvar 'program)) "BRICSCAD")
        (progn
          (setpropertyvalue (entlast) "SurfaceUIsolines" (1- m))
          (setpropertyvalue (entlast) "SurfaceVIsolines" (1- n))
        )
      )
      (initget "Yes No")
      (setq ch (getkword "\nDo you want to erase helper spline entities and leave only mesh and surface entity [Yes/No] <Yes> : "))
      (if (not ch) (setq ch "Yes"))
      (if (= ch "Yes")
        (foreach c entlst
          (if (and c (not (vlax-erased-p c)))
            (entdel c)
          )
        )
      )
    )
    (alert "Something wrong... EDGESURF command unable to create poly mesh...")
  )
  (*error* nil)
)