(defun c:3dlines23dsolid ( / *error* unit v^v LM:RemoveNth region chain adoc s lil lill lilll plil plill ll li pli plli p1 p2 p3 p4 pp sg lx n planelil planeplil g pg gg regs ss pl pll ex  )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if adoc
      (vla-endundomark adoc)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun unit ( v )
    (if (not (equal v '(0.0 0.0 0.0) 1e-8))
      (mapcar (function (lambda ( x ) (/ x (distance '(0.0 0.0 0.0) v)))) v)
    )
  )

  (defun v^v ( u v )
    (list
      (- (* (cadr u) (caddr v)) (* (caddr u) (cadr v)))
      (- (* (caddr u) (car v)) (* (car u) (caddr v)))
      (- (* (car u) (cadr v)) (* (cadr u) (car v)))
    )
  )

  ;;----------------------=={ Remove Nth }==--------------------;;
  ;;                                                            ;;
  ;;  Removes the item at the nth index in a supplied list      ;;
  ;;------------------------------------------------------------;;
  ;;  Author: Lee Mac, Copyright  2011 - www.lee-mac.com       ;;
  ;;------------------------------------------------------------;;
  ;;  Arguments:                                                ;;
  ;;  n - index of item to remove (zero based)                  ;;
  ;;  l - list from which item is to be removed                 ;;
  ;;------------------------------------------------------------;;
  ;;  Returns:  List with item at index n removed               ;;
  ;;------------------------------------------------------------;;

  (defun LM:RemoveNth ( n l / i )
      (setq i -1)
      (vl-remove-if '(lambda ( x ) (= (setq i (1+ i)) n)) l)
  )

  (defun region ( arg / spc argl reg )

    (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

    (if adoc
      (setq spc (vla-get-block (vla-get-activelayout adoc)))
      (setq spc (vla-get-block (vla-get-activelayout (vla-get-activedocument (vlax-get-acad-object)))))
    )
    (cond
      ( (and (= (type arg) 'ename) (/= (cdr (assoc 0 (entget arg))) "REGION"))
        (setq reg (vl-catch-all-apply (function vlax-invoke) (list spc 'addregion (list (vlax-ename->vla-object arg)))))
      )
      ( (and (= (type arg) 'pickset) (setq argl (vl-remove-if (function (lambda ( x ) (= (cdr (assoc 0 (entget x))) "REGION"))) (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex arg))))))
        (setq reg (vl-catch-all-apply (function vlax-invoke) (list spc 'addregion (mapcar (function vlax-ename->vla-object) argl))))
      )
      ( (and (= (type arg) 'list) (setq arg (vl-remove-if (function (lambda ( x ) (= (cdr (assoc 0 (entget x))) "REGION"))) arg)))
        (setq reg (vl-catch-all-apply (function vlax-invoke) (list spc 'addregion (mapcar (function vlax-ename->vla-object) arg))))
      )
    )
    (if (and reg (not (vl-catch-all-error-p reg)))
      (vlax-vla-object->ename (car reg))
    )
  )

  (defun chain ( entst entlst / unique sp ep pl entpl entl loop entn ent p entll )

    (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

    (defun unique ( l )
      (if l (cons (car l) (unique (vl-remove-if (function (lambda ( x ) (equal x (car l) 1e-6))) l))))
    )

    (setq sp (vlax-curve-getstartpoint entst) ep (vlax-curve-getendpoint entst))
    (setq pl (cons sp pl) pl (cons ep pl))
    (setq entpl (mapcar (function (lambda ( x ) (list (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x) x))) (setq entlst (vl-remove entst entlst))))
    (setq entl (cons entst entl))
    (setq loop t)
    (while (or loop (/= (length pl) (length (setq pl (unique pl)))))
      (foreach p pl
        (setq entn (car (vl-member-if (function (lambda ( x ) (= (type x) 'ename))) (vl-member-if (function (lambda ( x ) (equal x p 1e-6))) (apply (function append) entpl)))))
        (if entn
          (progn
            (setq sp (vlax-curve-getstartpoint entn) ep (vlax-curve-getendpoint entn))
            (setq pl (cons sp pl) pl (cons ep pl))
            (if (not (vl-position entn entl))
              (progn
                (setq entl (cons entn entl))
                (setq entpl (vl-remove-if (function (lambda ( x ) (eq entn (caddr x)))) entpl))
              )
            )
          )
        )
      )
      (setq loop nil)
    )
    (foreach entp entpl
      (if (and (not (vl-position (caddr entp) entl)) (and (vl-member-if (function (lambda ( x ) (equal (car entp) x 1e-6))) pl) (vl-member-if (function (lambda ( x ) (equal (cadr entp) x 1e-6))) pl)))
        (setq entl (cons (caddr entp) entl))
      )
    )
    (setq entl (reverse entl))
    (while entl
      (setq ent (car entl))
      (setq entl (cdr entl))
      (if (null p)
        (setq p (vlax-curve-getendpoint ent))
        (setq p (if (equal p (vlax-curve-getstartpoint ent) 1e-6) (vlax-curve-getendpoint ent) (vlax-curve-getstartpoint ent)))
      )
      (setq entl (vl-sort entl (function (lambda ( a b ) (or (equal p (vlax-curve-getstartpoint a) 1e-6) (equal p (vlax-curve-getendpoint a) 1e-6))))))
      (setq entll (cons ent entll))
    )
    (reverse entll)
  )

  (vla-startundomark (setq adoc (vla-get-activedocument (vlax-get-acad-object))))
  (prompt "\nSelect 3D LINES...")
  (setq s (ssget "_:L" '((0 . "LINE"))))
  (while (or (not s) (and s (not (= (length (chain (ssname s 0) (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex s))))) (sslength s)))))
    (prompt "\nEmpty sel. set or some lines not connected with each other... Please retry selecting connected 3D LINE entities...")
    (setq s (ssget "_:L" '((0 . "LINE"))))
  )
  (setq lil (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex s))))
  (setq lilll lil)
  (foreach li lil
    (setq lil (cons (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object li))) lil))
  )
  (foreach li lilll
    (setq lil (cons (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object li))) lil))
  )
  (setq lill lil)
  (setq plil (mapcar (function (lambda ( x ) (list (cdr (assoc 10 (entget x))) (cdr (assoc 11 (entget x)))))) lil))
  (while (setq pli (car plil))
    (setq p1 nil p2 nil p3 nil)
    (while (or (not p3) (not (equal pli plli 1e-6)))
      (if (and (not p1) (not p2))
        (setq p1 (car pli) p2 (cadr pli))
      )
      (setq p3 (car (vl-remove-if (function (lambda ( x ) (equal p1 x 1e-6))) (setq ll (car (vl-member-if (function (lambda ( x ) (or (equal p1 (car x) 1e-6) (equal p1 (cadr x) 1e-6)))) (setq plill (vl-remove pli plil))))))))
      (while (and p3 (or (equal (unit (mapcar (function -) p3 p1)) (unit (mapcar (function -) p2 p1)) 1e-6) (equal (unit (mapcar (function -) p1 p3)) (unit (mapcar (function -) p2 p1)) 1e-6)))
        (setq p3 (car (vl-remove-if (function (lambda ( x ) (equal p1 x 1e-6))) (setq ll (car (vl-member-if (function (lambda ( x ) (or (equal p1 (car x) 1e-6) (equal p1 (cadr x) 1e-6)))) (setq plill (vl-remove ll plill))))))))
      )
      (if (not p3)
        (if (null f)
          (progn
            (mapcar (function set) '(p1 p2) (list p2 p1))
            (setq f t)
          )
          (setq p3 t plli pli)
        )
        (setq plli pli)
      )
    )
    (if (listp p3)
      (progn
        (setq n (unit (v^v (mapcar (function -) p3 p1) (mapcar (function -) p2 p1))))
        (setq planeplil (vl-remove-if-not (function (lambda ( x ) (and (equal (- (caddr (trans p1 0 n)) (caddr (trans (car x) 0 n))) 0.0 1e-6) (equal (- (caddr (trans p1 0 n)) (caddr (trans (cadr x) 0 n))) 0.0 1e-6)))) plil))
        (setq planelil (mapcar (function (lambda ( x ) (nth (vl-position x plil) lil))) planeplil))
        (setq li (car planelil))
        (if li
          (progn
            (setq g (chain li planelil))
            (foreach l g
              (setq lil (LM:RemoveNth (vl-position l lil) lil))
            )
            (setq pg (mapcar (function (lambda ( x ) (list (cdr (assoc 10 (entget x))) (cdr (assoc 11 (entget x)))))) g))
            (foreach pp pg
              (setq plil (LM:RemoveNth (vl-position pp plil) plil))
            )
            (setq gg (cons g gg))
          )
        )
      )
      (setq plil nil)
    )
  )
  ;|
  (foreach g gg
    (while g
      (setq p1 (cdr (assoc 10 (entget (car g)))) p2 (cdr (assoc 11 (entget (car g)))))
      (setq p3 (cdr (assoc 10 (entget (cadr g)))) p4 (cdr (assoc 11 (entget (cadr g)))))
      (cond
        ( (equal p1 p3 1e-6)
          (setq pp p2)
        )
        ( (equal p1 p4 1e-6)
          (setq pp p2)
        )
        ( (equal p2 p3 1e-6)
          (setq pp p1)
        )
        ( (equal p2 p4 1e-6)
          (setq pp p1)
        )
      )
      (setq sg (cons (car g) sg))
      (setq g (cdr g))
      (while (setq lx (car g))
        (if (not (or (equal (cdr (assoc 10 (entget lx))) pp 1e-6) (equal (cdr (assoc 11 (entget lx))) pp 1e-6)))
          (setq sg (cons lx sg) g (cdr g))
          (progn
            (setq sg (cons lx sg))
            (setq regs (cons (region (reverse sg)) regs))
            (setq sg nil g (cdr g))
          )
        )
      )
    )
  )
  |;
  (foreach g gg
    (setq ss (ssadd))
    (foreach e g
      (ssadd e ss)
    )
    (vl-cmdf "_.REGION" ss)
    (while (< 0 (getvar 'cmdactive)) (vl-cmdf ""))
    (if (not (eq el (entlast)))
      (while (setq el (entnext el))
        (setq regs (cons el regs))
      )
      (progn
        (setq ss (ssadd))
        (setq pl (apply (function append) (mapcar (function (lambda ( x ) (list (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x)))) g)))
        (setq p1 (car pl) p2 (cadr pl) p3 (if (not (or (equal p1 (caddr pl) 1e-6) (equal p2 (caddr pl) 1e-6))) (caddr pl) (if (not (or (equal p1 (cadddr pl) 1e-6) (equal p2 (cadddr pl) 1e-6))) (cadddr pl) (nth 4 pl))))
        (setq n (unit (v^v (mapcar (function -) p2 p1) (mapcar (function -) p3 p1))))
        (setq pll (mapcar (function (lambda ( x ) (trans (list (car (trans x 0 n)) (cadr (trans x 0 n)) (caddr (trans p1 0 n))) n 0))) pl))
        (foreach e g
          (setq p1 (vlax-curve-getstartpoint e) p2 (vlax-curve-getendpoint e))
          (setq p1 (car (vl-member-if (function (lambda ( x ) (equal x p1 1e-6))) pll)))
          (setq p2 (car (vl-member-if (function (lambda ( x ) (equal x p2 1e-6))) pll)))
          (setq ex (entget e))
          (setq ex (subst (cons 10 p1) (assoc 10 ex) ex))
          (setq ex (subst (cons 11 p2) (assoc 11 ex) ex))
          (entupd (cdr (assoc -1 (entmod ex))))
          (ssadd e ss)
        )
        (vl-cmdf "_.REGION" ss)
        (while (< 0 (getvar 'cmdactive)) (vl-cmdf ""))
        (if (not (eq el (entlast)))
          (while (setq el (entnext el))
            (setq regs (cons el regs))
          )
        )
      )
    )
    ;(setq regs (cons (region g) regs))
  )
  (if lill
    (foreach li lill
      (if (and li (not (vlax-erased-p li)))
        (entdel li)
      )
    )
  )
  (setq ss (ssadd))
  (foreach reg regs
    (if reg
      (ssadd reg ss)
    )
  )
  (vl-cmdf "_.SURFSCULPT" ss "")
  (*error* nil)
)
