(defun c:2droof3d-hatch ( / *error* unit col slope->ang mid v^v _ilpp make3dlw acDoc cmde pea ape ch ent tmp tot big poly reg op hop v vl ml ss lst el c cc s ell lil )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (or acDoc (setq acDoc (vla-get-activedocument (vlax-get-acad-object))))
  (setq ms (vlax-get acDoc (if (= 1 (getvar 'cvport)) 'paperspace 'modelspace)))
  (vla-startundomark acDoc)
  
  (defun *error* ( msg )
    (if cmde (setvar 'cmdecho cmde))
    (if pea (setvar 'peditaccept pea))
    (if ape (setvar 'aperture ape))
    (vla-endundomark acDoc)
    (if msg (prompt msg))
    (princ)
  )

  (defun unit ( v / d )
    (if (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
      (mapcar '(lambda ( x ) (/ x d)) v)
    )
  )

  (defun col ( d / ang darkness )

    ;;; d^2=1^2+1^2-2*1*1*cos(a)
    ;;; d^2=2*(1-cos(a))
    ;;; cos(a)=1-d^2/2
    ;;; a=acos(1-d^2/2)
    (defun ang ( d )
      (acos (- 1.0 (/ (expt d 2.0) 2.0)))
    )

    (defun acos ( x )
      (if (<= -1.0 x 1.0)
        (cond
          ( (equal x 1.0)
            0.0
          )
          ( (equal x 0.0)
            (* 0.5 pi)
          )
          ( (equal x -1.0)
            pi
          )
          ( t
            (if (minusp (atan (sqrt (- 1.0 (* x x))) x))
              (+ (atan (sqrt (- 1.0 (* x x))) x) pi)
              (atan (sqrt (- 1.0 (* x x))) x)
            )
          )
        )
      )
    )

    (setq ang (ang d))
    (setq darkness (/ ang pi))
    (fix (- 255 (* 255 darkness))) ;;; r=g=b=(fix (- 255 (* 255 darkness)))
  )

  (defun slope->ang ( sl / v1 v2 *ang )
    (setq v1 (list 0.0 0.0))
    (setq v2 (list 1.0 (/ sl 100.0)))
    (setq *ang (angle v1 v2))
    *ang
  )

  (defun mid ( p1 p2 )
    (mapcar '(lambda ( a b ) (/ (+ a b) 2.0)) p1 p2)
  )

  (defun v^v ( u v )
    (list
      (- (* (cadr u) (caddr v)) (* (cadr v) (caddr u)))
      (- (* (car  v) (caddr u)) (* (car  u) (caddr v)))
      (- (* (car  u) (cadr  v)) (* (car  v) (cadr  u)))
    )
  )

  (defun _ilpp ( p1 p2 t1 t2 t3 / _ilp nor o )

    (defun _ilp ( p1 p2 o nor / p1p p2p op tp pp p )
      (if (not (equal (v^v nor (unit (mapcar '- p2 p1))) '(0.0 0.0 0.0) 1e-7))
        (progn
          (setq p1p (trans p1 0 (v^v nor (unit (mapcar '- p2 p1))))
                p2p (trans p2 0 (v^v nor (unit (mapcar '- p2 p1))))
                op  (trans o 0 (v^v nor (unit (mapcar '- p2 p1))))
                op  (list (car op) (cadr op) (caddr p1p))
                tp  (polar op (+ (* 0.5 pi) (angle '(0.0 0.0 0.0) (trans nor 0 (v^v nor (unit (mapcar '- p2 p1)))))) 1.0)
          )
          (if (inters p1p p2p op tp nil)
            (progn
              (setq p (trans (inters p1p p2p op tp nil) (v^v nor (unit (mapcar '- p2 p1))) 0))
              p
            )
            nil
          )
        )
        (progn
          (setq pp (list (car (trans p1 0 nor)) (cadr (trans p1 0 nor)) (caddr (trans o 0 nor))))
          (setq p (trans pp nor 0))
          p
        )
      )
    )

    (setq nor (unit (v^v (mapcar '- t3 t1) (mapcar '- t2 t1))))
    (setq o t1)
    
    (if (_ilp p1 p2 o nor)
      (_ilp p1 p2 o nor)
      nil
    )
  )

  (defun make3dlw ( lwp / vl vlu vlup z )
    (setq vl (mapcar 'cdr (acet-list-m-assoc 10 (entget lwp))))
    (setq vl (mapcar '(lambda ( x ) (trans x lwp 0)) vl))
    (setq vlu (mapcar '(lambda ( x ) (_ilpp x (mapcar '+ x '(0.0 0.0 1.0)) (trans '(0.0 0.0 0.0) 1 0) (trans '(1.0 0.0 0.0) 1 0) (trans '(0.0 1.0 0.0) 1 0))) vl))
    (setq vlup (mapcar '(lambda ( x ) (trans x 0 (trans '(0.0 0.0 1.0) 1 0 t))) vlu))
    (setq z (- (caddr (trans '(0.0 0.0 0.0) 0 1))))
    (entmake
      (append
        (list
          '(0 . "LWPOLYLINE")
          '(100 . "AcDbEntity")
          '(100 . "AcDbPolyline")
          (cons 90 (length vl))
          '(70 . 1)
          (cons 38 z)
        )
        (mapcar '(lambda ( x ) (list 10 (car x) (cadr x))) vlup)
        (list (cons 210 (trans '(0.0 0.0 1.0) 1 0 t)))
      )
    )
    (setq vl (mapcar 'cdr (vl-remove-if '(lambda ( x ) (/= (car x) 10)) (entget (entlast)))))
    (setq vl (mapcar '(lambda ( x ) (trans x (entlast) 0)) vl))
    (if (vl-every '(lambda ( x ) (equal (caddr (trans x 0 1)) 0.0 1e-6)) vl)
      (entlast)
      (progn
        (entdel (entlast))
        (setq vlup (mapcar '(lambda ( x ) (trans x 0 1)) vlu))
        (vl-cmdf "_.pline")
        (foreach p vlup
          (vl-cmdf "_non" p)
        )
        (vl-cmdf "_c")
        (entlast)
      )
    )
  )

;-----------------------------------------------------------------------------------------------------------------------------------

  (vl-cmdf "_.ucs" "_w")

  (or slope (setq slope 50))
  (or *ang* (setq *ang* 45))
  (setq tot 0.0)
  (setq cmde (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (setq pea (getvar 'peditaccept))
  (setvar 'peditaccept 1)
  (setq ape (getvar 'aperture))
  (setvar 'aperture 15)

  (initget 1 "Slope Angle")
  (setq ch (getkword "\nInput value [Angle/Slope] : "))
  (if (eq ch "Slope")
    (progn
      (initget 6)
      (setq slope
               (cond
                   ( (getreal (strcat "\nSlope (%)" (if slope (strcat " <" (rtos slope 2 1) ">: ")": "))) )
                   ( slope )
               )
      )
    )
    (progn
      (initget 6)
      (setq *ang*
               (cond
                   ( (getreal (strcat "\nAngle in decimal degrees " (if *ang* (strcat " <" (rtos *ang* 2 1) ">: ")": "))) )
                   ( (float *ang*) )
               )
      )
    )
  )

  (if (eq ch "Slope")
      (setq *ang* (cvunit (slope->ang slope) "radian" "degree"))
      (setq slope (* (/ (sin (* (/ *ang* 180.0) pi)) (cos (* (/ *ang* 180.0) pi))) 100.0))
  )

  (if command-s
    (command-s "_.-view" "_s" "MR")
    (vl-cmdf "_.-view" "_s" "MR")
  )
  (prompt "\nPick contour LWPOLYLINE...")
  (setq poly (ssget "_+.:E:S:L" '((0 . "LWPOLYLINE") (-4 . "&=") (70 . 1))))
  (setq poly (ssname poly 0))
  (if command-s
    (command-s "_.zoom" "_OB" poly "")
    (vl-cmdf "_.zoom" "_OB" poly "")
  )
  (if command-s
    (command-s "_.zoom" "_O")
    (vl-cmdf "_.zoom" "_O")
  )

  (setq vl (mapcar 'cdr (vl-remove-if '(lambda ( x ) (/= (car x) 10)) (entget poly))))
  (setq vl (mapcar '(lambda ( x ) (trans x poly 0)) vl))
  (if (not (equal (car vl) (last vl) 1e-8)) (setq vl (reverse (cons (car vl) (reverse vl)))))
  (vlax-invoke (vlax-ename->vla-object poly) 'offset -1e-3)
  (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea poly)) ;_force pointset CCW
    (setq vl (reverse vl))
  )
  (entdel (entlast))
  (setq ml (mapcar '(lambda ( a b ) (mid a b)) vl (append (cdr vl) (list (car vl)))))
  
  (vl-cmdf "_.explode" poly)
  (while (< 0 (getvar 'cmdactive)) (vl-cmdf ""))
  
  (prompt "\nSelect 2D roof solution LINE enitites with their contour...")
  (while (not ss)
    (if
      (setq ss (ssget '((0 . "LINE"))))
      (progn
        (repeat (setq i (sslength ss))
          (setq lst (cons (vlax-ename->vla-object (ssname ss (setq i (1- i)))) lst))
        )
        (setq reg (vlax-invoke ms 'AddRegion lst))
      )
      (princ "\nEmpty selection...Try again...")
    )
  )

  (foreach r reg
    (setq ent (entlast))
    (vl-cmdf "_.pedit" "_m")
    (apply 'vl-cmdf (mapcar 'vlax-vla-object->ename (vlax-invoke r 'explode)))
    (vl-cmdf "" "_j" "" "")
    (if
      (and
        (not (eq ent (setq ent (entlast))))
        (= "LWPOLYLINE" (cdr (assoc 0 (entget ent))))
      )
      (progn
        (setq tmp (vlax-curve-getarea ent)
              tot (+ tot tmp)
        )
        (if (< (car big) tmp)
          (setq big (list tmp ent))
        )
      )
    )
    (vla-delete r)
  )
  (if (equal (car big) (/ tot 2.0) 1e-3) ;; Gian Paolo Cattaneo
    (entdel (cadr big))
  )
  
  (setq ss (ssadd))

  (mapcar 
   '(lambda ( a b c / p1 p2 lw 3dlw )
      (progn
        (if command-s
          (command-s "_.zoom" "_w" "_non" a "_non" b)
          (vl-cmdf "_.zoom" "_w" "_non" a "_non" b)
        )
        (if command-s
          (command-s "_.zoom" "_O")
          (vl-cmdf "_.zoom" "_O")
        )
        (setq p1 (mapcar '+ a (mapcar '* '(0.1 0.1 0.1) (mapcar '- b a)))
              p2 (mapcar '+ a (mapcar '* '(0.9 0.9 0.9) (mapcar '- b a)))
        )
        (if (= (sslength (ssget "_CP" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-2) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-2) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-2) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-2)) '((0 . "LWPOLYLINE,LINE")))) 2)
          (progn
            (if command-s
              (command-s "_.ucs" "_3p" "_non" a "_non" b "")
              (vl-cmdf "_.ucs" "_3p" "_non" a "_non" b "")
            )
            (if command-s
              (command-s "_.ucs" "_3p" "_non" '(0.0 0.0 0.0) "_non" '(1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
              (vl-cmdf "_.ucs" "_3p" "_non" '(0.0 0.0 0.0) "_non" '(1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
            )
            (if (and (setq s (ssget "_C" (trans c 0 1) (trans c 0 1) '((0 . "LWPOLYLINE")))) (setq lw (ssname s 0)))
              (progn
                (setq 3dlw (make3dlw lw))
                (setq el (entlast))
                (if command-s
                  (command-s "_.loft" lw 3dlw "" "")
                  (vl-cmdf "_.loft" lw 3dlw "" "")
                )
                (if (not (eq el (entlast)))
                  (progn
                    (ssadd (entlast) ss)
                    (if (and lw (not (vlax-erased-p lw))) (entdel lw))
                    (if (and 3dlw (not (vlax-erased-p 3dlw))) (entdel 3dlw))
                    (repeat 2
                      (if command-s
                        (command-s "_.ucs" "_p")
                        (vl-cmdf "_.ucs" "_p")
                      )
                    )
                  )
                  (progn
                    (if command-s
                      (command-s "_.extrude" lw "" 5e+4 "")
                      (vl-cmdf "_.extrude" lw "" 5e+4 "")
                    )
                    (setq el (entlast))
                    (if command-s
                      (command-s "_.slice" el "" "_OB" 3dlw "_non" '(0.0 0.0 -1.0))
                      (vl-cmdf "_.slice" el "" "_OB" 3dlw "_non" '(0.0 0.0 -1.0))
                    )
                    (ssadd el ss)
                    (if (and lw (not (vlax-erased-p lw))) (entdel lw))
                    (if (and 3dlw (not (vlax-erased-p 3dlw))) (entdel 3dlw))
                    (repeat 2
                      (if command-s
                        (command-s "_.ucs" "_p")
                        (vl-cmdf "_.ucs" "_p")
                      )
                    )
                  )
                )
              )
              (repeat 2
                (if command-s
                  (command-s "_.ucs" "_p")
                  (vl-cmdf "_.ucs" "_p")
                )
              )
            )
          )
        )
        (if command-s
          (command-s "_.zoom" "_p")
          (vl-cmdf "_.zoom" "_p")
        )
      )
    ) vl (append (cdr vl) (list (car vl))) ml
  )

  (foreach obj lst
    (if (not (vlax-erased-p obj))
      (vla-delete obj)
    )
  )

  (if command-s
    (command-s "_.union" ss "")
    (vl-cmdf "_.union" ss "")
  )
  (if command-s
    (command-s "_.ucs" "_p")
    (vl-cmdf "_.ucs" "_p")
  )
  (if command-s
    (command-s "_.zoom" "_OB" (entlast) "")
    (vl-cmdf "_.zoom" "_OB" (entlast) "")
  )
  (if command-s
    (command-s "_.zoom" "_O")
    (vl-cmdf "_.zoom" "_O")
  )

  (initget "1 2 3")
  (setq op (getkword "\nChoose an option [1 3dsolid/2 2dhatch/3 3dsolid-3dhatch] <2 2dhatch> : "))
  (if (null op)
    (setq op "2")
  )
  (if (/= op "1")
    (progn
      (initget 1)
      (setq v (getpoint "\nPick or specify light source point to determine light vector of parallel rays - point must differ from target point 0,0,0 : "))
      (while (equal v (list 0.0 0.0 0.0) 1e-6)
        (prompt "\nInvalid specification - source vector point must differ from target point 0,0,0...")
        (initget 1)
        (setq v (getpoint "\nPick or specify light source point to determine light vector of parallel rays - point must differ from target point 0,0,0 : "))
      )
      (initget "1 2 3")
      (setq hop (getkword "\nDo you want linear or solid hatch [1 linear/ 2 solid /3 both] <1 linear> : "))
      (if (null hop)
        (setq hop "1")
      )
      (if (/= hop "2")
        (progn
          (initget 7)
          (setq gap (getdist "\nPick or specify gap between vertical hatching lines : "))
        )
      )
      (setq v (unit v))
      (setq el (entlast) lst nil reg nil big nil tot 0.0)
      (vl-cmdf "_.xedges" "_l" "")
      (entdel (ssname (ssget "_P") 0))
      (while (setq el (entnext el))
        (if (= "LINE" (cdr (assoc 0 (entget el))))
          (progn
            (entmod (subst (cons 10 (append (mapcar '+ '(0 0) (cdr (assoc 10 (entget el)))) (list 0.0))) (assoc 10 (entget el)) (entget el)))
            (entmod (subst (cons 11 (append (mapcar '+ '(0 0) (cdr (assoc 11 (entget el)))) (list 0.0))) (assoc 11 (entget el)) (entget el)))
            (if (or (not (vl-member-if '(lambda ( x ) (equal x (list (cdr (assoc 10 (entget el))) (cdr (assoc 11 (entget el)))) 1e-6)) lil)) (not (vl-member-if '(lambda ( x ) (equal x (list (cdr (assoc 11 (entget el))) (cdr (assoc 10 (entget el)))) 1e-6)) lil)))
              (setq lst (cons (vlax-ename->vla-object el) lst) lil (cons (list (cdr (assoc 10 (entget el))) (cdr (assoc 11 (entget el)))) lil))
              (setq ell (cons el ell))
            )
          )
          (setq ell (cons el ell))
        )
      )
      (if ell
        (mapcar 'entdel ell)
      )
      (setq reg (vlax-invoke ms 'AddRegion lst))
      (foreach r reg
        (setq ent (entlast))
        (vl-cmdf "_.pedit" "_m")
        (apply 'vl-cmdf (mapcar 'vlax-vla-object->ename (vlax-invoke r 'explode)))
        (vl-cmdf "" "_j" "" "")
        (if
          (and
            (not (eq ent (setq ent (entlast))))
            (= "LWPOLYLINE" (cdr (assoc 0 (entget ent))))
          )
          (progn
            (setq tmp (vlax-curve-getarea ent)
                  tot (+ tot tmp)
            )
            (if (< (car big) tmp)
              (setq big (list tmp ent))
            )
          )
        )
        (vla-delete r)
      )
      (if (equal (car big) (/ tot 2.0) 1e-3) ;; Gian Paolo Cattaneo
        (entdel (cadr big))
      )
      
      (setq ss (ssadd))

      (mapcar 
       '(lambda ( a b c / p1 p2 lw 3dlw )
          (progn
            (if command-s
              (command-s "_.zoom" "_w" "_non" a "_non" b)
              (vl-cmdf "_.zoom" "_w" "_non" a "_non" b)
            )
            (if command-s
              (command-s "_.zoom" "_O")
              (vl-cmdf "_.zoom" "_O")
            )
            (setq p1 (mapcar '+ a (mapcar '* '(0.1 0.1 0.1) (mapcar '- b a)))
                  p2 (mapcar '+ a (mapcar '* '(0.9 0.9 0.9) (mapcar '- b a)))
            )
            (if (eq (sslength (ssget "_CP" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-3)) '((0 . "LWPOLYLINE,LINE")))) 2)
              (progn
                (if command-s
                  (command-s "_.ucs" "_3p" "_non" a "_non" b "")
                  (vl-cmdf "_.ucs" "_3p" "_non" a "_non" b "")
                )
                (if command-s
                  (command-s "_.ucs" "_3p" "_non" '(0.0 0.0 0.0) "_non" '(1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
                  (vl-cmdf "_.ucs" "_3p" "_non" '(0.0 0.0 0.0) "_non" '(1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
                )
                (if (and (setq s (ssget "_C" (trans c 0 1) (trans c 0 1) '((0 . "LWPOLYLINE")))) (setq lw (ssname s 0)) (not (ssget "_C" (trans c 0 1) (trans p2 0 1) '((0 . "HATCH")))))
                  (if (= op "2")
                    (progn
                      (setq 3dlw (make3dlw lw))
                      (setq el (entlast))
                      (if command-s
                        (command-s "_.loft" lw 3dlw "" "")
                        (vl-cmdf "_.loft" lw 3dlw "" "")
                      )
                      (if (not (eq el (entlast)))
                        (progn
                          (if command-s
                            (command-s "_.undo" 1)
                            (vl-cmdf "_.undo" 1)
                          )
                          (if (entget 3dlw) (entdel 3dlw))
                          (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                          (if command-s
                            (command-s "_.ucs" "_p")
                            (vl-cmdf "_.ucs" "_p")
                          )
                          (cond
                            ( (= hop "1")
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                              (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                              (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                              (vla-setrgb cc c c c)
                              (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                            )
                            ( (= hop "2")
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                              (vla-setrgb cc c c c)
                              (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                            )
                            ( t
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                              (vla-setrgb cc c c c)
                              (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                              (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                            )
                          )
                          (if command-s
                            (command-s "_.draworder" lw "" "_f")
                            (vl-cmdf "_.draworder" lw "" "_f")
                          )
                          (if command-s
                            (command-s "_.ucs" "_p")
                            (vl-cmdf "_.ucs" "_p")
                          )
                        )
                        (progn
                          (if (entget 3dlw) (entdel 3dlw))
                          (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                          (if command-s
                            (command-s "_.ucs" "_p")
                            (vl-cmdf "_.ucs" "_p")
                          )
                          (cond
                            ( (= hop "1")
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                              (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                              (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                              (vla-setrgb cc c c c)
                              (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                            )
                            ( (= hop "2")
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                              (vla-setrgb cc c c c)
                              (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                            )
                            ( t
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                              (vla-setrgb cc c c c)
                              (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                              (if command-s
                                (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                                (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" lw "" "")
                              )
                              (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                              (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                            )
                          )
                          (if command-s
                            (command-s "_.draworder" lw "" "_f")
                            (vl-cmdf "_.draworder" lw "" "_f")
                          )
                          (if command-s
                            (command-s "_.ucs" "_p")
                            (vl-cmdf "_.ucs" "_p")
                          )
                        )
                      )
                    )
                    (progn
                      (setq 3dlw (make3dlw lw))
                      (setq el (entlast))
                      (if command-s
                        (command-s "_.loft" lw 3dlw "" "")
                        (vl-cmdf "_.loft" lw 3dlw "" "")
                      )
                      (if (not (eq el (entlast)))
                        (progn
                          (if (/= op "1")
                            (progn
                              (if command-s
                                (command-s "_.undo" 1)
                                (vl-cmdf "_.undo" 1)
                              )
                              (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                              (cond
                                ( (= hop "1")
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                                  (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                                  (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                                  (vla-setrgb cc c c c)
                                  (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                                )
                                ( (= hop "2")
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                                  (vla-setrgb cc c c c)
                                  (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                                )
                                ( t
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                                  (vla-setrgb cc c c c)
                                  (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                                  (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                                )
                              )
                              (if command-s
                                (command-s "_.loft" lw 3dlw "" "")
                                (vl-cmdf "_.loft" lw 3dlw "" "")
                              )
                            )
                          )
                          (ssadd (entlast) ss)
                          (if (entget lw) (entdel lw))
                          (if (entget 3dlw) (entdel 3dlw))
                          (repeat 2
                            (if command-s
                              (command-s "_.ucs" "_p")
                              (vl-cmdf "_.ucs" "_p")
                            )
                          )
                        )
                        (progn
                          (if command-s
                            (command-s "_.extrude" lw "" 1e+6 "")
                            (vl-cmdf "_.extrude" lw "" 1e+6 "")
                          )
                          (setq el (entlast))
                          (if command-s
                            (command-s "_.slice" el "" "_ob" 3dlw "_non" '(0.0 0.0 -1.0))
                            (vl-cmdf "_.slice" el "" "_ob" 3dlw "_non" '(0.0 0.0 -1.0))
                          )
                          (ssadd el ss)
                          (if (/= op "1")
                            (progn
                              (setq c (col (distance v (trans '(0.0 0.0 1.0) 1 0 t))))
                              (cond
                                ( (= hop "1")
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                                  (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                                  (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                                  (vla-setrgb cc c c c)
                                  (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                                )
                                ( (= hop "2")
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                                  (vla-setrgb cc c c c)
                                  (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                                )
                                ( t
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
                                  (vla-setrgb cc c c c)
                                  (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
                                  (if command-s
                                    (command-s "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                    (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" 3dlw "" "")
                                  )
                                  (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
                                  (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
                                )
                              )
                            )
                          )
                          (if (entget lw) (entdel lw))
                          (if (entget 3dlw) (entdel 3dlw))
                          (repeat 2
                            (if command-s
                              (command-s "_.ucs" "_p")
                              (vl-cmdf "_.ucs" "_p")
                            )
                          )
                        )
                      )
                    )
                  )
                  (repeat 2
                    (if command-s
                      (command-s "_.ucs" "_p")
                      (vl-cmdf "_.ucs" "_p")
                    )
                  )
                )
              )
            )
            (if command-s
              (command-s "_.zoom" "_p")
              (vl-cmdf "_.zoom" "_p")
            )
          )
        ) vl (append (cdr vl) (list (car vl))) ml
      )
      
      (foreach obj lst
        (if (not (vlax-erased-p obj))
          (vla-delete obj)
        )
      )

      (if (and ss (/= (sslength ss) 0))
        (progn
          (if command-s
            (command-s "_.draworder" ss "" "_f")
            (vl-cmdf "_.draworder" ss "" "_f")
          )
          (if command-s
            (command-s "_.union" ss "")
            (vl-cmdf "_.union" ss "")
          )
        )
      )
    )
  )
  (if command-s
    (command-s "_.-view" "_r" "MR")
    (vl-cmdf "_.-view" "_r" "MR")
  )
  (if command-s
    (command-s "_.-view" "_d" "MR")
    (vl-cmdf "_.-view" "_d" "MR")
  )
  (vla-regen acDoc acactiveviewport)
  (*error* nil)
)