(defun c:2droof3d-hatch ( / *error* unionss slope->ang mid v^v unit _ilpp make3dlw col regchk process process-hatch adoc spc cmd pea ape lfn ucsf ch ent poly reg vl ml ss i lst el elx ell lil s amax pol pols polsvlml vvv a b c sol1 op v hop gap regs islrgs isl sel se mainreg main vll pll r nn p1 p2 rss ti )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (setq adoc (vla-get-activedocument (vlax-get-acad-object)))
  (setq spc (vla-get-block (vla-get-activelayout adoc)))

  (if (= 8 (logand 8 (getvar (quote undoctl))))
    (vla-endundomark adoc)
  )
  (vla-startundomark adoc)

  (defun *error* ( m )
    (if cmd
      (setvar (quote cmdecho) cmd)
    )
    (if pea
      (setvar (quote peditaccept) pea)
    )
    (if ape
      (setvar (quote aperture) ape)
    )
    (if lfn
      (setvar (quote loftnormals) lfn)
    )
    (if (= 8 (logand 8 (getvar (quote undoctl))))
      (vla-endundomark adoc)
    )
    (if m
      (prompt (strcat "\n" m))
    )
    (princ)
  )

  (defun unionss ( ss / e i )
    (setq e (ssname ss 0) i 0)
    (repeat (1- (sslength ss))
      (setq i (1+ i))
      (if command-s
        (command-s "_.union" e (ssname ss i) "")
        (vl-cmdf "_.union" e (ssname ss i) "")
      )
    )
  )

  (defun slope->ang ( sl / v1 v2 *ang )
    (setq v1 (list 0.0 0.0))
    (setq v2 (list 1.0 (/ sl 100.0)))
    (setq *ang (angle v1 v2))
    *ang
  )

  (defun mid ( p1 p2 )
    (mapcar (function (lambda ( a b ) (/ (+ a b) 2.0))) p1 p2)
  )

  (defun v^v ( u v )
    (list
      (- (* (cadr u) (caddr v)) (* (cadr v) (caddr u)))
      (- (* (car  v) (caddr u)) (* (car  u) (caddr v)))
      (- (* (car  u) (cadr  v)) (* (car  v) (cadr  u)))
    )
  )

  (defun unit ( v / d )
    (if (and v (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-10)))
      (mapcar (function (lambda ( x ) (/ x d))) v)
    )
  )

  (defun _ilpp ( p1 p2 t1 t2 t3 / _ilp nor o )

    (defun _ilp ( p1 p2 o nor / p1p p2p op tp pp p )
      (if (not (equal (v^v nor (unit (mapcar (function -) p2 p1))) (list 0.0 0.0 0.0) 1e-7))
        (progn
          (setq p1p (trans p1 0 (v^v nor (unit (mapcar (function -) p2 p1))))
                p2p (trans p2 0 (v^v nor (unit (mapcar (function -) p2 p1))))
                op  (trans o 0 (v^v nor (unit (mapcar (function -) p2 p1))))
                op  (list (car op) (cadr op) (caddr p1p))
                tp  (polar op (+ (* 0.5 pi) (angle (list 0.0 0.0 0.0) (trans nor 0 (v^v nor (unit (mapcar (function -) p2 p1)))))) 1.0)
          )
          (if (inters p1p p2p op tp nil)
            (progn
              (setq p (trans (inters p1p p2p op tp nil) (v^v nor (unit (mapcar (function -) p2 p1))) 0))
              p
            )
            nil
          )
        )
        (progn
          (setq pp (list (car (trans p1 0 nor)) (cadr (trans p1 0 nor)) (caddr (trans o 0 nor))))
          (setq p (trans pp nor 0))
          p
        )
      )
    )

    (setq nor (unit (v^v (mapcar (function -) t3 t1) (mapcar (function -) t2 t1))))
    (setq o t1)
    (if (_ilp p1 p2 o nor)
      (_ilp p1 p2 o nor)
    )
  )

  (defun make3dlw ( lwp / vl vlu vlup z 3dlw )
    (setq vl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget lwp))))
    (setq vl (mapcar (function (lambda ( x ) (trans x lwp 0))) vl))
    (setq vlu (mapcar (function (lambda ( x / xx ) (if (setq xx (_ilpp x (mapcar (function +) x (list 0.0 0.0 1.0)) (trans (list 0.0 0.0 0.0) 1 0) (trans (list 1.0 0.0 0.0) 1 0) (trans (list 0.0 1.0 0.0) 1 0))) xx x))) vl))
    (setq vlup (mapcar (function (lambda ( x ) (trans x 0 (trans (list 0.0 0.0 1.0) 1 0 t)))) vlu))
    (setq z (- (caddr (trans (list 0.0 0.0 0.0) 0 1))))
    (setq 3dlw
      (entmakex
        (append
          (list
            (cons 0 "LWPOLYLINE")
            (cons 100 "AcDbEntity")
            (cons 100 "AcDbPolyline")
            (cons 90 (length vl))
            (cons 70 1)
            (cons 38 z)
          )
          (mapcar (function (lambda ( x ) (list 10 (car x) (cadr x)))) vlup)
          (list (cons 210 (trans (list 0.0 0.0 1.0) 1 0 t)))
        )
      )
    )
    (setq vl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget (entlast)))))
    (setq vl (mapcar (function (lambda ( x ) (trans x (entlast) 0))) vl))
    (if (vl-every (function (lambda ( x ) (equal (caddr (trans x 0 1)) 0.0 1e-6))) vl)
      3dlw
      (progn
        (if 3dlw
          (entdel 3dlw)
        )
        (setq vlup (mapcar (function (lambda ( x ) (trans x 0 1))) vlu))
        (vl-cmdf "_.pline")
        (foreach p vlup
          (vl-cmdf "_non" p)
        )
        (vl-cmdf "_c")
        (entlast)
      )
    )
  )

  (defun col ( d / ang darkness )

    ;;; d^2=1^2+1^2-2*1*1*cos(a)
    ;;; d^2=2*(1-cos(a))
    ;;; cos(a)=1-d^2/2
    ;;; a=acos(1-d^2/2)
    (defun ang ( d )
      (acos (- 1.0 (/ (expt d 2.0) 2.0)))
    )

    (defun acos ( x )
      (if (<= -1.0 x 1.0)
        (cond
          ( (equal x 1.0)
            0.0
          )
          ( (equal x 0.0)
            (* 0.5 pi)
          )
          ( (equal x -1.0)
            pi
          )
          ( t
            (if (minusp (atan (sqrt (- 1.0 (* x x))) x))
              (+ (atan (sqrt (- 1.0 (* x x))) x) pi)
              (atan (sqrt (- 1.0 (* x x))) x)
            )
          )
        )
      )
    )

    (setq ang (ang d))
    (setq darkness (/ ang pi))
    (fix (- 255 (* 255 darkness))) ;;; r=g=b=(fix (- 255 (* 255 darkness)))
  )

  (defun regchk ( reg plsts / s r )
    (vl-cmdf "_.explode" reg)
    (while (< 0 (getvar (quote cmdactive)))
      (vl-cmdf "")
    )
    (setq s (ssget "_p"))
    (vl-cmdf "_.pedit" "_m" s "" "_j")
    (while (< 0 (getvar (quote cmdactive)))
      (vl-cmdf "")
    )
    (if
      (vl-some
        (function (lambda ( x )
          (vl-every
            (function (lambda ( y )
              (vl-some
                (function (lambda ( z ) (equal y z 1e-6))) x
              )
            )) (mapcar (function (lambda ( p ) (trans p (entlast) 0)))
                 (mapcar (function cdr) (vl-remove-if (function (lambda ( q ) (/= (car q) 10))) (entget (entlast))))
               )
          )
        )) plsts
      )
      (setq r t)
    )
    (vl-cmdf "_.undo" 2)
    r
  )

  (defun process ( a b c / p1 p2 lw 3dlw chk )
    (if (not (equal a b 1e-6))
      (progn
        (if command-s
          (command-s "_.zoom" "_w" "_non" a "_non" b)
          (vl-cmdf "_.zoom" "_w" "_non" a "_non" b)
        )
        (if command-s
          (command-s "_.zoom" "0.9xp")
          (vl-cmdf "_.zoom" "0.9xp")
        )
        (setq p1 (mapcar (function +) a (mapcar (function *) (list 0.1 0.1 0.1) (mapcar (function -) b a)))
              p2 (mapcar (function +) a (mapcar (function *) (list 0.9 0.9 0.9) (mapcar (function -) b a)))
        )
        (setq s (ssget "_f" (list p1 p2) (list (cons 0 "LWPOLYLINE,LINE"))))
        (if (and s (= (sslength s) 2))
          (setq chk t)
        )
        (setq s (ssget "_cp" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3)) (list (cons 0 "LWPOLYLINE,LINE"))))
        (if (and s (= (sslength s) 2))
          (setq chk t)
        )
        (if chk
          (progn
            (if command-s
              (command-s "_.ucs" "_3p" "_non" a "_non" b "")
              (vl-cmdf "_.ucs" "_3p" "_non" a "_non" b "")
            )
            (if command-s
              (command-s "_.ucs" "_3p" "_non" (list 0.0 0.0 0.0) "_non" (list 1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
              (vl-cmdf "_.ucs" "_3p" "_non" (list 0.0 0.0 0.0) "_non" (list 1.0 0.0 0.0) "_non" (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
            )
            (if (and (setq s (ssget "_c" (mapcar (function +) (list -1e-3 -1e-3) (trans c 0 1)) (mapcar (function +) (list 1e-3 1e-3) (trans c 0 1)) (list (cons 0 "LWPOLYLINE")))) (setq lw (ssname s 0)))
              (if (= (strcase (getvar (quote program))) "BRICSCAD")
                (progn
                  (setq 3dlw (make3dlw lw))
                  (setq el (entlast))
                  (if command-s
                    (command-s "_.loft" lw 3dlw "" "")
                    (vl-cmdf "_.loft" lw 3dlw "" "")
                  )
                  (if (not (eq el (entlast)))
                    (progn
                      (ssadd (setq el (entlast)) ss)
                      (if (and lw (not (vlax-erased-p lw))) (entdel lw))
                      (if (and 3dlw (not (vlax-erased-p 3dlw))) (entdel 3dlw))
                      (repeat 2
                        (if command-s
                          (command-s "_.ucs" "_p")
                          (vl-cmdf "_.ucs" "_p")
                        )
                      )
                    )
                    (progn
                      (if command-s
                        (command-s "_.extrude" lw "" 5e+4 "")
                        (vl-cmdf "_.extrude" lw "" 5e+4 "")
                      )
                      (setq el (entlast))
                      (if command-s
                        (command-s "_.slice" el "" "_ob" 3dlw "_non" (list 0.0 0.0 -1.0))
                        (vl-cmdf "_.slice" el "" "_ob" 3dlw "_non" (list 0.0 0.0 -1.0))
                      )
                      (ssadd el ss)
                      (if (and lw (not (vlax-erased-p lw))) (entdel lw))
                      (if (and 3dlw (not (vlax-erased-p 3dlw))) (entdel 3dlw))
                      (repeat 2
                        (if command-s
                          (command-s "_.ucs" "_p")
                          (vl-cmdf "_.ucs" "_p")
                        )
                      )
                    )
                  )
                )
                (progn
                  (setq 3dlw (make3dlw lw))
                  (if command-s
                    (command-s "_.extrude" lw "" 5e+4 "")
                    (vl-cmdf "_.extrude" lw "" 5e+4 "")
                  )
                  (setq el (entlast))
                  (if command-s
                    (command-s "_.slice" el "" "_ob" 3dlw "_non" (list 0.0 0.0 -1.0))
                    (vl-cmdf "_.slice" el "" "_ob" 3dlw "_non" (list 0.0 0.0 -1.0))
                  )
                  (if command-s
                    (command-s "_.brep" el "")
                    (vl-cmdf "_.brep" el "")
                  )
                  (ssadd el ss)
                  (if (and lw (not (vlax-erased-p lw))) (entdel lw))
                  (if (and 3dlw (not (vlax-erased-p 3dlw))) (entdel 3dlw))
                  (repeat 2
                    (if command-s
                      (command-s "_.ucs" "_p")
                      (vl-cmdf "_.ucs" "_p")
                    )
                  )
                )
              )
              (repeat 2
                (if command-s
                  (command-s "_.ucs" "_p")
                  (vl-cmdf "_.ucs" "_p")
                )
              )
            )
          )
        )
        (if command-s
          (command-s "_.zoom" "_p")
          (vl-cmdf "_.zoom" "_p")
        )
      )
    )
  )

  (defun process-hatch nil
    (cond
      ( (= hop "0") )
      ( (= hop "1")
        (if command-s
          (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" el "" "")))
            (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" el "" "")
          )
          (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" el "" "")
        )
        (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
        (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
        (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
        (vla-setrgb cc c c c)
        (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
      )
      ( (= hop "2")
        (if command-s
          (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" el "" "")))
            (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" el "" "")
          )
          (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" el "" "")
        )
        (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
        (vla-setrgb cc c c c)
        (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
      )
      ( t
        (if command-s
          (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" el "" "")))
            (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" el "" "")
          )
          (vl-cmdf "_.-bhatch" "_p" "_s" "_a" "_a" "_y" "" "_s" el "" "")
        )
        (setq cc (vla-get-truecolor (vlax-ename->vla-object (entlast))))
        (vla-setrgb cc c c c)
        (vla-put-truecolor (vlax-ename->vla-object (entlast)) cc)
        (if command-s
          (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" el "" "")))
            (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" el "" "")
          )
          (vl-cmdf "_.-bhatch" "_p" "_u" 90.0 gap "_n" "_a" "_a" "_y" "" "_s" el "" "")
        )
        (vla-put-patternscale (vlax-ename->vla-object (entlast)) gap)
        (vla-put-patternspace (vlax-ename->vla-object (entlast)) gap)
      )
    )
  )

;-------------------------------------------------------------------;

  (if (= 0 (getvar (quote worlducs)))
    (progn
      (if command-s
        (command-s "_.ucs" "_w")
        (vl-cmdf "_.ucs" "_w")
      )
      (setq ucsf t)
    )
  )
  (alert "Make sure outer polygonal LWPOLYLINE has CCW oriented vertices and inside islands have CW oriented vertices...")
  (or slope (setq slope 100))
  (or *ang* (setq *ang* 45))
  (setq nn 0)
  (setq cmd (getvar (quote cmdecho)))
  (setvar (quote cmdecho) 0)
  (setq pea (getvar (quote peditaccept)))
  (setvar (quote peditaccept) 1)
  (setq ape (getvar (quote aperture)))
  (setvar (quote aperture) 15)
  (setq lfn (getvar (quote loftnormals)))
  (setvar (quote loftnormals) 0)
  (prompt "\nPick contour LWPOLYLINE...")
  (while (not (setq s (ssget "_+.:E:S:L" (list (cons 0 "LWPOLYLINE") (cons -4 "&=") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))))
  (setq poly (ssname s 0))
  (if command-s
    (command-s "_.zoom" "_ob" poly "")
    (vl-cmdf "_.zoom" "_ob" poly "")
  )
  (if command-s
    (command-s "_.zoom" "0.9xp")
    (vl-cmdf "_.zoom" "0.9xp")
  )
  (if command-s
    (command-s "_.-view" "_s" "{ tmp }")
    (vl-cmdf "_.-view" "_s" "{ tmp }")
  )
  (prompt "\nSelect inside LWPOLYLINE islands - ENTER TO FINISH or ENTER for none...")
  (if (setq s (ssget "_:L" (list (cons 0 "LWPOLYLINE") (cons -4 "&=") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
    (progn
      (if (ssmemb poly s)
        (ssdel poly s)
      )
      (repeat (sslength s)
        (setq pol (ssname s nn))
        (setq nn (1+ nn))
        (setq vl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget pol))))
        (setq vl (mapcar (function (lambda ( x ) (trans x pol 0))) vl))
        (setq pols (cons (list pol vl) pols))
        (setq ml (mapcar (function (lambda ( a b ) (mid a b))) vl (append (cdr vl) (list (car vl)))))
        (setq polsvlml (cons (list vl ml) polsvlml))
      )
    )
  )
  (setq amax (vlax-curve-getarea poly))
  (setq vl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget poly))))
  (setq vl (mapcar (function (lambda ( x ) (trans x poly 0))) vl))
  (setq ml (mapcar (function (lambda ( a b ) (mid a b))) vl (append (cdr vl) (list (car vl)))))
  (vl-cmdf "_.explode" poly)
  (while (< 0 (getvar (quote cmdactive)))
    (vl-cmdf "")
  )
  (foreach pol (mapcar (function car) pols)
    (vl-cmdf "_.explode" pol)
    (while (< 0 (getvar (quote cmdactive)))
      (vl-cmdf "")
    )
  )

  (prompt "\nSelect all LINE entities, i.e. complete roof solution...")
  (while (not ss)
    (if (not (setq ss (ssget "_:L" (list (cons 0 "LINE")))))
      (princ "\nEmpty selection... Try again...")
    )
  )
  (initget "1 2 3")
  (setq op (getkword "\nChoose an option [1 3dsolid / 2 2dhatch-2dempty / 3 3dsolid-3dhatch] <2 2dhatch-2dempty> : "))
  (if (not op)
    (setq op "2")
  )
  (if (/= op "2")
    (progn
      (initget 1 "Slope Angle")
      (setq ch (getkword "\nInput value [Angle/Slope] : "))
      (if (eq ch "Slope")
        (progn
          (initget 6)
          (setq slope
            (cond
              ( (getreal (strcat "\nSlope (%)" (if slope (strcat " <" (rtos slope 2 1) ">: ")": "))) )
              ( slope )
            )
          )
        )
        (progn
          (initget 6)
          (setq *ang*
            (cond
              ( (getreal (strcat "\nAngle in decimal degrees " (if *ang* (strcat " <" (rtos *ang* 2 1) ">: ")": "))) )
              ( (float *ang*) )
            )
          )
        )
      )
      (if (eq ch "Slope")
        (setq *ang* (cvunit (slope->ang slope) "radian" "degree"))
        (setq slope (* (/ (sin (* (/ *ang* 180.0) pi)) (cos (* (/ *ang* 180.0) pi))) 100.0))
      )
    )
  )
  (if (/= op "1")
    (progn
      (initget "0 1 2 3")
      (setq hop (getkword "\nDo you want linear or solid hatch [0 none / 1 linear/ 2 solid /3 both] <0 none> : "))
      (if (not hop)
        (setq hop "0")
      )
      (if (and (/= hop "0") (/= hop "1"))
        (progn
          (initget 1)
          (setq v (getpoint "\nPick or specify light source point to determine light vector of parallel rays - point must differ from target point 0,0,0 : "))
          (while (equal v (list 0.0 0.0 0.0) 1e-6)
            (prompt "\nInvalid specification - source vector point must differ from target point 0,0,0...")
            (initget 1)
            (setq v (getpoint "\nPick or specify light source point to determine light vector of parallel rays - point must differ from target point 0,0,0 : "))
          )
        )
      )
      (if (and (/= hop "0") (/= hop "2"))
        (progn
          (initget 7)
          (setq gap (getdist "\nPick or specify gap between vertical hatching lines : "))
        )
      )
    )
  )
  (setq ti (car (_vl-times)))
  (repeat (setq i (sslength ss))
    (setq lst (cons (vlax-ename->vla-object (ssname ss (setq i (1- i)))) lst))
  )
  (setq reg (vlax-invoke spc (quote addregion) lst))
  (foreach r reg
    (setq ent (entlast))
    (vl-cmdf "_.pedit" "_m")
    (apply (function vl-cmdf) (mapcar (function vlax-vla-object->ename) (vlax-invoke r (quote explode))))
    (vl-cmdf "" "_j" "" "")
    (if
      (and
        (not (eq ent (setq ent (entlast))))
        (or
          (equal (vlax-curve-getarea ent) amax 1e-6)
          (vl-some
            (function (lambda ( z )
              (vl-every
                (function (lambda ( x )
                  (vl-some
                    (function (lambda ( y ) (equal x y 1e-6))) z
                  )
                )) (mapcar (function (lambda ( p ) (trans p ent 0))) (mapcar (function cdr) (vl-remove-if (function (lambda ( p ) (/= (car p) 10))) (entget ent))))
              ))
            ) (mapcar (function cadr) pols)
          )
        )
      )
      (entdel ent)
    )
    (if (and r (= (type r) (quote vla-object)) (not (vlax-erased-p r)) (= (cdr (assoc 0 (entget (vlax-vla-object->ename r)))) "REGION"))
      (progn
        (vla-delete r)
        (vlax-release-object r)
      )
    )
  )

  (setq ss (ssadd))

  (mapcar (function (lambda ( a b c ) (setq vvv (cons (list a b c) vvv)))) vl (append (cdr vl) (list (car vl))) ml)
  (foreach v (reverse vvv)
    (setq a (car v) b (cadr v) c (caddr v))
    (process a b c)
  )

  (foreach vlml polsvlml
    (setq vl (car vlml) ml (cadr vlml))
    (setq vvv nil)
    (mapcar (function (lambda ( a b c ) (setq vvv (cons (list a b c) vvv)))) vl (append (cdr vl) (list (car vl))) ml)
    (foreach v (reverse vvv)
      (setq a (car v) b (cadr v) c (caddr v))
      (process a b c)
    )
  )

  (foreach obj lst
    (if (and obj (= (type obj) (quote vla-object)) (not (vlax-erased-p obj)) (= (cdr (assoc 0 (entget (vlax-vla-object->ename obj)))) "LINE"))
      (progn
        (vla-delete obj)
        (vlax-release-object obj)
      )
    )
  )
  (if (and ss (> (sslength ss) 0))
    (unionss ss)
  )
  (if (= (cdr (assoc 0 (entget (entlast)))) "3DSOLID")
    (setq sol1 (entlast))
  )
  (if command-s
    (command-s "_.-view" "_r" "{ tmp }")
    (vl-cmdf "_.-view" "_r" "{ tmp }")
  )

  (setq v (unit v) el (entlast) lst nil)
  (if command-s
    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.xedges" sol1 "")))
      (vl-cmdf "_.xedges" sol1 "")
    )
    (vl-cmdf "_.xedges" sol1 "")
  )
  (if (= 0 (getvar (quote worlducs)))
    (progn
      (if command-s
        (command-s "_.ucs" "_w")
        (vl-cmdf "_.ucs" "_w")
      )
      (setq ucsf t)
    )
  )
  (if command-s
    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.copybase" (list 0.0 0.0 0.0) sol1 "")))
      (vl-cmdf "_.copybase" (list 0.0 0.0 0.0) sol1 "")
    )
    (vl-cmdf "_.copybase" (list 0.0 0.0 0.0) sol1 "")
  )
  (if (/= op "1")
    (progn
      (entdel sol1)
      (while (setq el (entnext el))
        (cond
          ( (= "LINE" (cdr (assoc 0 (setq elx (entget el)))))
            (setq elx (subst (cons 10 (append (mapcar (function +) (list 0.0 0.0) (cdr (assoc 10 elx))) (list 0.0))) (assoc 10 elx) elx))
            (setq elx (subst (cons 11 (append (mapcar (function +) (list 0.0 0.0) (cdr (assoc 11 elx))) (list 0.0))) (assoc 11 elx) elx))
            (entupd (setq el (cdr (assoc -1 (entmod elx)))))
            (if (and (not (vl-some (function (lambda ( x ) (equal x (list (cdr (assoc 10 elx)) (cdr (assoc 11 elx))) 1e-6))) lil)) (not (vl-some (function (lambda ( x ) (equal x (list (cdr (assoc 11 elx)) (cdr (assoc 10 elx))) 1e-6))) lil)))
              (setq lst (cons (vlax-ename->vla-object el) lst) lil (cons (list (cdr (assoc 10 (entget el))) (cdr (assoc 11 (entget el)))) lil))
            )
          )
          ( (= "SPLINE" (cdr (assoc 0 elx)))
            (setq ell (cons el ell))
            (if (assoc 10 (setq elx (entget el)))
              (if (not (vl-some (function (lambda ( x ) (equal x (list (cdr (assoc 10 elx)) (cdr (assoc 10 (reverse elx)))) 1e-6))) lil))
                (setq lst (cons (vlax-ename->vla-object (entmakex (list (cons 0 "LINE") (cons 10 (append (mapcar (function +) (list 0.0 0.0) (cdr (assoc 10 elx))) (list 0.0))) (cons 11 (append (mapcar (function +) (list 0.0 0.0) (cdr (assoc 10 (reverse elx)))) (list 0.0)))))) lst) lil (cons (list (cdr (assoc 10 (entget (entlast)))) (cdr (assoc 11 (entget (entlast))))) lil) lil (cons (list (cdr (assoc 11 (entget (entlast)))) (cdr (assoc 10 (entget (entlast))))) lil))
              )
              (if (not (vl-some (function (lambda ( x ) (equal x (list (cdr (assoc 11 elx)) (cdr (assoc 11 (reverse elx)))) 1e-6))) lil))
                (setq lst (cons (vlax-ename->vla-object (entmakex (list (cons 0 "LINE") (cons 10 (append (mapcar (function +) (list 0.0 0.0) (cdr (assoc 11 elx))) (list 0.0))) (cons 11 (append (mapcar (function +) (list 0.0 0.0) (cdr (assoc 11 (reverse elx)))) (list 0.0)))))) lst) lil (cons (list (cdr (assoc 10 (entget (entlast)))) (cdr (assoc 11 (entget (entlast))))) lil) lil (cons (list (cdr (assoc 11 (entget (entlast)))) (cdr (assoc 10 (entget (entlast))))) lil))
              )
            )
          )
        )
        (foreach el ell
          (if (not (vlax-erased-p el))
            (entdel el)
          )
        )
      )
      (setq regs (mapcar (function vlax-vla-object->ename) (vl-catch-all-apply (function vlax-invoke) (list spc (quote addregion) lst))))
      (foreach obj lst
        (if (and obj (= (type obj) (quote vla-object)) (not (vlax-erased-p obj)))
          (progn
            (vla-delete obj)
            (vlax-release-object obj)
          )
        )
      )
      (setq lst nil)
      (setq mainreg (vl-some (function (lambda ( x ) (if (equal (vla-get-area (vlax-ename->vla-object x)) amax 1e-6) x))) regs))
      (setq regs (vl-remove mainreg regs))
      (vl-cmdf "_.explode" mainreg)
      (while (< 0 (getvar (quote cmdactive)))
        (vl-cmdf "")
      )
      (vl-cmdf "_.pedit" "_m" (ssget "_p") "" "_j")
      (while (< 0 (getvar (quote cmdactive)))
        (vl-cmdf "")
      )
      (setq main (entlast))
      (while (< (length islrgs) nn)
        (foreach pl (mapcar (function cadr) pols)
          (setq p1 (car pl) p2 (cadr pl))
          (setq p1 (mapcar (function +) p1 (mapcar (function *) (list 0.1 0.1 0.1) (mapcar (function -) p2 p1))))
          (setq p2 (mapcar (function +) p1 (mapcar (function *) (list 0.9 0.9 0.9) (mapcar (function -) p2 p1))))
          (setq rss (ssget "_f" (list p1 p2) (list (cons 0 "REGION"))))
          (foreach r (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex rss)))
            (if (regchk r (mapcar (function cadr) pols))
              (setq islrgs (cons r islrgs) regs (vl-remove r regs))
            )
          )
        )
      )
      (foreach r islrgs
        (vl-cmdf "_.explode" r)
        (while (< 0 (getvar (quote cmdactive)))
          (vl-cmdf "")
        )
        (vl-cmdf "_.pedit" "_m" (ssget "_p") "" "_j")
        (while (< 0 (getvar (quote cmdactive)))
          (vl-cmdf "")
        )
        (setq isl (cons (entlast) isl))
      )
      (setq se (ssadd))
      (foreach r regs
        (vl-cmdf "_.explode" r)
        (while (< 0 (getvar (quote cmdactive)))
          (vl-cmdf "")
        )
        (if (/= hop "0")
          (progn
            (vl-cmdf "_.pedit" "_m" (ssget "_p") "" "_j")
            (while (< 0 (getvar (quote cmdactive)))
              (vl-cmdf "")
            )
          )
          (foreach li (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex (ssget "_p"))))
            (ssadd li se)
          )
        )
      )
      (if (/= hop "0")
        (progn
          (setq vll (mapcar (function cadr) pols))
          (vlax-invoke (vlax-ename->vla-object main) (quote offset) -1e-3)
          (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea main))
            (setq vll (cons (mapcar (function (lambda ( p ) (trans p main 0))) (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget main)))) vll))
            (setq vll (cons (mapcar (function (lambda ( p ) (trans p main 0))) (reverse (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget main))))) vll))
          )
          (entdel (entlast))
          (foreach vl vll
            (setq vvv nil)
            (mapcar (function (lambda ( a b ) (setq vvv (cons (list a b (mid a b)) vvv)))) vl (append (cdr vl) (list (car vl))))
            (foreach abc (reverse vvv)
              (setq a (car abc) b (cadr abc) c (caddr abc))
              (setq p1 nil p2 nil lw nil 3dlw nil chk nil)
              (if (not (equal a b 1e-6))
                (progn
                  (setq p1 (osnap (mapcar (function +) a (mapcar (function *) (list 0.1 0.1 0.1) (mapcar (function -) b a))) "_nea")
                        p2 (osnap (mapcar (function +) a (mapcar (function *) (list 0.9 0.9 0.9) (mapcar (function -) b a))) "_nea")
                  )
                  (if (or (not p1) (not p2))
                    (setq p1 (mapcar (function +) a (mapcar (function *) (list 0.1 0.1 0.1) (mapcar (function -) b a)))
                          p2 (mapcar (function +) a (mapcar (function *) (list 0.9 0.9 0.9) (mapcar (function -) b a)))
                    )
                  )
                  (if command-s
                    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.zoom" "_w" a b)))
                      (vl-cmdf "_.zoom" "_w" a b)
                    )
                    (vl-cmdf "_.zoom" "_w" a b)
                  )
                  (setq sel (ssget "_f" (list p1 p2) (list (cons 0 "LWPOLYLINE"))))
                  (if (and sel (= (sslength sel) 2))
                    (setq chk t)
                  )
                  (if (not chk)
                    (setq sel (ssget "_cp" (list (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* -0.5 pi)) 1e-3) (polar p2 (+ (angle p1 p2) (* 0.5 pi)) 1e-3) (polar p1 (+ (angle p1 p2) (* 0.5 pi)) 1e-3)) (list (cons 0 "LWPOLYLINE"))))
                  )
                  (if (and sel (= (sslength sel) 2))
                    (setq chk t)
                  )
                  (if command-s
                    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.ucs" "_3p" a b "")))
                      (vl-cmdf "_.ucs" "_3p" a b "")
                    )
                    (vl-cmdf "_.ucs" "_3p" a b "")
                  )
                  (if command-s
                    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.ucs" "_3p" (list 0.0 0.0 0.0) (list 1.0 0.0 0.0) (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))))
                      (vl-cmdf "_.ucs" "_3p" (list 0.0 0.0 0.0) (list 1.0 0.0 0.0) (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
                    )
                    (vl-cmdf "_.ucs" "_3p" (list 0.0 0.0 0.0) (list 1.0 0.0 0.0) (list 0.0 (cos (* (/ *ang* 180.0) pi)) (sin (* (/ *ang* 180.0) pi))))
                  )
                  (if chk
                    (progn
                      (if (ssmemb main sel)
                        (ssdel main sel)
                      )
                      (foreach is isl
                        (if (ssmemb is sel)
                          (ssdel is sel)
                        )
                      )
                      (setq lw (ssname sel 0))
                      (if (= op "2")
                        (if lw
                          (progn
                            (setq 3dlw (vl-catch-all-apply (function make3dlw) (list lw)))
                            (setq el (entlast))
                            (setq c (col (distance v (trans (list 0.0 0.0 1.0) 1 0 t))))
                            (if command-s
                              (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.ucs" "_p")))
                                (vl-cmdf "_.ucs" "_p")
                              )
                              (vl-cmdf "_.ucs" "_p")
                            )
                            (process-hatch)
                            (if (= op "2")
                              (progn
                                (if (and lw (not (vlax-erased-p lw)))
                                  (if command-s
                                    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.draworder" lw "" "_f")))
                                      (vl-cmdf "_.draworder" lw "" "_f")
                                    )
                                    (vl-cmdf "_.draworder" lw "" "_f")
                                  )
                                )
                                (if (and 3dlw (not (vlax-erased-p 3dlw)))
                                  (entdel 3dlw)
                                )
                              )
                              (progn
                                (if (and 3dlw (not (vlax-erased-p 3dlw)))
                                  (entdel 3dlw)
                                )
                                (if (and lw (not (vlax-erased-p lw)))
                                  (entdel lw)
                                )
                              )
                            )
                          )
                        )
                      )
                      (if (= op "3")
                        (if lw
                          (progn
                            (setq 3dlw (vl-catch-all-apply (function make3dlw) (list lw)))
                            (setq el (entlast))
                            (setq c (col (distance v (trans (list 0.0 0.0 1.0) 1 0 t))))
                            (process-hatch)
                            (if (= op "2")
                              (progn
                                (if (and lw (not (vlax-erased-p lw)))
                                  (if command-s
                                    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.draworder" lw "" "_f")))
                                      (vl-cmdf "_.draworder" lw "" "_f")
                                    )
                                    (vl-cmdf "_.draworder" lw "" "_f")
                                  )
                                )
                                (if (and 3dlw (not (vlax-erased-p 3dlw)))
                                  (entdel 3dlw)
                                )
                              )
                              (progn
                                (if (and 3dlw (not (vlax-erased-p 3dlw)))
                                  (entdel 3dlw)
                                )
                                (if (and lw (not (vlax-erased-p lw)))
                                  (entdel lw)
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                  )
                  (if (= op "2")
                    (if command-s
                      (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.ucs" "_p")))
                        (vl-cmdf "_.ucs" "_p")
                      )
                      (vl-cmdf "_.ucs" "_p")
                    )
                    (repeat 2
                      (if command-s
                        (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.ucs" "_p")))
                          (vl-cmdf "_.ucs" "_p")
                        )
                        (vl-cmdf "_.ucs" "_p")
                      )
                    )
                  )
                  (if command-s
                    (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.zoom" "_p")))
                      (vl-cmdf "_.zoom" "_p")
                    )
                    (vl-cmdf "_.zoom" "_p")
                  )
                )
              )
            )
          )
          (foreach obj lst
            (if (and obj (= (type obj) (quote vla-object)) (not (vlax-erased-p obj)))
              (vla-delete obj)
              (vlax-release-object obj)
            )
          )
        )
        (progn
          (setq vll (cons (mapcar (function (lambda ( p ) (trans p main 0))) (reverse (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget main))))) vll))
          (foreach is isl
            (setq vll (cons (mapcar (function (lambda ( p ) (trans p is 0))) (reverse (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget is))))) vll))
          )
          (foreach vl vll
            (setq pll (mapcar (function (lambda ( a b ) (list a b))) vl (append (cdr vl) (list (car vl)))))
            (foreach ab pll
              (setq a (car ab) b (cadr ab))
              (setq p1 (mapcar (function +) a (mapcar (function *) (mapcar (function -) b a) (list 0.1 0.1 0.1))))
              (setq p2 (mapcar (function +) a (mapcar (function *) (mapcar (function -) b a) (list 0.9 0.9 0.9))))
              (if (setq s (ssget "_f" (list p1 p2) (list (cons 0 "LINE"))))
                (if command-s
                  (command-s "_.erase" s "")
                  (vl-cmdf "_.erase" s "")
                )
              )
            )
          )
          (vl-cmdf "_.-overkill" se "")
          (while (< 0 (getvar (quote cmdactive)))
            (vl-cmdf "")
          )
        )
      )
    )
  )
  (if (= 0 (getvar (quote worlducs)))
    (progn
      (if command-s
        (command-s "_.ucs" "_w")
        (vl-cmdf "_.ucs" "_w")
      )
      (setq ucsf t)
    )
  )
  (if (= op "3")
    (if command-s
      (if (vl-catch-all-error-p (vl-catch-all-apply (function command-s) (list "_.pasteclip" (list 0.0 0.0 0.0))))
        (vl-cmdf "_.pasteclip" (list 0.0 0.0 0.0))
      )
      (vl-cmdf "_.pasteclip" (list 0.0 0.0 0.0))
    )
  )
  (if ucsf
    (if command-s
      (command-s "_.ucs" "_p")
      (vl-cmdf "_.ucs" "_p")
    )
  )
  (if command-s
    (command-s "_.-view" "_r" "{ tmp }")
    (vl-cmdf "_.-view" "_r" "{ tmp }")
  )
  (if command-s
    (command-s "_.-view" "_d" "{ tmp }")
    (vl-cmdf "_.-view" "_d" "{ tmp }")
  )
  (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")
  (if (= "BRICSCAD" (strcase (getvar (quote program))))
    (progn
      (vl-cmdf "_.rtrotctr" "_non" (mapcar (function +) (list 0.0 0.0) (getvar (quote viewctr))))
      (while (< 0 (getvar (quote cmdactive)))
        (vl-cmdf "\\")
      )
    )
    (progn
      (if command-s
        (command-s "_.3dorbitctr" "_non" (mapcar (function +) (list 0.0 0.0) (getvar (quote viewctr))))
        (vl-cmdf "_.3dorbitctr" "_non" (mapcar (function +) (list 0.0 0.0) (getvar (quote viewctr))))
      )
    )
  )
  (*error* nil)
)