;;;--------------------- Creating a hip roof -------------------------;;;
;;;                                                                   ;;;
;;;  file:    HipRoof.lsp                                             ;;;
;;;  author:  Gian Paolo Cattaneo                                     ;;;
;;;  version: 1.0 - 06.oct.2013                                       ;;;
;;;                                                                   ;;;
;;;-------------------------------------------------------------------;;;

(defun c:hr ( / *error* bulge? slope->ang 2D LM:Unique coll_p verify_n flat_line Vert_poly MaximumInscribedCircle_p grid_1 grid_2 inside_p Point_center dist R0 *er* s1 s2 p pp osm cmd ch au angb angd *angn* poly h elev list_vert_poly EL sol :L NL )

;****************************************************************************

(defun bulge? (PL / par *bulge* )
    (repeat (fix (setq par (vlax-curve-GetEndParam PL)))
        (if (not (zerop (vla-getbulge (vlax-ename->vla-object PL) (setq par (1- par)))))
            (setq *bulge* T)
        )
    )
    *bulge*
)

;****************************************************************************

(defun slope->ang (sl / v1 v2 *ang)
    (setq v1 (list 0.0 0.0))
    (setq v2 (list 1.0 (/ sl 100.0)))
    (setq *ang (cvunit (angle v1 v2) "radian" "degree"))
    *ang
)  

;****************************************************************************

(defun 2D (/ e_new )
    (setq EL (entlast) sol EL)
    (vl-cmdf "_xedges" EL "")
    (if (/= EL (entlast))
        (while (setq EL (entnext EL))
       	    (if (entget EL) (setq E_new (cons EL E_new)))
        )
    )
    (setq NL 0)
    (setq :L (ssadd))
    (mapcar
       '(lambda (x)
             (flat_line x)
             (setq :L (ssadd x :L))
        )
        E_new
    )
)

;****************************************************************************
;; Unique  -  Lee Mac                                                        
;; Returns a list with duplicate elements removed.                           
(defun LM:Unique ( l ) 
    (if l
        (cons (car l)
              (LM:Unique (vl-remove (car l) (cdr l)))
        )
    )
)

;****************************************************************************
;      Valuta tre vertici successivi di una lista (2D) e ritorna l'elenco    
;      dei vertici collineari                                                
;      Evaluates 3 successive vertices of a list and returns the list of     
;      aligned vertices.                                                     
(defun coll_p ( L_vert / Lv_coll)
    (mapcar
        (function
            (lambda ( a b c )
                (if (equal (angle a b) (angle a c) 1e-8) (setq Lv_coll (cons b Lv_coll)))
            )
        )
        (cons (last L_vert) L_vert) L_vert (append (cdr L_vert) (list (car L_vert)))
    )
    Lv_coll
)

;****************************************************************************
;      Verifica il numero delle nuove linee (colmi e cantonali) in base      
;      al numero di segmenti della poly.                                     
;      Check the number of new lines (ridges and valleys) according to       
;      the segments number of polyline.                                      
(defun verify_n ( / Lv_ Lvc_ nv_p NL_max)
    
    ;lista dei vertici esclusi i duplicati
    (setq Lv_ (LM:Unique list_vert_poly))

    ;lista vertici collineari
    (setq Lvc_ (coll_p Lv_))

    ;numero dei vertici validi per la verifica
    (setq nv_p (- (length Lv_) (length Lvc_)))

    ;numero max nuove linee
    (setq NL_max (+ 3 (* 2 (- nv_p 3))))

    ;verifica 
    (if (> NL NL_max) nil T)
)

;****************************************************************************

(defun flat_line ( :L / ) ;elev)
    (setq e1 (entget :L))
    (if (= "LINE" (cdr (assoc 0 e1)))
        (progn
            (setq z1 (assoc 10 e1))
            (setq z2 (assoc 11 e1))
            (cond
                ( (and (equal (last z1) elev 1e-6) (equal (last z2) elev 1e-6)) (entdel :L) )
                ( (or (not (equal (last z1) elev 1e-6)) (not (equal (last z2) elev 1e-6)))
                  (if (not (equal (last z1) elev 1e-6))
                      (setq e1 (subst (list 10 (cadr z1) (caddr z1) elev) (assoc 10 e1) e1))
                  )
                  (if (not (equal (last z2) elev 1e-6))
                      (setq e1 (subst (list 11 (cadr z2) (caddr z2) elev) (assoc 11 e1) e1))
                  )
                  (entmod e1)
                  (setq NL (1+ NL))
                )
            )
        )
    )
)

;****************************************************************************
;  Ritorna il centro del massimo cerchio inscritto in una polilinea          
;  Returns the center point of the maximum inscribed circle in a polyline    
;                    Author: Gian Paolo Cattaneo 
;  edited by GSLS(SS) 2012-8-5
;****************************************************************************                            
  (defun MaximumInscribedCircle_p ( poly / step1 step2 all_ins r0 P_center )

      (setq step1 48) ;_--> grid_1      
      (setq step2 32) ;_--> grid_2
      (setq list_vert_poly (Vert_poly))      
      (grid_1)
      (inside_p)
      (Point_center)
      (while (> (- Dist R0) 4e-13)
        (grid_2)
        (inside_p)
        (Point_center)
      )
      P_center
  )
; restituisce la lista dei vertici di una polilinea
; Returns a list of polyline vertices
  (defun Vert_poly (/ n_par pt Lv ) ;elev)
      (setq n_par (fix (vlax-curve-getendparam poly)))
      (repeat n_par
          (setq pt (vlax-curve-getpointatparam poly (setq n_par (1- n_par))))
          (setq Lv (cons pt Lv))
          (if (= 1 (length Lv)) (setq elev (last pt)))
          (if (/= (last pt) elev)
              (progn
                  (alert
                      (strcat
                          "Invalid Object Selected."
                          "\nThe z coordinate must be the same for all vertices."
                      )
                  )
                  (exit)
              )
          )
      )
      Lv
  )
;; Restituisce una griglia di punti all'interno del getboundingbox della poly selezionata
;; Returns a grid of points within the BoundingBox of the selected poly
  (defun grid_1 (/ p1 p2 X1 Y1 l1)
    (vla-getboundingbox (vlax-ename->vla-object POLY) 'p1 'p2)
    (setq	p1 (vlax-safearray->list p1)
          p2 (vlax-safearray->list p2)
          p1 (list (car p1) (cadr p1))
          p2 (list (car p2) (cadr p2))
    )
    (setq Dx (/ (- (car p2) (car p1)) step1))
    (setq Dy (/ (- (cadr p2) (cadr p1)) step1))
    (setq	Lp (list p1)
          X1 (car p1)
          Y1 (cadr p1)
    )
    (repeat step1
      (setq Lp (cons (list (setq X1 (+ X1 Dx)) Y1) Lp))
    )
    (setq Lp (list Lp))
    (repeat step1
      (setq Lp (cons (mapcar (function (lambda (x)
                 (list (car x) (+ (cadr x) Dy))
               )
           )
           (car lp)
         )
         Lp
         )
      )
    )
    (setq Lp (apply (function append) Lp))
  )
;; Restituisce una griglia di punti intorno al punto centrale (provvisorio)
;; Returns a grid of points around the center point (provisional)
  (defun grid_2 (/ X1 Y1 P1)
    (setq list_p_int nil
          X1	   (- (car P_center) (* 1.0 Dx (/ step1 4.0)))
          Y1	   (- (cadr P_center) (* 1.0 Dy (/ step1 4.0)))
          P1	   (list X1 Y1)
          Dx	   (/ (* 2.0 Dx (/ step1 4.0)) step2)
          Dy	   (/ (* 2.0 Dy (/ step1 4.0)) step2)
    )
    (setq list_p_int (list P1))
    (repeat step2
      (setq list_p_int (cons (list (setq X1 (+ X1 Dx)) Y1) list_p_int))
    )
    (setq list_p_int (list list_p_int))
    (repeat step2
      (setq list_p_int
        (cons (mapcar (function (lambda (x)
                (list (car x) (+ (cadr x) Dy))
                  )
                )
                (car list_p_int)
              )
              list_p_int
        )
      )
    )
    (setq list_p_int (apply (function append) list_p_int))
    (setq step1 step2)
  )
; restituisce la lista dei punti interni ad un poligono
; dati:  - lista coordinate dei punti -> Lp
;        - lista coordinate vertici poligono -> list_vert_poly
; Returns the list of points inside the polyline
  (defun inside_p (/ remote_p n Pr cont attr p# Pa Pa_ Pb )
      (setq remote_p (list (* 1.1 (car (getvar "extmax"))) (* 1.1 (cadr (getvar "extmax")))))
      (if (not all_ins)
          (progn
              (setq list_p_int nil)
              (foreach Pr Lp	
                  (setq cont -1)
                  (setq attr 0)
                  (setq p# nil)	
                  (setq Pa (nth (setq cont (1+ cont)) list_vert_poly))
                  (setq Pa_ Pa)
                  (repeat (length list_vert_poly)
                      (setq Pb (nth (setq cont (1+ cont)) list_vert_poly))
                      (if (= cont (length list_vert_poly)) (setq Pb Pa_))
                      (setq P# (inters Pa Pb Pr remote_p))
                      (if (/= P# nil) (setq attr (1+ attr)))
                      (setq Pa Pb)
                  )
                  (if (> (rem attr 2) 0) (setq list_p_int (cons Pr list_p_int)))	     
              )
              (setq list_p_int (reverse list_p_int))
              (if (vl-every '(lambda ( a b ) (equal a b 1e-8)) Lp list_p_int)
                  (setq all_ins t)
                  (setq all_ins nil)
              )
              (setq Lp list_p_int)
          )
      )
  )
;; Da una lista di punti restituisce quello pi lontano da un oggetto
;; dati:  - lista dei punti -> list_p_int
;;        - oggetto -> POLY_vl
;; Returns the farthest point from the polyline
  (defun Point_center ( / Pa Pvic )
    (if (null Dist) (setq Dist 1e-6))
    (foreach Pa list_p_int
      (setq Pvic (vlax-curve-getClosestPointTo Poly Pa))
      (if (> (distance Pa Pvic) Dist)
        (setq P_center Pa
              R0       Dist
              Dist     (distance Pa Pvic)
        )
      )
    )
  )

;****************************************************************************

    (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))
    ;(or CAL (arxload "GEOMCAL"))
;|
    (if (< (atoi (substr (ver) 13)) 2007)
        (progn
            (alert "This software require AutoCAD 2007 or higher.")
            (exit)
        )
    )
|;    
    (defun *error* (msg)
        (if (= *er* 1)
            (vla-sendcommand
                (vla-get-ActiveDocument (vlax-get-acad-object))
                (strcat (chr 27)(chr 27)"_.undo _end ")
            )
            (vl-cmdf "_.undo" "_end")
        )

        (setvar 'aunits au)
        (setvar 'angdir angd)
        (setvar 'angbase angb)
        (setvar 'delobj dobj)    
        (setvar 'cmdecho cmd)
        (setvar 'osmode osm)
        (if msg (prompt msg))
        (princ) 
    )
    
    (setq cmd (getvar 'cmdecho)
           au (getvar 'aunits)
         angb (getvar 'angbase)
         angd (getvar 'angdir)
         dobj (getvar 'delobj)
          osm (getvar 'osmode)
    )
  
    (vl-cmdf "_.undo" "_begin")
  
    (setvar 'cmdecho 0)
    (setvar 'aunits 0)
    (setvar 'angdir 1)
    (setvar 'angbase (/ pi 2))
    (setvar 'delobj 0)
    (setvar 'osmode 512)
    
    (setq s1 (ssget "_X" '((0 . "3DSOLID"))))
    (or model (setq model "2D"))
    (or slope (setq slope 50))
    (or *ang* (setq *ang* 45))
    (initget "2D 3D")
    (setq model
             (cond
                 ( (getkword (strcat "\nEnter choice [2D/3D]  <" model ">: ")) )
                 ( model )
             )
    )
    (if (= model "3D")
           (progn
               (initget 1 "Slope Angle")
               (setq ch (getkword "\nInput value [Angle/Slope] : "))
               (if (eq ch "Slope")
                   (progn
                       (initget 6)
                       (setq slope
                                (cond
                                    ( (getreal (strcat "\nSlope (%)" (if slope (strcat " <" (rtos slope 2 1) ">: ")": "))) )
                                    ( slope )
                                )
                       )
                   )
                   (progn
                       (initget 6)
                       (setq *ang*
                                (cond
                                    ( (getreal (strcat "\nAngle in decimal degrees " (if *ang* (strcat " <" (rtos *ang* 2 1) ">: ")": "))) )
                                    ( (float *ang*) )
                                )
                       )
                   )
               )
           )
    )
    (if 
        (and
            (princ "\nSelect a Closed Polyline")
            (setq poly (ssget "_+.:S:E" '((0 . "*POLYLINE")(-4 . "&=")(70 . 1))))
            (setq poly (ssname poly 0))
            (setq pp (vlax-curve-getclosestpointto poly (cadr (grread t))))
        )
        (if (or
                (= 8 (logand 8 (cdr (assoc 70 (entget poly)))))
                (not (bulge? poly))
            )
            (progn
                (setq *er* 1)
                (if (eq ch "Slope")
                    (setq *ang* (slope->ang slope))
                    (setq slope (* (/ (sin (* (/ *ang* 180.0) pi)) (cos (* (/ *ang* 180.0) pi))) 100.0))
                )
                (if (<= (atoi (substr (ver) 13)) 2010) (setq *angn* (- *ang* 90.0)) (setq *angn* *ang*))
                (setq p (MaximumInscribedCircle_p poly)
                      p (trans (list (car p) (cadr p) elev) 0 1)
                      h (/ (* dist slope) 100.0)
                      EL (entlast)
                )
                (vl-cmdf "_extrude" "_mode" "_solid" poly "" "_t" (rtos *angn*) "0.01" )
                (prompt "\n")(prompt "\n")(prompt "\n")
                (if (not (equal EL (entlast)))
                    (progn
                        (vl-cmdf
                            "_solidedit"
                            "_f"
                            "_m"
                            p
                            ""
                            "_non" (trans '(0.0 0.0 0.0) 0 1)
                            "_non" (trans (list 0.0 0.0 (* h 1.003)) 0 1)
                            "_x"
                            "_x"
                        )
                        (vl-cmdf "_.solidedit" "_b" "_p" (entlast) "" "_x")
                        (setq s2 (ssget "_X" '((0 . "3DSOLID"))))
                        (vl-cmdf "_.erase" (acet-ss-remove s1 s2) "_r" "_c" (mapcar '- pp '(1e-1 1e-1 1e-1)) (mapcar '+ pp '(1e-1 1e-1 1e-1)) "")
                        (2D)
                        (if (verify_n)
                            (if (= model "2D") (entdel sol) (vl-cmdf "_erase" :L "")) 
                            (progn
                                (entdel sol)
                                (vl-cmdf "_erase" :L "")                      
                                (alert "Failed creation.")
                            )
                        )
                    )
                    (progn
                        (vl-cmdf)
                        (prompt "\n")(prompt "\n")(prompt "\n")
                        (alert "Failed creation.")
                    )
                )
            )
            (alert "The Polyline has one or more Arc segments")
        )
        (alert "No Closed Polyline Selected")
    )
    (*error* nil) 
)
