(defun c:roof-2d-short-n ( / *error* unit inside-p car-sort dist rem_coll_pts getlwpts collinear-p cichk clockwiselw-p clockwise-p chkttt processchk unique uniquelil uniquetll freepts ptss collinearptschk group_collinear_pts process liln lilchk proc2xx
                             adoc osm cmd fuzz s ti lw lwl pl pll tll ttll ppl ppll ppllo lil lil0 lil1 lil2 lil3 lil4 lil5 lil6 lil7 lil8 lil9 lil10 chkppx ff pts gg xx si ips fl m )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if osm (setvar (quote osmode) osm))
    (if cmd (setvar (quote cmdecho) cmd))
    (if (and lwl (not (vlax-erased-p lwl))) (entdel lwl))
    (if adoc
      (if (= 8 (logand 8 (getvar (quote undoctl))))
        (vla-endundomark adoc)
      )
    )
    (if ti (progn (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")))
    (if lil (sssetfirst nil sss) (setq sss nil))
    (if m
      (prompt (strcat "\n" m))
      (if lil (prompt "\nSelection set with solution is highlighted and stored in global variable \"sss\"... Invoke it with : !sss, or (sssetfirst nil sss)..."))
    )
    (princ)
  )

  ;;; SUB FUNCTIONS ;;;

  (defun unit ( v / d )
    (if (and v (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-10)))
      (mapcar (function (lambda ( x ) (/ x d))) v)
    )
  )

  (defun inside-p ( p lw lwl )
    (< (distance p (vlax-curve-getclosestpointto lwl p)) (distance p (vlax-curve-getclosestpointto lw p)))
  )

  (defun car-sort ( lst fun / r )
    (setq r (car lst))
    (foreach itm (cdr lst)
      (if (apply fun (list itm r))
        (setq r itm)
      )
    )
    r
  )

  (defun dist ( p pp tt )
    (distance p (inters p (polar p (+ (angle (list 0.0 0.0) tt) (* 0.5 pi)) 1.0) pp (polar pp (angle (list 0.0 0.0) tt) 1.0) nil))
  )

  (defun rem_coll_pts ( pts / a ptsp ptsn )
    (setq a (angle (car pts) (cadr pts)))
    (while (equal a (angle (car pts) (cadr pts)) 1e-8)
      (setq pts (append (cdr pts) (list (car pts))))
    )
    (setq ptsp (cons (last pts) (reverse (cdr (reverse pts)))) ptsn (append (cdr pts) (list (car pts))))
    (unique (vl-remove nil (mapcar (function (lambda ( a b c ) (if (not (equal (distance a c) (+ (distance a b) (distance b c)) 1e-4)) b))) (append ptsp ptsp) (append pts pts) (append ptsn ptsn))))
  )

  (defun getlwpts ( lw / i pl )
    (setq i -1)
    (while (< (setq i (1+ i)) (vlax-curve-getendparam lw))
      (setq pl (cons (mapcar (function +) (list 0.0 0.0) (vlax-curve-getpointatparam lw (float i))) pl))
    )
    (reverse pl)
  )

  (defun collinear-p ( p1 p2 p3 )
    (
      (lambda ( a b c )
        (or
          (equal (+ a b) c 1e-8)
          (equal (+ b c) a 1e-8)
          (equal (+ c a) b 1e-8)
        )
      )
      (distance p1 p2) (distance p2 p3) (distance p1 p3)
    )
  )

  (defun cichk ( lw ip rad / ci pp )
    (setq ci (entmakex (list (cons 0 "CIRCLE") (cons 10 ip) (cons 40 (- rad fuzz)))))
    (setq pp (vlax-invoke (vlax-ename->vla-object ci) (quote intersectwith) (vlax-ename->vla-object lw) acextendnone))
    (entdel ci)
    (not pp)
  )

  (defun clockwiselw-p ( lw / ll ur p1 p2 p3 p4 )
    (vla-getboundingbox (vlax-ename->vla-object lw) (quote ll) (quote ur))
    (mapcar (function set) (list (quote ll) (quote ur)) (mapcar (function safearray-value) (list ll ur)))
    (setq p1 (vlax-curve-getclosestpointto lw ll))
    (setq p2 (vlax-curve-getclosestpointto lw (list (car ur) (cadr ll))))
    (setq p3 (vlax-curve-getclosestpointto lw ur))
    (setq p4 (vlax-curve-getclosestpointto lw (list (car ll) (cadr ur))))
    (setq p1 (vlax-curve-getparamatpoint lw p1))
    (setq p2 (vlax-curve-getparamatpoint lw p2))
    (setq p3 (vlax-curve-getparamatpoint lw p3))
    (setq p4 (vlax-curve-getparamatpoint lw p4))
    (not
      (or
        (< p1 p2 p3 p4)
        (< p2 p3 p4 p1)
        (< p3 p4 p1 p2)
        (< p4 p1 p2 p3)
      )
    )
  )

  (defun clockwise-p ( p1 p2 p3 )
    (< 
      (* (- (car p2) (car p1)) (- (cadr p3) (cadr p1)))
      (* (- (cadr p2) (cadr p1)) (- (car p3) (car p1)))
    )
  )

  (defun chkttt ( pp1 pp2 flg / ttx ttt tt t1 t3 ip np dl d dd lws1 lws2 lwss1 lwss2 tst lw1 lw2 p1 p2 el lwx n m x y z lws22 lw22 pp pts f fff xx r ) ;;; ff - lexical global variable ;;;
    (if (and (caadr pp1) (cadadr pp1) (caadr pp2) (cadadr pp2) (setq ip (inters (caadr pp1) (mapcar (function +) (caadr pp1) (cadadr pp1)) (caadr pp2) (mapcar (function +) (caadr pp2) (cadadr pp2)) nil)))
      (if
        (and
          (setq ttt (append (car pp1) (car pp2)))
          (or
            (setq ttx (vl-some (function (lambda ( x ) (if (= (length (vl-remove x ttt)) 2) x))) ttt))
            (setq ttx (vl-some (function (lambda ( x ) (vl-some (function (lambda ( y ) (if (and (collinear-p (car x) (cadr x) (car y)) (collinear-p (car x) (cadr x) (cadr y)) (collinear-p (car y) (cadr y) (car x)) (collinear-p (car y) (cadr y) (cadr x))) (list x y)))) (vl-remove x ttt)))) ttt))
          )
        )
        (progn
          (setq tt (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-4))) (if (numberp (caar ttx)) (list ttx) ttx)))) ttt))
          (setq dl (mapcar (function (lambda ( x ) (dist ip (car x) (unit (mapcar (function -) (cadr x) (car x)))))) (if (not ttll) (setq ttll (uniquetll tll)) ttll)))
          (foreach d dl
            (if (> (- (length dl) (length (vl-remove-if (function (lambda ( x ) (equal x d (* 250.0 fuzz)))) dl))) 2)
              (setq tst (cons d tst))
              (setq tst (cons nil tst))
            )
          )
          (setq dl (mapcar (function (lambda ( x ) (dist ip (car x) (unit (mapcar (function -) (cadr x) (car x)))))) tt))
          (foreach d dl
            (if (> (- (length dl) (length (vl-remove-if (function (lambda ( x ) (equal x d (* 250.0 fuzz)))) dl))) 1)
              (setq dd (cons d dd))
              (setq dd (cons nil dd))
            )
          )
          (setq d (vl-some (function (lambda ( x ) (if (vl-some (function (lambda ( y ) (equal x y (* 250.0 fuzz)))) (vl-sort (vl-remove nil tst) (function <))) x))) (vl-sort (vl-remove nil dd) (function <))))
          (if (and ip d (= (length tt) 2) (inside-p ip lw lwl) (cichk lw ip d))
            (progn
              (setq t1 (car tt) t3 (cadr tt))
              (setq np
                (list tt
                  (list ip
                    (if
                      (or
                        (equal (unit (mapcar (function -) (cadr t1) (car t1))) (unit (mapcar (function -) (cadr t3) (car t3))) 1e-4)
                        (equal (unit (mapcar (function -) (cadr t1) (car t1))) (unit (mapcar (function -) (car t3) (cadr t3))) 1e-4)
                      )
                      (unit (mapcar (function -) (cadr t1) (car t1)))
                      (unit (mapcar (function -) ip (inters (car t1) (cadr t1) (car t3) (cadr t3) nil)))
                    )
                  )
                )
              )
              (if
                (setq pp (vl-some (function (lambda ( x )
                  (if
                    (and
                      (or
                        (and
                          (or (equal (unit (mapcar (function -) ip (caadr x))) (cadadr np) 1e-4) (equal (unit (mapcar (function -) (caadr x) ip)) (cadadr np) 1e-4))
                          (or (equal (cadadr x) (cadadr np) 1e-4) (equal (mapcar (function -) (cadadr x)) (cadadr np) 1e-4))
                        )
                        (equal (caadr x) (inters (car t1) (cadr t1) (car t3) (cadr t3) nil) 1e-4)
                      )
                      (vl-some (function (lambda ( y ) (equal (car tt) y 1e-4))) (car x))
                      (vl-some (function (lambda ( y ) (equal (cadr tt) y 1e-4))) (car x))
                    )
                    x
                  )
                  ))
                  ppll
                  )
                )
                (progn
                  (setq f t)
                  (setq lil (cons (list (caadr pp) ip) lil))
                  (setq lil (cons (list (caadr pp1) ip) lil))
                  (setq lil (cons (list (caadr pp2) ip) lil))
                  (setq ppll (vl-remove-if (function (lambda ( x ) (equal x pp 1e-4))) ppll))
                  (setq ppll (vl-remove-if (function (lambda ( x ) (equal x pp1 1e-4))) ppll))
                  (setq ppll (vl-remove-if (function (lambda ( x ) (equal x pp2 1e-4))) ppll))
                )
              )
              (if (not f)
                (progn
                  (cond
                    ( (not ff)
                      (if (not (setq xx (vl-some (function (lambda ( x ) (if (equal (caadr pp1) (cadr x) 1e-4) x))) chkppx)))
                        (setq chkppx (cons (list (distance ip (caadr pp1)) (caadr pp1)) chkppx))
                        (if (< (distance ip (caadr pp1)) (car xx))
                          (setq chkppx (subst (list (distance ip (caadr pp1)) (caadr pp1)) xx chkppx))
                        )
                      )
                      (if (not (setq xx (vl-some (function (lambda ( x ) (if (equal (caadr pp2) (cadr x) 1e-4) x))) chkppx)))
                        (setq chkppx (cons (list (distance ip (caadr pp2)) (caadr pp2)) chkppx))
                        (if (< (distance ip (caadr pp2)) (car xx))
                          (setq chkppx (subst (list (distance ip (caadr pp2)) (caadr pp2)) xx chkppx))
                        )
                      )
                    )
                    ( ff
                      (if (and (not (vl-some (function (lambda ( x ) (equal x ip 1e-4))) ips)) (vl-some (function (lambda ( x ) (or (and (equal (distance ip (caadr pp1)) (car x) 1e-4) (equal (caadr pp1) (cadr x) 1e-4)) (and (equal (distance ip (caadr pp2)) (car x) 1e-4) (equal (caadr pp2) (cadr x) 1e-4))))) chkppx))
                        (setq fff t)
                      )
                    )
                  )
                  (setq el (entlast))
                  (if (not (vl-catch-all-error-p (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (* si (- d fuzz))))))
                    (while (setq el (entnext el))
                      (setq lws1 (cons el lws1))
                    )
                    (progn
                      (vla-copy (vlax-ename->vla-object lw))
                      (setq lwx (entlast))
                      (setq el (entlast))
                      (vl-cmdf "_.offset" (- d fuzz) lwx "_non" ip "")
                      (while (setq el (entnext el))
                        (setq lws1 (cons el lws1))
                      )
                    )
                  )
                  (setq lws1 (vl-remove-if (function (lambda ( x ) (/= "LWPOLYLINE" (cdr (assoc 0 (entget x)))))) lws1))
                  (setq el (entlast))
                  (if (not (vl-catch-all-error-p (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (* si (+ d fuzz))))))
                    (while (setq el (entnext el))
                      (setq lws2 (cons el lws2))
                    )
                    (progn
                      (if (not lwx)
                        (progn
                          (vla-copy (vlax-ename->vla-object lw))
                          (setq lwx (entlast))
                        )
                      )
                      (setq el (entlast))
                      (vl-cmdf "_.offset" (+ d fuzz) lwx "_non" ip "")
                      (while (setq el (entnext el))
                        (setq lws2 (cons el lws2))
                      )
                    )
                  )
                  (setq lws2 (vl-remove-if (function (lambda ( x ) (/= "LWPOLYLINE" (cdr (assoc 0 (entget x)))))) lws2))
                  (if lws1
                    (progn
                      (setq lwss1 (mapcar (function (lambda ( x ) (list x (rem_coll_pts (unique (getlwpts x)))))) lws1))
                      (setq p1 (car-sort (apply (function append) (mapcar (function cadr) lwss1)) (function (lambda ( a b ) (< (distance ip a) (distance ip b))))))
                      (setq lw1 (vl-some (function (lambda ( x ) (if (vl-position p1 (cadr x)) (car x)))) lwss1))
                    )
                  )
                  (if (and lw1 (< (distance ip (vlax-curve-getclosestpointto lw1 ip)) (* 10.0 fuzz)))
                    (setq n (length (rem_coll_pts (unique (getlwpts lw1)))) x (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 10.0 fuzz)))) (rem_coll_pts (unique (getlwpts lw1)))))
                    (setq n 0)
                  )
                  (if lws2
                    (progn
                      (setq lwss2 (mapcar (function (lambda ( x ) (list x (rem_coll_pts (unique (getlwpts x)))))) lws2))
                      (if p1
                        (setq p2 (car-sort (apply (function append) (mapcar (function cadr) lwss2)) (function (lambda ( a b ) (if (equal (distance ip a) (distance ip b) 1e-4) (< (distance p1 a) (distance p1 b)) (< (distance ip a) (distance ip b)))))))
                        (setq p2 (car-sort (apply (function append) (mapcar (function cadr) lwss2)) (function (lambda ( a b ) (< (distance ip a) (distance ip b))))))
                      )
                      (setq lw2 (vl-some (function (lambda ( x ) (if (vl-position p2 (cadr x)) (car x)))) lwss2))
                    )
                  )
                  (if (and lw2 (< (distance ip (vlax-curve-getclosestpointto lw2 ip)) (* 10.0 fuzz)))
                    (setq m (length (rem_coll_pts (unique (getlwpts lw2)))) y (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 10.0 fuzz)))) (rem_coll_pts (unique (getlwpts lw2)))))
                    (setq m 0)
                  )
                  (setq lws22 (vl-remove-if-not (function (lambda ( x ) (< (distance ip (vlax-curve-getclosestpointto x ip)) (* 50.0 fuzz)))) lws2))
                  (setq lw22 (car (vl-remove lw2 lws22)))
                  (if lw22
                    (setq z (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 50.0 fuzz)))) (getlwpts lw22)))
                  )
                  (ptss lil)
                  (if
                    (and
                      (cond
                        ( (and (not x) (not y) fff) t )
                        ( (and
                            lw1 lw2
                            (vl-some (function (lambda ( x ) (equal x (caadr pp1) 1e-3))) pl)
                            (vl-some (function (lambda ( x ) (equal x (caadr pp2) 1e-3))) pl)
                            (not (clockwise-p (car (vl-remove (caadr pp1) (apply (function append) (car pp1)))) (caadr pp1) (cadr (vl-remove (caadr pp1) (apply (function append) (car pp1))))))
                            (not (clockwise-p (car (vl-remove (caadr pp2) (apply (function append) (car pp2)))) (caadr pp2) (cadr (vl-remove (caadr pp2) (apply (function append) (car pp2))))))
                          )
                          t
                        )
                        ( (and lw1 lw2)
                          (if (/= (length x) (length y))
                            (/= n m)
                            (cond
                              ( (= (length x) 1)
                                (cond
                                  ( (and x y (not z))
                                    (if ff
                                      (and (/= n m) (or (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3)))
                                      (or (/= n m) (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3))
                                    )
                                  )
                                  ( (and x y z)
                                    (if ff
                                      (and (/= n m) (or (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car z) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car z))) (cadadr np) 1e-3)))
                                      (or (/= n m) (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car z) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car z))) (cadadr np) 1e-3))
                                    )
                                  )
                                )
                              )
                              ( (> (length x) 1)
                                (/= n m)
                              )
                            )
                          )
                        )
                        ( (or lw1 lw2)
                          (/= (length x) (length y))
                        )
                      )
                      (not (vl-some (function (lambda ( x ) (or (and (equal (distance ip (caadr pp1)) (+ (distance ip x) (distance x (caadr pp1))) 1e-4) (not (equal x (caadr pp1) 1e-4))) (and (equal (distance ip (caadr pp2)) (+ (distance ip x) (distance x (caadr pp2))) 1e-4) (not (equal x (caadr pp2) 1e-4)))))) pts))
                    )
                    (setq r (list (cond ( (or (= flg 1) (= flg 6)) (+ (distance ip (caadr pp1)) (distance ip (caadr pp2))) ) ( (or (= flg 2) (= flg 7)) (abs (- (distance ip (caadr pp1)) (distance ip (caadr pp2)))) ) ( (or (= flg 3) (= flg 8)) (min (distance ip (caadr pp1)) (distance ip (caadr pp2))) ) ( (or (= flg 4) (= flg 9)) (max (distance ip (caadr pp1)) (distance ip (caadr pp2))) ) ( t d )) pp1 np pp2))
                  )
                  (foreach lw1 lws1 (if (and lw1 (not (vlax-erased-p lw1))) (entdel lw1)))
                  (foreach lw2 lws2 (if (and lw2 (not (vlax-erased-p lw2))) (entdel lw2)))
                  (if (and lwx (not (vlax-erased-p lwx))) (entdel lwx))
                  r
                )
              )
            )
          )
        )
      )
    )
  )

  (defun processchk ( chk )
    (if chk
      (progn
        (if (not ff)
          (setq ips (cons (caadr (caddr chk)) ips))
        )
        (setq lil (cons (list (caadr (cadr chk)) (caadr (caddr chk))) lil))
        (setq lil (cons (list (caadr (cadddr chk)) (caadr (caddr chk))) lil))
        (if (not (vl-some (function (lambda ( x ) (equal x (caddr chk) 1e-4))) ppll))
          (setq ppll (cons (caddr chk) ppll))
        )
        (setq ppll (vl-remove-if (function (lambda ( x ) (or (equal x (cadr chk) 1e-4) (equal x (cadddr chk) 1e-4)))) ppll))
      )
    )
  )

  (defun unique ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (equal x a 1e-8))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-8))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun uniquelil ( lst / a ll )
    (setq lst (vl-remove-if (function (lambda ( x ) (or (equal (car x) (cadr x) 1e-4) (not (car x)) (not (cadr x))))) lst))
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (or (equal x a 1e-4) (equal x (reverse a) 1e-4)))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (or (equal x a 1e-4) (equal x (reverse a) 1e-4)))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun uniquetll ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (and (collinear-p (car x) (cadr x) (car a)) (collinear-p (car x) (cadr x) (cadr a)) (collinear-p (car a) (cadr a) (car x)) (collinear-p (car a) (cadr a) (cadr x))))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (and (collinear-p (car x) (cadr x) (car a)) (collinear-p (car x) (cadr x) (cadr a)) (collinear-p (car a) (cadr a) (car x)) (collinear-p (car a) (cadr a) (cadr x))))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun freepts ( n ) ;;; pts - lexical global variable ;;;
    (unique (vl-remove-if-not (function (lambda ( x ) (= n (- (length pts) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-4))) pts)))))) pts))
  )

  (defun ptss ( lll ) ;;; pts - lexical global variable ;;;
    (setq pts (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-4))) pl))) (apply (function append) (uniquelil lll))))
  )

  (defun collinearptschk ( lll gg / p1 lst qq n i )
    (foreach ppp gg
      (setq n nil i nil)
      (setq p1 (car-sort ppp (function (lambda ( a b ) (> (distance a (car ppp)) (distance b (car ppp)))))))
      (setq lst (vl-sort ppp (function (lambda ( a b ) (< (distance a p1) (distance b p1))))))
      (setq lst (unique lst))
      (setq qq (mapcar (function (lambda ( a b ) (list a b))) lst (cdr lst)))
      (setq qq (vl-remove-if-not (function (lambda ( x ) (= 0 (rem (setq n (if (not n) 0 (1+ n))) 2)))) qq))
      (setq qq (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (and (setq i (inters (car x) (cadr x) (car y) (cadr y))) (not (equal (car x) i 1e-4)) (not (equal (cadr x) i 1e-4)) (not (equal (car y) i 1e-4)) (not (equal (cadr y) i 1e-4))))) (append lll tll)))) qq))
      (setq lll (uniquelil (append lll qq)))
    )
    lll
  )

  (defun group_collinear_pts ( ptlst / collinear-p collinear-3d-p filter-max-groups is-subset-of-any member-equal points-on-line point-in-list point-lessp remove-duplicate-groups subsetp-equal to-3d unique-points collinear-clusters )

    ;|
    ;; Test if three 2D/3D points are collinear
    ;; NOTE: may give 3D false positives for certain 2D cases
    ;; Returns T if collinear, nil otherwise
    (defun collinear-p (p1 p2 p3 / tolerance) 
      (setq tolerance 1e-6)
      ;; Using cross product method for 2D/3D
      (< 
        (abs 
          (- (* (- (car p2) (car p1)) (- (cadr p3) (cadr p1))) 
             (* (- (cadr p2) (cadr p1)) (- (car p3) (car p1)))
          )
        )
        tolerance
      )
    )
    |;

    ;; collinear-3d-p
    ;; Tests if three points (2D or 3D) are collinear using the vector cross product.
    ;; Arguments:
    ;;   p1, p2, p3 - points as lists (e.g., (x y) or (x y z))
    ;; Returns:
    ;;   T if the points are collinear, nil otherwise.
    ;; Notes:
    ;;   - Works for both 2D and 3D points (missing Z is treated as 0)
    ;;   - Not sensitive to point order
    ;;   - Uses a small tolerance to account for floating-point errors
    (defun collinear-3d-p (p1 p2 p3 / v1 v2 cp tolerance)
      (setq tolerance 1e-8)
      (setq v1 (mapcar (function -) (to-3d p2) (to-3d p1))) ; vector from p1 to p2
      (setq v2 (mapcar (function -) (to-3d p3) (to-3d p1))) ; vector from p1 to p3
      (setq cp (list
        (- (* (cadr v1) (caddr v2)) (* (caddr v1) (cadr v2))) ; X component
        (- (* (caddr v1) (car v2)) (* (car v1) (caddr v2)))   ; Y component
        (- (* (car v1) (cadr v2)) (* (cadr v1) (car v2)))     ; Z component
      ))
      (< (distance (list 0.0 0.0 0.0) cp) tolerance)
    )

    ;|
      group all relevant points into groups of collinear coordinates.
      Consider input list of points and return a list of lists,
      where each sublist contains points that are collinear.
      Example:
        (collinear-clusters '((0 0) (1 1) (2 2) (0 1) (1 0) (2 1)))
        => '(((0 0) (1 1) (2 2))   ((0 1) (1 1) (2 1)))
        
        (collinear-clusters '((0 0 0) (1 1 1) (2 2 2) (0 1 0) (1 0 1) (2 1 2)))
        => '(((0 0 0) (1 1 1) (2 2 2))   ((0 1 0) (1 1 1) (2 1 2)))   
        
      |;
    ;; ----------------------------------------------------------------
    ;; Helper: remove groups that are strict subsets of other groups
    (defun filter-max-groups (groups)
      (if groups
        (if (is-subset-of-any (car groups) (cdr groups))
          (filter-max-groups (cdr groups))
          (cons (car groups) (filter-max-groups (cdr groups)))
        )
        nil
      )
    )

    ;; ----------------------------------------------------------------
    ;; Helper: checks whether grp is a subset of any group in lst
    (defun is-subset-of-any (grp lst)
      (cond
        ((null lst) nil)
        ((and (<= (length grp) (length (car lst)))
              (subsetp-equal grp (car lst))
              (not (equal grp (car lst))))
         T)
        (T (is-subset-of-any grp (cdr lst)))
      )
    )

    ;; ----------------------------------------------------------------
    ;; Helper function: member with EQUAL (deep comparison)
    (defun member-equal (item lst)
      (cond
        ((null lst) nil)
        ((equal item (car lst)) lst)
        (T (member-equal item (cdr lst)))
      )
    )

    ;; ----------------------------------------------------------------
    ;; Helper: build maximal set of points collinear with p1 and p2
    (defun points-on-line (points p1 p2 / on)
      (setq on '())
      (foreach p points
        (if (collinear-3d-p p1 p2 p)
          (setq on (cons p on))
        )
      )
      (vl-sort (unique-points on) 'point-lessp)
    )

    ;; ----------------------------------------------------------------
    ;; Helper function: checks if point is in list using EQUAL
    (defun point-in-list (pt lst)
      (if lst
        (if (equal pt (car lst)) T (point-in-list pt (cdr lst)))
        nil
      )
    )

    ;; ----------------------------------------------------------------
    ;; Helper function: lexicographic less-than for points (x, then y, then z)
    (defun point-lessp (a b)
      (cond
        ((< (car a) (car b)) T)
        ((> (car a) (car b)) nil)
        ((< (cadr a) (cadr b)) T)
        ((> (cadr a) (cadr b)) nil)
        ((< (if (caddr a) (caddr a) 0.0) (if (caddr b) (caddr b) 0.0)) T)
        (T nil)
      )
    )

    ;; ----------------------------------------------------------------
    ;; Helper function: removes duplicate lists from a list of lists
    (defun remove-duplicate-groups (lst)
      (if lst
        (if (member-equal (car lst) (cdr lst))
          (remove-duplicate-groups (cdr lst))
          (cons (car lst) (remove-duplicate-groups (cdr lst)))
        )
        nil
      )
    )

    ;; ----------------------------------------------------------------
    ;; Helper: true if a is a subset of b (using point-in-list)
    (defun subsetp-equal (a b)
      (if a
        (if (point-in-list (car a) b)
          (subsetp-equal (cdr a) b)
          nil
        )
        T
      )
    )

    ;; ----------------------------------------------------------------
    ;; Helper function: ensures a point is 3D (pads with 0 if needed)
    (defun to-3d (pt)
      (list (car pt)
            (cadr pt)
            (if (caddr pt) (caddr pt) 0.0))
    )

    ;; ----------------------------------------------------------------
    ;; Helper: keep only unique points from list (preserves first-seen order)
    (defun unique-points (lst / out)
      (setq out '())
      (foreach p lst
        (if (not (point-in-list p out))
          (setq out (cons p out))
        )
      )
      (reverse out)
    )

    ;; ----------------------------------------------------------------
    ;; ----------------------------------------------------------------

    (defun collinear-clusters (points / pairs groups p1 p2 grp)
      ;; collinear-clusters
      ;; Finds collinear point clusters (size >= 3) from a list of 2D/3D points.
      ;;
      ;; Input:
      ;;   points - list of points: (x y) or (x y z)
      ;;
      ;; Output:
      ;;   - nil if fewer than 3 points, or no collinear clusters found
      ;;   - otherwise a list of groups, where each group is a list of points
      ;;
      ;; Behavior notes:
      ;;   - Uses `collinear-3d-p` so 2D points are treated as (x y 0)
      ;;   - Builds candidate groups from every unique point-pair (p1,p2)
      ;;   - Each candidate group is all points collinear with that pair
      ;;   - Duplicates are removed, then strict subset groups are dropped
      ;;   - Final output is stable-sorted:
      ;;       * points within each group are sorted by x,y,z
      ;;       * groups are sorted by their first (smallest) point
      ;;
      ;; Complexity:
      ;;   O(n^3) worst-case due to pair enumeration + scanning all points per pair.
      ;; Return nil if fewer than 3 points
      (if (< (length points) 3)
        nil
        (progn
          (setq groups '())
          ;; Enumerate unique pairs (p1, p2) with p1 before p2.
          ;; Using `point-lessp` avoids processing both (p1,p2) and (p2,p1).
          (foreach p1 points
            (foreach p2 points
              (if (and (not (equal p1 p2)) (point-lessp p1 p2))
                (progn
                  ;; Build the maximal set of points lying on the line through p1 & p2
                  (setq grp (points-on-line points p1 p2))
                  (if (>= (length grp) 3)
                    (setq groups (cons grp groups))
                  )
                )
              )
            )
          )
          ;; Many pairs produce the same group: remove duplicates
          (setq groups (remove-duplicate-groups groups))
          ;; Keep only maximal groups (drop strict subsets)
          (setq groups (filter-max-groups groups))
          ;; Sort groups themselves for stable output (by group leader point)
          (setq groups (vl-sort groups
            (function
              (lambda (g1 g2)
                (point-lessp (car g1) (car g2))
              )
            )
          ))
          (if groups groups nil)
        )
      )
    )

    (collinear-clusters ptlst)
  )

  (defun process ( flg / k donex doney pp1 pp2 cc chks lil lilo done )
    (while (not done)
      (setq lilo lil)
      (setq ppl ppll donex nil doney nil)
      (if (= flg 0)
        (while (and (not donex) (setq pp1 (car ppl)))
          (setq ppl (cdr ppl) k -1 doney nil)
          (while (not doney)
            (setq pp2 (if (< (setq k (1+ k)) (length ppl)) (nth k ppl)))
            (cond
              ( (setq cc (chkttt pp1 pp2 0))
                (setq chks (cons cc chks) doney t donex t)
              )
              ( (or (not pp2) (not ppl))
                (setq doney t)
              )
            )
          )
        )
        (foreach pp1 ppl
          (setq ppl (cdr ppl))
          (foreach pp2 ppl
            (if (setq cc (chkttt pp1 pp2 flg))
              (setq chks (cons cc chks))
            )
          )
        )
      )
      (if (= flg 0)
        (processchk (car chks))
        (processchk (car-sort chks (function (lambda ( a b ) ((if (< flg 6) < >) (car a) (car b))))))
      )
      (if (or (not chks) (equal lilo lil 1e-4))
        (setq done t)
      )
      (setq chks nil lil (uniquelil lil) ppll (unique ppll))
    )
    lil
  )

  (defun liln ( flg / ff ips chkppx lll lilx1 lilx2 ) ;;; ff ; fl - lexical global variables ;;;
    (setq ppll ppllo)
    (setq lilx1 (process flg))
    (if (lilchk lilx1)
      (progn
        (setq ff t)
        (setq ppll ppllo)
        (setq lilx2 (process flg))
        (if (not (lilchk lilx2))
          (setq lll lilx2)
        )
      )
      (setq lll lilx1)
    )
    (if lll (setq fl t))
    (if lll lll (if (> (length lilx1) (length lilx2)) lilx1 lilx2))
  )

  (defun lilchk ( lll / pts i )
    (ptss (uniquelil lll))
    (or
      (freepts 1)
      (vl-some (function (lambda ( x )
        (vl-some (function (lambda ( y )
          (and
            (setq i (inters (car x) (cadr x) (car y) (cadr y)))
            (not (equal i (car x) 1e-4))
            (not (equal i (cadr x) 1e-4))
            (not (equal i (car y) 1e-4))
            (not (equal i (cadr y) 1e-4))
          )
        ))
        (vl-remove x (append tll lll))
        )
        ))
        (append tll lll)
      )
      (/=
        (length (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-4))) (unique pl)))) (apply (function append) lll)))
        (length (unique pl))
      )
    )
  )

  (defun proc2xx ( pplll l / p pp q lll )
    (while (setq p (car l))
      (if (setq pp (vl-some (function (lambda ( x ) (if (equal (caadr x) p 1e-4) x))) pplll))
        (progn
          (setq q (vl-some (function (lambda ( x ) (if (collinear-p p (mapcar (function +) p (cadadr pp)) x) x))) (cdr l)))
          (if (and p q)
            (setq lll (cons (list p q) lll))
          )
          (setq l (vl-remove q (cdr l)))
        )
        (setq l (cdr l))
      )
    )
    lll
  )

  ;;; MAIN ROUTINE ;;;

  (setq adoc (vla-get-activedocument (vlax-get-acad-object)))
  (if (= 8 (logand 8 (getvar (quote undoctl))))
    (vla-endundomark adoc)
  )
  (vla-startundomark adoc)
  (setq osm (getvar (quote osmode)))
  (setq cmd (getvar (quote cmdecho)))
  (setvar (quote osmode) 0)
  (setvar (quote cmdecho) 0)
  (initget 6)
  (setq fuzz (getdist "\nPick or specify fuzz distance for LWPOLYLINE offset checking <0.01> : "))
  (if (not fuzz) (setq fuzz 0.01))
  (prompt "\nPick closed polygonal LWPOLYLINE on unlocked Layer...")
  (if (setq s (ssget "_+.:E:S:L" (list (cons 0 "LWPOLYLINE") (cons -4 "&") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
    (progn
      (setq ti (car (_vl-times)))
      (setq lw (ssname s 0))
      (if (clockwiselw-p lw)
        (progn
          (vl-cmdf "_.pedit" lw "_r")
          (while (< 0 (getvar (quote cmdactive)))
            (vl-cmdf "")
          )
        )
      )
      (vl-cmdf "_.zoom" "_ob" lw "" "_.zoom" "0.75xp")
      (vla-offset (vlax-ename->vla-object lw) 1e-4)
      (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
        (progn (entdel (entlast)) (vla-offset (vlax-ename->vla-object lw) -1e-4) (setq si -1.0))
        (setq si 1.0)
      )
      (setq pl (getlwpts lw))
      (setq pl (unique pl))
      (setq pl (rem_coll_pts pl))
      (setq pll (getlwpts (setq lwl (entlast))))
      (setq pll (unique pll))
      (setq pll (rem_coll_pts pll))
      (setq tll (mapcar (function (lambda ( a b ) (list a b))) pl (append (cdr pl) (list (car pl)))))
      (setq ppllo (mapcar (function (lambda ( t1 t2 p pp ) (list (list t1 t2) (list p (unit (mapcar (function -) pp p)))))) (cons (last tll) (reverse (cdr (reverse tll)))) tll pl pll))
      (cond
        ( (progn (setq fl nil) (setq lil0 (liln 0)) fl) (setq lil lil0) )
        ( (progn (setq fl nil) (setq lil1 (liln 1)) fl) (setq lil lil1) )
        ( (progn (setq fl nil) (setq lil2 (liln 2)) fl) (setq lil lil2) )
        ( (progn (setq fl nil) (setq lil3 (liln 3)) fl) (setq lil lil3) )
        ( (progn (setq fl nil) (setq lil4 (liln 4)) fl) (setq lil lil4) )
        ( (progn (setq fl nil) (setq lil5 (liln 5)) fl) (setq lil lil5) )
        ( (progn (setq fl nil) (setq lil6 (liln 6)) fl) (setq lil lil6) )
        ( (progn (setq fl nil) (setq lil7 (liln 7)) fl) (setq lil lil7) )
        ( (progn (setq fl nil) (setq lil8 (liln 8)) fl) (setq lil lil8) )
        ( (progn (setq fl nil) (setq lil9 (liln 9)) fl) (setq lil lil9) )
        ( (progn (setq fl nil) (setq lil10 (liln 10)) fl) (setq lil lil10) )
      )
      (if (not lil)
        (setq lil (car-sort (list lil0 lil1 lil2 lil3 lil4 lil5 lil6 lil7 lil8 lil9 lil10) (function (lambda ( a b ) (> (length a) (length b))))))
      )
      (ptss lil)
      (if (setq gg (vl-remove-if (function (lambda ( x ) (= 1 (rem (length x) 2)))) (group_collinear_pts (setq pts (unique pts)))))
        (progn
          (setq lil (vl-remove-if (function (lambda ( x ) (or (and (setq xx (vl-some (function (lambda ( y ) (if (vl-some (function (lambda ( z ) (equal (car x) z 1e-4))) y) y))) gg)) (vl-some (function (lambda ( z ) (equal (cadr x) z 1e-4))) xx)) (vl-some (function (lambda ( y ) (and (equal (distance (car x) (cadr x)) (+ (distance (car x) y) (distance y (cadr x))) 1e-4) (not (equal (car x) y 1e-4)) (not (equal (cadr x) y 1e-4))))) pts)))) lil))
          (setq lil (collinearptschk lil gg))
          (ptss lil)
        )
      )
      (setq lil (vl-remove-if (function (lambda ( x ) (and (vl-some (function (lambda ( y ) (equal (car x) y 1e-4))) (setq xx (unique (freepts 4)))) (vl-some (function (lambda ( y ) (equal (cadr x) y 1e-4))) xx)))) lil))
      (ptss lil)
      (if (and ppll (setq xx (unique (freepts 2))))
        (setq lil (append lil (proc2xx ppll xx)))
      )
      (setq sss (ssadd))
      (if lil
        (foreach li (uniquelil lil)
          (if (and (car li) (cadr li))
            (ssadd (entmakex (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)))) sss)
          )
        )
      )
    )
    (setq m "Missed picking closed polygonal LWPOLYLINE on unlocked Layer...")
  )
  (*error* (if m m))
)