(defun c:roof-mr-3dlines-convex+concave-all-lines-BCAD ( / *error* vl-sort online dd ddd txchk inters-1e-2 vl-position-fuzz inside-p rlw offsetchk car-sort chiv uniqueptvec uniqueipvec unique unit v^v clockwise-lw lw2plst clean_poly tstchk adoc s slope minbb maxbb maxd lw vl tl v1 v2 tll tlll lls lsl lslx lsll ip n loop lil1 lil2 d dl k kl tst dxf90 sign el lw1 lw2 lww1 lww2 dxf90-1 p pp ppp ppp1 ppp2 par1 par2 ti ape plll ucsf qq ddds dddsl d2 d2l dq lwn lws f un ls lss zf tttt ipl lslip lil px pxd20 pxd40 cmde lll ee dlst fpts ptt ex )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if ucsf
      (vl-cmdf "_.UCS" "_P")
    )
    (if (and lwi (not (vlax-erased-p lwi)))
      (entdel lwi)
    )
    (if ape
      (setvar 'aperture ape)
    )
    (if cmde
      (setvar 'cmdecho cmde)
    )
    (if adoc
      (vla-endundomark adoc)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun vl-sort ( lst func )
    (mapcar
      (function (lambda ( x ) (nth x lst)))
      (vl-sort-i lst func)
    )
  )

  (defun online ( p1 p2 p3 )
    (equal (distance p1 p3) (+ (distance p1 p2) (distance p2 p3)) 1e-6)
  )

  (defun dd ( p / dl )
    (foreach tt tl
      (setq dl
        (cons
          (distance
            (mapcar (function +) (list 0.0 0.0) (trans p 1 (mapcar (function -) (cadr tt) (car tt))))
            (mapcar (function +) (list 0.0 0.0) (trans (car tt) 1 (mapcar (function -) (cadr tt) (car tt))))
          )
          dl
        )
      )
    )
    dl
  )

  (defun txchk ( l1 l2 p / tx )
    (foreach x1 l1
      (foreach x2 l2
        (setq tx (cons (not (equal (distance (mapcar (function +) '(0 0) x1) x2) (+ (distance x1 p) (distance p x2)) 1e-10)) tx))
      )
    )
    (apply (function or) tx)
  )

  (defun inters-1e-2 ( p1 p2 p3 p4 / unit p v1 pp1 dd1 d1 ratio1 ip1 v2 pp2 dd2 d2 ratio2 ip2 )

    (defun unit ( v / d )
      (if (not (equal (setq d (distance '(0.0 0.0 0.0) v)) 0.0 1e-8))
        (mapcar (function (lambda ( x ) (/ x d))) v)
      )
    )

    (setq p (append (inters (mapcar (function +) '(0 0) p1) (mapcar (function +) '(0 0) p2) (mapcar (function +) '(0 0) p3) (mapcar (function +) '(0 0) p4) nil) (list (caddar vl))))
    (if (and (= (type p) 'list) (= (length p) 3) (vl-every (function numberp) p))
      (progn
        (setq v1 (unit (mapcar (function -) p2 p1)))
        (setq pp1 (mapcar (function +) p1 v1))
        (setq dd1 (distance (mapcar (function +) '(0 0) p1) (mapcar (function +) '(0 0) pp1)))
        (setq d1 (distance (mapcar (function +) '(0 0) p1) p))
        (setq ratio1 (/ d1 dd1))
        (setq ip1 (mapcar (function +) p1 (mapcar (function *) v1 (list ratio1 ratio1 ratio1))))
        (setq v2 (unit (mapcar (function -) p4 p3)))
        (setq pp2 (mapcar (function +) p3 v2))
        (setq dd2 (distance (mapcar (function +) '(0 0) p3) (mapcar (function +) '(0 0) pp2)))
        (setq d2 (distance (mapcar (function +) '(0 0) p3) p))
        (setq ratio2 (/ d2 dd2))
        (setq ip2 (mapcar (function +) p3 (mapcar (function *) v2 (list ratio2 ratio2 ratio2))))
        (if (equal ip1 ip2 1e-2)
          (mapcar (function (lambda ( a b ) (/ (+ a b) 2.0))) ip1 ip2)
        )
      )
    )
  )

  (defun vl-position-fuzz ( e l fuzz / car-vl-member-if )
    (defun car-vl-member-if ( f l / ff r )
      (setq ff (function (lambda ( x ) (if (apply f (list x)) (setq r x)))))
      (vl-some ff l)
      r
    )
    (vl-position (car-vl-member-if (function (lambda ( x ) (equal e x fuzz))) l) l)
  )

  (defun inside-p ( p lw lwi )
    (< (distance p (vlax-curve-getclosestpointto lwi p)) (distance p (vlax-curve-getclosestpointto lw p)))
  )

  (defun rlw ( lw / e x1 x2 x3 x4 x5 x6 )
    ;; by ElpanovEvgeniy
    (if (= (cdr (assoc 0 (setq e (entget lw)))) "LWPOLYLINE")
      (progn
        (foreach a1 e
          (cond
            ( (= (car a1) 10) (setq x2 (cons a1 x2)) )
            ( (= (car a1) 40) (setq x4 (cons (cons 41 (cdr a1)) x4)) )
            ( (= (car a1) 41) (setq x3 (cons (cons 40 (cdr a1)) x3)) )
            ( (= (car a1) 42) (setq x5 (cons (cons 42 (- (cdr a1))) x5)) )
            ( (= (car a1) 210) (setq x6 (cons a1 x6)) )
            ( t (setq x1 (cons a1 x1)) )
          )
        )
        (entmod
          (append (reverse x1)
            (append
              (apply 'append
                (apply 'mapcar
                  (cons 'list
                    (list x2
                      (cdr (reverse (cons (car x3) (reverse x3))))
                      (cdr (reverse (cons (car x4) (reverse x4))))
                      (cdr (reverse (cons (car x5) (reverse x5))))
                    )
                  )
                )
              )
              x6
            )
          )
        )
        (entupd lw)
      )
    )
  )

  (defun offsetchk ( lwlst dmax sign f / dx k eell catch ppll dxf90s tmp n nn ddd ddds nnns pl )
    (foreach lw lwlst
      (setq ddds nil nnns nil ddd nil nn nil pl nil)
      (setq dx (/ dmax 100))
      (setq k 0)
      (repeat 100
        (setq eell (entlast))
        (setq catch (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (sign (* (setq k (1+ k)) dx)))))
        (if (not (vl-catch-all-error-p catch))
          (progn
            (while (setq eell (entnext eell))
              (setq ppll (cons eell ppll))
            )
            (foreach e ppll
              (setq dxf90s (cons (cdr (assoc 90 (entget e))) dxf90s))
            )
            (foreach e ppll
              (entdel e)
            )
            (setq ppll nil)
            (setq dxf90s (vl-sort dxf90s (function >)))
            (if (null tmp)
              (setq tmp dxf90s)
              (progn
                (if (= (length tmp) (length dxf90s))
                  (progn
                    (setq nn nil)
                    (mapcar (function (lambda ( a b ) (if (> a b) (setq nn (cons b nn))))) dxf90s tmp)
                    (if nn
                      (progn
                        (setq ddd (* (1- k) dx))
                        (setq ddds (cons ddd ddds))
                        (setq nnns (cons (reverse nn) nnns))
                        (if (null pl)
                          (progn
                            (setq eell (entlast))
                            (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (sign ddd)))
                            (while (setq eell (entnext eell))
                              (setq pl (cons eell pl))
                            )
                            (setq pl (vl-sort pl (function (lambda ( a b ) (> (cdr (assoc 90 (entget a))) (cdr (assoc 90 (entget b))))))))
                          )
                        )
                      )
                    )
                  )
                  (setq tmp dxf90s)
                )
                (setq tmp dxf90s)
              )
            )
            (setq dxf90s nil)
          )
        )
      )
      (if f
        (entdel lw)
      )
      (if ddds
        (progn
          (setq dddsl (cons (list (if (car dddsl) (+ (last ddds) (caar dddsl)) (last ddds)) (last nnns)) dddsl))
          (offsetchk pl dmax sign t)
        )
      )
    )
    dddsl
  )

  (defun car-sort ( lst cmp / rtn )
    (setq rtn (car lst))
    (foreach itm (cdr lst)
      (if (apply cmp (list itm rtn))
        (setq rtn itm)
      )
    )
    rtn
  )

  (defun chiv ( e p / ed edd eddd eddd1 eddd2 eddd3 newed m n i )
    (setq ed (entget e))
    (setq edd nil)
    (foreach ec ed 
      (if (not 
            (or (eq (car ec) 10) (eq (car ec) 40) (eq (car ec) 41) (eq (car ec) 42) (eq (car ec) 91) (eq (car ec) 210))
          )
          (setq edd (cons ec edd))
      )
    )
    (setq edd (reverse edd))
    (setq eddd nil)
    (setq eddd1 nil)
    (setq eddd2 nil)
    (setq eddd (member (assoc 10 ed) ed))
    (setq m (vlax-curve-getparamatpoint e (vlax-curve-getclosestpointto e p)))
    (if (assoc 91 ed) (setq n (* m 5)) (setq n (* m 4)))
    (setq i 0)
    (foreach ec eddd
      (progn
        (setq i (+ i 1))
        (if (<= i n)
          (setq eddd1 (cons ec eddd1))
        )
        (if (> i n)
          (setq eddd2 (cons ec eddd2))
        )
      )
    )
    (setq eddd1 (reverse eddd1))
    (setq eddd3 (list (assoc 210 eddd2)))
    (setq eddd2 (cdr eddd2))
    (setq eddd2 (reverse eddd2))
    (setq newed (append edd eddd2 eddd1 eddd3))
    (entmod newed)
    (entupd e)
  )

  (defun uniqueptvec ( l )
    (if l
      (cons (car l) (uniqueptvec (vl-remove-if (function (lambda ( x ) (and (equal (caar l) (car x) 1e-6) (or (equal (cadar l) (cadr x) 1e-6) (equal (cadar l) (mapcar (function -) (cadr x)) 1e-6))))) l)))
    )
  )

  (defun uniqueipvec ( l ip / l1 ptvec )
    (setq l (vl-sort l (function (lambda ( a b ) (< (distance (car a) ip) (distance (car b) ip))))))
    (while (setq ptvec (car l))
      (setq l1 (cons ptvec l1))
      (setq l (vl-remove-if (function (lambda ( x ) (or (equal (cadr ptvec) (cadr x) 1e-6) (equal (cadr ptvec) (mapcar (function -) (cadr x)) 1e-6)))) l))
    )
    l1
  )

  (defun unique ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (equal x a 1e-6))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun unit ( v )
    (if (not (equal v '(0.0 0.0 0.0) 1e-8))
      (mapcar (function (lambda ( x ) (/ x (distance '(0.0 0.0 0.0) v)))) v)
    )
  )

  (defun v^v ( u v )
    (list
      (- (* (cadr u) (caddr v)) (* (caddr u) (cadr v)))
      (- (* (caddr u) (car v)) (* (car u) (caddr v)))
      (- (* (car u) (cadr v)) (* (cadr u) (car v)))
    )
  )

  (defun clockwise-lw ( lw / minpt maxpt p1 p2 p3 p4 pmax )
    (vla-getboundingbox (vlax-ename->vla-object lw) 'minpt 'maxpt)
    (mapcar (function set) '(minpt maxpt) (mapcar (function safearray-value) (list minpt maxpt)))
    (setq p1 minpt p2 (list (car maxpt) (cadr minpt)) p3 maxpt p4 (list (car minpt) (cadr maxpt)))
    (setq p1 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p1)))
    (setq p2 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p2)))
    (setq p3 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p3)))
    (setq p4 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p4)))
    (setq pmax (max p1 p2 p3 p4))
    (cond
      ( (and (= pmax p1) (> p2 p4))
        t
      )
      ( (and (= pmax p2) (> p3 p1))
        t
      )
      ( (and (= pmax p3) (> p4 p2))
        t
      )
      ( (and (= pmax p4) (> p1 p3))
        t
      )
      ( t nil )
    )
  )

  (defun lw2plst ( lw / lst k p )
    (setq lst (cons (vlax-curve-getstartpoint lw) lst))
    (setq k 0)
    (while (and (setq k (1+ k)) (<= k (fix (- (vlax-curve-getendparam lw) 0.01))))
      (setq p (vlax-curve-getpointatparam lw (float k)))
      (setq lst (cons p lst))
    )
    (reverse lst)
  )

  (defun clean_poly ( lw / pl pos pre suf k lwx )
    (setq pl (lw2plst lw))
    (setq pos (mapcar (function (lambda ( a b c ) (if (equal (distance a c) (+ (distance a b) (distance b c)) 1e-6) t nil))) (cons (last pl) (reverse (cdr (reverse pl)))) (append (cdr (cons (last pl) (reverse (cdr (reverse pl))))) (list (last pl))) (append (cddr (cons (last pl) (reverse (cdr (reverse pl))))) (list (last pl) (car pl)))))
    (if (apply (function or) pos)
      (progn
        (setq k -1)
        (setq pos (vl-remove nil (mapcar (function (lambda ( x ) (progn (setq k (1+ k)) (if (eq x t) k)))) pos)))
        (foreach p pos
          (setq pos (subst (nth p pl) p pos))
        )
        (foreach p pos
          (setq pl (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) pl))
        )
        (setq pre (reverse (cdr (member (assoc 10 (setq lwx (entget lw))) (reverse lwx)))))
        (setq pre (subst (cons 90 (length pl)) (assoc 90 pre) pre))
        (setq suf (append (mapcar (function (lambda ( x ) (cons 10 (trans x 0 (cdr (assoc 210 lwx)))))) pl) (list (assoc 210 lwx))))
        (entmod (append pre suf))
      )
    )
    (entupd lw)
  )

  (defun tstchk ( / el lw1 lw2 lww1 lww2 )
    (setq el (entlast) dxf90 nil)
    (setq lw1 (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object (if lwn lwn lw)) (sign (- (if lwn d2 d) pxd40)))))
    (if (not (vl-catch-all-error-p lw1))
      (progn
        (setq lw1 nil)
        (while (setq el (entnext el))
          (setq lw1 (cons el lw1))
        )
      )
      (setq lw1 nil)
    )
    (if lw1
      (progn
        (foreach l lw1
          (setq dxf90 (cons (cdr (assoc 90 (entget l))) dxf90))
        )
      )
    )
    (setq el (entlast) dxf90-1 nil)
    (setq lw2 (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object (if lwn lwn lw)) (sign (+ (if lwn d2 d) pxd40)))))
    (if (not (vl-catch-all-error-p lw2))
      (progn
        (setq lw2 nil)
        (while (setq el (entnext el))
          (setq lw2 (cons el lw2))
        )
      )
      (setq lw2 nil)
    )
    (if lw2
      (progn
        (foreach l lw2
          (setq dxf90-1 (cons (cdr (assoc 90 (entget l))) dxf90-1))
        )
      )
    )
    (cond
      ( (and (null dxf90-1) (null dxf90))
      )
      ( (and (null dxf90-1) dxf90)
        (foreach el lw1
          (clean_poly el)
        )
        (setvar 'aperture 25)
        (setq ppp (osnap (list (car ip) (cadr ip) (caddar vl)) "_end"))
        (if (and ppp (equal (list (car ip) (cadr ip) (caddar vl)) ppp 0.001))
          (setq tst t)
        )
      )
      ( (and dxf90-1 (= (length dxf90-1) 1) dxf90 (= (length dxf90) 1))
        (setq ppp1 nil)
        (setq lw1 (car lw1))
        (clean_poly lw1)
        (setvar 'aperture 25)
        (if (and lw1 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end"))
          (progn
            (if (equal (vlax-curve-getstartpoint lw1) (osnap (list (car ip) (cadr ip) (caddar vl)) "_end") 1e-6)
              (setq par1 0.0)
              (setq par1 (float (fix (+ 0.001 (vlax-curve-getparamatpoint lw1 (vlax-curve-getclosestpointto lw1 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end")))))))
            )
            (setq k 1)
            (while (and (setq pp (vlax-curve-getpointatparam lw1 (float (if (<= (fix (+ par1 (setq k (1- k)))) 0) (fix (+ par1 k (vlax-curve-getendparam lw1))) (fix (+ par1 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
              (if (not (vl-position pp ppp1))
                (setq ppp1 (cons pp ppp1))
              )
            )
            (setq k 0)
            (while (and (setq pp (vlax-curve-getpointatparam lw1 (float (if (>= (fix (+ par1 (setq k (1+ k)))) (fix (vlax-curve-getendparam lw1))) (fix (+ par1 k (- (vlax-curve-getendparam lw1)))) (fix (+ par1 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
              (if (not (vl-position pp ppp1))
                (setq ppp1 (cons pp ppp1))
              )
            )
          )
        )
        (setq ppp2 nil)
        (setq lw2 (car lw2))
        (clean_poly lw2)
        (setvar 'aperture 25)
        (if (and lw2 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end"))
          (progn
            (if (equal (vlax-curve-getstartpoint lw2) (osnap (list (car ip) (cadr ip) (caddar vl)) "_end") 1e-6)
              (setq par2 0.0)
              (setq par2 (float (fix (+ 0.001 (vlax-curve-getparamatpoint lw2 (vlax-curve-getclosestpointto lw2 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end")))))))
            )
            (setq k 1)
            (while (and (setq pp (vlax-curve-getpointatparam lw2 (float (if (<= (fix (+ par2 (setq k (1- k)))) 0) (fix (+ par2 k (vlax-curve-getendparam lw2))) (fix (+ par2 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
              (if (not (vl-position pp ppp2))
                (setq ppp2 (cons pp ppp2))
              )
            )
            (setq k 0)
            (while (and (setq pp (vlax-curve-getpointatparam lw2 (float (if (>= (fix (+ par2 (setq k (1+ k)))) (fix (vlax-curve-getendparam lw2))) (fix (+ par2 k (- (vlax-curve-getendparam lw2)))) (fix (+ par2 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
              (if (not (vl-position pp ppp2))
                (setq ppp2 (cons pp ppp2))
              )
            )
          )
        )
        (cond
          ( (and ppp1 (null ppp2))
            (setq tst t)
          )
          ( (and (null ppp1) ppp2)
            (setq tst t)
          )
          ( (and ppp1 ppp2 (not (and (cadr ppp1) (cadr ppp2))))
            (if (txchk ppp1 ppp2 (list (car ip) (cadr ip)))
              (setq tst t)
            )
          )
        )
      )
      ( (and dxf90-1 dxf90 (or (> (length dxf90-1) 1) (> (length dxf90) 1)))
        (setq ppp1 nil)
        (foreach el lw1
          (if (< (distance (list (car ip) (cadr ip) (caddar vl)) (vlax-curve-getclosestpointto el (list (car ip) (cadr ip) (caddar vl)))) pxd20)
            (progn
              (setq lww1 el)
              (clean_poly lww1)
              (setvar 'aperture 25)
              (if (and lww1 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end"))
                (progn
                  (if (equal (vlax-curve-getstartpoint lww1) (osnap (list (car ip) (cadr ip) (caddar vl)) "_end") 1e-6)
                    (setq par1 0.0)
                    (setq par1 (float (fix (+ 0.001 (vlax-curve-getparamatpoint lww1 (vlax-curve-getclosestpointto lww1 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end")))))))
                  )
                  (setq k 1)
                  (while (and (setq pp (vlax-curve-getpointatparam lww1 (float (if (<= (fix (+ par1 (setq k (1- k)))) 0) (fix (+ par1 k (vlax-curve-getendparam lww1))) (fix (+ par1 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
                    (if (not (vl-position pp ppp1))
                      (setq ppp1 (cons pp ppp1))
                    )
                  )
                  (setq k 0)
                  (while (and (setq pp (vlax-curve-getpointatparam lww1 (float (if (>= (fix (+ par1 (setq k (1+ k)))) (fix (vlax-curve-getendparam lww1))) (fix (+ par1 k (- (vlax-curve-getendparam lww1)))) (fix (+ par1 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
                    (if (not (vl-position pp ppp1))
                      (setq ppp1 (cons pp ppp1))
                    )
                  )
                )
              )
            )
          )
        )
        (setq ppp2 nil)
        (foreach el lw2
          (if (< (distance (list (car ip) (cadr ip) (caddar vl)) (vlax-curve-getclosestpointto el (list (car ip) (cadr ip) (caddar vl)))) pxd20)
            (progn
              (setq lww2 el)
              (clean_poly lww2)
              (setvar 'aperture 25)
              (if (and lww2 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end"))
                (progn
                  (if (equal (vlax-curve-getstartpoint lww2) (osnap (list (car ip) (cadr ip) (caddar vl)) "_end") 1e-6)
                    (setq par2 0.0)
                    (setq par2 (float (fix (+ 0.001 (vlax-curve-getparamatpoint lww2 (vlax-curve-getclosestpointto lww2 (osnap (list (car ip) (cadr ip) (caddar vl)) "_end")))))))
                  )
                  (setq k 1)
                  (while (and (setq pp (vlax-curve-getpointatparam lww2 (float (if (<= (fix (+ par2 (setq k (1- k)))) 0) (fix (+ par2 k (vlax-curve-getendparam lww2))) (fix (+ par2 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
                    (if (not (vl-position pp ppp2))
                      (setq ppp2 (cons pp ppp2))
                    )
                  )
                  (setq k 0)
                  (while (and (setq pp (vlax-curve-getpointatparam lww2 (float (if (>= (fix (+ par2 (setq k (1+ k)))) (fix (vlax-curve-getendparam lww2))) (fix (+ par2 k (- (vlax-curve-getendparam lww2)))) (fix (+ par2 k)))))) (< (distance (list (car ip) (cadr ip) (caddar vl)) pp) pxd20))
                    (if (not (vl-position pp ppp2))
                      (setq ppp2 (cons pp ppp2))
                    )
                  )
                )
              )
            )
          )
        )
        (cond
          ( (and ppp1 (null ppp2))
            (setq tst t)
          )
          ( (and (null ppp1) ppp2)
            (setq tst t)
          )
          ( (and ppp1 ppp2 (not (and (cadr ppp1) (cadr ppp2))))
            (if (txchk ppp1 ppp2 (list (car ip) (cadr ip)))
              (setq tst t)
            )
          )
        )
      )
    )
    (if (and lw1 (listp lw1))
      (foreach e lw1
        (if (not (vlax-erased-p e))
          (entdel e)
        )
      )
    )
    (if (and lw1 (= (type lw1) 'ename) (not (vlax-erased-p lw1)))
      (entdel lw1)
    )
    (if (and lw2 (listp lw2))
      (foreach e lw2
        (if (not (vlax-erased-p e))
          (entdel e)
        )
      )
    )
    (if (and lw2 (= (type lw2) 'ename) (not (vlax-erased-p lw2)))
      (entdel lw2)
    )
    (if (and lww1 (listp lww1))
      (foreach e lww1
        (if (not (vlax-erased-p e))
          (entdel e)
        )
      )
    )
    (if (and lww1 (= (type lww1) 'ename) (not (vlax-erased-p lww1)))
      (entdel lww1)
    )
    (if (and lww2 (listp lww2))
      (foreach e lww2
        (if (not (vlax-erased-p e))
          (entdel e)
        )
      )
    )
    (if (and lww2 (= (type lww2) 'ename) (not (vlax-erased-p lww2)))
      (entdel lww2)
    )
  )

  (setq adoc (vla-get-activedocument (vlax-get-acad-object)))
  (if (= 8 (logand 8 (getvar 'undoctl)))
    (vla-endundomark adoc)
  )
  (setq cmde (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (vl-cmdf "_.UNDO" "_M")
  (while
    (or
      (prompt "\nPick closed LWPOLYLINE POLYGON on unlocked layer in Model space...")
      (not (setq s (ssget "_+.:E:S:L" '((0 . "LWPOLYLINE") (-4 . "<or") (70 . 1) (70 . 129) (-4 . "or>") (-4 . "<not") (-4 . "<>") (42 . 0.0) (-4 . "not>") (410 . "Model")))))
    )
    (prompt "\nMissed or picked wrong entity type or picking in wrong space...")
  )
  (initget 7)
  (setq slope (getreal "\nSpecify slope angle in decimal degrees : "))
  (setq ti (car (_vl-times)))
  (vla-getboundingbox (vlax-ename->vla-object (setq lw (ssname s 0))) 'minbb 'maxbb)
  (mapcar (function set) '(minbb maxbb) (mapcar (function safearray-value) (list minbb maxbb)))
  (setq minbb (mapcar (function +) '(0 0) minbb) maxbb (mapcar (function +) '(0 0) maxbb))
  (setq maxd (/ (apply (function min) (mapcar (function -) maxbb minbb)) 2.0))
  (setq ape (getvar 'aperture))
  (setvar 'aperture 25)
  (if (= (getvar 'tilemode) 0)
    (setvar 'tilemode 1)
  )
  (if (= (getvar 'worlducs) 0)
    (progn
      (vl-cmdf "_.UCS" "_W")
      (setq ucsf t)
    )
  )
  (vl-cmdf "_.VSCURRENT" "_2D")
  (if (not (and (equal (car (getvar 'viewdir)) 0.0 1e-6) (equal (cadr (getvar 'viewdir)) 0.0 1e-6) (> (caddr (getvar 'viewdir)) 0.0)))
    (progn
      (vl-cmdf "_.PLAN" "")
      (setq zf t)
    )
  )
  (vl-cmdf "_.ZOOM" "_OB" lw)
  (while (< 0 (getvar 'cmdactive))
    (vl-cmdf "")
  )
  (setq px (/ (getvar 'viewsize) (cadr (getvar 'screensize))))
  (setq pxd20 (/ px 20.0) pxd40 (/ px 40.0))
  (clean_poly lw)
  (vlax-invoke (vlax-ename->vla-object lw) (quote offset) -1e-3)
  (if (> (vlax-curve-getarea (setq lwi (entlast))) (vlax-curve-getarea lw)) ;_force pointset CCW
    (progn
      (rlw lw)
      (if (and lwi (not (vlax-erased-p lwi)))
        (entdel lwi)
      )
      (vlax-invoke (vlax-ename->vla-object lw) (quote offset) -1e-3)
      (setq lwi (entlast))
    )
  )
  (setq vl (lw2plst lw))
  (chiv lw (setq p (car-sort vl (function (lambda ( a b ) (if (= (car a) (car b)) (<= (cadr a) (cadr b)) (<= (car a) (car b))))))))
  (setq vl (append (member p vl) (reverse (cdr (member p (reverse vl))))))
  (setq tl (mapcar (function (lambda ( a b ) (list a b))) vl (append (cdr vl) (list (car vl)))))
  (foreach tt tl
    (setq v1 (unit (mapcar (function -) (cadr tt) (car tt))))
    (setq v2 (mapcar (function -) (append (mapcar (function +) '(0 0) (polar (car tt) (+ (angle (car tt) (cadr tt)) (* 0.5 pi)) (cos (cvunit slope "degree" "radian")))) (list (+ (sin (cvunit slope "degree" "radian")) (caddar vl)))) (car tt)))
    (setq tll (cons (list tt (unit (v^v v1 v2))) tll))
  )
  (foreach ttt tll
    (if (= (vl-position ttt tll) (1- (length tll)))
      (setq tttt (car tll))
      (setq tttt (nth (1+ (vl-position ttt tll)) tll))
    )
    (setq un (unit (v^v (cadr ttt) (cadr tttt))))
    (if (minusp (caddr un))
      (setq lls (list (caar ttt) (mapcar (function -) un)))
      (setq lls (list (caar ttt) un))
    )
    (setq lsl (cons lls lsl))
  )
  (setq tttt nil)
  (vla-offset (vlax-ename->vla-object lw) pxd20)
  (if (< (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
    (setq sign +)
    (setq sign -)
  )
  (entdel (entlast))
  (setq dddsl (offsetchk (list lw) maxd sign nil))
  (if dddsl
    (setq ddds (unique (mapcar (function car) dddsl)))
  )
  (setq loop t)
  (while (and lsl loop)
    (if (equal lsl lsll 1e-6)
      (setq loop nil)
    )
    (setq lsl (vl-sort lsl (function (lambda ( a b ) (if (/= (caddar a) (caddar b)) (< (caddar a) (caddar b)))))))
    (setq lsll lsl)
    (foreach ls lsl
      (foreach lss (vl-remove ls lsl)
        (if
          (and
            (setq ip (inters-1e-2 (car ls) (mapcar (function +) (car ls) (cadr ls)) (car lss) (mapcar (function +) (car lss) (cadr lss))))
            (not (vl-some (function (lambda ( x ) (equal (car x) ip 1e-6))) lsl))
            (not (equal ip (car ls) 1e-6))
            (not (equal ip (car lss) 1e-6))
            (> (caddr ip) 0.0)
          )
          (progn
            (setq tlll tll kl nil dl nil tst nil)
            (foreach tt tl
              (setq d (distance (mapcar (function +) '(0 0) (trans (car tt) 0 (unit (mapcar (function -) (cadr tt) (car tt))))) (mapcar (function +) '(0 0) (trans (list (car ip) (cadr ip) (caddar vl)) 0 (unit (mapcar (function -) (cadr tt) (car tt)))))))
              (if (<= d (+ maxd 1e-4))
                (setq dl (cons (list d tt) dl))
              )
            )
            (setq k -1)
            (foreach dt dl
              (setq k (1+ k))
              (if (>= (length (vl-remove-if-not (function (lambda ( x ) (equal (car dt) (car x) 1e-6))) dl)) 2)
                (setq kl (cons k kl))
              )
            )
            (if kl
              (progn
                (setq kl (reverse kl))
                (setq dl (mapcar (function (lambda ( x ) (nth x dl))) kl))
                (setq k -1)
                (while (setq qq (nth (setq k (1+ k)) dl))
                  (setq dl (cons qq (vl-remove-if (function (lambda ( x ) (equal (inters (list (car ip) (cadr ip)) (polar (list (car ip) (cadr ip)) (+ (angle (caadr qq) (cadadr qq)) (* 0.5 pi)) 1.0) (list (car (caadr qq)) (cadr (caadr qq))) (list (car (cadadr qq)) (cadr (cadadr qq))) nil) (inters (list (car ip) (cadr ip)) (polar (list (car ip) (cadr ip)) (+ (angle (caadr x) (cadadr x)) (* 0.5 pi)) 1.0) (list (car (caadr x)) (cadr (caadr x))) (list (car (cadadr x)) (cadr (cadadr x))) nil) 1e-6))) dl)))
                )
                (setq dl (vl-sort dl (function (lambda ( a b ) (< (car a) (car b))))))
                (setq d nil)
                (vl-some (function (lambda ( x ) (if (and (null d) (>= (length (vl-remove-if-not (function (lambda ( y ) (equal (car x) (car y) 1e-6))) dl)) 2)) (setq d (car x))))) dl)
                (if d
                  (progn
                    (if (and ddds (> d (last ddds)))
                      (progn
                        (setq dddss (cons d ddds))
                        (setq dddss (vl-sort dddss (function <)))
                        (setq d2l (reverse (cdr (member d (reverse dddss)))))
                        (setq dq 0.0)
                        (foreach dd d2l
                          (setq dq (- dd dq))
                          (setq el (entlast))
                          (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object (if lwn lwn lw)) (sign (if lwn dq dd))))
                          (while (setq el (entnext el))
                            (setq lw1 (cons el lw1))
                          )
                          (setq lwn (car-sort lw1 (function (lambda ( a b ) (<= (distance (list (car ip) (cadr ip) (caddar vl)) (vlax-curve-getclosestpointto a (list (car ip) (cadr ip) (caddar vl)))) (distance (list (car ip) (cadr ip) (caddar vl)) (vlax-curve-getclosestpointto b (list (car ip) (cadr ip) (caddar vl)))))))))
                          (foreach e lw1
                            (if (not (eq e lwn))
                              (entdel e)
                            )
                          )
                          (setq lw1 nil)
                          (if lwn
                            (setq lws (cons lwn lws))
                          )
                          (setq d2 (- d dd))
                          (if (and (null tst) lwn)
                            (tstchk)
                          )
                          (setq lwn nil d2 nil)
                        )
                        (if lws
                          (foreach lwn lws
                            (entdel lwn)
                          )
                        )
                        (setq lws nil)
                      )
                    )
                    (if (null tst)
                      (tstchk)
                    )
                  )
                )
              )
            )
            (if tst
              (progn
                (setq lslx nil f nil)
                (setq tlll (vl-remove-if-not (function (lambda ( x ) (equal (- (caddr (trans ip 0 (cadr x))) (caddr (trans (caar x) 0 (cadr x)))) 0.0 1e-6))) tlll))
                (if
                  (not
                    (and
                      (equal (caddr (car ls)) (caddar vl) 1e-6)
                      (equal (caddr (car lss)) (caddar vl) 1e-6)
                      (if (and (vl-position ls lsl) (vl-position lss lsl))
                        (and
                          (not
                            (or
                              (= (vl-position ls lsl) (1+ (vl-position lss lsl)))
                              (= (vl-position lss lsl) (1+ (vl-position ls lsl)))
                            )
                          )
                          (not
                            (or
                              (and
                                (= (vl-position ls lsl) 0)
                                (= (vl-position lss lsl)
                                  (1- (length (vl-member-if (function (lambda ( x )
                                                              (equal (caddr (car x)) (caddar vl) 1e-6)
                                                            ))
                                                            (reverse lsl)
                                              )
                                      )
                                  )
                                )
                              )
                              (and
                                (= (vl-position lss lsl) 0)
                                (= (vl-position ls lsl)
                                   (1- (length (vl-member-if (function (lambda ( x )
                                                                (equal (caddr (car x)) (caddar vl) 1e-6)
                                                              ))
                                                              (reverse lsl)
                                              )
                                      )
                                   )
                                )
                              )
                            )
                          )
                        )
                      )
                    )
                  )
                  (if (setq n (unit (v^v (cadr ls) (cadr lss))))
                    (progn
                      (setq tlll (vl-remove-if (function (lambda ( x ) (or (equal n (cadr x) 1e-6) (equal (mapcar (function -) n) (cadr x) 1e-6)))) tlll))
                      (setq f t)
                    )
                  )
                )
                (foreach ttt tlll
                  (foreach tttt (vl-remove ttt tlll)
                    (setq lls (list ip (unit (v^v (cadr ttt) (cadr tttt)))))
                    (if (cadr lls)
                      (setq lslx (cons lls lslx))
                    )
                  )
                )
                (if lslx
                  (progn
                    (setq ls (list (car ls) (unit (mapcar (function -) ip (car ls)))))
                    (setq lss (list (car lss) (unit (mapcar (function -) ip (car lss)))))
                    (if f
                      (setq lslx (cons (list ip (mapcar (function -) (cadr ls))) lslx) lslx (cons (list ip (mapcar (function -) (cadr lss))) lslx))
                    )
                    (setq lslx (unique lslx))
                    (setq lslx (vl-remove-if (function (lambda ( x ) (equal x (list ip (cadr ls)) 1e-6))) lslx))
                    (setq lslx (vl-remove-if (function (lambda ( x ) (equal x (list ip (cadr lss)) 1e-6))) lslx))
                    (setq lsl (append lsl lslx))
                    (setq lsl (vl-remove-if (function (lambda ( x ) (equal x (list (car ls) (mapcar (function -) (cadr ls))) 1e-6))) lsl))
                    (setq lsl (vl-remove-if (function (lambda ( x ) (equal x (list (car lss) (mapcar (function -) (cadr lss))) 1e-6))) lsl))
                  )
                )
              )
              (if
                (and
                  (not (vl-position ip ipl))
                  (inside-p (list (car ip) (cadr ip) (caddar vl)) lw lwi)
                  (<= 2 (- (length (setq ddd (dd (list (car ip) (cadr ip) (caddar vl))))) (length (unique ddd))))
                )
                (setq ipl (cons ip ipl))
              )
            )
          )
        )
      )
    )
  )
  (setq lsl (uniqueptvec lsl))
  (foreach ls lsl
    (foreach e (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (and (and (not (equal (car x) (car y) 1e-6)) (online (car x) (car y) (cadr x))) (and (not (equal (car x) (cadr y) 1e-6)) (online (car x) (cadr y) (cadr x))) (online (car x) (cadr x) (cadr y)) (and (not (equal (cadr x) (cadr y) 1e-6)) (online (car y) (cadr y) (cadr x)))))) (vl-remove x lil2)))) lil2)
      (if (not (vlax-erased-p (caddr e)))
        (entdel (caddr e))
      )
    )
    (setq lil2 nil)
    (foreach lss (vl-remove ls lsl)
      (if
        (and
          (not (equal (car ls) (car lss) 1e-6))
          (or
            (equal (unit (mapcar (function -) (car lss) (car ls))) (cadr ls) 1e-6)
            (equal (unit (mapcar (function -) (car ls) (car lss))) (cadr ls) 1e-6)
            (equal (unit (mapcar (function -) (car lss) (car ls))) (cadr lss) 1e-6)
            (equal (unit (mapcar (function -) (car ls) (car lss))) (cadr lss) 1e-6)
          )
          (not (vl-some (function (lambda ( x ) (or (equal (list (car ls) (car lss)) x 1e-6) (equal (list (car lss) (car ls)) x 1e-6)))) lil))
          (<= 2 (- (length (setq ddd (dd (list (caar lss) (cadar lss))))) (length (unique ddd))))
          (not (vl-some (function (lambda ( x ) (equal (car x) ip 1e-6))) lil))
        )
        (progn
          (entmake (list (cons 0 "LINE") (cons 10 (car ls)) (cons 11 (car lss))))
          (setq lil2 (cons (list (car ls) (car lss) (entlast)) lil2))
          (setq lil (cons (list (car ls) (car lss)) lil))
        )
      )
    )
  )
  (foreach e (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (and (and (not (equal (car x) (car y) 1e-6)) (online (car x) (car y) (cadr x))) (and (not (equal (car x) (cadr y) 1e-6)) (online (car x) (cadr y) (cadr x))) (online (car x) (cadr x) (cadr y)) (and (not (equal (cadr x) (cadr y) 1e-6)) (online (car y) (cadr y) (cadr x)))))) (vl-remove x lil)))) lil)
    (if (not (vlax-erased-p (caddr e)))
      (entdel (caddr e))
    )
  )
  (setq lil2 nil)
  (foreach ip ipl
    (if (>= (length (setq lslip (uniqueipvec (vl-remove-if-not (function (lambda ( x ) (or (equal (unit (mapcar (function -) ip (car x))) (cadr x) 1e-6) (equal (unit (mapcar (function -) (car x) ip)) (cadr x) 1e-6)))) lsl) ip))) 3)
      (foreach ls lslip
        (if
          (and
            (not (or (vl-position-fuzz (list (car ls) ip) lil 1e-6) (vl-position-fuzz (list ip (car ls)) lil 1e-6)))
            (not (vl-some (function (lambda ( x ) (and (not (equal (car x) (car ls) 1e-6)) (equal (distance ip (car ls)) (+ (distance ip (car x)) (distance (car x) (car ls))) 1e-6)))) lslip))
            (<= 2 (- (length (setq ddd (dd (list (car ip) (cadr ip))))) (length (unique ddd))))
            (not (vl-some (function (lambda ( x ) (and (not (equal (car x) ip 1e-6)) (not (equal (cadr x) ip 1e-6)) (online (car x) (cadr x) ip)))) lil))
            (not (vl-some (function (lambda ( x ) (equal (car x) ip 1e-6))) lil))
          )
          (progn
            (entmake (list (cons 0 "LINE") (cons 10 (car ls)) (cons 11 ip)))
            (setq lil2 (cons (list (car ls) ip (entlast)) lil2))
            (setq lil (cons (list (car ls) ip) lil))
          )
        )
      )
    )
  )
  (setq dlst
    (vl-remove-if-not
      (function (lambda ( x )
        (vl-some
          (function (lambda ( y )
            (or
              (and
                (equal (car y) (cadr x) 1e-6)
                (online (car y) (polar (car y) (angle (car x) (cadr x)) 1e-3) (cadr y))
              )
              (and
                (not (equal (cadr y) (cadr x) 1e-6))
                (not (equal (cadr y) (car x) 1e-6))
                (online (car x) (cadr y) (cadr x))
              )
            )
          ))
          (vl-remove x lil)
        )
      ))
      lil
    )
  )
  (foreach e dlst
    (if
      (setq ee
        (vl-some
          (function (lambda ( x )
            (if
              (and
                (equal (car e) (cdr (assoc 10 (entget x))) 1e-6)
                (equal (cadr e) (cdr (assoc 11 (entget x))) 1e-6)
              )
              x
            )
          ))
          lll
        )
      )
      (if (and ee (not (vlax-erased-p ee)))
        (entdel ee)
      )
    )
  )
  (foreach e
    (vl-remove-if-not
      (function (lambda ( x )
        (vl-some
          (function (lambda ( y )
            (and
              (equal (car y) (cadr x) 1e-6)
              (online (car x) (cadr x) (cadr y))
            )
          ))
          (vl-remove x lil)
        )
      ))
      lil
    )
    (if
      (setq ee
        (vl-some
          (function (lambda ( x )
            (if
              (and
                (equal (car e) (cdr (assoc 10 (entget x))) 1e-6)
                (equal (cadr e) (cdr (assoc 11 (entget x))) 1e-6)
              )
              x
            )
          ))
          lll
        )
      )
      (if (and ee (not (vlax-erased-p ee)))
        (entdel ee)
      )
    )
  )
  (setq fpts
    (vl-remove-if
      (function (lambda ( p )
        (vl-some
          (function (lambda ( li )
            (equal p (car li) 1e-6)
          ))
          (vl-remove nil
            (mapcar
              (function (lambda ( x )
                (if (setq ex (entget x))
                  (list (cdr (assoc 10 ex)) (cdr (assoc 11 ex)))
                )
              ))
              lll
            )
          )
        )
      ))
      vl
    )
  )
  (if fpts
    (foreach pt fpts
      (cond
        ( (setq ptt (vl-remove-if-not (function (lambda ( x ) (equal pt (car x) 1e-6))) lil))
          (foreach px (mapcar (function cadr) ptt)
            (entmake
              (list
                (cons 0 "LINE")
                (cons 10 pt)
                (cons 11 px)
              )
            )
          )
        )
        ( (setq ptt (vl-remove-if-not (function (lambda ( x ) (equal pt (cadr x) 1e-6))) lil))
          (foreach px (mapcar (function car) ptt)
            (entmake
              (list
                (cons 0 "LINE")
                (cons 10 px)
                (cons 11 pt)
              )
            )
          )
        )
      )
    )
    (vl-some
      (function (lambda ( x )
        (vl-some
          (function (lambda ( y )
            (if
              (and
                y
                (vlax-erased-p y)
                (equal x (cdr (assoc 10 (entget (entdel y)))) 1e-6)
              )
              (if
                (and
                  y
                  (vlax-erased-p y)
                )
                (entdel y)
              )
            )
          ))
          lll
        )
      ))
      vl
    )
  )
  (vl-cmdf "_.ZOOM" "_P")
  (if zf
    (vl-cmdf "_.ZOOM" "_P")
  )
  (prompt "\nElapsed time : ") (princ (rtos (/ (- (car (_vl-times)) ti) 1000.0) 2 50)) (prompt " seconds.")
  (*error* nil)
)