(defun c:roof-mr-3dlines23dsolid ( / *error* unit v^v car-sort chiv clockwise-lw lw2plst clean_poly rlw uniqueg uniquetll getslope 3dlines2regs adoc s ss ang slope lw lill ti ucsf vl tl v1 v2 tll tttt un lls lsl regs cmde )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if cmde
      (setvar 'cmdecho cmde)
    )
    (if adoc
      (vla-endundomark adoc)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun unit ( v )
    (if (not (equal v '(0.0 0.0 0.0) 1e-8))
      (mapcar (function (lambda ( x ) (/ x (distance '(0.0 0.0 0.0) v)))) v)
    )
  )

  (defun v^v ( u v )
    (list
      (- (* (cadr u) (caddr v)) (* (caddr u) (cadr v)))
      (- (* (caddr u) (car v)) (* (car u) (caddr v)))
      (- (* (car u) (cadr v)) (* (cadr u) (car v)))
    )
  )

  (defun car-sort ( lst cmp / rtn )
    (setq rtn (car lst))
    (foreach itm (cdr lst)
      (if (apply cmp (list itm rtn))
        (setq rtn itm)
      )
    )
    rtn
  )

  (defun chiv ( e p / ed edd eddd eddd1 eddd2 eddd3 newed m n i )
    (setq ed (entget e))
    (setq edd nil)
    (foreach ec ed 
      (if (not 
            (or (eq (car ec) 10) (eq (car ec) 40) (eq (car ec) 41) (eq (car ec) 42) (eq (car ec) 91) (eq (car ec) 210))
          )
          (setq edd (cons ec edd))
      )
    )
    (setq edd (reverse edd))
    (setq eddd nil)
    (setq eddd1 nil)
    (setq eddd2 nil)
    (setq eddd (member (assoc 10 ed) ed))
    (setq m (vlax-curve-getparamatpoint e (vlax-curve-getclosestpointto e p)))
    (if (assoc 91 ed) (setq n (* m 5)) (setq n (* m 4)))
    (setq i 0)
    (foreach ec eddd
      (progn
        (setq i (+ i 1))
        (if (<= i n)
          (setq eddd1 (cons ec eddd1))
        )
        (if (> i n)
          (setq eddd2 (cons ec eddd2))
        )
      )
    )
    (setq eddd1 (reverse eddd1))
    (setq eddd3 (list (assoc 210 eddd2)))
    (setq eddd2 (cdr eddd2))
    (setq eddd2 (reverse eddd2))
    (setq newed (append edd eddd2 eddd1 eddd3))
    (entmod newed)
    (entupd e)
  )

  (defun clockwise-lw ( lw / minpt maxpt p1 p2 p3 p4 pmax )
    (vla-getboundingbox (vlax-ename->vla-object lw) 'minpt 'maxpt)
    (mapcar (function set) '(minpt maxpt) (mapcar (function safearray-value) (list minpt maxpt)))
    (setq p1 minpt p2 (list (car maxpt) (cadr minpt)) p3 maxpt p4 (list (car minpt) (cadr maxpt)))
    (setq p1 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p1)))
    (setq p2 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p2)))
    (setq p3 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p3)))
    (setq p4 (vlax-curve-getparamatpoint lw (vlax-curve-getclosestpointto lw p4)))
    (setq pmax (max p1 p2 p3 p4))
    (cond
      ( (and (= pmax p1) (> p2 p4))
        t
      )
      ( (and (= pmax p2) (> p3 p1))
        t
      )
      ( (and (= pmax p3) (> p4 p2))
        t
      )
      ( (and (= pmax p4) (> p1 p3))
        t
      )
      ( t nil )
    )
  )

  (defun lw2plst ( lw / lst k p )
    (setq lst (cons (vlax-curve-getstartpoint lw) lst))
    (setq k 0)
    (while (and (setq k (1+ k)) (<= k (fix (- (vlax-curve-getendparam lw) 0.01))))
      (setq p (vlax-curve-getpointatparam lw (float k)))
      (setq lst (cons p lst))
    )
    (reverse lst)
  )

  (defun clean_poly ( lw / pl pos pre suf k lwx )
    (setq pl (lw2plst lw))
    (setq pos (mapcar (function (lambda ( a b c ) (if (equal (distance a c) (+ (distance a b) (distance b c)) 1e-6) t nil))) (cons (last pl) (reverse (cdr (reverse pl)))) (append (cdr (cons (last pl) (reverse (cdr (reverse pl))))) (list (last pl))) (append (cddr (cons (last pl) (reverse (cdr (reverse pl))))) (list (last pl) (car pl)))))
    (if (apply (function or) pos)
      (progn
        (setq k -1)
        (setq pos (vl-remove nil (mapcar (function (lambda ( x ) (progn (setq k (1+ k)) (if (eq x t) k)))) pos)))
        (foreach p pos
          (setq pos (subst (nth p pl) p pos))
        )
        (foreach p pos
          (setq pl (vl-remove-if (function (lambda ( x ) (equal x p 1e-8))) pl))
        )
        (setq pre (reverse (cdr (member (assoc 10 (setq lwx (entget lw))) (reverse lwx)))))
        (setq pre (subst (cons 90 (length pl)) (assoc 90 pre) pre))
        (setq suf (append (mapcar (function (lambda ( x ) (cons 10 (trans x 0 (cdr (assoc 210 lwx)))))) pl) (list (assoc 210 lwx))))
        (entmod (append pre suf))
      )
    )
    (entupd lw)
  )

  (defun rlw ( lw / e x1 x2 x3 x4 x5 x6 )
    (if (= (cdr (assoc 0 (setq e (entget lw)))) "LWPOLYLINE")
      (progn (foreach a1 e
               (cond ((= (car a1) 10) (setq x2 (cons a1 x2)))
                     ((= (car a1) 40) (setq x4 (cons (cons 41 (cdr a1)) x4)))
                     ((= (car a1) 41) (setq x3 (cons (cons 40 (cdr a1)) x3)))
                     ((= (car a1) 42) (setq x5 (cons (cons 42 (- (cdr a1))) x5)))
                     ((= (car a1) 210) (setq x6 (cons a1 x6)))
                     (t (setq x1 (cons a1 x1)))
               )
             )
             (entmod (append (reverse x1)
                             (append (apply (function append)
                                            (apply (function mapcar)
                                                   (cons 'list
                                                         (list x2
                                                               (cdr (reverse (cons (car x3) (reverse x3))))
                                                               (cdr (reverse (cons (car x4) (reverse x4))))
                                                               (cdr (reverse (cons (car x5) (reverse x5))))
                                                         )
                                                   )
                                            )
                                     )
                                     x6
                             )
                     )
             )
             (entupd lw)
      )
    )
  )

  (defun uniqueg ( elst )
    (if elst (cons (car elst) (uniqueg (vl-remove-if (function (lambda ( x ) (and (equal (vlax-curve-getstartpoint x) (vlax-curve-getstartpoint (car elst)) 1e-6) (equal (vlax-curve-getendpoint x) (vlax-curve-getendpoint (car elst)) 1e-6)))) elst))))
  )

  (defun uniquetll ( tll )
    (if tll (cons (car tll) (uniquetll (vl-remove-if (function (lambda ( x ) (and (or (equal (cadar tll) (cadr x) 1e-6) (equal (cadar tll) (mapcar (function -) (cadr x)) 1e-6)) (equal (- (caddr (trans (caaar tll) 0 (cadar tll))) (caddr (trans (caar x) 0 (cadar tll)))) 0.0 1e-6) (equal (- (caddr (trans (caaar tll) 0 (cadar tll))) (caddr (trans (cadar x) 0 (cadar tll)))) 0.0 1e-6)))) tll))))
  )

  (defun getslope ( p1 p2 ps / pp ip pp1 ps1 slope )
    (setq pp (list (car ps) (cadr ps) (caddr p1)))
    (setq ip (inters p1 p2 pp (polar pp (+ (angle p1 p2) (* 0.5 pi)) 1.0) nil))
    (setq pp1 (mapcar (function +) ip (mapcar (function /) (mapcar (function -) pp ip) (list (distance pp ip) (distance pp ip) (distance pp ip)))))
    (setq ps1 (mapcar (function +) ip (mapcar (function *) (mapcar (function /) (mapcar (function -) ps ip) (list (distance ps ip) (distance ps ip) (distance ps ip))) (list (/ (distance ps ip) (distance pp ip)) (/ (distance ps ip) (distance pp ip)) (/ (distance ps ip) (distance pp ip))))))
    (setq slope (cvunit (atan (- (caddr ps1) (caddr p1))) "radian" "degree"))
    slope
  )

  (defun 3dlines2regs ( lwlil lil tll / lill lilst el g ssg regs p1 p2 p1n p2n lix )

    (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

    (foreach li lil
      (setq lill (cons (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object li))) lill))
    )
    (setq lilst (append lwlil lil lill))
    (foreach tl (uniquetll tll)
      (setq el (entlast))
      (setq g (vl-remove-if-not (function (lambda ( x ) (and (equal (- (caddr (trans (caar tl) 0 (cadr tl))) (caddr (trans (vlax-curve-getstartpoint x) 0 (cadr tl)))) 0.0 1e-6) (equal (- (caddr (trans (caar tl) 0 (cadr tl))) (caddr (trans (vlax-curve-getendpoint x) 0 (cadr tl)))) 0.0 1e-6)))) lilst))
      (setq g (uniqueg g))
      (setq ssg (ssadd))
      (foreach li g
        (setq p1 (vlax-curve-getstartpoint li) p2 (vlax-curve-getendpoint li))
        (setq p1n (trans (list (car (trans p1 0 (cadr tl))) (cadr (trans p1 0 (cadr tl))) (caddr (trans (caar tl) 0 (cadr tl)))) (cadr tl) 0))
        (setq p2n (trans (list (car (trans p2 0 (cadr tl))) (cadr (trans p2 0 (cadr tl))) (caddr (trans (caar tl) 0 (cadr tl)))) (cadr tl) 0))
        (setq lix (entget li))
        (setq lix (subst (cons 10 p1n) (assoc 10 lix) lix))
        (setq lix (subst (cons 11 p2n) (assoc 11 lix) lix))
        (ssadd (entupd (cdr (assoc -1 (entmod lix)))) ssg)
      )
      (vl-cmdf "_.REGION" ssg "")
      (while (< 0 (getvar 'cmdactive))
        (vl-cmdf "")
      )
      (if (not (eq el (entlast)))
        (while (setq el (entnext el))
          (setq regs (cons el regs))
        )
      )
      (foreach e g
        (setq lilst (vl-remove e lilst))
      )
    )
    (foreach li (append lwlil lil lill)
      (if (and li (not (vlax-erased-p li)))
        (entdel li)
      )
    )
    regs
  )

  (setq adoc (vla-get-activedocument (vlax-get-acad-object)))
  (if (= 8 (logand 8 (getvar 'undoctl)))
    (vla-endundomark adoc)
  )
  (setq cmde (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (vl-cmdf "_.UNDO" "_M")
  (while
    (or
      (prompt "\nPick closed LWPOLYLINE POLYGON on unlocked layer...")
      (not (setq s (ssget "_+.:E:S:L" '((0 . "LWPOLYLINE") (-4 . "<or") (70 . 1) (70 . 129) (-4 . "or>") (-4 . "<not") (-4 . "<>") (42 . 0.0) (-4 . "not>")))))
    )
    (prompt "\nMissed or picked wrong entity type...")
  )
  (while
    (or
      (prompt "\nSelect 3d lines - solution of roof...")
      (not (setq ss (ssget "_:L" '((0 . "LINE")))))
    )
    (prompt "\nEmpty sel.set...")
  )
  (prompt "\nWhen asked to select objects, type \"P\" - Previous...")
  (c:breakall-nogap)
  (setq ss (ssget "_I"))
  (if (= 0 (getvar 'worlducs))
    (progn
      (vl-cmdf "_.UCS" "_W")
      (setq ucsf t)
    )
  )
  (setq lw (ssname s 0))
  (setq lill (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex ss))))
  (clean_poly lw)
  (vlax-invoke (vlax-ename->vla-object lw) 'offset -1e-3)
  (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw)) ;_force pointset CCW
    (rlw lw)
  )
  (entdel (entlast))
  ;|
  (if (clockwise-lw lw)
    (rlw lw)
  )
  |;
  (setq vl (lw2plst lw))
  (chiv lw (setq p (car-sort vl (function (lambda ( a b ) (if (= (car a) (car b)) (<= (cadr a) (cadr b)) (<= (car a) (car b))))))))
  (setq vl (append (member p vl) (reverse (cdr (member p (reverse vl))))))
  (setq ang (getslope (car vl) (cadr vl) (car (vl-remove-if (function (lambda ( x ) (equal x (car vl) 1e-6))) ((lambda ( x ) (list (vlax-curve-getstartpoint x) (vlax-curve-getendpoint x))) (car (vl-remove-if-not (function (lambda ( x ) (or (equal (vlax-curve-getstartpoint x) (car vl) 1e-6) (equal (vlax-curve-getendpoint x) (car vl) 1e-6)))) lill)))))))
  (initget 6)
  (setq slope (getreal (strcat "\nSpecify slope angle in decimal degrees <" (rtos ang 2 50) "> : ")))
  (if (null slope)
    (setq slope ang)
  )
  (setq ti (car (_vl-times)))
  (setq tl (mapcar (function (lambda ( a b ) (list a b))) vl (cdr (reverse (cons (car vl) (reverse vl))))))
  (foreach tt tl
    (setq v1 (unit (mapcar (function -) (cadr tt) (car tt))))
    (setq v2 (mapcar (function -) (append (mapcar (function +) '(0 0) (polar (car tt) (+ (angle (car tt) (cadr tt)) (* 0.5 pi)) (cos (cvunit slope "degree" "radian")))) (list (+ (sin (cvunit slope "degree" "radian")) (caddar vl)))) (car tt)))
    (setq tll (cons (list tt (unit (v^v v1 v2))) tll))
  )
  (vla-copy (vlax-ename->vla-object lw))
  (vl-cmdf "_.REGION" "_L")
  (while (< 0 (getvar 'cmdactive))
    (vl-cmdf "")
  )
  (setq regs (cons (entlast) regs))
  (vl-cmdf "_.EXPLODE" lw)
  (while (< 0 (getvar 'cmdactive))
    (vl-cmdf "")
  )
  (setq regs (append (list (car regs)) (3dlines2regs (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex (ssget "_P")))) lill tll)))
  (setq ss (ssadd))
  (foreach reg regs
    (ssadd reg ss)
  )
  (vl-cmdf "_.SURFSCULPT" ss "")
  (if ucsf
    (vl-cmdf "_.UCS" "_P")
  )
  (prompt "\nElapsed time : ") (princ (rtos (/ (- (car (_vl-times)) ti) 1000.0) 2 50)) (prompt " seconds.")
  (*error* nil)
)
