(defun c:2droof-arx ( / pts hole i lst outline ret ss ent lll ti )

  (defun getpts ( ent )
    (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= 10 (car x)))) (entget ent)))
  )

  (defun makeline ( p q )
    (entmakex (list (cons 0 "LINE") (cons 10 p) (cons 11 q)))
  )

  (if (not (vl-position "straightskeleton.r2021-2024.arx" (arx)))
    (if (findfile "StraightSkeleton.R2021-2024.arx")
      (arxload (findfile "StraightSkeleton.R2021-2024.arx"))
    )
  )
  (prompt "\nPlease select polylines: the first one will be the outer contour, and the others will be treated as hole contours (if any).")
  (setq ss (ssget (list (cons 0 "LWPOLYLINE") (cons -4 "&=") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
  (if ss
    (progn
      (setq ti (car (_vl-times)))
      (setq outline (ssname ss 0))
      (setq lst (list (getpts outline)))
      (setq i 1)
      (repeat (1- (sslength ss))
        (setq hole (ssname ss i))
        (setq pts (getpts hole))
        (setq lst (cons pts lst))
        (setq i (1+ i))
      )
      (setq lst (reverse lst))
      (setq ret (apply (function StraightSkeleton) lst))
      (foreach x ret
        (if (and (not (vl-position x lll)) (not (vl-position (reverse x) lll)))
          (progn
            (setq ent (apply (function makeline) x))
            (setq lll (cons x lll))
        ;;; (vla-put-color (vlax-ename->vla-object ent) 1)
          )
        )
      )
      (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")
    )
  )
  (princ)
)