(defun c:roof-triangs ( / *error* _offset unit rlw offd inside-p collinear-p collinear-pp unique chkcircinside chkcircinside-dist mc subbody subprocess preprocess preprocess-rev prout process osm cmd done lw lwi lwx ent enti lil lix lwnl lwnll el p1 p2 pp ppp ipp ippl vll vlli tll iplst n ti ) ;;; cad, doc, spc, lay, vlll, vllli, tlll, f - global variables ;;;

  (defun *error* ( m )
    (if (and lwi (not (vlax-erased-p lwi)))
      (entdel lwi)
    )
    (if (and enti (not (vlax-erased-p enti)))
      (entdel enti)
    )
    (while (setq el (entnext el))
      (if (and el (not (vlax-erased-p el)))
        (entdel el)
      )
    )
    (if lil
      (foreach li lil
        (entmake (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)) (cons 62 3)))
      )
    )
    (if (setq ppp (unique (mapcar 'car lil)))
      (foreach pp ppp
        (entmake (list (cons 0 "POINT") (cons 10 pp) (cons 62 1)))
      )
    )
    ;;;(command-s "_.-OVERKILL" "_ALL" "_T" "_Y" "" "")
    (if osm
      (setvar 'osmode osm)
    )
    (if cmd
      (setvar 'cmdecho cmd)
    )
    (if (= 8 (logand 8 (getvar 'undoctl)))
      (vla-endundomark doc)
    )
    (prompt "\nIf you want to start again on different sample, make sure you nil flag f : (setq f nil vlll nil vllli nil tlll nil done nil) ...")
    (setq f nil vlll nil vllli nil tlll nil done nil)
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun _offset ( lw dist / lill lww vl lwx tl tln iplst lws )
    (setq vl (mapcar 'cdr (vl-remove-if '(lambda ( x ) (/= (car x) 10)) (setq lwx (entget lw)))))
    (setq tl (mapcar '(lambda ( a b ) (list a b)) vl (append (cdr vl) (list (car vl)))))
    (setq tln (mapcar '(lambda ( x ) (list (polar (car x) (+ (* 0.5 pi) (angle (car x) (cadr x))) (- dist)) (polar (cadr x) (+ (* 0.5 pi) (angle (car x) (cadr x))) (- dist)))) tl))
    (setq iplst (mapcar '(lambda ( a b ) (inters (car a) (cadr a) (car b) (cadr b) nil)) tln (append (cdr tln) (list (car tln)))))
    (setq lill (mapcar '(lambda ( a b ) (list a b)) iplst (append (cdr iplst) (list (car iplst)))))
    (setq lill (vl-remove-if '(lambda ( x ) (or (null (car x)) (null (cadr x)))) lill))
    (setq lws
      (cons
        (setq lww
          (entmakex
            (append
              (list
                (cons 0 "LWPOLYLINE")
                (cons 100 "AcDbEntity")
                (cons 100 "AcDbPolyline")
                (cons 90 (length iplst))
                (cons 70 (1+ (* 128 (getvar 'plinegen))))
                (cons 38 0.0)
              )
              (mapcar '(lambda ( p ) (cons 10 p)) iplst)
              (list (list 210 0.0 0.0 1.0))
            )
          )
        )
        lws
      )
    )
  )

  (defun unit ( v / d )
    (if (not (equal (setq d (distance '(0.0 0.0 0.0) v)) 0.0 1e-6))
      (mapcar '(lambda ( x ) (/ x d)) v)
    )
  )

  (defun rlw ( lw / e x1 x2 x3 x4 x5 x6 )
    ;; by ElpanovEvgeniy
    (if (= (cdr (assoc 0 (setq e (entget lw)))) "LWPOLYLINE")
      (progn
        (foreach a1 e
          (cond ((= (car a1) 10) (setq x2 (cons a1 x2)))
                ((= (car a1) 40) (setq x4 (cons (cons 41 (cdr a1)) x4)))
                ((= (car a1) 41) (setq x3 (cons (cons 40 (cdr a1)) x3)))
                ((= (car a1) 42) (setq x5 (cons (cons 42 (- (cdr a1))) x5)))
                ((= (car a1) 210) (setq x6 (cons a1 x6)))
                (t (setq x1 (cons a1 x1)))
          )
        )
        (entmod (append (reverse x1)
                  (append (apply 'append
                            (apply 'mapcar
                              (cons 'list
                                (list x2
                                  (cdr (reverse (cons (car x3) (reverse x3))))
                                  (cdr (reverse (cons (car x4) (reverse x4))))
                                  (cdr (reverse (cons (car x5) (reverse x5))))
                                )
                              )
                            )
                          )
                          x6
                  )
                )
        )
        (entupd lw)
      )
    )
  )

  (defun offd ( sign ip tl / dl )
    (setq dl (mapcar '(lambda ( x )
                        (distance ip
                          (inters
                            ip
                            (polar ip (+ (* 0.5 pi) (angle (car x) (cadr x))) 1.0)
                            (car x)
                            (polar (car x) (angle (car x) (cadr x)) 1.0)
                            nil
                          )
                        )
                      ) tl
              )
    )
    (vl-some '(lambda ( x )
               (if
                 (>
                   (-
                     (length dl)
                     (length (vl-remove-if '(lambda ( y ) (equal x y 1e-5)) dl))
                   ) 2
                 )
                 x
               )
             ) (vl-sort dl sign)
    )
  )

  (defun inside-p ( p lw lwi )
    (< (distance p (vlax-curve-getclosestpointto lwi p)) (distance p (vlax-curve-getclosestpointto lw p)))
  )

  (defun collinear-p ( p1 p p2 )
    (equal (distance p1 p2) (+ (distance p1 p) (distance p p2)) 1e-6)
  )

  (defun collinear-pp ( p1 p2 p3 )
    (
      (lambda ( a b c )
        (or
          (equal (+ a b) c 1e-6)
          (equal (+ b c) a 1e-6)
          (equal (+ c a) b 1e-6)
        )
      )
      (distance p1 p2) (distance p2 p3) (distance p1 p3)
    )
  )

  (defun unique ( lst )
    (if lst
      (cons (car lst)
            (unique
              (vl-remove-if
                '(lambda ( x )
                   (equal x (car lst) 1e-6)
                 )
                (cdr lst)
              )
            )
      )
    )
  )

  (defun chkcircinside ( pp tll / ci1 ipp1 ippl1 params1 pts1 ci2 ipp2 ippl2 params2 pts2 tst )
    (if (and pp tll)
      (progn
        (setq ci1 (entmakex (list (cons 0 "CIRCLE") (cons 10 pp) (cons 40 (offd (function <) pp tll)))))
        (setq ci2 (entmakex (list (cons 0 "CIRCLE") (cons 10 pp) (cons 40 (offd (function >) pp tll)))))
        (if (setq ipp1 (vlax-invoke (vlax-ename->vla-object ci1) 'intersectwith (vlax-ename->vla-object ent) acextendnone))
          (progn
            (while ipp1
              (setq ippl1 (cons (list (car ipp1) (cadr ipp1)) ippl1))
              (setq ipp1 (cdddr ipp1))
            )
            (setq params1 (mapcar '(lambda ( x ) (vlax-curve-getparamatpoint ci1 x)) ippl1))
            (setq pts1 (apply 'append (mapcar '(lambda ( x ) (list (vlax-curve-getpointatparam ci1 (- x 0.25)) (vlax-curve-getpointatparam ci1 (+ x 0.25)))) params1)))
            (if (or (not ippl1) (vl-every '(lambda ( x ) (inside-p x ent enti)) pts1))
              (setq tst (cons t tst))
              (setq tst (cons nil tst))
            )
          )
          (setq tst (cons t tst))
        )
        (if (not (apply 'and tst))
          (if (setq ipp2 (vlax-invoke (vlax-ename->vla-object ci2) 'intersectwith (vlax-ename->vla-object ent) acextendnone))
            (progn
              (while ipp2
                (setq ippl2 (cons (list (car ipp2) (cadr ipp2)) ippl2))
                (setq ipp2 (cdddr ipp2))
              )
              (setq params2 (mapcar '(lambda ( x ) (vlax-curve-getparamatpoint ci2 x)) ippl2))
              (setq pts2 (apply 'append (mapcar '(lambda ( x ) (list (vlax-curve-getpointatparam ci2 (- x 0.25)) (vlax-curve-getpointatparam ci2 (+ x 0.25)))) params2)))
              (if (or (not ippl2) (vl-every '(lambda ( x ) (inside-p x ent enti)) pts2))
                (setq tst (cons t tst))
                (setq tst (cons nil tst))
              )
            )
            (setq tst (cons t tst))
          )
        )
        (if (and ci1 (not (vlax-erased-p ci1)))
          (entdel ci1)
        )
        (if (and ci2 (not (vlax-erased-p ci2)))
          (entdel ci2)
        )
      )
    )
    (apply 'and tst)
  )

  (defun chkcircinside-dist ( pp dist / ci ipp ippl params pts tst )
    (if (and pp dist)
      (progn
        (setq ci (entmakex (list (cons 0 "CIRCLE") (cons 10 pp) (cons 40 dist))))
        (if (setq ipp (vlax-invoke (vlax-ename->vla-object ci) 'intersectwith (vlax-ename->vla-object ent) acextendnone))
          (progn
            (while ipp
              (setq ippl (cons (list (car ipp) (cadr ipp)) ippl))
              (setq ipp (cdddr ipp))
            )
            (setq params (mapcar '(lambda ( x ) (vlax-curve-getparamatpoint ci x)) ippl))
            (setq pts (apply 'append (mapcar '(lambda ( x ) (list (vlax-curve-getpointatparam ci (- x 0.25)) (vlax-curve-getpointatparam ci (+ x 0.25)))) params)))
            (if (or (not ippl) (vl-every '(lambda ( x ) (inside-p x ent enti)) pts))
              (setq tst (cons t tst))
              (setq tst (cons nil tst))
            )
          )
          (setq tst (cons t tst))
        )
        (if (and ci (not (vlax-erased-p ci)))
          (entdel ci)
        )
      )
    )
    (apply 'and tst)
  )

  (defun mc ( p lw / mid ci pl mp p1 p2 p3 p4 par1 par2 par3 par4 tst tllll )

    (defun mid ( ci p1 p2 / par1 par2 mp )
      (setq par1 (vlax-curve-getparamatpoint ci p1) par2 (vlax-curve-getparamatpoint ci p2))
      (setq mp (mapcar '+ '(0.0 0.0) (vlax-curve-getpointatparam ci (/ (+ par1 par2) 2.0))))
    )

    (setq ci (entmakex (list (cons 0 "CIRCLE") (cons 10 p) (cons 40 0.25)))) ;;; quater unit vector radius ...
    (setq pl (vlax-invoke (vlax-ename->vla-object ci) 'intersectwith (vlax-ename->vla-object lw) acextendnone))
    (cond
      ( (= (length pl) 12)
        (setq p1 (list (car pl) (cadr pl)))
        (setq p2 (list (nth 3 pl) (nth 4 pl)))
        (setq p3 (list (nth 6 pl) (nth 7 pl)))
        (setq p4 (list (nth 9 pl) (nth 10 pl)))
        (cond
          ( (vl-some '(lambda ( li ) (or (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- (mid ci p1 p2) p)) 1e-3) (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- p (mid ci p1 p2))) 1e-3))) lil)
            (setq mp (mid ci p3 p4))
            (setq tllll tlll)
            (repeat (length tlll)
              (if (vl-some '(lambda ( x y ) (and (not (equal (car x) (car y) 1e-6)) (not (equal (cadr x) (cadr y) 1e-6)) (collinear-pp mp p (inters (car x) (cadr x) (car y) (cadr y) nil)))) tlll (setq tllll (append (cdr tllll) (list (car tllll)))))
                (setq tst (cons t tst))
                (setq tst (cons nil tst))
              )
            )
            (if (not (apply 'or tst))
              (setq mp (polar p (+ (* 0.5 pi) (angle p mp)) 1.0))
            )
          )
          ( (vl-some '(lambda ( li ) (or (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- (mid ci p2 p3) p)) 1e-3) (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- p (mid ci p2 p3))) 1e-3))) lil)
            (setq mp (mid ci p4 p1))
            (setq tllll tlll)
            (repeat (length tlll)
              (if (vl-some '(lambda ( x y ) (and (not (equal (car x) (car y) 1e-6)) (not (equal (cadr x) (cadr y) 1e-6)) (collinear-pp mp p (inters (car x) (cadr x) (car y) (cadr y) nil)))) tlll (setq tllll (append (cdr tllll) (list (car tllll)))))
                (setq tst (cons t tst))
                (setq tst (cons nil tst))
              )
            )
            (if (not (apply 'or tst))
              (setq mp (polar p (+ (* 0.5 pi) (angle p mp)) 1.0))
            )
          )
          ( (vl-some '(lambda ( li ) (or (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- (mid ci p3 p4) p)) 1e-3) (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- p (mid ci p3 p4))) 1e-3))) lil)
            (setq mp (mid ci p1 p2))
            (setq tllll tlll)
            (repeat (length tlll)
              (if (vl-some '(lambda ( x y ) (and (not (equal (car x) (car y) 1e-6)) (not (equal (cadr x) (cadr y) 1e-6)) (collinear-pp mp p (inters (car x) (cadr x) (car y) (cadr y) nil)))) tlll (setq tllll (append (cdr tllll) (list (car tllll)))))
                (setq tst (cons t tst))
                (setq tst (cons nil tst))
              )
            )
            (if (not (apply 'or tst))
              (setq mp (polar p (+ (* 0.5 pi) (angle p mp)) 1.0))
            )
          )
          ( (vl-some '(lambda ( li ) (or (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- (mid ci p4 p1) p)) 1e-3) (equal (unit (mapcar '- (car li) (cadr li))) (unit (mapcar '- p (mid ci p4 p1))) 1e-3))) lil)
            (setq mp (mid ci p2 p3))
            (setq tllll tlll)
            (repeat (length tlll)
              (if (vl-some '(lambda ( x y ) (and (not (equal (car x) (car y) 1e-6)) (not (equal (cadr x) (cadr y) 1e-6)) (collinear-pp mp p (inters (car x) (cadr x) (car y) (cadr y) nil)))) tlll (setq tllll (append (cdr tllll) (list (car tllll)))))
                (setq tst (cons t tst))
                (setq tst (cons nil tst))
              )
            )
            (if (not (apply 'or tst))
              (setq mp (polar p (+ (* 0.5 pi) (angle p mp)) 1.0))
            )
          )
        )
      )
      ( (= (length pl) 6)
        (setq p1 (list (car pl) (cadr pl)))
        (setq p2 (list (nth 3 pl) (nth 4 pl)))
        (setq mp (mid ci p1 p2))
      )
      ( (= (length pl) 3)
        (setq mp (list (car pl) (cadr pl)))
      )
    )
    (if (and ci (not (vlax-erased-p ci)))
      (entdel ci)
    )
    (list p mp)
  )

  (defun subbody ( ipd / n p1 p2 pp1 pp2 fl ttt d1 d2 )
    (if (and ipd (chkcircinside (car ipd) tlll))
      (progn
        (if lil
          (setq n (length lil))
          (setq n 0)
        )
        (if
          (and
            (setq p1
              (vl-some '(lambda ( x )
                (if
                  (equal
                    (unit (mapcar '- (car ipd) x))
                    (unit (mapcar '- (car ipd) (caadr ipd)))
                    1e-6
                  )
                  x
                )
              ) vll
              )
            )
            (setq pp1
              (vl-some '(lambda ( x )
                (if
                  (equal
                    (unit (mapcar '- (car ipd) x))
                    (unit (mapcar '- (car ipd) p1))
                    1e-6
                  )
                  x
                )
              ) vlll
              )
            )
          )
          (if (not (vl-position (list (car ipd) pp1) lil))
            (setq lil (cons (list (car ipd) pp1) lil))
          )
          (if p1
            (if (not (vl-position (list (car ipd) p1) lil))
              (setq lil (cons (list (car ipd) p1) lil))
            )
            (if (not (vl-position (list (car ipd) (caadr ipd)) lil))
              (setq lil (cons (list (car ipd) (caadr ipd)) lil))
            )
          )
        )
        (if (setq ttt (vl-remove nil (mapcar '(lambda ( x ) (if (or (equal (cadar lil) (car x) 1e-6) (equal (cadar lil) (cadr x) 1e-6)) x)) tlll)))
          (progn
            (setq d1 (distance (caar lil) (inters (caar lil) (polar (caar lil) (+ (* 0.5 pi) (angle (caar ttt) (cadar ttt))) 1.0) (caar ttt) (cadar ttt) nil)))
            (setq d2 (distance (caar lil) (inters (caar lil) (polar (caar lil) (+ (* 0.5 pi) (angle (caadr ttt) (cadadr ttt))) 1.0) (caadr ttt) (cadadr ttt) nil)))
            (if
              (and
                (not (chkcircinside-dist (caar lil) d1))
                (not (chkcircinside-dist (caar lil) d2))
              )
              (setq lil (cdr lil) fl t)
            )
          )
        )
        (if
          (and
            (setq p2
              (vl-some '(lambda ( x )
                (if
                  (equal
                    (unit (mapcar '- (car ipd) x))
                    (unit (mapcar '- (car ipd) (cadadr ipd)))
                    1e-6
                  )
                  x
                )
              ) vll
              )
            )
            (setq pp2
              (vl-some '(lambda ( x )
                (if
                  (equal
                    (unit (mapcar '- (car ipd) x))
                    (unit (mapcar '- (car ipd) p2))
                    1e-6
                  )
                  x
                )
              ) vlll
              )
            )
          )
          (if (not (vl-position (list (car ipd) pp2) lil))
            (setq lil (cons (list (car ipd) pp2) lil))
          )
          (if p2
            (if (not (vl-position (list (car ipd) p2) lil))
              (setq lil (cons (list (car ipd) p2) lil))
            )
            (if (not (vl-position (list (car ipd) (cadadr ipd)) lil))
              (setq lil (cons (list (car ipd) (cadadr ipd)) lil))
            )
          )
        )
        (if fl
          (setq lil (cdr lil))
          (if (setq ttt (vl-remove nil (mapcar '(lambda ( x ) (if (or (equal (cadar lil) (car x) 1e-6) (equal (cadar lil) (cadr x) 1e-6)) x)) tlll)))
            (progn
              (setq d1 (distance (caar lil) (inters (caar lil) (polar (caar lil) (+ (* 0.5 pi) (angle (caar ttt) (cadar ttt))) 1.0) (caar ttt) (cadar ttt) nil)))
              (setq d2 (distance (caar lil) (inters (caar lil) (polar (caar lil) (+ (* 0.5 pi) (angle (caadr ttt) (cadadr ttt))) 1.0) (caadr ttt) (cadadr ttt) nil)))
              (if
                (and
                  (not (chkcircinside-dist (caar lil) d1))
                  (not (chkcircinside-dist (caar lil) d2))
                )
                (setq lil (cddr lil))
              )
            )
          )
        )
        (if (= (length lil) (+ n 2))
          (progn
            (setq vll (vl-remove-if '(lambda ( x ) (equal x (cadar lil) 1e-6)) vll))
            (setq vlli (vl-remove-if '(lambda ( x ) (equal x (cadar lil) 0.1)) vlli))
            (setq vll (vl-remove-if '(lambda ( x ) (equal x (cadadr lil) 1e-6)) vll))
            (setq vlli (vl-remove-if '(lambda ( x ) (equal x (cadadr lil) 0.1)) vlli))
          )

          (if (= (length lil) n) ;;; exit while loop - unable to create new ridges [ n = (length lil) ]
            (setq done t)
          )

        )
      )
    )
    t
  )

  (defun subprocess ( iplst flag / iplstoffd r )
    (if (setq iplst (vl-remove-if '(lambda ( x ) (or (not (car x)) (not (cadr x)))) iplst))
      (progn
        (setq iplstoffd (mapcar '(lambda ( x ) (if (and (car x) (cadr x))
                                                 (list
                                                   (mapcar '+ '(0.0 0.0) (car x))
                                                   (mapcar '(lambda ( y ) (mapcar '+ '(0.0 0.0) y)) (cadr x))
                                                   (offd (function <) (mapcar '+ '(0.0 0.0) (car x)) tlll)
                                                 )
                                                 (list nil nil nil)
                                               )
                                 ) iplst
                        )
        )
        (setq iplstoffd (vl-remove-if '(lambda ( x ) (not (caddr x))) iplstoffd))
        (if (not flag)
          (foreach ipd (vl-sort iplstoffd '(lambda ( a b ) (< (caddr a) (caddr b))))
            (cond
              ( (not lil)
                (setq rrr (cons (subbody ipd) rrr))
              )
              ( (and (not (vl-some '(lambda ( x ) (or (equal (cadr x) (caadr ipd) 1e-6) (equal (cadr x) (cadadr ipd) 1e-6))) lil)) (vl-some '(lambda ( x ) (or (equal x (caadr ipd) 1e-6) (equal x (cadadr ipd) 1e-6))) vll))
                (setq rrr (cons (subbody ipd) rrr))
              )
            )
          )
          (setq lil (reverse lil))
        )
      )
    )
    (apply 'and r)
  )

  (defun preprocess ( vl vli )
    (setq iplst (mapcar '(lambda ( p1 p2 p3 p4 / ip )
                          (if
                            (and
                              (setq ip (inters p1 p2 p3 p4 nil))
                              (inside-p ip ent enti)
                              (equal (unit (mapcar '- ip p1)) (unit (mapcar '- p2 p1)) 1e-2)
                              (equal (unit (mapcar '- ip p3)) (unit (mapcar '- p4 p3)) 1e-2)
                              (inside-p (mapcar '+ p1 (mapcar '* (unit (mapcar '- ip p1)) (list 1e-2 1e-2))) ent enti)
                              (inside-p (mapcar '+ p3 (mapcar '* (unit (mapcar '- ip p3)) (list 1e-2 1e-2))) ent enti)
                            )
                            (list ip (list p1 p3))
                            (list nil nil)
                          )
                        )
                        vl
                        vli
                        (append (cdr vl) (list (car vl)))
                        (append (cdr vli) (list (car vli)))
                )
    )
    iplst
  )

  (defun preprocess-rev ( vl vli )
    (setq iplst (mapcar '(lambda ( p1 p2 p3 p4 / ip )
                          (if
                            (and
                              (setq ip (inters p1 p2 p3 p4 nil))
                              (inside-p ip ent enti)
                              (equal (unit (mapcar '- ip p1)) (unit (mapcar '- p2 p1)) 1e-2)
                              (equal (unit (mapcar '- ip p3)) (unit (mapcar '- p4 p3)) 1e-2)
                              (inside-p (mapcar '+ p1 (mapcar '* (unit (mapcar '- ip p1)) (list 1e-2 1e-2))) ent enti)
                              (inside-p (mapcar '+ p3 (mapcar '* (unit (mapcar '- ip p3)) (list 1e-2 1e-2))) ent enti)
                            )
                            (list ip (list p1 p3))
                            (list nil nil)
                          )
                        )
                        (reverse vl)
                        (reverse vli)
                        (append (cdr (reverse vl)) (list (car (reverse vl))))
                        (append (cdr (reverse vli)) (list (car (reverse vli))))
                )
    )
    iplst
  )

  (defun prout ( vll vlli / iplst n )
    (if (not lil)
      (setq n 0)
      (setq n (length lil))
    )
    (setq iplst (preprocess vll vlli))
    (subprocess iplst nil)
    (if (and lil (= n (length lil)))
      (progn
        (setq iplst (preprocess-rev vll vlli))
        (subprocess iplst nil)
      )
      (if (and lil (= (length lil) (+ n 2)))
        t
      )
    )
  )

  (defun process ( lw / lwi lwx vl vli tl catch ) ;;; lil, vll, vlli, tll, ppp, done - lexical global variables ;;;
    (if lw
      (progn
        (setq vl (mapcar 'cdr (vl-remove-if '(lambda ( x ) (/= (car x) 10)) (setq lwx (entget lw)))))
        (if (not vll)
          (setq vll vl)
        )
        (setq lwi (vlax-vla-object->ename (car (vlax-invoke (vlax-ename->vla-object lw) 'offset -1e-3))))
        (setq vli (mapcar 'cdr (vl-remove-if '(lambda ( x ) (/= (car x) 10)) (entget lwi))))
        (if (not vlli)
          (setq vlli vli)
        )
        (setq tl (mapcar '(lambda ( a b ) (list a b)) vl (append (cdr vl) (list (car vl)))))
        (if (not tll)
          (setq tll tl)
        )
        (if (prout vll vlli)
          (setq done t)
        )
        (if (and lwi (not (vlax-erased-p lwi)))
          (entdel lwi)
        )
      )
    )
  )

  (or cad (progn (vl-load-com) (setq cad (vlax-get-acad-object))))
  (or doc (setq doc (vla-get-activedocument cad)))
  (or spc (setq spc (vla-get-block (setq lay (vla-get-activelayout doc)))))

  (setq osm (getvar 'osmode))
  (setvar 'osmode 0)
  (setq cmd (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (if (= 8 (logand 8 (getvar 'undoctl)))
    (vla-endundomark doc)
  )
  (vla-startundomark doc)
  (if
    (and
      (setq lw (car (entsel "\nPick boundary closed polygonal LWPOLYLINE with only straight segments...")))
      (setq ti (car (_vl-times)))
      (= (cdr (assoc 0 (setq lwx (entget lw)))) "LWPOLYLINE")
      (= 1 (logand 1 (cdr (assoc 70 lwx))))
      (vl-every '(lambda ( x ) (= 0.0 (cdr x))) (vl-remove-if '(lambda ( x ) (/= (car x) 42)) lwx))
      (setq el (entlast) ent lw)
    )
    (progn
      (setq lwi (vlax-vla-object->ename (car (vlax-invoke (vlax-ename->vla-object lw) 'offset -1e-3))))
      (if (> (vlax-curve-getarea lwi) (vlax-curve-getarea lw))
        (setq lw (rlw lw)) ;;; force main lwpolyline CCW - counter clockwise ;;;
      )
      (setq enti (vlax-vla-object->ename (car (vlax-invoke (vlax-ename->vla-object ent) 'offset -1e-3))))
      (if (and lwi (not (vlax-erased-p lwi)))
        (entdel lwi)
      )
      (if (not f)
        (progn
          (setq vlll (mapcar 'cdr (vl-remove-if '(lambda ( x ) (/= (car x) 10)) (entget ent))))
          (setq vllli (mapcar 'cdr (vl-remove-if '(lambda ( x ) (/= (car x) 10)) (entget enti))))
          (setq tlll (mapcar '(lambda ( a b ) (list a b)) vlll (append (cdr vlll) (list (car vlll)))))
          (setq f t)
        )
      )
      (vl-cmdf "_.ZOOM" "_OB" ent "")
      (while (not done)
        (if (vl-catch-all-error-p (vl-catch-all-apply 'process (list lw)))
          (setq done t)
        )
      ) ;;; start and finish ...
      (vl-cmdf "_.ZOOM" "_P")
      (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 20)) (prompt " milliseconds...")
    )
  )
  (*error* nil)
)
