;;;---------------------------------------------------------------;;;
;;;                                                               ;;;
;;;                  HIP ROOF - 2D RIDGE EDGES                    ;;;
;;;                                                               ;;;
;;;  Author : Marko Ribar, d.i.a. (architect)                     ;;;
;;;  Autolisp routine for AutoCAD or BricsCAD                     ;;;
;;;  Copyright (C) 2021.                                          ;;;
;;;  Tested and programmed on Windows 10 OS                       ;;;
;;;  Bugs or failures may appear and aren't authors responsibility;;;
;;;  LSP file is free to be used for improvements...              ;;;
;;;  All relevant suggestions are welcomed...                     ;;;
;;;                                                               ;;;
;;;---------------------------------------------------------------;;;

(defun c:roof2d-new-nnn ( / *error* vl-load acos angle3d 3pline unique uniquelil unit mid clockwise-p inside-p distp2t offsett2p removesingles removedoubles correctplanedist collinear-pp unioncollinearplaneprints car-sort chklili processtxtipl findlinesbetweentl processipl processipll processplaa processplaa-x processend process processplaa-n process-n postprocess processing cmde s ti lw lwi lwx pl tl utl pla plao n plaa x y lil ipl ipldl ll flag errli errlis liloo lilo loop ip pla1 maxlen iplls iplls1 ipld ipldd mode closed op x1 x2 xx xxx xxx1 xxx2 xxxx xxxx1 xxxx2 plaal chk lixl plaox lilx fflag plaoxl lill lilxplaoxl merrlis errpts errll iplx errliso index pass done qqq )

  (defun *error* ( m )
    (cond
      ( (and lwi (not (vlax-erased-p lwi)))
        (cond
          ( (= (type lwi) (quote ename))
            (entdel lwi)
          )
          ( (= t t)
            (vla-delete lwi)
          )
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (cond
        ( doc
          (vla-endundomark doc)
        )
        ( (= t t)
          (cond
            ( command-s
              (command-s "_.UNDO" "_E")
            )
            ( (= t t)
              (vl-cmdf "_.UNDO" "_E")
            )
          )
        )
      )
    )
    (cond
      ( cmde
        (setvar (quote cmdecho) cmde)
      )
    )
    (cond
      ( ti
        (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")
        (prompt "\nFor UNDO - type \"UNDO\" - \"Back\" option...")
      )
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun vl-load nil
    (or cad
      (cond
        ( vlax-get-acad-object
          (setq cad (vlax-get-acad-object))
        )
        ( (= t t)
          (vl-load-com)
          (setq cad (vlax-get-acad-object))
        )
      )
    )
    (or doc (setq doc (vla-get-activedocument cad)))
    (or alo (setq alo (vla-get-activelayout doc)))
    (or spc (setq spc (vla-get-block alo)))
  )

  (defun acos ( x )
    (cond
      ( (equal x 1.0 1e-8) 0.0 )
      ( (equal x -1.0 1e-8) pi )
      ( (and (not (minusp x)) (equal x 0.0 1e-8)) (/ pi 2.0) )
      ( (and (minusp x) (equal x 0.0 1e-8)) (* 3.0 (/ pi 2.0)) )
      ( (atan (sqrt (- 1.0 (* x x))) x) )
    )
  )

  (defun angle3d ( p1 por p2 / vec1 vec2 dd ang )
    (setq vec1 (unit (mapcar '- p1 por))
          vec2 (unit (mapcar '- p2 por))
          dd (distance vec1 vec2)
          ang (acos (- 1.0 (/ (expt dd 2) 2.0)))
    )
    (cond
      ( (minusp ang)
        (+ ang pi)
      )
      ( (= t t)
        ang
      )
    )
  )

  (defun 3pline ( p1 p p2 )
    (equal (distance p1 p2) (+ (distance p1 p) (distance p p2)) 1e-6)
  )

  (defun unique ( lst / a ll )
    (while (setq a (car lst))
      (cond
        ( (vl-some (function (lambda ( x ) (equal x a 1e-6))) (cdr lst))
          (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) (cdr lst)))
        )
        ( (= t t)
          (setq ll (cons a ll) lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun uniquelil ( lst / a ll )
    (while (setq a (car lst))
      (cond
        ( (vl-some (function (lambda ( x ) (or (equal x a 1e-6) (equal x (reverse a) 1e-6)))) (cdr lst))
          (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (or (equal x a 1e-6) (equal x (reverse a) 1e-6)))) (cdr lst)))
        )
        ( (= t t)
          (setq ll (cons a ll) lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun unit ( v / d )
    (cond
      ( (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
        (mapcar (function (lambda ( x ) (/ x d))) v)
      )
    )
  )

  (defun mid ( p1 p2 )
    (mapcar (function (lambda ( a b ) (/ (+ a b) 2.0))) p1 p2)
  )

  (defun clockwise-p ( p1 p2 p3 )
    (minusp (sin (- (angle p1 p3) (angle p1 p2))))
  )

  (defun inside-p ( pt lw lwi )
    (< (distance pt (vlax-curve-getclosestpointto lwi pt)) (distance pt (vlax-curve-getclosestpointto lw pt)))
  )

  (defun distp2t ( p tt / i )
    (cond
      ( (setq i (inters p (polar p (+ (angle (car tt) (cadr tt)) (* 0.5 pi)) 1.0) (car tt) (cadr tt) nil))
        (distance p i)
      )
    )
  )

  (defun offsett2p ( p tt d / ip v v1 )
    (setq ip (inters p (polar p (+ (angle (car tt) (cadr tt)) (* 0.5 pi)) 1.0) (car tt) (cadr tt) nil))
    (setq v (mapcar (function -) p ip))
    (setq v1 (unit v))
    (list (mapcar (function +) (car tt) (mapcar (function *) v1 (list d d))) (mapcar (function +) (cadr tt) (mapcar (function *) v1 (list d d))))
  )

  (defun removesingles ( lst / a )
    (while (setq a (vl-some (function (lambda ( x ) (if (= (1- (length lst)) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) lst))) x))) lst))
      (setq lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) lst))
    )
    lst
  )

  (defun removedoubles ( lst / a )
    (while (setq a (vl-some (function (lambda ( x ) (if (= (- (length lst) 2) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) lst))) x))) lst))
      (setq lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) lst))
    )
    lst
  )

  (defun correctplanedist ( ip / d )
    (cond
      ( (and (caar ip) (caadr ip) (cadadr ip) (caaddr ip) (cadr (caddr ip)) (equal (setq d (distp2t (caar ip) (cadr ip))) (distp2t (caar ip) (caddr ip)) 1e-6) d)
        d
      )
    )
  )

  (defun collinear-pp ( p1 p2 p3 )
    (
      (lambda ( a b c )
        (or
          (equal (+ a b) c 1e-10)
          (equal (+ b c) a 1e-10)
          (equal (+ c a) b 1e-10)
        )
      )
      (distance p1 p2) (distance p2 p3) (distance p1 p3)
    )
  )

  (defun unioncollinearplaneprints ( tl / a b tll )
    (while (setq a (car tl))
      (setq b (vl-remove-if-not (function (lambda ( x ) (and (collinear-pp (car a) (cadr a) (car x)) (collinear-pp (car a) (cadr a) (cadr x))))) tl))
      (setq tll (cons a tll))
      (cond
        ( b
          (setq tl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) b))) tl))
        )
        ( (= t t)
          (setq tl (cdr tl))
        )
      )
    )
    tll
  )

  (defun car-sort ( lst cmp / rtn )
    (setq rtn (car lst))
    (foreach itm (cdr lst)
      (cond
        ( (apply cmp (list itm rtn))
          (setq rtn itm)
        )
      )
    )
    rtn
  )

  (defun chklili ( lil / lilpts )
    (setq lilpts (apply (function append) lil))
    (setq lilpts (vl-remove-if-not (function (lambda ( x ) (= (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) lilpts)) (- (length lilpts) 2)))) lilpts))
    lilpts
  )

  (defun processtxtipl ( tl / ipl tl1 tl2 intt )
    (setq tl1 tl tl2 tl)
    (foreach t1 tl1
      (setq tl2 (cdr tl2))
      (foreach t2 tl2
        (cond
          ( (setq intt (inters (car t1) (polar (car t1) (angle (car t1) (cadr t1)) 1.0) (car t2) (polar (car t2) (angle (car t2) (cadr t2)) 1.0) nil))
            (setq ipl (cons intt ipl))
          )
          ( (= t t)
            (setq ipl (cons (angle (car t1) (cadr t1)) ipl))
          )
        )
      )
    )
    ipl
  )

  (defun findlinesbetweentl ( tl / llt tl1 tl2 )
    (setq tl1 tl tl2 tl)
    (foreach t1 tl1
      (setq tl2 (cdr tl2))
      (foreach t2 tl2
        (setq llt (cons (list (mid (car t1) (cadr t1)) (mid (car t2) (cadr t2))) llt))
      )
    )
    llt
  )
 
  (defun processipl ( pla / pla1 pla2 intt xx xxx xxxx uu ipl )
    (setq pla (vl-remove nil pla))
    (setq pla1 pla pla2 pla)
    (foreach p1 pla1
      (setq pla2 (cdr pla2))
      (foreach p2 pla2
        (setq aaa nil aaa1 nil aaa2 nil)
        (setq intt (inters (caar p1) (polar (caar p1) (cadar p1) 1.0) (caar p2) (polar (caar p2) (cadar p2) 1.0) nil))
        (cond
          ( (or (equal intt (caar p1) 1e-6) (equal intt (caar p2) 1e-6))
            (setq intt nil)
          )
          ( (and intt (not (inside-p intt lw lwi)))
            (setq intt nil)
          )
        )
        (cond
          ( intt
            (cond
              ( (setq xxx (vl-some (function (lambda ( x ) (if (= (length (vl-remove x (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2))))) 2) x))) (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2)))))
                (cond
                  ( (or (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p2))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))) (and (caadr p2) (cadadr p2) (caaddr p2) (cadr (caddr p2)) (or (equal (angle (caadr p2) (cadadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6) (equal (angle (cadadr p2) (caadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p1))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))))
                    (cond
                      ( (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)))
                        (setq ipl (cons (list (list intt (if (setq xx (vl-remove xxx (list (cadr p2) (caddr p2)))) (angle (caar xx) (cadar xx)) (cadar p2))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                      ( (= t t)
                        (setq ipl (cons (list (list intt (if (setq xx (vl-remove xxx (list (cadr p1) (caddr p1)))) (angle (caar xx) (cadar xx)) (cadar p1))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                    )
                  )
                  ( (= t t)
                    (setq ipl (cons (list (list intt (if (setq xxxx (if (and (setq xx (vl-remove xxx (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2))))) (= (length xx) 2)) (inters (caar xx) (cadar xx) (caadr xx) (cadadr xx) nil))) (angle xxxx intt) (angle (caar xx) (cadar xx)))) (car xx) (cadr xx) xxx p1 p2) ipl))
                  )
                )
              )
              ( (= t t)
                (cond
                  ( (or (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p2))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))) (and (caadr p2) (cadadr p2) (caaddr p2) (cadr (caddr p2)) (or (equal (angle (caadr p2) (cadadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6) (equal (angle (cadadr p2) (caadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p1))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))))
                    (cond
                      ( (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)))
                        (setq ipl (cons (list (list intt (if (setq xx (vl-remove xxx (list (cadr p2) (caddr p2)))) (angle (caar xx) (cadar xx)) (cadar p2))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                      ( (= t t)
                        (setq ipl (cons (list (list intt (if (setq xx (vl-remove xxx (list (cadr p1) (caddr p1)))) (angle (caar xx) (cadar xx)) (cadar p1))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                    )
                  )
                  ( (= (length (setq uu (unioncollinearplaneprints (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2)))))) 3)
                    (foreach pp uu
                      (if (= (length (vl-remove-if-not (function (lambda ( x ) (or (equal pp x) (and (equal (distance (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (car pp) (cadr pp)) (car x)) (+ (distance (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (car pp) (cadr pp)) (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (cadr pp) (car pp))) (distance (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (cadr pp) (car pp)) (car x))) 1e-6) (equal (distance (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (car pp) (cadr pp)) (cadr x)) (+ (distance (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (car pp) (cadr pp)) (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (cadr pp) (car pp))) (distance (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (cadr pp) (car pp)) (cadr x))) 1e-6))))) (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2))))) 2)
                        (setq xxx pp)
                      )
                    )
                    (setq ipl (cons (list (list intt (if (setq xxxx (if (and (setq xx (vl-remove xxx uu)) (= (length xx) 2)) (inters (caar xx) (cadar xx) (caadr xx) (cadadr xx) nil))) (angle xxxx intt) (angle (caar xx) (cadar xx)))) (car xx) (cadr xx) nil p1 p2) ipl))
                  )
                  ( (= t t)
                    (setq ipl (cons (list (list intt nil) nil nil nil p1 p2) ipl))
                  )
                )
              )
            )
          )
        )
      )
    )
    (setq ipl (vl-remove-if-not (function (lambda ( p / d1 d2 )
      (and 
        (caar p)
        (listp (caar p))
        (vl-every (function numberp) (caar p))
        (= (length (caar p)) 2)
        (inside-p (caar p) lw lwi)
        (removedoubles (removesingles (vl-remove nil (mapcar (function (lambda ( tt ) (distp2t (caar p) tt))) utl))))
        (cond
          ( (and (caadr p) (cadadr p) (caaddr p) (cadr (caddr p)))
            (or
              (and (setq d1 (distance (caar p) (vlax-curve-getclosestpointto lw (caar p)))) (setq d2 (correctplanedist p)) (> d1 d2))
              (and d1 d2 (equal d1 d2 1e-6))
            )
          )
          ( (= t t)
            t
          )
        )
      )
    )) ipl))
  )

  (defun processipll ( mode / makeipll ipl1l errx err ipl1 lst ipll ipllx dd ip )

    (defun makeipll ( / a1 a2 nn mm b1 b2 jj hh )
      (cond
        ( (setq lst (vl-remove-if-not (function (lambda ( x ) (equal (caar ipl1) (caar x) 1e-6)))
                     (vl-remove-if (function (lambda ( x ) 
                       (vl-some (function (lambda ( y ) (and (equal (caar x) (caar y) 1e-6)
                         (vl-some (function (lambda ( q )
                           (or
                             (and (not (equal (caar x) (caar q) 1e-6))
                                  (not (equal (caaar (cddddr x)) (caar q) 1e-6))
                                  (3pline (caar x) (caar q) (caaar (cddddr x))))
                             (and (not (equal (caar x) (caar q) 1e-6))
                                  (not (equal (caaadr (cddddr x)) (caar q) 1e-6))
                                  (3pline (caar x) (caar q) (caaadr (cddddr x)))))))
                       ipl))))
                    errx)))
                   ipl)
                   )
          )
          (setq ipll (cons lst ipll))
        )
      )
    )

    (setq ipl (vl-remove-if (function (lambda ( x ) (or (null (cadr x)) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) errpts)))) ipl))
    (setq ipl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (or (setq ip (inters (polar (car y) (angle (car y) (cadr y)) 1e-3) (polar (cadr y) (angle (cadr y) (car y)) 1e-3) (caaar (cddddr x)) (caar x))) (setq ip (inters (polar (car y) (angle (car y) (cadr y)) 1e-3) (polar (cadr y) (angle (cadr y) (car y)) 1e-3) (caaadr (cddddr x)) (caar x)))))) tl))) ipl))
    (foreach pla1 pla
      (setq ipl1l (vl-remove-if-not (function (lambda ( z ) (or (equal (angle (caar z) (caar pla1)) (cadar pla1) 1e-6) (equal (angle (caar pla1) (caar z)) (cadar pla1) 1e-6)))) ipl))
      (foreach ipl1 ipl1l
        (cond
          ( (vl-some (function (lambda ( x ) (or (and (not (equal (caar x) (caar ipl1) 1e-6)) (not (equal (caar x) (caaar (cddddr ipl1)) 1e-6)) (3pline (caar ipl1) (caar x) (caaar (cddddr ipl1)))) (and (not (equal (caar x) (caar ipl1) 1e-6)) (not (equal (caar x) (caaadr (cddddr ipl1)) 1e-6)) (3pline (caar ipl1) (caar x) (caaadr (cddddr ipl1))))))) ipl1l)
            (setq errx (cons ipl1 errx))
          )
        )
      )
      (setq err (vl-remove-if (function (lambda ( x ) (> (length (vl-remove-if (function (lambda ( y ) (vl-some (function (lambda ( z ) (and (not (equal (caar x) (caar z) 1e-6)) (3pline (caar x) (caar z) (caar y))))) ipl))) (vl-remove-if-not (function (lambda ( y ) (and (or (equal (angle (caar y) (caar x)) (cadar y) 1e-6) (equal (angle (caar x) (caar y)) (cadar y) 1e-6))))) pla))) 1))) errx))
      (cond
        ( (and err ipl1l (setq dd (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) (caar y) 1e-6))) err))) ipl1l)))
          (setq ipl1l dd)
        )
      )
      (setq ipl1 (car-sort ipl1l (function (lambda ( a b ) (if (equal (angle3d (append (caaar (cddddr a)) (list 0.0)) (append (caar a) (list 0.0)) (append (caaadr (cddddr a)) (list 0.0))) (angle3d (append (caaar (cddddr b)) (list 0.0)) (append (caar b) (list 0.0)) (append (caaadr (cddddr b)) (list 0.0))) 1e-6) (if (equal (car-sort (list (distance (caaar (cddddr a)) (caar a)) (distance (caaadr (cddddr a)) (caar a)) (distance (vlax-curve-getclosestpointto lw (caar a)) (caar a))) (function >)) (car-sort (list (distance (caaar (cddddr b)) (caar b)) (distance (caaadr (cddddr b)) (caar b)) (distance (vlax-curve-getclosestpointto lw (caar b)) (caar b))) (function >)) 1e-6) (< (distance (caaar (cddddr a)) (caaadr (cddddr a))) (distance (caaar (cddddr b)) (caaadr (cddddr b)))) (> (car-sort (list (distance (caaar (cddddr a)) (caar a)) (distance (caaadr (cddddr a)) (caar a)) (distance (vlax-curve-getclosestpointto lw (caar a)) (caar a))) (function >)) (car-sort (list (distance (caaar (cddddr b)) (caar b)) (distance (caaadr (cddddr b)) (caar b)) (distance (vlax-curve-getclosestpointto lw (caar b)) (caar b))) (function >)))) (> (angle3d (append (caaar (cddddr a)) (list 0.0)) (append (caar a) (list 0.0)) (append (caaadr (cddddr a)) (list 0.0))) (angle3d (append (caaar (cddddr b)) (list 0.0)) (append (caar b) (list 0.0)) (append (caaadr (cddddr b)) (list 0.0)))))))))
      (makeipll)
    )
    (cond
      ( mode
        (setq iplx (append (vl-remove nil ipl) (if errpts (mapcar (function (lambda ( x ) (list (list x nil) nil nil nil nil nil))) errpts))))
      )
    )
    (cond
      ( (setq dd (vl-remove-if (function (lambda ( x ) (vl-every (function (lambda ( y ) (null (cadar y)))) x))) (vl-remove nil ipll)))
        (setq ipll dd)
      )
    )
    (cond
      ( (vl-some (function (lambda ( x ) (equal (caar x) (cadar lil) 1e-6))) pla)
        (cond
          ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (append (apply (function append) errlis) (mapcar (function caar) plaal))))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
            (setq ipll ipllx)
          )
          ( (= t t)
            (cond
              ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (apply (function append) errlis)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                (setq ipll ipllx)
              )
              ( (= t t)
                (cond
                  ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function caar) plaal)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                    (setq ipll ipllx)
                  )
                  ( (= t t)
                    (setq ipll (car-sort (vl-remove nil ipll) (function (lambda ( a b / c d )
                      (cond
                        ( (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6))
                          (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b)))
                        )
                        ( (= t t)
                          (cond
                            ( (or (null c) (null d))
                              (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b)))
                            )
                            ( (= t t)
                              (< c d)
                            )
                          )
                        )
                      )
                    ))))
                  )
                )
              )
            )
          )
        )
      )
      ( (= t t)
        (cond
          ( lil
            (cond
              ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (append (apply (function append) errlis) (mapcar (function caar) plaal))))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                (setq ipll ipllx)
              )
              ( (= t t)
                (cond
                  ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (apply (function append) errlis)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                    (setq ipll ipllx)
                  )
                  ( (= t t)
                    (cond
                      ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function caar) plaal)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                        (setq ipll ipllx)
                      )
                      ( (= t t)
                        (setq ipll (car-sort (vl-remove nil ipll) (function (lambda ( a b / c d )
                          (cond
                            ( (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6))
                              (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b)))
                            )
                            ( (= t t)
                              (cond
                                ( (or (null c) (null d))
                                  (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b)))
                                )
                                ( (= t t)
                                  (< c d)
                                )
                              )
                            )
                          )
                        ))))
                      )
                    )
                  )
                )
              )
            )
          )
        )
      )
    )
    ipll
  )

  (defun processplaa ( pla )
    (setq ipl (processipl pla))
    (processipll nil)
  )

  (defun processplaa-x ( pla )
    (setq ipl (processipl pla))
    (setq ipl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function cadr) errlis)))) ipl))
    (processipll nil)
  )

  (defun processend nil
    (cond
      ( (< 2 (length (unioncollinearplaneprints (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa))))))
        (cond
          ( (not (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (or (equal y (caaar (cddddr x)) 1e-6) (equal y (caaadr (cddddr x)) 1e-6)))) pl))) plaa))
            (setq pla (vl-remove-if (function (lambda ( z ) (vl-some (function (lambda ( x ) (equal (caar x) (caar z) 1e-6))) plaa))) pla))
          )
          ( (= t t)
            (cond
              ( (and (= 3 (length (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa))))) (vl-some (function (lambda ( x ) (null (cadddr x)))) plaa))
                (setq pla (vl-remove-if (function (lambda ( z ) (vl-some (function (lambda ( x ) (equal (caar x) (caar z) 1e-6))) plaa))) pla))
              )
              ( (= 3 (length (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa)))))
                nil
              )
              ( (= t t)
                (setq pla (vl-remove-if (function (lambda ( z ) (vl-some (function (lambda ( x ) (equal (caar x) (caar z) 1e-6))) plaa))) pla))
                (setq x1 (car plaa))
                (setq x2 (last plaa))
                (cond
                  ( (vl-some (function (lambda ( x ) (not (vl-position (caar x) pl)))) (cddddr (vl-some (function (lambda ( y ) (if (or (not (vl-position (caaar (cddddr y)) pl)) (not (vl-position (caaadr (cddddr y)) pl))) y))) plaa)))
                    (setq pla (append pla (apply (function append) (mapcar (function cddddr) plaa))))
                    (setq errpts (cons (caaar plaa) errpts))
                  )
                )
                (setq xx (list (list (caar x1) (if (setq ip (inters (car (cadr x1)) (cadr (cadr x1)) (car (caddr x2)) (cadr (caddr x2)) nil)) (angle (caar x1) ip) (angle (car (cadr x1)) (cadr (cadr x1))))) (cadr x1) (caddr x2) nil (car (cddddr x1)) (cadr (cddddr x2))))
                (setq pla (cons xx pla))
              )
            )
          )
        )
      )
      ( (= t t)
        (cond
          ( (= 3 (length (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa)))))
            (cond
              ( (setq xxx (vl-some (function (lambda ( x ) (if (= (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa)))) 2) x))) (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa))))
                (setq pla (cons (car (vl-remove-if (function (lambda ( x ) (equal (caar x) (car (vl-remove (caaar plaa) xxx)) 1e-6))) (append (cddddr (car plaa)) (cddddr (cadr plaa))))) pla))
              )
            )
          )
        )
      )
    )
  )

  (defun process ( processplafun / a1 a2 nn mm b1 b2 jj hh )
    (while (> n 0)
      (cond
        ( (null plaa)
          (setq ipl (processipl pla))
          (setq ipl (vl-remove-if (function (lambda ( x ) (null (cadar x)))) ipl))
          (setq ipldl (mapcar (function (lambda ( x ) (list (correctplanedist x) x))) ipl))
          (setq pla1 (cadr (car-sort (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl) (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr a) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))) (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr b) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl)))) (< (car a) (car b))))))))
          (setq plaa (mapcar (function cadr) (vl-remove-if-not (function (lambda ( x ) (equal (caar pla1) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))))
          (cond
            ( (not (vl-every (function (lambda ( x ) (equal (caar x) (caaar plaa) 1e-6))) plaa))
              (setq plaa (list (car plaa)))
            )
          )
        )
        ( (= t t)
          (cond
            ( (equal plaa (setq plaa (unique (apply processplafun (list (setq pla (unique pla)))))) 1e-6)
              (setq n 0)
            )
          )
        )
      )
      (cond
        ( (and (car plaa) (vl-every (function (lambda ( x ) (cadar x))) plaa))
          (foreach pla1 (reverse plaa)
            (cond
              ( (not (vl-some (function (lambda ( x ) (equal pla1 x 1e-6))) pla))
                (setq pla (cons pla1 pla))
              )
            )
          )
        )
        ( (= t t)
          (setq n 0)
        )
      )
      (cond
        ( plaa
          (cond
            ( (= (length plaa) 1)
              (setq x (caaar (cddddr (car plaa))))
              (setq y (caaadr (cddddr (car plaa))))
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) x) 1e-6))) lil)))
                  (cond
                    ( (not (equal x (caaar plaa) 1e-6))
                      (setq lil (cons (list x (caaar plaa)) lil))
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                    )
                  )
                )
              )
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) y) 1e-6))) lil)))
                  (cond
                    ( (not (equal y (caaar plaa) 1e-6))
                      (setq lil (cons (list y (caaar plaa)) lil))
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                    )
                  )
                )
              )
            )
            ( (= t t)
              (foreach pla1 plaa
                (setq x (caaar (cddddr pla1)))
                (setq y (caaadr (cddddr pla1)))
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) x) 1e-6))) lil)))
                    (cond
                      ( (not (equal x (caar pla1) 1e-6))
                        (setq lil (cons (list x (caar pla1)) lil))
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                      )
                    )
                  )
                )
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) y) 1e-6))) lil)))
                    (cond
                      ( (not (equal y (caar pla1) 1e-6))
                        (setq lil (cons (list y (caar pla1)) lil))
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                      )
                    )
                  )
                )
              )
              (processend)
            )
          )
        )
      )
    )
  )

  (defun processplaa-n ( pla )
    (setq ipl (processipl pla))
    (setq ipl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function cadr) errlis)))) ipl))
    (processipll mode)
  )

  (defun process-n ( processplafun / a1 a2 nn mm b1 b2 jj hh )
    (while (and (> n 0) (null flag))
      (setq plaox pla lilxplaoxl nil)
      (cond
        ( (null plaa)
          (setq ipl (processipl pla))
          (setq ipl (vl-remove-if (function (lambda ( x ) (null (cadar x)))) ipl))
          (setq ipldl (mapcar (function (lambda ( x ) (list (correctplanedist x) x))) ipl))
          (setq ipld (mapcar (function cadr) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl)))
          (while (setq pla1 (car ipld))
            (setq ipldd (cons (vl-remove-if-not (function (lambda ( x ) (equal (caar pla1) (caar x) 1e-6))) ipld) ipldd))
            (setq ipld (vl-remove-if (function (lambda ( x ) (equal (caar pla1) (caar x) 1e-6))) ipld))
          )
          (setq maxlen (length (car-sort ipldd (function (lambda ( a b ) (> (length a) (length b)))))))
          (cond
            ( (> maxlen 1)
              (setq mode t)
            )
          )
          (setq pla1 (cadr (car-sort (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl) (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr a) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))) (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr b) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl)))) (< (car a) (car b))))))))
          (setq plaa (mapcar (function cadr) (vl-remove-if-not (function (lambda ( x ) (equal (caar pla1) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))))
          (cond
            ( (not (vl-every (function (lambda ( x ) (equal (caar x) (caaar plaa) 1e-6))) plaa))
              (setq plaa (list (car plaa)))
            )
          )
        )
        ( (= t t)
          (cond
            ( (equal plaa (setq plaa (unique (apply processplafun (list (setq pla (unique pla)))))) 1e-6)
              (setq n 0)
            )
          )
        )
      )
      (cond
        ( plaa
          (setq plaal (cons plaa plaal))
        )
      )
      (setq lil (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) errlis))) lil))
      (setq closed (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) lil))) closed))
      (cond
        ( merrlis
          (cond
            ( (and plaa (= (length plaa) 1))
              (setq plaoxl (cons (list plaa plaox) plaoxl))
              (setq lill (cons (list plaa lil) lill))
            )
            ( (= t t)
              (cond
                ( plaa
                  (foreach pla1 plaa
                    (setq plaoxl (cons (list pla1 plaox) plaoxl))
                    (setq lill (cons (list pla1 lil) lill))
                  )
                )
              )
            )
          )
        )
      )
      (cond
        ( (and (car plaa) (vl-every (function (lambda ( x ) (cadar x))) plaa))
          (foreach pla1 (reverse plaa)
            (cond
              ( (not (vl-some (function (lambda ( x ) (equal pla1 x 1e-6))) pla))
                (setq pla (cons pla1 pla))
              )
            )
          )
        )
        ( (= t t)
          (setq n (length utl))
          (foreach li lil
            (cond
              ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
                (setq lil (subst (reverse li) li lil))
              )
            )
          )
          (cond
            ( (= (length pl) (length (unique (mapcar (function cadr) lil))))
              (setq n 0)
            )
            ( (= t t)
              (foreach pla1 pla
                (cond
                  ( (setq ip (vl-some (function (lambda ( x ) (if (or (equal (angle (caar pla1) x) (cadar pla1) 1e-6) (equal (angle x (caar pla1)) (cadar pla1) 1e-6)) x))) (mapcar (function cadr) lil)))
                    (cond
                      ( (and (not (vl-some (function (lambda ( z ) (equal z (list (caar pla1) ip) 1e-6))) lil)) (not (vl-some (function (lambda ( z ) (equal z (list ip (caar pla1)) 1e-6))) lil)))
                        (setq lil (cons (list (caar pla1) ip) lil))
                      )
                    )
                  )
                )
              )
              (foreach li lil
                (cond
                  ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
                    (setq lil (subst (reverse li) li lil))
                  )
                )
              )
              (cond
                ( (= (length pl) (length (unique (mapcar (function cadr) lil))))
                  (setq n 0)
                )
                ( (= t t)
                  (setq op (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar y) (cadr x) 1e-6))) pla))) closed))
                  (setq op (vl-some (function (lambda ( x ) (vl-some (function (lambda ( y ) (if (and (setq ip (inters (polar (caar y) (cadar y) 1e+6) (polar (caar y) (cadar y) -1e+6) (car x) (cadr x))) (not (equal ip (car x) 1e-6)) (not (equal ip (cadr x) 1e-6))) y))) pla))) op))
                  (setq op (vl-remove-if-not (function (lambda ( x ) (equal (caar op) (cadr x) 1e-6))) closed))
                  (cond
                    ( op
                      (setq errlis (append op errlis))
                    )
                  )
                  (cond
                    ( (and errlis (not (vl-some (function (lambda ( x ) (equal x errlis 1e-6))) errll)))
                      (setq errll (cons errlis errll) flag t)
                    )
                    ( (= t t)
                      (cond
                        ( (< (length pass) index)
                          (setq pass (cons t pass) flag t)
                        )
                        ( (= t t)
                          (setq flag nil n 0)
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
      )
      (cond
        ( plaa
          (cond
            ( (= (length plaa) 1)
              (setq x (caaar (cddddr (car plaa))))
              (setq y (caaadr (cddddr (car plaa))))
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) x) 1e-6))) lil)))
                  (setq lilo lil errli nil)
                  (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters x (caaar plaa) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                    (cond
                      ( (and errli (not (equal ip x 1e-6)) (not (equal ip (caaar plaa) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                        (setq errlis (cons errli errlis) errlis (cons (list x (caaar plaa)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                      )
                    )
                  )
                  (cond
                    ( (and (null flag) (not (equal x (caaar plaa) 1e-6)))
                      (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline x (caar z) (caaar plaa)) (not (equal x (caar z) 1e-6)) (not (equal (caaar plaa) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline x q (caaar plaa)) (not (equal x q 1e-6)) (not (equal (caaar plaa) q 1e-6))) q))) (apply (function append) lil)) ))))
                        (cond
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list x ip) lil) lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)))
                            (setq lil (cons (list x ip) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (not ip)
                            (setq lil (cons (list x (caaar plaa)) lil))
                          )
                        )
                        (setq lil (cons (list x (caaar plaa)) lil))
                      )
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                      (setq closed (cons (list x (caaar plaa)) closed))
                    )
                  )
                )
              )
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) y) 1e-6))) lil)))
                  (setq lilo lil errli nil)
                  (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters y (caaar plaa) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                    (cond
                      ( (and errli (not (equal ip y 1e-6)) (not (equal ip (caaar plaa) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                        (setq errlis (cons errli errlis) errlis (cons (list y (caaar plaa)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                      )
                    )
                  )
                  (cond
                    ( (and (null flag) (not (equal y (caaar plaa) 1e-6)))
                      (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline y (caar z) (caaar plaa)) (not (equal y (caar z) 1e-6)) (not (equal (caaar plaa) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline y q (caaar plaa)) (not (equal y q 1e-6)) (not (equal (caaar plaa) q 1e-6))) q))) (apply (function append) lil)) ))))
                        (cond
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list y ip) lil) lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)))
                            (setq lil (cons (list y ip) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (not ip)
                            (setq lil (cons (list y (caaar plaa)) lil))
                          )
                        )
                        (setq lil (cons (list y (caaar plaa)) lil))
                      )
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                      (setq closed (cons (list y (caaar plaa)) closed))
                    )
                  )
                )
              )
            )
            ( (= t t)
              (foreach pla1 plaa
                (setq x (caaar (cddddr pla1)))
                (setq y (caaadr (cddddr pla1)))
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) x) 1e-6))) lil)))
                    (setq lilo lil errli nil)
                    (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters x (caar pla1) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                      (cond
                        ( (and errli (not (equal ip x 1e-6)) (not (equal ip (caar pla1) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                          (setq errlis (cons errli errlis) errlis (cons (list x (caar pla1)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                        )
                      )
                    )
                    (cond
                      ( (and (null flag) (not (equal x (caar pla1) 1e-6)))
                        (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline x (caar z) (caar pla1)) (not (equal x (caar z) 1e-6)) (not (equal (caar pla1) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline x q (caar pla1)) (not (equal x q 1e-6)) (not (equal (caar pla1) q 1e-6))) q))) (apply (function append) lil)) ))))
                          (cond
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list x ip) lil) lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)))
                              (setq lil (cons (list x ip) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (not ip)
                              (setq lil (cons (list x (caar pla1)) lil))
                            )
                          )
                          (setq lil (cons (list x (caar pla1)) lil))
                        )
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                        (setq closed (cons (list x (caar pla1)) closed))
                      )
                    )
                  )
                )
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) y) 1e-6))) lil)))
                    (setq lilo lil errli nil)
                    (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters y (caar pla1) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                      (cond
                        ( (and errli (not (equal ip y 1e-6)) (not (equal ip (caar pla1) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                          (setq errlis (cons errli errlis) errlis (cons (list y (caar pla1)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                        )
                      )
                    )
                    (cond
                      ( (and (null flag) (not (equal y (caar pla1) 1e-6)))
                        (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline y (caar z) (caar pla1)) (not (equal y (caar z) 1e-6)) (not (equal (caar pla1) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline y q (caar pla1)) (not (equal y q 1e-6)) (not (equal (caar pla1) q 1e-6))) q))) (apply (function append) lil)) ))))
                          (cond
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list y ip) lil) lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)))
                              (setq lil (cons (list y ip) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (not ip)
                              (setq lil (cons (list y (caar pla1)) lil))
                            )
                          )
                          (setq lil (cons (list y (caar pla1)) lil))
                        )
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                        (setq closed (cons (list y (caar pla1)) closed))
                      )
                    )
                  )
                )
              )
              (processend)
            )
          )
        )
        ( (= t t)
          (cond
            ( merrlis
              (setq flag t fflag t)
            )
          )
        )
      )
    )
  )

  (defun postprocess ( / chk )
    (setq flag t loop t lil nil plaa nil errpts nil pass nil pla plao merrlis t)
    (while (and flag loop)
      (setq n (length utl) flag nil)
      (process-n (function processplaa-n))
      (cond
        ( fflag
          (setq flag nil)
        )
      )
      (cond
        ( (and lilxplaoxl (null fflag))
          (setq lilxplaoxl (reverse lilxplaoxl) lilxplaoxl (vl-some (function (lambda ( x ) (if (= (length (car x)) (apply (function min) (mapcar (function length) (mapcar (function car) lilxplaoxl)))) x))) lilxplaoxl) lil (car lilxplaoxl) pla (cadr lilxplaoxl) plaa (caadr (vl-member-if (function (lambda ( x ) (equal pla (cadr x) 1e-6))) plaoxl)) lill (vl-member-if (function (lambda ( x ) (equal plaa (car x) 1e-6))) lill) plaoxl (vl-member-if (function (lambda ( x ) (equal plaa (car x) 1e-6))) plaoxl) lilxplaoxl nil)
        )
      )
    )
    (setq lil (uniquelil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil)))
    (setq n (length utl))
    (foreach li lil
      (cond
        ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
          (setq lil (subst (reverse li) li lil))
        )
      )
    )
    (cond
      ( (and (not (chklili lil)) (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) (unique (mapcar (function cadr) lil))))) pl))
        (foreach li (reverse lil)
          (entmake (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)) (cons 62 256)))
        )
        (setq chk t qqq t)
      )
    )
    (cond
      ( (null chk)
        (setq flag t loop t plaal nil fflag nil merrlis nil errliso nil liloo nil pass nil)
        (while (and flag loop)
          (setq lil nil n (length utl) pla plao plaa nil flag nil closed nil errpts nil)
          (process-n (function processplaa-n))
          (cond
            ( fflag
              (setq flag nil)
            )
          )
          (cond
            ( (equal liloo lil 1e-6)
              (setq errlis (reverse (cdr (reverse (unique errlis)))))
            )
            ( (= t t)
              (setq liloo lil)
            )
          )
          (cond
            ( (and flag (null errlis))
              (setq loop nil)
            )
          )
        )
        (cond
          ( (or (null flag) (null loop))
            (setq lil (uniquelil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil)))
            (setq n (length utl))
            (foreach li lil
              (cond
                ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
                  (setq lil (subst (reverse li) li lil))
                )
              )
            )
            (cond
              ( (and (not (chklili lil)) (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) (unique (mapcar (function cadr) lil))))) pl))
                (foreach li (reverse lil)
                  (entmake (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)) (cons 62 256)))
                )
                (setq loop nil chk t qqq t)
              )
            )
          )
        )
      )
    )
  )

  (defun processing nil
    (setq lil nil plaa nil errpts nil pass nil qqq nil n (length utl) pla plao)
    (process (function processplaa))
    (setq lil (uniquelil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil)))
    (setq lixl (vl-remove-if-not (function (lambda ( x ) (> (length (vl-remove-if-not (function (lambda ( y ) (and (setq ip (inters (car x) (cadr x) (car y) (cadr y))) (not (equal ip (car x) 1e-6)) (not (equal ip (cadr x) 1e-6)) (not (equal ip (car y) 1e-6)) (not (equal ip (cadr y) 1e-6))))) (vl-remove x lil))) 1))) lil))
    (foreach lix lixl
      (foreach li (vl-remove lix lil)
        (cond
          ( (and (setq ip (inters (car lix) (cadr lix) (car li) (cadr li))) (not (equal ip (car lix) 1e-6)) (not (equal ip (cadr lix) 1e-6)) (not (equal ip (car li) 1e-6)) (not (equal ip (cadr li) 1e-6)))
            (setq errlis (cons li errlis))
          )
        )
      )
    )
    (foreach li lil
      (cond
        ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
          (setq lil (subst (reverse li) li lil))
        )
      )
    )
    (cond
      ( (and (not (chklili lil)) (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) (unique (mapcar (function cadr) lil))))) pl))
        (foreach li (reverse lil)
          (entmake (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)) (cons 62 256)))
        )
        (setq qqq t)
      )
      ( (= t t)
        (cond
          ( errlis
            (setq lil nil plaa nil errpts nil pass nil qqq nil n (length utl) pla plao)
            (process (function processplaa-x))
            (setq lil (uniquelil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil)))
            (setq errlis nil errpts nil)
            (setq n (length utl))
            (foreach li lil
              (cond
                ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
                  (setq lil (subst (reverse li) li lil))
                )
              )
            )
            (cond
              ( (and (not (chklili lil)) (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) (unique (mapcar (function cadr) lil))))) pl))
                (foreach li (reverse lil)
                  (entmake (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)) (cons 62 256)))
                )
                (setq qqq t)
              )
              ( (= t t)
                (postprocess)
              )
            )
          )
          ( (= t t)
            (postprocess)
          )
        )
      )
    )
    (foreach li lil
      (cond
        ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
          (setq lil (subst (reverse li) li lil))
        )
      )
    )
    (cond
      ( qqq
        t
      )
    )
  )

  (setq cmde (getvar (quote cmdecho)))
  (setvar (quote cmdecho) 0)
  (or (and cad doc alo spc) (vl-load))
  (while (= 8 (logand 8 (getvar (quote undoctl))))
    (cond
      ( doc
        (vla-endundomark doc)
      )
      ( (= t t)
        (cond
          ( command-s
            (command-s "_.UNDO" "_E")
          )
          ( (= t t)
            (vl-cmdf "_.UNDO" "_E")
          )
        )
      )
    )
  )
  (cond
    ( doc
      (vla-startundomark doc)
    )
    ( (= t t)
      (cond
        ( command-s
          (command-s "_.UNDO" "_BE")
        )
        ( (= t t)
          (vl-cmdf "_.UNDO" "_BE")
        )
      )
    )
  )
  (cond
    ( (= 0 (getvar (quote worlducs)))
      (cond
        ( command-s
          (command-s "_.UCS" "_W")
        )
        ( (= t t)
          (vl-cmdf "_.UCS" "_W")
        )
      )
    )
  )
  (prompt "\nPick closed polygonal LWPOLYLINE...")
  (cond
    ( (setq s (ssget "_+.:E:S" '((0 . "LWPOLYLINE") (-4 . "&=") (70 . 1) (-4 . "<not") (-4 . "<>") (42 . 0.0) (-4 . "not>"))))
      (initget 6)
      (setq index (cond ((getint "\nSpecify index of searching for a solution from 0 to bigger number - 0 fastest search/low reliability / bigger number slow search/higher reliability <0> : ")) (0)))
      (setq ti (car (_vl-times)))
      (setq lwx (entget (setq lw (ssname s 0))))
      (setq lwi (vlax-vla-object->ename (car (vlax-invoke (vlax-ename->vla-object lw) (quote offset) 0.001))))
      (cond
        ( (< (vlax-curve-getarea lw) (vlax-curve-getarea lwi))
          (entdel lwi)
          (setq lwi (vlax-vla-object->ename (car (vlax-invoke (vlax-ename->vla-object lw) (quote offset) -0.001))))
          (setq pl (mapcar (function (lambda ( p ) (mapcar (function +) (list 0 0) (trans p lw 0)))) (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) lwx))))
        )
        ( (= t t)
          (setq pl (reverse (mapcar (function (lambda ( p ) (mapcar (function +) (list 0 0) (trans p lw 0)))) (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) lwx)))))
        )
      )
      (setq pl (append pl (list (car pl))))
      (setq tl (mapcar (function (lambda ( a b ) (list a b))) (reverse (cdr (reverse pl))) (cdr pl)))
      (setq pla (mapcar (function (lambda ( p mp ) (list p (angle p mp)))) pl (mapcar (function (lambda ( a b ) (cond ( (collinear-pp (car a) (car b) (cadr b)) (vlax-curve-getclosestpointto lwi (car b)) ) ( t (if (clockwise-p (car a) (car b) (cadr b)) (mid (polar (cadr a) (angle (cadr a) (car a)) -1.0) (polar (car b) (angle (car b) (cadr b)) -1.0)) (mid (polar (cadr a) (angle (cadr a) (car a)) 1.0) (polar (car b) (angle (car b) (cadr b)) 1.0))) )))) (cons (last tl) tl) tl)))
      (setq pla (mapcar (function (lambda ( a pla b ) (list pla a b))) (cons (last tl) tl) pla tl))
      (setq plao pla)
      (setq ll (findlinesbetweentl tl))
      (setq n (length (setq utl (unioncollinearplaneprints tl))))
      (while (null done)
        (cond
          ( (not (processing))
            (foreach li lil
              (cond
                ( (vl-some (function (lambda ( x ) (equal (car li) x 1e-6))) pl)
                  (setq lil (subst (reverse li) li lil))
                )
              )
            )
            (cond
              ( (and (not (chklili lil)) (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) (unique (mapcar (function cadr) lil))))) pl))
                (setq done t)
              )
              ( (= t t)
                (setq done t)
                (prompt "\nSOLUTION CAN'T BE FOUNDED...")
                (cond
                  ( lil
                    (foreach li lil
                      (entmake (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)) (cons 62 1)))
                    )
                  )
                )
              )
            )
          )
        )
        (setq done t)
      )
    )
  )
  (*error* nil)
)
