;;;---------------------------------------------------------------;;;
;;;                                                               ;;;
;;;                  HIP ROOF - 2D RIDGE EDGES                    ;;;
;;;                  ALTERNATE SOLUTION FINDER                    ;;;
;;;                                                               ;;;
;;;  Author : Marko Ribar, d.i.a. (architect)                     ;;;
;;;  Autolisp routine for AutoCAD or BricsCAD                     ;;;
;;;  Copyright (C) 2021.                                          ;;;
;;;  Tested and programmed on Windows 10 OS                       ;;;
;;;  Bugs or failures may appear and aren't authors responsibility;;;
;;;  LSP file is free to be used for improvements...              ;;;
;;;  All relevant suggestions are welcomed...                     ;;;
;;;                                                               ;;;
;;;---------------------------------------------------------------;;;

(defun c:roof2d-new-solutions-n ( / *error* vl-load offd acos angle3d 3pline unique uniquelil uniquelilident unit mid clockwise-p inside-p distp2t offsett2p modelst removesingles removedoubles correctplanedist collinear-pp unioncollinearplaneprints car-sort _vl-sort processtxtipl chksolution test chklili findlinesbetweentl chklilinlillst processipl processipll processplaa processplaa-x processend process processplaa-n process-n postprocess processing cmde s ti lw lwi lwx pl tl utl pla plao n plaa x y lil ipl ipldl ll flag errli errlis liloo lilo loop ip pla1 maxlen iplls iplls1 ipld ipldd mode closed op x1 x2 xx xxx xxx1 xxx2 xxxx xxxx1 xxxx2 plaal chk lixl plaox lilx fflag plaoxl lill lilxplaoxl merrlis dx fff errpts errll iplx defaultsort done errliso ipl1sort case pass index comb stertcomb lillsto qq qqq )

  (vl-load-com)

  (defun *error* ( m )
    (cond
      ( (and lwi (not (vlax-erased-p lwi)))
        (cond
          ( (= (type lwi) (quote ename))
            (entdel lwi)
          )
          ( t
            (vla-delete lwi)
          )
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (cond
        ( doc
          (vla-endundomark doc)
        )
        ( t
          (cond
            ( command-s
              (command-s "_.UNDO" "_E")
            )
            ( t
              (vl-cmdf "_.UNDO" "_E")
            )
          )
        )
      )
    )
    (cond
      ( cmde
        (setvar (quote cmdecho) cmde)
      )
    )
    (cond
      ( qq
        (prompt "\nSome solution(s) was(were) founded... Note that there may be more solutions, but with some different algorithm...")
      )
      ( t
        (prompt "\nThere are no alternate solutions that could be founded at least not with this algorithm...")
      )
    )
    (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")
    (prompt "\nExit combination : ") (princ return)
    (prompt "\nIf routine was unexpectidly terminated and you want memory clear, type (setq return nil k nil lils nil lillst nil) at command prompt... \nreturn varibable is global that is needed for continuing next time - type enter at start combination input...")
    (princ "\n")
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun vl-load nil
    (or cad
      (cond
        ( vlax-get-acad-object
          (setq cad (vlax-get-acad-object))
        )
        ( t
          (vl-load-com)
          (setq cad (vlax-get-acad-object))
        )
      )
    )
    (or doc (setq doc (vla-get-activedocument cad)))
    (or alo (setq alo (vla-get-activelayout doc)))
    (or spc (setq spc (vla-get-block alo)))
  )

  (defun acos ( x )
    (cond
      ( (equal x 1.0 1e-8) 0.0 )
      ( (equal x -1.0 1e-8) pi )
      ( (and (not (minusp x)) (equal x 0.0 1e-8)) (/ pi 2.0) )
      ( (and (minusp x) (equal x 0.0 1e-8)) (* 3.0 (/ pi 2.0)) )
      ( (atan (sqrt (- 1.0 (* x x))) x) )
    )
  )

  (defun angle3d ( p1 por p2 / vec1 vec2 dd ang )
    (setq vec1 (unit (mapcar '- p1 por))
          vec2 (unit (mapcar '- p2 por))
          dd (distance vec1 vec2)
          ang (acos (- 1.0 (/ (expt dd 2) 2.0)))
    )
    (cond
      ( (minusp ang)
        (+ ang pi)
      )
      ( t
        ang
      )
    )
  )

  (defun 3pline ( p1 p p2 )
    (equal (distance p1 p2) (+ (distance p1 p) (distance p p2)) 1e-6)
  )

  (defun unique ( lst / a ll )
    (while (setq a (car lst))
      (cond
        ( (vl-some (function (lambda ( x ) (equal x a 1e-6))) (cdr lst))
          (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) (cdr lst)))
        )
        ( t
          (setq ll (cons a ll) lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun uniquelil ( lst / a ll )
    (while (setq a (car lst))
      (cond
        ( (vl-some (function (lambda ( x ) (or (equal x a 1e-6) (equal x (reverse a) 1e-6)))) (cdr lst))
          (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (or (equal x a 1e-6) (equal x (reverse a) 1e-6)))) (cdr lst)))
        )
        ( t
          (setq ll (cons a ll) lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun uniquelilident ( lst / a ll )
    (while (setq a (car lst))
      (cond
        ( (vl-some (function (lambda ( x ) (and (equal (car a) (car x) 1e-6) (equal (cadr a) (cadr x) 1e-6)))) (cdr lst))
          (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (and (equal (car a) (car x) 1e-6) (equal (cadr a) (cadr x) 1e-6)))) (cdr lst)))
        )
        ( t
          (setq ll (cons a ll) lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun unit ( v / d )
    (cond
      ( (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
        (mapcar (function (lambda ( x ) (/ x d))) v)
      )
    )
  )

  (defun mid ( p1 p2 )
    (mapcar (function (lambda ( a b ) (/ (+ a b) 2.0))) p1 p2)
  )

  (defun clockwise-p ( p1 p2 p3 )
    (minusp (sin (- (angle p1 p3) (angle p1 p2))))
  )

  (defun inside-p ( pt lw lwi )
    (< (distance pt (vlax-curve-getclosestpointto lwi pt)) (distance pt (vlax-curve-getclosestpointto lw pt)))
  )

  (defun distp2t ( p tt / i )
    (cond
      ( (setq i (inters p (polar p (+ (angle (car tt) (cadr tt)) (* 0.5 pi)) 1.0) (car tt) (cadr tt) nil))
        (distance p i)
      )
    )
  )

  (defun offsett2p ( p tt d / ip v v1 )
    (setq ip (inters p (polar p (+ (angle (car tt) (cadr tt)) (* 0.5 pi)) 1.0) (car tt) (cadr tt) nil))
    (setq v (mapcar (function -) p ip))
    (setq v1 (unit v))
    (list (mapcar (function +) (car tt) (mapcar (function *) v1 (list d d))) (mapcar (function +) (cadr tt) (mapcar (function *) v1 (list d d))))
  )

  (defun modelst ( lst fuz / cnt dif itm len rtn )
    (while lst
      (setq len (length lst))
      (setq itm (car lst))
      (setq lst (vl-remove-if (function (lambda ( x ) (equal itm x fuz))) (cdr lst)))
      (setq dif (- len (length lst)))
      (if (< cnt dif)
        (setq cnt dif rtn itm)
      )
    )
    rtn
  )

  (defun removesingles ( lst / a )
    (while (setq a (vl-some (function (lambda ( x ) (if (= (1- (length lst)) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) lst))) x))) lst))
      (setq lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) lst))
    )
    lst
  )

  (defun removedoubles ( lst / a )
    (while (setq a (vl-some (function (lambda ( x ) (if (= (- (length lst) 2) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) lst))) x))) lst))
      (setq lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) lst))
    )
    lst
  )

  (defun correctplanedist ( ip / d )
    (cond
      ( (and (caar ip) (caadr ip) (cadadr ip) (caaddr ip) (cadr (caddr ip)) (equal (setq d (distp2t (caar ip) (cadr ip))) (distp2t (caar ip) (caddr ip)) 1e-6) d)
        d
      )
    )
  )

  (defun collinear-pp ( p1 p2 p3 )
    (
      (lambda ( a b c )
        (or
          (equal (+ a b) c 1e-10)
          (equal (+ b c) a 1e-10)
          (equal (+ c a) b 1e-10)
        )
      )
      (distance p1 p2) (distance p2 p3) (distance p1 p3)
    )
  )

  (defun unioncollinearplaneprints ( tl / a b tll )
    (while (setq a (car tl))
      (setq b (vl-remove-if-not (function (lambda ( x ) (and (collinear-pp (car a) (cadr a) (car x)) (collinear-pp (car a) (cadr a) (cadr x))))) tl))
      (setq tll (cons a tll))
      (cond
        ( b
          (setq tl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) b))) tl))
        )
        ( t
          (setq tl (cdr tl))
        )
      )
    )
    tll
  )

  (defun car-sort ( lst cmp / rtn )
    (setq rtn (car lst))
    (foreach itm (cdr lst)
      (cond
        ( (apply cmp (list itm rtn))
          (setq rtn itm)
        )
      )
    )
    rtn
  )

  (defun _vl-sort ( lst func )
    (mapcar
      (function (lambda ( x ) (nth x lst)))
      (vl-sort-i lst func)
    )
  )

  (defun offd ( ip tl / d dl )
    (cond
      ( (and ip (listp ip) (= (length ip) 2) (vl-every (function numberp) ip) (inside-p ip lw lwi))
        (setq dl
          (mapcar
            (function
              (lambda ( x )
                (distance ip
                  (inters
                    ip
                    (polar ip (+ (* 0.5 pi) (angle (car x) (cadr x))) 1.0)
                    (car x)
                    (polar (car x) (angle (car x) (cadr x)) 1.0)
                    nil
                  )
                )
              )
            )
            tl
          )
        )
        (setq dl (removedoubles (removesingles dl)))
        (cond
          ( dl
            (setq d (modelst dl 1e-5))
          )
        )
      )
    )
    d
  )

  (defun processtxtipl ( tl / ipl tl1 tl2 intt )
    (setq tl1 tl tl2 tl)
    (foreach t1 tl1
      (setq tl2 (cdr tl2))
      (foreach t2 tl2
        (cond
          ( (setq intt (inters (car t1) (polar (car t1) (angle (car t1) (cadr t1)) 1.0) (car t2) (polar (car t2) (angle (car t2) (cadr t2)) 1.0) nil))
            (setq ipl (cons intt ipl))
          )
          ( t
            (setq ipl (cons (angle (car t1) (cadr t1)) ipl))
          )
        )
      )
    )
    ipl
  )

  (defun findlinesbetweentl ( tl / ll tl1 tl2 )
    (setq tl1 tl tl2 tl)
    (foreach t1 tl1
      (setq tl2 (cdr tl2))
      (foreach t2 tl2
        (setq ll (cons (list (mid (car t1) (cadr t1)) (mid (car t2) (cadr t2))) ll))
      )
    )
    ll
  )

  (defun chklilinlillst ( ll lst / l1 l2 )
    (setq l1 (apply (function append) ll))
    (setq l2 (apply (function append) (apply (function append) lst)))
    (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 5e-2))) l2))) l1)
  )

  (defun chksolution ( errli / allplanesips anglst )
    (cond
      ( (and (car errli) (cadr errli))
        (setq allplanesips (processtxtipl tl))
        (setq allplanesips (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) pl))) allplanesips))
        (setq anglst (vl-remove-if (function listp) allplanesips))
        (cond
          ( (vl-some (function (lambda ( x ) (or (equal x 1e-8 1e-6) (equal x -1e-8 1e-6)))) anglst)
            (setq anglst (cons 0.0 anglst) anglst (cons pi anglst) anglst (cons (* 2 pi) anglst))
          )
        )
        (setq allplanesips (vl-remove-if-not (function listp) allplanesips))
        (cond
          ( (or
              (vl-some (function (lambda ( x ) (or
                                                 (equal (distance (car errli) (cadr errli)) (+ (distance (car errli) x) (distance x (cadr errli))) 1e-8)
                                                 (equal (distance (car errli) x) (+ (distance (car errli) (cadr errli)) (distance (cadr errli) x)) 1e-8)
                                                 (equal (distance (cadr errli) x) (+ (distance (cadr errli) (car errli)) (distance (car errli) x)) 1e-8)
                                               )
                                 )) allplanesips
              )
              (vl-some (function (lambda ( x ) (or (equal (angle (car errli) (cadr errli)) x 1e-8) (equal (angle (cadr errli) (car errli)) x 1e-8)))) anglst)
              (vl-some (function (lambda ( x ) (collinear-pp (car errli) (cadr errli) x))) pl)
            )
          )
        )
      )
      ( t
        t
      )
    )
  )

  (defun test nil
    (and
      (not (vl-some (function (lambda ( x ) (and (not (vl-some (function (lambda ( y ) (inters (car x) (cadr x) (car y) (cadr y)))) lil)) (not (vl-some (function (lambda ( y ) (equal (distance (car y) (cadr y)) (+ (distance (car y) (polar (car x) (angle (car x) (cadr x)) 0.1)) (distance (polar (car x) (angle (car x) (cadr x)) 0.01) (cadr y))) 1e-6))) tl)) (inside-p (polar (car x) (angle (car x) (cadr x)) 0.01) lw lwi) (inside-p (polar (cadr x) (angle (cadr x) (car x)) 0.01) lw lwi)))) ll))
      (vl-every (function (lambda ( li ) (chksolution li))) lil)
      (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) (apply (function append) lil)))) pl)
      (not (vl-some (function (lambda ( li1 ) (vl-some (function (lambda ( li2 / ip ) (and (setq ip (inters (car li1) (cadr li1) (car li2) (cadr li2))) (not (equal ip (car li1) 1e-6)) (not (equal ip (cadr li1) 1e-6)) (not (equal ip (car li2) 1e-6)) (not (equal ip (cadr li2) 1e-6))))) (vl-remove li1 lil)))) lil))
    )
  )

  (defun chklili ( lil / lilpts )
    (setq lilpts (apply (function append) lil))
    (setq lilpts (vl-remove-if-not (function (lambda ( x ) (= (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) lilpts)) (- (length lilpts) 2)))) lilpts))
    lilpts
  )

  (defun processipl ( pla / pla1 pla2 intt ii1 ii2 xx xxx xxxx uu ipl aaa aaa1 aaa2 d1 d2 di )
    (setq pla (vl-remove nil pla))
    (setq pla1 pla pla2 pla)
    (foreach p1 pla1
      (setq pla2 (cdr pla2))
      (foreach p2 pla2
        (setq aaa nil aaa1 nil aaa2 nil)
        (setq intt (inters (caar p1) (polar (caar p1) (cadar p1) 1.0) (caar p2) (polar (caar p2) (cadar p2) 1.0) nil))
        (cond
          ( (or (equal intt (caar p1) 1e-6) (equal intt (caar p2) 1e-6))
            (setq intt nil)
          )
          ( (and intt (not (inside-p intt lw lwi)))
            (setq intt nil)
          )
        )
        (cond
          ( (and intt (setq ii1 (vl-some (function (lambda ( x ) (if (equal (caar x) intt 1e-6) x))) ipl)))
            (cond
              ( (cadar ii1)
                (setq aaa1 (cadar ii1))
              )
            )
          )
        )
        (cond
          ( intt
            (cond
              ( (setq xxx (vl-some (function (lambda ( x ) (if (= (length (vl-remove x (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2))))) 2) x))) (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2)))))
                (cond
                  ( (or (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p2))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))) (and (caadr p2) (cadadr p2) (caaddr p2) (cadr (caddr p2)) (or (equal (angle (caadr p2) (cadadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6) (equal (angle (cadadr p2) (caadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p1))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))))
                    (cond
                      ( (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)))
                        (setq ipl (cons (list (list intt (setq aaa2 (if (setq xx (vl-remove xxx (list (cadr p2) (caddr p2)))) (angle (caar xx) (cadar xx)) (cadar p2)))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                      ( t
                        (setq ipl (cons (list (list intt (setq aaa2 (if (setq xx (vl-remove xxx (list (cadr p1) (caddr p1)))) (angle (caar xx) (cadar xx)) (cadar p1)))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                    )
                  )
                  ( t
                    (setq ipl (cons (list (list intt (setq aaa2 (if (setq xxxx (if (and (setq xx (vl-remove xxx (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2))))) (= (length xx) 2)) (inters (caar xx) (cadar xx) (caadr xx) (cadadr xx) nil))) (angle xxxx intt) (angle (caar xx) (cadar xx))))) (car xx) (cadr xx) xxx p1 p2) ipl))
                  )
                )
              )
              ( t
                (cond
                  ( (or (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p2))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))) (and (caadr p2) (cadadr p2) (caaddr p2) (cadr (caddr p2)) (or (equal (angle (caadr p2) (cadadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6) (equal (angle (cadadr p2) (caadr p2)) (angle (caaddr p2) (cadr (caddr p2))) 1e-6)) (setq xx (vl-some (function (lambda ( x ) (if (equal x (mapcar (function +) intt (mapcar (function -) intt (caar p1))) 1e-6) x))) pl)) (or (equal (angle xx intt) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6) (equal (angle intt xx) (cadar (vl-some (function (lambda ( x ) (if (equal xx (caar x) 1e-6) x))) pla)) 1e-6))))
                    (cond
                      ( (and (caadr p1) (cadadr p1) (caaddr p1) (cadr (caddr p1)) (or (equal (angle (caadr p1) (cadadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6) (equal (angle (cadadr p1) (caadr p1)) (angle (caaddr p1) (cadr (caddr p1))) 1e-6)))
                        (setq ipl (cons (list (list intt (setq aaa2 (if (setq xx (vl-remove xxx (list (cadr p2) (caddr p2)))) (angle (caar xx) (cadar xx)) (cadar p2)))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                      ( t
                        (setq ipl (cons (list (list intt (setq aaa2 (if (setq xx (vl-remove xxx (list (cadr p1) (caddr p1)))) (angle (caar xx) (cadar xx)) (cadar p1)))) (car xx) (if (and (caar xx) (cadar xx) (distp2t intt (car xx))) (offsett2p intt (car xx) (* (distp2t intt (car xx)) 2.0))) nil p1 p2) ipl))
                      )
                    )
                  )
                  ( (= (length (setq uu (unioncollinearplaneprints (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2)))))) 3)
                    (foreach pp uu
                      (if (= (length (vl-remove-if-not (function (lambda ( x ) (or (equal pp x) (and (equal (distance (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (car pp) (cadr pp)) (car x)) (+ (distance (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (car pp) (cadr pp)) (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (cadr pp) (car pp))) (distance (if (> (distance (car pp) (car x)) (distance (cadr pp) (car x))) (cadr pp) (car pp)) (car x))) 1e-6) (equal (distance (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (car pp) (cadr pp)) (cadr x)) (+ (distance (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (car pp) (cadr pp)) (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (cadr pp) (car pp))) (distance (if (> (distance (car pp) (cadr x)) (distance (cadr pp) (cadr x))) (cadr pp) (car pp)) (cadr x))) 1e-6))))) (append (list (cadr p1) (caddr p1)) (list (cadr p2) (caddr p2))))) 2)
                        (setq xxx pp)
                      )
                    )
                    (setq ipl (cons (list (list intt (setq aaa2 (if (setq xxxx (if (and (setq xx (vl-remove xxx uu)) (= (length xx) 2)) (inters (caar xx) (cadar xx) (caadr xx) (cadadr xx) nil))) (angle xxxx intt) (angle (caar xx) (cadar xx))))) (car xx) (cadr xx) nil p1 p2) ipl))
                  )
                  ( t
                    (setq ipl (cons (list (list intt nil) nil nil nil p1 p2) ipl))
                  )
                )
              )
            )
          )
        )
        (setq ii2 (car ipl))
        (cond
          ( (and aaa1 aaa2)
            (setq aaa (rem (+ (/ (+ aaa1 aaa2) 2.0) (/ pi 2)) (* 2 pi)))
            (setq ipl (subst (list (list (caar ii1) aaa) (nth 1 ii1) (nth 2 ii1) (nth 3 ii1) (nth 4 ii1) (nth 5 ii1)) ii1 (cdr ipl)))
            (setq ipl (cons (list (list (caar ii2) aaa) (nth 1 ii2) (nth 2 ii2) (nth 3 ii2) (nth 4 ii2) (nth 5 ii2)) ipl))
          )
        )
      )
    )
    (setq ipl (_vl-sort (vl-remove-if-not (function (lambda ( p / d1 d2 ll )
      (and
        (caar p)
        (inside-p (caar p) lw lwi)
        (setq ll (vl-remove nil (mapcar (function (lambda ( tt ) (distp2t (caar p) tt))) utl)))
        (setq d (modelst ll 1e-5))
        (>= (length (vl-remove-if-not (function (lambda ( x ) (equal x d 1e-5))) ll)) 3)
        (cond
          ( (and (caadr p) (cadadr p) (caaddr p) (cadr (caddr p)))
            (or
              (and (setq d1 (distance (caar p) (vlax-curve-getclosestpointto lw (caar p)))) (setq d2 (correctplanedist p)) (> d1 d2))
              (and d1 d2 (equal d1 d2 1e-6))
            )
          )
        )
      )
    )) ipl) (function (lambda ( a b ) (> (offd (caar a) utl) (offd (caar b) utl))))))
  )

  (defun processipll ( mode / makeipll ipl1l errx err ipl1 lst ll ipll ipllx dd d )

    (defun makeipll ( / a1 a2 nn mm b1 b2 jj hh )
      (cond
        ( (cond
            ( (= case 0)
              (setq lst (vl-remove-if-not (function (lambda ( x ) (and (equal (caar ipl1) (caar x) 1e-6) (not (vl-some (function (lambda ( y ) (or (and (not (equal (caaar (cddddr x)) (caar y) 1e-6)) (not (equal (caar x) (caar y) 1e-6)) (3pline (caaar (cddddr x)) (caar y) (caar x))) (and (not (equal (caaadr (cddddr x)) (caar y) 1e-6)) (not (equal (caar x) (caar y) 1e-6)) (3pline (caaadr (cddddr x)) (caar y) (caar x)))))) (vl-remove x ipl)))))) ipl))
            )
            ( (= case 1)
              (setq lst (vl-remove-if-not (function (lambda ( x ) (equal (caar ipl1) (caar x) 1e-6))) (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (and (equal (caar x) (caar y) 1e-6) (vl-some (function (lambda ( q ) (or (and (not (equal (caar x) (caar q) 1e-6)) (not (equal (caaar (cddddr x)) (caar q) 1e-6)) (3pline (caar x) (caar q) (caaar (cddddr x)))) (and (not (equal (caar x) (caar q) 1e-6)) (not (equal (caaadr (cddddr x)) (caar q) 1e-6)) (3pline (caar x) (caar q) (caaadr (cddddr x))))))) ipl)))) errx))) ipl)))
            )
            ( (= case 2)
              (setq lst (vl-remove-if-not (function (lambda ( x ) (equal (caar ipl1) (caar x) 1e-6))) ipl))
            )
          )
          (setq ipll (cons (_vl-sort lst (if (/= case 2) (function (lambda ( a b / aa bb n m ) (if (or (null (cadddr a)) (null (cadddr b))) (if (or (not (vl-some (function (lambda ( x ) (or (equal x (caaar (cddddr a)) 1e-6) (equal x (caaadr (cddddr a)) 1e-6)))) pl)) (not (vl-some (function (lambda ( x ) (or (equal x (caaar (cddddr b)) 1e-6) (equal x (caaadr (cddddr b)) 1e-6)))) pl))) (< (max (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (max (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))) (progn (setq aa (cond ( (and (setq a1 (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr a)) 1e-6) x))) pl)) (setq a2 (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr a)) 1e-6) x))) pl))) (car-sort (list a1 a2) (function (lambda ( c d ) (< (vl-some (function (lambda ( q ) (setq nn (if (null nn) 0 (1+ nn))) (if (equal q c 1e-6) nn))) (append pl pl)) (vl-some (function (lambda ( q ) (setq mm (if (null mm) 0 (1+ mm))) (if (equal q d 1e-6) mm))) (append pl pl)))))) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr a)) 1e-6) x))) pl) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr a)) 1e-6) x))) pl) ) )) (setq bb (cond ( (and (setq b1 (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr b)) 1e-6) x))) pl)) (setq b2 (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr b)) 1e-6) x))) pl))) (car-sort (list b1 b2) (function (lambda ( c d ) (< (vl-some (function (lambda ( q ) (setq jj (if (null jj) 0 (1+ jj))) (if (equal q c 1e-6) jj))) (append pl pl)) (vl-some (function (lambda ( q ) (setq hh (if (null hh) 0 (1+ hh))) (if (equal q d 1e-6) hh))) (append pl pl)))))) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr b)) 1e-6) x))) pl) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr b)) 1e-6) x))) pl) ) )) (setq a1 nil a2 nil nn nil mm nil b1 nil b2 nil jj nil hh nil) (< (vl-some (function (lambda ( q ) (setq n (if (null n) 0 (1+ n))) (if (equal q aa 1e-6) n))) (append pl pl)) (vl-some (function (lambda ( q ) (setq m (if (null m) 0 (1+ m))) (if (equal q bb 1e-6) m))) (append pl pl))))) (< (vl-some (function (lambda ( q ) (setq n (if (null n) 0 (1+ n))) (if (equal q (cadddr a) 1e-6) n))) (append tl tl)) (vl-some (function (lambda ( q ) (setq m (if (null m) 0 (1+ m))) (if (equal q (cadddr b) 1e-6) m))) (append tl tl)))))) (function (lambda ( a b ) (< (max (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (max (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))))))) ipll))
        )
      )
    )

    (setq d (car-sort (vl-remove nil (mapcar (function (lambda ( li ) (offd (cadr li) utl))) lil)) (function >)))
    (setq ipl (vl-remove-if (function (lambda ( x ) (or (null (cadr x)) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) errpts)))) ipl))
    (cond
      ( (= case 1)
        (foreach pla1 pla
          (setq ipl1l (vl-remove-if-not (function (lambda ( z ) (or (equal (angle (caar z) (caar pla1)) (cadar pla1) 1e-6) (equal (angle (caar pla1) (caar z)) (cadar pla1) 1e-6)))) ipl))
          (foreach ipl1 ipl1l
            (if (vl-some (function (lambda ( x ) (or (and (not (equal (caar x) (caar ipl1) 1e-6)) (not (equal (caar x) (caaar (cddddr ipl1)) 1e-6)) (3pline (caar ipl1) (caar x) (caaar (cddddr ipl1)))) (and (not (equal (caar x) (caar ipl1) 1e-6)) (not (equal (caar x) (caaadr (cddddr ipl1)) 1e-6)) (3pline (caar ipl1) (caar x) (caaadr (cddddr ipl1))))))) ipl1l)
              (setq errx (cons ipl1 errx))
            )
          )
        )
        (setq err (vl-remove-if (function (lambda ( x ) (> (length (vl-remove-if (function (lambda ( y ) (vl-some (function (lambda ( z ) (and (not (equal (caar x) (caar z) 1e-6)) (3pline (caar x) (caar z) (caar y))))) ipl))) (vl-remove-if-not (function (lambda ( y ) (and (or (equal (angle (caar y) (caar x)) (cadar y) 1e-6) (equal (angle (caar x) (caar y)) (cadar y) 1e-6))))) pla))) 1))) errx))
      )
    )
    (foreach pla1 pla
      (setq ipl1l (vl-remove-if-not (function (lambda ( z ) (or (equal (angle (caar z) (caar pla1)) (cadar pla1) 1e-6) (equal (angle (caar pla1) (caar z)) (cadar pla1) 1e-6)))) ipl))
      (cond
        ( (= case 1)
          (if (setq dd (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) (caar y) 1e-6))) err))) ipl1l))
            (setq ipl1l dd)
          )
        )
        ( (= case 2)
          (if (and lils (setq dd (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) (cadr y) 1e-6))) lils))) ipl1l)))
            (setq ipl1l dd)
          )
        )
      )
      (setq ipl1
        (cond
          ( (= ipl1sort 0)
            (car-sort ipl1l (function (lambda ( a b ) (if (equal (car-sort (list (distance (caaar (cddddr a)) (caar a)) (distance (caaadr (cddddr a)) (caar a)) (distance (vlax-curve-getclosestpointto lw (caar a)) (caar a))) (function <)) (car-sort (list (distance (caaar (cddddr b)) (caar b)) (distance (caaadr (cddddr b)) (caar b)) (distance (vlax-curve-getclosestpointto lw (caar b)) (caar b))) (function <)) 1e-6) (< (distance (caaar (cddddr a)) (caaadr (cddddr a))) (distance (caaar (cddddr b)) (caaadr (cddddr b)))) (< (car-sort (list (distance (caaar (cddddr a)) (caar a)) (distance (caaadr (cddddr a)) (caar a)) (distance (vlax-curve-getclosestpointto lw (caar a)) (caar a))) (function <)) (car-sort (list (distance (caaar (cddddr b)) (caar b)) (distance (caaadr (cddddr b)) (caar b)) (distance (vlax-curve-getclosestpointto lw (caar b)) (caar b))) (function <)))))))
          )
          ( (= ipl1sort 1)
            (car-sort ipl1l (function (lambda ( a b ) (if (equal (angle3d (append (caaar (cddddr a)) (list 0.0)) (append (caar a) (list 0.0)) (append (caaadr (cddddr a)) (list 0.0))) (angle3d (append (caaar (cddddr b)) (list 0.0)) (append (caar b) (list 0.0)) (append (caaadr (cddddr b)) (list 0.0))) 1e-6) (if (equal (car-sort (list (distance (caaar (cddddr a)) (caar a)) (distance (caaadr (cddddr a)) (caar a)) (distance (vlax-curve-getclosestpointto lw (caar a)) (caar a))) (function <)) (car-sort (list (distance (caaar (cddddr b)) (caar b)) (distance (caaadr (cddddr b)) (caar b)) (distance (vlax-curve-getclosestpointto lw (caar b)) (caar b))) (function <)) 1e-6) (< (distance (caaar (cddddr a)) (caaadr (cddddr a))) (distance (caaar (cddddr b)) (caaadr (cddddr b)))) (< (car-sort (list (distance (caaar (cddddr a)) (caar a)) (distance (caaadr (cddddr a)) (caar a)) (distance (vlax-curve-getclosestpointto lw (caar a)) (caar a))) (function <)) (car-sort (list (distance (caaar (cddddr b)) (caar b)) (distance (caaadr (cddddr b)) (caar b)) (distance (vlax-curve-getclosestpointto lw (caar b)) (caar b))) (function <)))) (> (angle3d (append (caaar (cddddr a)) (list 0.0)) (append (caar a) (list 0.0)) (append (caaadr (cddddr a)) (list 0.0))) (angle3d (append (caaar (cddddr b)) (list 0.0)) (append (caar b) (list 0.0)) (append (caaadr (cddddr b)) (list 0.0))))))))
          )
          ( (= ipl1sort 2)
            (car-sort ipl1l (function (lambda ( a b ) (< (distance (vlax-curve-getclosestpointto lw (caar a)) (caar a)) (distance (vlax-curve-getclosestpointto lw (caar b)) (caar b))))))
          )
          ( (= ipl1sort 3)
            (cond
              ( d
                (car-sort ipl1l (function (lambda ( a b ) (< (abs (- d (modelst (vl-remove nil (mapcar (function (lambda ( tt ) (distp2t (caar a) tt))) utl)) 1e-5))) (abs (- d (modelst (vl-remove nil (mapcar (function (lambda ( tt ) (distp2t (caar b) tt))) utl)) 1e-5)))))))
              )
            )
          )
          ( (= ipl1sort 4)
            (car-sort ipl1l (function (lambda ( a b ) (< (distance (cadar lil) (caar a)) (distance (cadar lil) (caar b))))))
          )
          ( (= ipl1sort 5)
            (car-sort ipl1l (function (lambda ( a b ) (< (min (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (min (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))))))
          )
          ( (= ipl1sort 6)
            (car-sort ipl1l (function (lambda ( a b ) (> (min (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (min (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))))))
          )
          ( (= ipl1sort 7)
            (car-sort ipl1l (function (lambda ( a b ) (< (max (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (max (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))))))
          )
          ( (= ipl1sort 8)
            (car-sort ipl1l (function (lambda ( a b ) (> (max (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (max (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))))))
          )
          ( (= ipl1sort 9)
            (car-sort ipl1l (function (lambda ( a b ) (> (distance (caar a) (caar pla1)) (distance (caar b) (caar pla1))))))
          )
          ( (= ipl1sort 10)
            (car-sort ipl1l (function (lambda ( a b ) (< (distance (caar a) (caar pla1)) (distance (caar b) (caar pla1))))))
          )
        )
      )
      (cond
        ( (= case 2)
          (cond
            ( (and ipl1 (if (and (setq zzz (vl-some (function (lambda ( x ) (vl-some (function (lambda ( y ) (if (and (not (equal (caar x) (caar y) 1e-6)) (not (equal (caar x) (caar ipl1) 1e-6)) (not (equal (caar y) (caar ipl1) 1e-6)) (or (and (not (equal (caar y) (caaar (cddddr ipl1)) 1e-6)) (not (equal (caar x) (caaar (cddddr ipl1)) 1e-6)) (and (or (inters (caar y) (polar (caar y) (cadar y) 1e+6) (caaar (cddddr ipl1)) (caar ipl1)) (inters (caar y) (polar (caar y) (cadar y) -1e+6) (caaar (cddddr ipl1)) (caar ipl1))) (equal (caar x) (inters (caar y) (polar (caar y) (cadar y) 1.0) (caaar (cddddr ipl1)) (caar ipl1) nil) 1e-6))) (and (not (equal (caar y) (caaadr (cddddr ipl1)) 1e-6)) (not (equal (caar x) (caaadr (cddddr ipl1)) 1e-6)) (and (or (inters (caar y) (polar (caar y) (cadar y) 1e+6) (caaadr (cddddr ipl1)) (caar ipl1)) (inters (caar y) (polar (caar y) (cadar y) -1e+6) (caaadr (cddddr ipl1)) (caar ipl1))) (equal (caar x) (inters (caar y) (polar (caar y) (cadar y) 1.0) (caaadr (cddddr ipl1)) (caar ipl1) nil) 1e-6))))) (list x y)))) (vl-remove-if (function (lambda ( x ) (null (cadar x)))) (append pla ipl))))) (vl-remove-if (function (lambda ( x ) (null (cadar x)))) (append pla ipl)))) (vl-some (function (lambda ( x ) (and (not (equal (caar x) (caaar zzz) 1e-6)) (not (equal (caar x) (caaadr zzz) 1e-6)) (equal (distance (caaar zzz) (caaadr zzz)) (+ (distance (caaar zzz) (caar x)) (distance (caar x) (caaadr zzz))) 1e-6)))) (append pla ipl))) t (not zzz)))
              (makeipll)
            )
          )
        )
        ( t
          (makeipll)
        )
      )
    )
    (cond
      ( mode
        (setq iplx (append (vl-remove nil ipl) (if errpts (mapcar (function (lambda ( x ) (list (list x nil) nil nil nil nil nil))) errpts))))
      )
    )
    (cond
      ( (and (/= case 2) lils (setq dd (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caaar x) y 1e-6))) (mapcar (function cadr) lils)))) (vl-remove nil ipll))))
        (setq ipll dd)
      )
    )
    (cond
      ( (setq dd (vl-remove-if (function (lambda ( x ) (vl-every (function (lambda ( y ) (null (cadar y)))) x))) (vl-remove nil ipll)))
        (setq ipll dd)
      )
    )
    (cond
      ( (= defaultsort 0)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (if (equal (car-sort (list (distance (caaar (cddddr (car a))) (caar (car a))) (distance (caaadr (cddddr (car a))) (caar (car a))) (distance (vlax-curve-getclosestpointto lw (caaar a)) (caaar a))) (function <)) (car-sort (list (distance (caaar (cddddr (car b))) (caar (car b))) (distance (caaadr (cddddr (car b))) (caar (car b))) (distance (vlax-curve-getclosestpointto lw (caaar b)) (caaar b))) (function <)) 1e-6) (< (distance (caaar (cddddr (car a))) (caaadr (cddddr (car a)))) (distance (caaar (cddddr (car b))) (caaadr (cddddr (car b))))) (< (car-sort (list (distance (caaar (cddddr (car a))) (caar (car a))) (distance (caaadr (cddddr (car a))) (caar (car a))) (distance (vlax-curve-getclosestpointto lw (caaar a)) (caaar a))) (function <)) (car-sort (list (distance (caaar (cddddr (car b))) (caar (car b))) (distance (caaadr (cddddr (car b))) (caar (car b))) (distance (vlax-curve-getclosestpointto lw (caaar b)) (caaar b))) (function <)))))))
      )
      ( (= defaultsort 1)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (if (equal (angle3d (append (caaar (cddddr (car a))) (list 0.0)) (append (caaar a) (list 0.0)) (append (caaadr (cddddr (car a))) (list 0.0))) (angle3d (append (caaar (cddddr (car b))) (list 0.0)) (append (caaar b) (list 0.0)) (append (caaadr (cddddr (car b))) (list 0.0))) 1e-6) (if (equal (car-sort (list (distance (caaar (cddddr (car a))) (caar (car a))) (distance (caaadr (cddddr (car a))) (caar (car a))) (distance (vlax-curve-getclosestpointto lw (caaar a)) (caaar a))) (function <)) (car-sort (list (distance (caaar (cddddr (car b))) (caar (car b))) (distance (caaadr (cddddr (car b))) (caar (car b))) (distance (vlax-curve-getclosestpointto lw (caaar b)) (caaar b))) (function <)) 1e-6) (< (distance (caaar (cddddr (car a))) (caaadr (cddddr (car a)))) (distance (caaar (cddddr (car b))) (caaadr (cddddr (car b))))) (< (car-sort (list (distance (caaar (cddddr (car a))) (caar (car a))) (distance (caaadr (cddddr (car a))) (caar (car a))) (distance (vlax-curve-getclosestpointto lw (caaar a)) (caaar a))) (function <)) (car-sort (list (distance (caaar (cddddr (car b))) (caar (car b))) (distance (caaadr (cddddr (car b))) (caar (car b))) (distance (vlax-curve-getclosestpointto lw (caaar b)) (caaar b))) (function <)))) (> (angle3d (append (caaar (cddddr (car a))) (list 0.0)) (append (caaar a) (list 0.0)) (append (caaadr (cddddr (car a))) (list 0.0))) (angle3d (append (caaar (cddddr (car b))) (list 0.0)) (append (caaar b) (list 0.0)) (append (caaadr (cddddr (car b))) (list 0.0))))))))
      )
      ( (= defaultsort 2)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (< (distance (vlax-curve-getclosestpointto lw (caaar a)) (caaar a)) (distance (vlax-curve-getclosestpointto lw (caaar b)) (caaar b))))))
      )
      ( (= defaultsort 3)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (< (abs (- d (modelst (vl-remove nil (mapcar (function (lambda ( tt ) (distp2t (caaar a) tt))) utl)) 1e-5))) (abs (- d (modelst (vl-remove nil (mapcar (function (lambda ( tt ) (distp2t (caaar b) tt))) utl)) 1e-5)))))))
      )
      ( (= defaultsort 4)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))))))
      )
      ( (= defaultsort 5)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (< (min (distance (caaar a) (caaar (cddddr (car a)))) (distance (caaar a) (caaadr (cddddr (car a))))) (min (distance (caaar b) (caaar (cddddr (car b)))) (distance (caaar b) (caaadr (cddddr (car b)))))))))
      )
      ( (= defaultsort 6)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (> (min (distance (caaar a) (caaar (cddddr (car a)))) (distance (caaar a) (caaadr (cddddr (car a))))) (min (distance (caaar b) (caaar (cddddr (car b)))) (distance (caaar b) (caaadr (cddddr (car b)))))))))
      )
      ( (= defaultsort 7)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (< (max (distance (caaar a) (caaar (cddddr (car a)))) (distance (caaar a) (caaadr (cddddr (car a))))) (max (distance (caaar b) (caaar (cddddr (car b)))) (distance (caaar b) (caaadr (cddddr (car b)))))))))
      )
      ( (= defaultsort 8)
        (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (> (max (distance (caaar a) (caaar (cddddr (car a)))) (distance (caaar a) (caaadr (cddddr (car a))))) (max (distance (caaar b) (caaar (cddddr (car b)))) (distance (caaar b) (caaadr (cddddr (car b)))))))))
      )
      ( (= defaultsort 9)
        (cond
          ( (vl-some (function (lambda ( x ) (equal (caar x) (cadar lil) 1e-6))) pla)
            (cond
              ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (append (apply (function append) errlis) (mapcar (function caar) plaal))))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                (setq ipll ipllx)
              )
              ( t
                (cond
                  ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (apply (function append) errlis)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                    (setq ipll ipllx)
                  )
                  ( t
                    (cond
                      ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function caar) plaal)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                        (setq ipll ipllx)
                      )
                      ( t
                        (setq ipll (car-sort (vl-remove nil ipll) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (< (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                      )
                    )
                  )
                )
              )
            )
          )
          ( t
            (cond
              ( lil
                (cond
                  ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (append (apply (function append) errlis) (mapcar (function caar) plaal))))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                    (setq ipll ipllx)
                  )
                  ( t
                    (cond
                      ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (apply (function append) errlis)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                        (setq ipll ipllx)
                      )
                      ( t
                        (cond
                          ( (setq ipllx (car-sort (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function caar) plaal)))) (vl-remove nil ipll)) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                            (setq ipll ipllx)
                          )
                          ( t
                            (setq ipll (car-sort (vl-remove nil ipll) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b))) (equal c d 1e-6)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (if (or (null c) (null d)) (> (distance (cadar lil) (caaar a)) (distance (cadar lil) (caaar b))) (< c d)))))))
                          )
                        )
                      )
                    )
                  )
                )
              )
              ( t
                (setq ipll (car-sort (vl-remove nil ipll) (function (lambda ( a b / c d ) (if (and (setq c (correctplanedist (car a))) (setq d (correctplanedist (car b)))) (< c d) (< (distance (caaar a) (vlax-curve-getclosestpointto lw (caaar a))) (distance (caaar b) (vlax-curve-getclosestpointto lw (caaar b)))))))))
              )
            )
          )
        )
        ipll
      )
      ( (= defaultsort 10)
        (cond
          ( (and (offd (caaaar (vl-remove nil ipll)) utl) (offd (caaaar (cdr (vl-remove nil ipll))) utl))
            (car-sort (vl-remove nil ipll) (function (lambda ( a b ) (< (offd (caaar a) utl) (offd (caaar b) utl)))))
          )
          ( t
            (car (vl-remove nil ipll))
          )
        )
      )
    )
  )

  (defun processplaa ( pla )
    (setq ipl (processipl pla))
    (processipll nil)
  )

  (defun processplaa-x ( pla )
    (setq ipl (processipl pla))
    (setq ipl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function cadr) errlis)))) ipl))
    (processipll nil)
  )

  (defun processend nil
    (cond
      ( (< 2 (length (unioncollinearplaneprints (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa))))))
        (cond
          ( (not (vl-every (function (lambda ( x ) (vl-some (function (lambda ( y ) (or (equal y (caaar (cddddr x)) 1e-6) (equal y (caaadr (cddddr x)) 1e-6)))) pl))) plaa))
            (setq pla (vl-remove-if (function (lambda ( z ) (vl-some (function (lambda ( x ) (equal (caar x) (caar z) 1e-6))) plaa))) pla))
          )
          ( t
            (cond
              ( (and (= 3 (length (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa))))) (vl-some (function (lambda ( x ) (null (cadddr x)))) plaa))
                (setq pla (vl-remove-if (function (lambda ( z ) (vl-some (function (lambda ( x ) (equal (caar x) (caar z) 1e-6))) plaa))) pla))
              )
              ( (= 3 (length (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa)))))
                nil
              )
              ( t
                (setq pla (vl-remove-if (function (lambda ( z ) (vl-some (function (lambda ( x ) (equal (caar x) (caar z) 1e-6))) plaa))) pla))
                (setq x1 (car plaa))
                (setq x2 (last plaa))
                (cond
                  ( (vl-some (function (lambda ( x ) (not (vl-position (caar x) pl)))) (cddddr (vl-some (function (lambda ( y ) (if (or (not (vl-position (caaar (cddddr y)) pl)) (not (vl-position (caaadr (cddddr y)) pl))) y))) plaa)))
                    (setq pla (append pla (apply (function append) (mapcar (function cddddr) plaa))))
                    (setq errpts (cons (caaar plaa) errpts))
                  )
                )
                (setq xx (list (list (caar x1) (if (setq ip (inters (car (cadr x1)) (cadr (cadr x1)) (car (caddr x2)) (cadr (caddr x2)) nil)) (angle (caar x1) ip) (angle (car (cadr x1)) (cadr (cadr x1))))) (cadr x1) (caddr x2) nil (car (cddddr x1)) (cadr (cddddr x2))))
                (setq pla (cons xx pla))
              )
            )
          )
        )
      )
      ( t
        (cond
          ( (= 3 (length (unique (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa)))))
            (cond
              ( (setq xxx (vl-some (function (lambda ( x ) (if (= (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa)))) 2) x))) (apply (function append) (mapcar (function (lambda ( x ) (list (list (caar x) (caaar (cddddr x))) (list (caar x) (caaadr (cddddr x)))))) plaa))))
                (setq pla (cons (car (vl-remove-if (function (lambda ( x ) (equal (caar x) (car (vl-remove (caaar plaa) xxx)) 1e-6))) (append (cddddr (car plaa)) (cddddr (cadr plaa))))) pla))
              )
            )
          )
        )
      )
    )
  )

  (defun process ( processplafun / a1 a2 nn mm b1 b2 jj hh )
    (while (> n 0)
      (cond
        ( (null plaa)
          (setq ipl (processipl pla))
          (setq ipl (vl-remove-if (function (lambda ( x ) (null (cadar x)))) ipl))
          (setq ipldl (mapcar (function (lambda ( x ) (list (correctplanedist x) x))) ipl))
          (setq pla1 (cadr (car-sort (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl) (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr a) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))) (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr b) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl)))) (< (car a) (car b))))))))
          (setq plaa (_vl-sort (mapcar (function cadr) (vl-remove-if-not (function (lambda ( x ) (equal (caar pla1) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))) (function (lambda ( a b / aa bb n m ) (if (or (null (cadddr a)) (null (cadddr b))) (if (or (not (vl-some (function (lambda ( x ) (or (equal x (caaar (cddddr a)) 1e-6) (equal x (caaadr (cddddr a)) 1e-6)))) pl)) (not (vl-some (function (lambda ( x ) (or (equal x (caaar (cddddr b)) 1e-6) (equal x (caaadr (cddddr b)) 1e-6)))) pl))) (< (max (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (max (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))) (progn (setq aa (cond ( (and (setq a1 (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr a)) 1e-6) x))) pl)) (setq a2 (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr a)) 1e-6) x))) pl))) (car-sort (list a1 a2) (function (lambda ( c d ) (< (vl-some (function (lambda ( q ) (setq nn (if (null nn) 0 (1+ nn))) (if (equal q c 1e-6) nn))) (append pl pl)) (vl-some (function (lambda ( q ) (setq mm (if (null mm) 0 (1+ mm))) (if (equal q d 1e-6) mm))) (append pl pl)))))) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr a)) 1e-6) x))) pl) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr a)) 1e-6) x))) pl) ) )) (setq bb (cond ( (and (setq b1 (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr b)) 1e-6) x))) pl)) (setq b2 (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr b)) 1e-6) x))) pl))) (car-sort (list b1 b2) (function (lambda ( c d ) (< (vl-some (function (lambda ( q ) (setq jj (if (null jj) 0 (1+ jj))) (if (equal q c 1e-6) jj))) (append pl pl)) (vl-some (function (lambda ( q ) (setq hh (if (null hh) 0 (1+ hh))) (if (equal q d 1e-6) hh))) (append pl pl)))))) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr b)) 1e-6) x))) pl) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr b)) 1e-6) x))) pl) ) )) (setq a1 nil a2 nil nn nil mm nil b1 nil b2 nil jj nil hh nil) (< (vl-some (function (lambda ( q ) (setq n (if (null n) 0 (1+ n))) (if (equal q aa 1e-6) n))) (append pl pl)) (vl-some (function (lambda ( q ) (setq m (if (null m) 0 (1+ m))) (if (equal q bb 1e-6) m))) (append pl pl))))) (< (vl-some (function (lambda ( q ) (setq n (if (null n) 0 (1+ n))) (if (equal q (cadddr a) 1e-6) n))) (append tl tl)) (vl-some (function (lambda ( q ) (setq m (if (null m) 0 (1+ m))) (if (equal q (cadddr b) 1e-6) m))) (append tl tl))))))))
          (if (not (vl-every (function (lambda ( x ) (equal (caar x) (caaar plaa) 1e-6))) plaa))
            (setq plaa (list (car plaa)))
          )
        )
        ( t
          (cond
            ( (equal plaa (setq plaa (unique (apply processplafun (list (setq pla (unique pla)))))) 1e-6)
              (setq n 0)
            )
          )
        )
      )
      (cond
        ( (and (car plaa) (vl-every (function (lambda ( x ) (cadar x))) plaa))
          (foreach pla1 (reverse plaa)
            (cond
              ( (not (vl-some (function (lambda ( x ) (equal pla1 x 1e-6))) pla))
                (setq pla (cons pla1 pla))
              )
            )
          )
        )
        ( t
          (setq n 0)
        )
      )
      (cond
        ( plaa
          (cond
            ( (= (length plaa) 1)
              (setq x (caaar (cddddr (car plaa))))
              (setq y (caaadr (cddddr (car plaa))))
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) x) 1e-6))) lil)))
                  (cond
                    ( (not (equal x (caaar plaa) 1e-6))
                      (setq lil (cons (list x (caaar plaa)) lil))
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                    )
                  )
                )
              )
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) y) 1e-6))) lil)))
                  (cond
                    ( (not (equal y (caaar plaa) 1e-6))
                      (setq lil (cons (list y (caaar plaa)) lil))
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                    )
                  )
                )
              )
            )
            ( t
              (foreach pla1 plaa
                (setq x (caaar (cddddr pla1)))
                (setq y (caaadr (cddddr pla1)))
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) x) 1e-6))) lil)))
                    (cond
                      ( (not (equal x (caar pla1) 1e-6))
                        (setq lil (cons (list x (caar pla1)) lil))
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                      )
                    )
                  )
                )
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) y) 1e-6))) lil)))
                    (cond
                      ( (not (equal y (caar pla1) 1e-6))
                        (setq lil (cons (list y (caar pla1)) lil))
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                      )
                    )
                  )
                )
              )
              (processend)
            )
          )
        )
      )
    )
  )

  (defun processplaa-n ( pla )
    (setq ipl (processipl pla))
    (setq ipl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar x) y 1e-6))) (mapcar (function cadr) errlis)))) ipl))
    (processipll mode)
  )

  (defun process-n ( processplafun / a1 a2 nn mm b1 b2 jj hh )
    (while (and (> n 0) (null flag))
      (setq plaox pla lilxplaoxl nil)
      (cond
        ( (null plaa)
          (setq ipl (processipl pla))
          (setq ipl (vl-remove-if (function (lambda ( x ) (null (cadar x)))) ipl))
          (setq ipldl (mapcar (function (lambda ( x ) (list (correctplanedist x) x))) ipl))
          (setq ipld (mapcar (function cadr) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl)))
          (while (setq pla1 (car ipld))
            (setq ipldd (cons (vl-remove-if-not (function (lambda ( x ) (equal (caar pla1) (caar x) 1e-6))) ipld) ipldd))
            (setq ipld (vl-remove-if (function (lambda ( x ) (equal (caar pla1) (caar x) 1e-6))) ipld))
          )
          (setq maxlen (length (car-sort ipldd (function (lambda ( a b ) (> (length a) (length b)))))))
          (if (> maxlen 1)
            (setq mode t)
          )
          (setq pla1 (cadr (car-sort (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl) (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr a) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))) (length (vl-remove-if-not (function (lambda ( x ) (equal (caaadr b) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl)))) (< (car a) (car b))))))))
          (setq plaa (_vl-sort (mapcar (function cadr) (vl-remove-if-not (function (lambda ( x ) (equal (caar pla1) (caaadr x) 1e-6))) (vl-remove-if (function (lambda ( x ) (null (car x)))) ipldl))) (function (lambda ( a b / aa bb n m ) (if (or (null (cadddr a)) (null (cadddr b))) (if (or (not (vl-some (function (lambda ( x ) (or (equal x (caaar (cddddr a)) 1e-6) (equal x (caaadr (cddddr a)) 1e-6)))) pl)) (not (vl-some (function (lambda ( x ) (or (equal x (caaar (cddddr b)) 1e-6) (equal x (caaadr (cddddr b)) 1e-6)))) pl))) (< (max (distance (caar a) (caaar (cddddr a))) (distance (caar a) (caaadr (cddddr a)))) (max (distance (caar b) (caaar (cddddr b))) (distance (caar b) (caaadr (cddddr b))))) (progn (setq aa (cond ( (and (setq a1 (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr a)) 1e-6) x))) pl)) (setq a2 (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr a)) 1e-6) x))) pl))) (car-sort (list a1 a2) (function (lambda ( c d ) (< (vl-some (function (lambda ( q ) (setq nn (if (null nn) 0 (1+ nn))) (if (equal q c 1e-6) nn))) (append pl pl)) (vl-some (function (lambda ( q ) (setq mm (if (null mm) 0 (1+ mm))) (if (equal q d 1e-6) mm))) (append pl pl)))))) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr a)) 1e-6) x))) pl) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr a)) 1e-6) x))) pl) ) )) (setq bb (cond ( (and (setq b1 (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr b)) 1e-6) x))) pl)) (setq b2 (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr b)) 1e-6) x))) pl))) (car-sort (list b1 b2) (function (lambda ( c d ) (< (vl-some (function (lambda ( q ) (setq jj (if (null jj) 0 (1+ jj))) (if (equal q c 1e-6) jj))) (append pl pl)) (vl-some (function (lambda ( q ) (setq hh (if (null hh) 0 (1+ hh))) (if (equal q d 1e-6) hh))) (append pl pl)))))) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaar (cddddr b)) 1e-6) x))) pl) ) ( (vl-some (function (lambda ( x ) (if (equal x (caaadr (cddddr b)) 1e-6) x))) pl) ) )) (setq a1 nil a2 nil nn nil mm nil b1 nil b2 nil jj nil hh nil) (< (vl-some (function (lambda ( q ) (setq n (if (null n) 0 (1+ n))) (if (equal q aa 1e-6) n))) (append pl pl)) (vl-some (function (lambda ( q ) (setq m (if (null m) 0 (1+ m))) (if (equal q bb 1e-6) m))) (append pl pl))))) (< (vl-some (function (lambda ( q ) (setq n (if (null n) 0 (1+ n))) (if (equal q (cadddr a) 1e-6) n))) (append tl tl)) (vl-some (function (lambda ( q ) (setq m (if (null m) 0 (1+ m))) (if (equal q (cadddr b) 1e-6) m))) (append tl tl))))))))
          (if (not (vl-every (function (lambda ( x ) (equal (caar x) (caaar plaa) 1e-6))) plaa))
            (setq plaa (list (car plaa)))
          )
        )
        ( t
          (cond
            ( (equal plaa (setq plaa (unique (apply processplafun (list (setq pla (unique pla)))))) 1e-6)
              (setq n 0)
            )
          )
        )
      )
      (cond
        ( plaa
          (setq plaal (cons plaa plaal))
        )
      )
      (setq lil (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) errlis))) lil))
      (setq closed (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) lil))) closed))
      (cond
        ( merrlis
          (cond
            ( (and plaa (= (length plaa) 1))
              (setq plaoxl (cons (list plaa plaox) plaoxl))
              (setq lill (cons (list plaa lil) lill))
            )
            ( t
              (cond
                ( plaa
                  (foreach pla1 plaa
                    (setq plaoxl (cons (list pla1 plaox) plaoxl))
                    (setq lill (cons (list pla1 lil) lill))
                  )
                )
              )
            )
          )
        )
      )
      (cond
        ( (and (car plaa) (vl-every (function (lambda ( x ) (cadar x))) plaa))
          (foreach pla1 (reverse plaa)
            (cond
              ( (not (vl-some (function (lambda ( x ) (equal pla1 x 1e-6))) pla))
                (setq pla (cons pla1 pla))
              )
            )
          )
        )
        ( t
          (setq n (length utl))
          (cond
            ( (and (test) (not (chklili lil)) (<= n (length lil)))
              (setq n 0)
            )
            ( t
              (foreach pla1 pla
                (cond
                  ( (setq ip (vl-some (function (lambda ( x ) (if (or (equal (angle (caar pla1) x) (cadar pla1) 1e-6) (equal (angle x (caar pla1)) (cadar pla1) 1e-6)) x))) (mapcar (function cadr) lil)))
                    (cond
                      ( (and (not (vl-some (function (lambda ( z ) (equal z (list (caar pla1) ip) 1e-6))) lil)) (not (vl-some (function (lambda ( z ) (equal z (list ip (caar pla1)) 1e-6))) lil)))
                        (setq lil (cons (list (caar pla1) ip) lil))
                      )
                    )
                  )
                )
              )
              (cond
                ( (and (test) (not (chklili lil)) (<= n (length lil)))
                  (setq n 0)
                )
                ( t
                  (setq op (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal (caar y) (cadr x) 1e-6))) pla))) closed))
                  (setq op (vl-some (function (lambda ( x ) (vl-some (function (lambda ( y ) (if (and (setq ip (inters (polar (caar y) (cadar y) 1e+6) (polar (caar y) (cadar y) -1e+6) (car x) (cadr x))) (not (equal ip (car x) 1e-6)) (not (equal ip (cadr x) 1e-6))) y))) pla))) op))
                  (setq op (vl-remove-if-not (function (lambda ( x ) (equal (caar op) (cadr x) 1e-6))) closed))
                  (cond
                    ( op
                      (setq errlis (append op errlis))
                    )
                  )
                  (cond
                    ( (and errlis (not (vl-some (function (lambda ( x ) (equal x errlis 1e-6))) errll)))
                      (setq errll (cons errlis errll) flag t)
                    )
                    ( t
                      (cond
                        ( (< (length pass) index)
                          (setq pass (cons t pass) flag t)
                        )
                        ( t
                          (setq flag nil n 0)
                        )
                      )
                    )
                  )
                )
              )
            )
          )
        )
      )
      (cond
        ( plaa
          (cond
            ( (= (length plaa) 1)
              (setq x (caaar (cddddr (car plaa))))
              (setq y (caaadr (cddddr (car plaa))))
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) x) 1e-6))) lil)))
                  (setq lilo lil errli nil)
                  (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters x (caaar plaa) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                    (cond
                      ( (and errli (not (equal ip x 1e-6)) (not (equal ip (caaar plaa) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                        (setq errlis (cons errli errlis) errlis (cons (list x (caaar plaa)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                      )
                    )
                  )
                  (cond
                    ( (and (null flag) (not (equal x (caaar plaa) 1e-6)))
                      (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline x (caar z) (caaar plaa)) (not (equal x (caar z) 1e-6)) (not (equal (caaar plaa) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline x q (caaar plaa)) (not (equal x q 1e-6)) (not (equal (caaar plaa) q 1e-6))) q))) (apply (function append) lil)) ))))
                        (cond
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list x ip) lil) lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)))
                            (setq lil (cons (list x ip) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (not ip)
                            (setq lil (cons (list x (caaar plaa)) lil))
                          )
                        )
                        (setq lil (cons (list x (caaar plaa)) lil))
                      )
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                      (setq closed (cons (list x (caaar plaa)) closed))
                    )
                  )
                )
              )
              (cond
                ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caaar plaa)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caaar plaa) y) 1e-6))) lil)))
                  (setq lilo lil errli nil)
                  (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters y (caaar plaa) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                    (cond
                      ( (and errli (not (equal ip y 1e-6)) (not (equal ip (caaar plaa) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                        (setq errlis (cons errli errlis) errlis (cons (list y (caaar plaa)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                      )
                    )
                  )
                  (cond
                    ( (and (null flag) (not (equal y (caaar plaa) 1e-6)))
                      (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline y (caar z) (caaar plaa)) (not (equal y (caar z) 1e-6)) (not (equal (caaar plaa) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline y q (caaar plaa)) (not (equal y q 1e-6)) (not (equal (caaar plaa) q 1e-6))) q))) (apply (function append) lil)) ))))
                        (cond
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list y ip) lil) lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)))
                            (setq lil (cons (list y ip) lil))
                          )
                          ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caaar plaa)) 1e-6) (equal z (list (caaar plaa) ip) 1e-6)))) lil)))
                            (setq lil (cons (list ip (caaar plaa)) lil))
                          )
                          ( (not ip)
                            (setq lil (cons (list y (caaar plaa)) lil))
                          )
                        )
                        (setq lil (cons (list y (caaar plaa)) lil))
                      )
                      (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                      (setq closed (cons (list y (caaar plaa)) closed))
                    )
                  )
                )
              )
            )
            ( t
              (foreach pla1 plaa
                (setq x (caaar (cddddr pla1)))
                (setq y (caaadr (cddddr pla1)))
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list x (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) x) 1e-6))) lil)))
                    (setq lilo lil errli nil)
                    (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters x (caar pla1) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                      (cond
                        ( (and errli (not (equal ip x 1e-6)) (not (equal ip (caar pla1) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                          (setq errlis (cons errli errlis) errlis (cons (list x (caar pla1)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                        )
                      )
                    )
                    (cond
                      ( (and (null flag) (not (equal x (caar pla1) 1e-6)))
                        (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline x (caar z) (caar pla1)) (not (equal x (caar z) 1e-6)) (not (equal (caar pla1) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline x q (caar pla1)) (not (equal x q 1e-6)) (not (equal (caar pla1) q 1e-6))) q))) (apply (function append) lil)) ))))
                          (cond
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list x ip) lil) lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list x ip) 1e-6) (equal z (list ip x) 1e-6)))) lil)))
                              (setq lil (cons (list x ip) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (not ip)
                              (setq lil (cons (list x (caar pla1)) lil))
                            )
                          )
                          (setq lil (cons (list x (caar pla1)) lil))
                        )
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal x (caar z) 1e-6))) pla))
                        (setq closed (cons (list x (caar pla1)) closed))
                      )
                    )
                  )
                )
                (cond
                  ( (not (or (vl-some (function (lambda ( z ) (equal z (list y (caar pla1)) 1e-6))) lil) (vl-some (function (lambda ( z ) (equal z (list (caar pla1) y) 1e-6))) lil)))
                    (setq lilo lil errli nil)
                    (while (setq errli (vl-some (function (lambda ( a ) (if (setq ip (inters y (caar pla1) (car a) (cadr a))) a))) (setq lilo (vl-remove errli lilo))))
                      (cond
                        ( (and errli (not (equal ip y 1e-6)) (not (equal ip (caar pla1) 1e-6)) (not (equal ip (car errli) 1e-6)) (not (equal ip (cadr errli) 1e-6)))
                          (setq errlis (cons errli errlis) errlis (cons (list y (caar pla1)) errlis) plaox (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse plaoxl))) lilx (cadr (vl-some (function (lambda ( x ) (if (or (equal (car errli) (caaar (cddddr (caar x))) 1e-6) (equal (car errli) (caaadr (cddddr (caar x))) 1e-6)) x))) (reverse lill))) lilxplaoxl (cons (list lilx plaox) lilxplaoxl) flag t)
                        )
                      )
                    )
                    (cond
                      ( (and (null flag) (not (equal y (caar pla1) 1e-6)))
                        (if (and mode (setq ip (cond ( (vl-some (function (lambda ( z ) (if (and (3pline y (caar z) (caar pla1)) (not (equal y (caar z) 1e-6)) (not (equal (caar pla1) (caar z) 1e-6))) (caar z)))) iplx) ) ( (vl-some (function (lambda ( q ) (if (and (3pline y q (caar pla1)) (not (equal y q 1e-6)) (not (equal (caar pla1) q 1e-6))) q))) (apply (function append) lil)) ))))
                          (cond
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)) (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list y ip) lil) lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list y ip) 1e-6) (equal z (list ip y) 1e-6)))) lil)))
                              (setq lil (cons (list y ip) lil))
                            )
                            ( (and ip (not (vl-some (function (lambda ( z ) (or (equal z (list ip (caar pla1)) 1e-6) (equal z (list (caar pla1) ip) 1e-6)))) lil)))
                              (setq lil (cons (list ip (caar pla1)) lil))
                            )
                            ( (not ip)
                              (setq lil (cons (list y (caar pla1)) lil))
                            )
                          )
                          (setq lil (cons (list y (caar pla1)) lil))
                        )
                        (setq pla (vl-remove-if (function (lambda ( z ) (equal y (caar z) 1e-6))) pla))
                        (setq closed (cons (list y (caar pla1)) closed))
                      )
                    )
                  )
                )
              )
              (processend)
            )
          )
        )
        ( t
          (cond
            ( merrlis
              (setq flag t fflag t)
            )
          )
        )
      )
    )
  )

  (defun postprocess ( / chk )
    (setq flag t loop t lil nil plaa nil errpts nil pass nil pla plao merrlis t)
    (while (and flag loop)
      (setq n (length utl) flag nil)
      (process-n (function processplaa-n))
      (cond
        ( fflag
          (setq flag nil)
        )
      )
      (cond
        ( (and lilxplaoxl (null fflag))
          (setq lilxplaoxl (reverse lilxplaoxl) lilxplaoxl (vl-some (function (lambda ( x ) (if (= (length (car x)) (apply (function min) (mapcar (function length) (mapcar (function car) lilxplaoxl)))) x))) lilxplaoxl) lil (car lilxplaoxl) pla (cadr lilxplaoxl) plaa (caadr (vl-member-if (function (lambda ( x ) (equal pla (cadr x) 1e-6))) plaoxl)) lill (vl-member-if (function (lambda ( x ) (equal plaa (car x) 1e-6))) lill) plaoxl (vl-member-if (function (lambda ( x ) (equal plaa (car x) 1e-6))) plaoxl) lilxplaoxl nil)
        )
      )
    )
    (setq lil (uniquelil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil)))
    (setq n (length utl))
    (cond
      ( (and (null qqq) lil (test) (not (chklili lil)) (<= n (length lil)))
        (cond
          ( (not (chklilinlillst lil lillst))
            (setq lillst (cons lil lillst) qqq t)
          )
        )
        (setq chk t)
      )
    )
    (cond
      ( (null chk)
        (setq flag t loop t plaal nil fflag nil merrlis nil errliso nil liloo nil)
        (while (and flag loop)
          (setq lil nil n (length utl) pla plao plaa nil flag nil closed nil errpts nil pass nil)
          (process-n (function processplaa-n))
          (cond
            ( fflag
              (setq flag nil)
            )
          )
          (cond
            ( (equal liloo lil 1e-6)
              (setq errlis (reverse (cdr (reverse (unique errlis)))))
            )
            ( t
              (setq liloo lil)
            )
          )
          (cond
            ( (and flag (null errlis))
              (setq loop nil)
            )
          )
        )
        (cond
          ( (or (null flag) (null loop))
            (setq lil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil))
            (setq n (length utl))
            (cond
              ( (and (null qqq) lil (test) (not (chklili lil)) (<= n (length lil)))
                (cond
                  ( (not (chklilinlillst lil lillst))
                    (setq lillst (cons lil lillst) qqq t)
                  )
                )
                (setq loop nil chk t)
              )
            )
          )
        )
      )
    )
  )

  (defun processing ( casex ipl1sortx defaultsortx )
    (setq case casex ipl1sort ipl1sortx defaultsort defaultsortx)
    (setq lil nil plaa nil errpts nil pass nil qqq nil n (length utl) pla plao)
    (process (function processplaa))
    (setq lil (uniquelil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil)))
    (setq lixl (vl-remove-if-not (function (lambda ( x ) (> (length (vl-remove-if-not (function (lambda ( y ) (and (setq ip (inters (car x) (cadr x) (car y) (cadr y))) (not (equal ip (car x) 1e-6)) (not (equal ip (cadr x) 1e-6)) (not (equal ip (car y) 1e-6)) (not (equal ip (cadr y) 1e-6))))) (vl-remove x lil))) 1))) lil))
    (foreach lix lixl
      (foreach li (vl-remove lix lil)
        (cond
          ( (and (setq ip (inters (car lix) (cadr lix) (car li) (cadr li))) (not (equal ip (car lix) 1e-6)) (not (equal ip (cadr lix) 1e-6)) (not (equal ip (car li) 1e-6)) (not (equal ip (cadr li) 1e-6)))
            (setq errlis (cons li errlis))
          )
        )
      )
    )
    (setq n (length utl))
    (cond
      ( (and (null qqq) lil (test) (not (chklili lil)) (<= n (length lil)))
        (cond
          ( (not (chklilinlillst lil lillst))
            (setq lillst (cons lil lillst) qqq t)
          )
        )
      )
      ( t
        (cond
          ( errlis
            (setq lil nil plaa nil errpts nil pass nil n (length utl) pla plao)
            (process (function processplaa-x))
            (setq lil (uniquelil (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-6))) lil)))
            (setq errlis nil errll nil)
            (setq n (length utl))
            (cond
              ( (and lil (test) (not (chklili lil)) (<= n (length lil)))
                (cond
                  ( (not (chklilinlillst lil lillst))
                    (setq lillst (cons lil lillst) qqq t)
                  )
                )
              )
              ( t
                (postprocess)
              )
            )
          )
          ( t
            (postprocess)
          )
        )
      )
    )
    (setq return (list case ipl1sort defaultsort))
    (princ "\n")
    (princ return)
  )

  (setq cmde (getvar (quote cmdecho)))
  (setvar (quote cmdecho) 0)
  (or (and cad doc alo spc) (vl-load))
  (while (= 8 (logand 8 (getvar (quote undoctl))))
    (cond
      ( doc
        (vla-endundomark doc)
      )
      ( t
        (cond
          ( command-s
            (command-s "_.UNDO" "_E")
          )
          ( t
            (vl-cmdf "_.UNDO" "_E")
          )
        )
      )
    )
  )
  (cond
    ( doc
      (vla-startundomark doc)
    )
    ( t
      (cond
        ( command-s
          (command-s "_.UNDO" "_BE")
        )
        ( t
          (vl-cmdf "_.UNDO" "_BE")
        )
      )
    )
  )
  (cond
    ( (= 0 (getvar (quote worlducs)))
      (cond
        ( command-s
          (command-s "_.UCS" "_W")
        )
        ( t
          (vl-cmdf "_.UCS" "_W")
        )
      )
    )
  )
  (prompt "\nPick closed polygonal LWPOLYLINE...")
  (cond
    ( (setq s (ssget "_+.:E:S" (list (cons 0 "LWPOLYLINE") (cons -4 "&=") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
      (while (null lils)
        (prompt "\nSelect initial solution LINES...")
        (setq lils (ssget (list (cons 0 "LINE"))))
        (cond
          ( lils
            (setq lils (mapcar (function (lambda ( x ) (mapcar (function (lambda ( y ) (mapcar (function +) (list 0.0 0.0) (cdr y)))) (vl-remove-if-not (function (lambda ( z ) (vl-position (car z) (list 10 11)))) (entget x))))) (vl-remove-if (function listp) (mapcar (function cadr) (ssnamex lils)))))
            (setq lillst (cons lils lillst))
          )
        )
      )
      (initget 4)
      (setq index (getint "\nSpecify solutions search index - greater number (slower/more solutions); smaller number (faster/less solutions) <0> : "))
      (cond
        ( (null index)
          (setq index 0)
        )
      )
      (setq startcomb (getpoint "\nEnter start combination (case,ipl1sort,defaultsort) - ENTER FOR LAST EXIT COMBINATION +1 - FOR FRESH START JUST TYPE 0,0,0 : "))
      (cond
        ( startcomb
          (setq startcomb (mapcar (function fix) startcomb))
        )
        ( t
          (cond
            ( return
              (cond
                ( (> (1+ (caddr return)) 10)
                  (exit)
                )
                ( t
                  (cond 
                    ( (> (1+ (cadr return)) 10)
                      (exit)
                    )
                    ( t
                      (cond
                        ( (> (1+ (car return)) 2)
                          (prompt "\nYou can't start from last exit combination... Quitting...")
                          (exit)
                        )
                        ( t
                          (setq startcomb (list (1+ (car return)) 0 0))
                        )
                      )
                    )
                    ( t
                      (setq startcomb (list (car return) (1+ (cadr return)) 0))
                    )
                  )
                )
                ( t
                  (setq startcomb (list (car return) (cadr return) (1+ (caddr return))))
                )
              )
            )
            ( t
              (setq startcomb (list 0 0 0))
            )
          )
        )
      )
      (cond
        ( (null startcomb)
          (setq startcomb (list 0 0 0))
        )
      )
      (cond
        ( startcomb
          (while (and startcomb (or (/= (length startcomb) 3) (not (< -1 (car startcomb) 3)) (not (< -1 (cadr startcomb) 11)) (not (< -1 (caddr startcomb) 11))))
            (prompt "\nInvalid specification of start combination (case must be between -1 and 3), (ipl1sort must be between -1 and 11), (defaultsort must be between -1 and 11)...")
            (setq startcomb (getpoint "\nEnter start combination (case ipl1sort defaultsort) - ENTER FOR LAST EXIT COMBINATION +1 - FOR FRESH START JUST TYPE 0,0,0 : "))
            (cond
              ( startcomb
                (setq startcomb (mapcar (function fix) startcomb))
              )
              ( t
                (cond
                  ( return
                    (cond
                      ( (> (1+ (caddr return)) 10)
                        (exit)
                      )
                      ( t
                        (cond 
                          ( (> (1+ (cadr return)) 10)
                            (exit)
                          )
                          ( t
                            (cond
                              ( (> (1+ (car return)) 2)
                                (prompt "\nYou can't start from last exit combination... Quitting...")
                                (exit)
                              )
                              ( t
                                (setq startcomb (list (1+ (car return)) 0 0))
                              )
                            )
                          )
                          ( t
                            (setq startcomb (list (car return) (1+ (cadr return)) 0))
                          )
                        )
                      )
                      ( t
                        (setq startcomb (list (car return) (cadr return) (1+ (caddr return))))
                      )
                    )
                  )
                  ( t
                    (setq startcomb (list 0 0 0))
                  )
                )
              )
            )
          )
        )
      )
      (cond
        ( (null startcomb)
          (setq startcomb (list 0 0 0))
        )
      )
      (setq comb (getpoint "\nEnter exit combination (case,ipl1sort,defaultsort) - ENTER FOR COMPLETE SEARCH : "))
      (cond
        ( comb
          (setq comb (mapcar (function fix) comb))
        )
      )
      (cond
        ( comb
          (while (and comb (or (/= (length comb) 3) (< (car comb) (car startcomb)) (and (>= (car comb) (car startcomb)) (< (caddr comb) (caddr startcomb))) (and (>= (car comb) (car startcomb)) (>= (caddr comb) (caddr startcomb)) (< (caddr comb) (caddr startcomb))) (not (< -1 (car comb) 3)) (not (< -1 (cadr comb) 11)) (not (< -1 (caddr comb) 11))))
            (prompt "\nInvalid specification of exit combination [(case must be between -1 and 3),(ipl1sort must be between -1 and 11),(defaultsort must be between -1 and 11)] - also combination list must be greater than start combination list...")
            (setq comb (getpoint "\nEnter exit combination (case,ipl1sort,defaultsort) : "))
            (cond
              ( comb
                (setq comb (mapcar (function fix) comb))
              )
            )
          )
        )
      )
      (setq ti (car (_vl-times)))
      (setq lwx (entget (setq lw (ssname s 0))))
      (setq lwi (vlax-vla-object->ename (car (vlax-invoke (vlax-ename->vla-object lw) 'offset 0.001))))
      (cond
        ( (< (vlax-curve-getarea lw) (vlax-curve-getarea lwi))
          (entdel lwi)
          (setq lwi (vlax-vla-object->ename (car (vlax-invoke (vlax-ename->vla-object lw) 'offset -0.001))))
          (setq pl (mapcar (function (lambda ( p ) (mapcar (function +) (list 0 0) (trans p lw 0)))) (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) lwx))))
        )
        ( t
          (setq pl (reverse (mapcar (function (lambda ( p ) (mapcar (function +) (list 0 0) (trans p lw 0)))) (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) lwx)))))
        )
      )
      (setq pl (append pl (list (car pl))))
      (setq tl (mapcar (function (lambda ( a b ) (list a b))) (reverse (cdr (reverse pl))) (cdr pl)))
      (setq pla (mapcar (function (lambda ( p mp ) (list p (angle p mp)))) pl (mapcar (function (lambda ( a b ) (cond ( (collinear-pp (car a) (car b) (cadr b)) (vlax-curve-getclosestpointto lwi (car b)) ) ( t (if (clockwise-p (car a) (car b) (cadr b)) (mid (polar (cadr a) (angle (cadr a) (car a)) -1.0) (polar (car b) (angle (car b) (cadr b)) -1.0)) (mid (polar (cadr a) (angle (cadr a) (car a)) 1.0) (polar (car b) (angle (car b) (cadr b)) 1.0))) )))) (cons (last tl) tl) tl)))
      (setq pla (mapcar (function (lambda ( a pla b ) (list pla a b))) (cons (last tl) tl) pla tl))
      (setq plao pla)
      (setq dx (- (car (car-sort pl (function (lambda ( a b ) (> (car a) (car b)))))) (car (car-sort pl (function (lambda ( a b ) (< (car a) (car b))))))))
      (setq ll (findlinesbetweentl tl))
      (setq n (length (setq utl (unioncollinearplaneprints tl))))
      (while (null done)
        (setq lillsto lillst)
        (cond
          ( (and (null case) (null ipl1sort) (null defaultsort))
            (setq case (car startcomb) ipl1sort (cadr startcomb) defaultsort (caddr startcomb))
          )
        )
        (processing case ipl1sort defaultsort)
        (cond
          ( (and comb (= case (car comb)) (= ipl1sort (cadr comb)) (= defaultsort (caddr comb)))
            (setq done t)
          )
        )
        (setq defaultsort (1+ defaultsort))
        (cond
          ( (= defaultsort 11)
            (setq defaultsort 0 ipl1sort (1+ ipl1sort))
            (cond
              ( (= ipl1sort 11)
                (setq ipl1sort 0 case (1+ case))
              )
            )
          )
        )
        (cond
          ( (not (equal lillsto lillst 1e-6))
            (setq k (if (null k) 1 (1+ k)))
            (entupd (vlax-vla-object->ename (vla-copy (vlax-ename->vla-object lw))))
            (vla-move (vlax-ename->vla-object (entlast)) (vlax-3d-point (list 0.0 0.0 0.0)) (vlax-3d-point (list (* k dx) 0.0 0.0)))
            (setq lil (reverse (car lillst)))
            (foreach li lil
              (entupd (entmakex (list (cons 0 "LINE") (cons 10 (mapcar (function +) (list (* k dx) 0.0) (car li))) (cons 11 (mapcar (function +) (list (* k dx) 0.0) (cadr li))) (cons 62 (1+ k)))))
            )
            (setq lils (uniquelilident (apply (function append) lillst)) errlis nil)
          )
        )
        (cond
          ( (= case 3)
            (cond
              ( (cdr lillst)
                (setq qq t)
              )
            )
            (setq done t return nil k nil lils nil lillst nil)
          )
        )
      )
    )
  )
  (*error* nil)
)
