(defun c:roof-2d-short ( / *error* unit inside-p car-sort dist rem_coll_pts getlwpts vxv listcollinear-p collinear-p collinearlilchk cichk clockwiselw-p clockwise-p chkttt liloverlapchk processchk unique uniquelil uniquetll freepts ptss process lilchk
                           adoc osm cmd fuzz s ti lw lwl pl pll tll ttll ppl ppll ppllo ppllx pplll lil lil1 lil2 pts p1 p2 xx qq li si ff m )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if osm (setvar (quote osmode) osm))
    (if cmd (setvar (quote cmdecho) cmd))
    (if (and lwl (not (vlax-erased-p lwl))) (entdel lwl))
    (if adoc
      (if (= 8 (logand 8 (getvar (quote undoctl))))
        (vla-endundomark adoc)
      )
    )
    (if ti (progn (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")))
    (if lil (sssetfirst nil sss) (setq sss nil))
    (if m
      (prompt (strcat "\n" m))
      (if lil (prompt "\nSelection set with solution is highlighted and stored in global variable \"sss\"... Invoke it with : !sss, or (sssetfirst nil sss)..."))
    )
    (princ)
  )

  ;;; SUB FUNCTIONS ;;;

  (defun unit ( v / d )
    (if (and v (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-10)))
      (mapcar (function (lambda ( x ) (/ x d))) v)
    )
  )

  (defun inside-p ( p lw lwl )
    (< (distance p (vlax-curve-getclosestpointto lwl p)) (distance p (vlax-curve-getclosestpointto lw p)))
  )

  (defun car-sort ( lst fun / r )
    (setq r (car lst))
    (foreach itm (cdr lst)
      (if (apply fun (list itm r))
        (setq r itm)
      )
    )
    r
  )

  (defun dist ( p pp tt )
    (distance p (inters p (polar p (+ (angle (list 0.0 0.0) tt) (* 0.5 pi)) 1.0) pp (polar pp (angle (list 0.0 0.0) tt) 1.0) nil))
  )

  (defun rem_coll_pts ( pts / a ptsp ptsn )
    (setq a (angle (car pts) (cadr pts)))
    (while (equal a (angle (car pts) (cadr pts)) 1e-8)
      (setq pts (append (cdr pts) (list (car pts))))
    )
    (setq ptsp (cons (last pts) (reverse (cdr (reverse pts)))) ptsn (append (cdr pts) (list (car pts))))
    (unique (vl-remove nil (mapcar (function (lambda ( a b c ) (if (not (equal (distance a c) (+ (distance a b) (distance b c)) 1e-3)) b))) (append ptsp ptsp) (append pts pts) (append ptsn ptsn))))
  )

  (defun getlwpts ( lw / i pl )
    (setq i -1)
    (while (< (setq i (1+ i)) (vlax-curve-getendparam lw))
      (setq pl (cons (mapcar (function +) (list 0.0 0.0) (vlax-curve-getpointatparam lw (float i))) pl))
    )
    (reverse pl)
  )

  (defun vxv ( u v )
    (apply (function +) (mapcar (function *) u v))
  )

  (defun listcollinear-p ( lst tol )
    (or (not (cddr lst))
      (and
        (equal 1.0
          (abs
            (vxv
              (unit (mapcar (function -) (car lst) (cadr  lst)))
              (unit (mapcar (function -) (car lst) (caddr lst)))
            )
          )
          tol
        )
        (listcollinear-p (cdr lst) tol)
      )
    )
  )

  (defun collinear-p ( p1 p2 p3 )
    (
      (lambda ( a b c )
        (or
          (equal (+ a b) c 1e-6)
          (equal (+ b c) a 1e-6)
          (equal (+ c a) b 1e-6)
        )
      )
      (distance p1 p2) (distance p2 p3) (distance p1 p3)
    )
  )

  (defun collinearlilchk ( lil / lll lst p1 p2 p3 p4 ll qq q xx rtn )
    (setq lll lil)
    (foreach l1 lll
      (setq lll (cdr lll))
      (foreach l2 lll
        (if (and (collinear-p (car l1) (cadr l1) (car l2)) (collinear-p (car l1) (cadr l1) (cadr l2)) (collinear-p (car l2) (cadr l2) (car l1)) (collinear-p (car l2) (cadr l2) (cadr l1)))
          (progn
            (setq xx (cons l1 xx) xx (cons l2 xx))
            (if (not (equal l1 (caar ll) 1e-3))
              (setq ll (cons (list l1 l2) ll))
              (setq ll (subst (append (car ll) (list l2)) (car ll) ll))
            )
          )
          (setq rtn (cons l1 rtn) rtn (cons l2 rtn))
        )
      )
    )
    (foreach x ll
      (setq q (apply (function append) x))
      (setq p1 (car-sort q (function (lambda ( a b ) (> (distance a (car q)) (distance b (car q)))))))
      (setq lst (vl-sort q (function (lambda ( a b ) (< (distance a p1) (distance b p1))))))
      (setq lst (unique lst))
      (setq p1 (car lst) p2 (cadr lst) p3 (caddr lst) p4 (cadddr lst))
      (setq qq (cons (list p1 p2) qq) qq (cons (list p3 p4) qq))
    )
    (setq rtn (uniquelil (append (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (or (equal x y 1e-3) (equal x (reverse y) 1e-3)))) xx))) rtn) qq)))
  )

  (defun cichk ( lw ip rad / ci pp )
    (setq ci (entmakex (list (cons 0 "CIRCLE") (cons 10 ip) (cons 40 (- rad fuzz)))))
    (setq pp (vlax-invoke (vlax-ename->vla-object ci) (quote intersectwith) (vlax-ename->vla-object lw) acextendnone))
    (entdel ci)
    (not pp)
  )

  (defun clockwiselw-p ( lw / ll ur p1 p2 p3 p4 )
    (vla-getboundingbox (vlax-ename->vla-object lw) (quote ll) (quote ur))
    (mapcar (function set) (list (quote ll) (quote ur)) (mapcar (function safearray-value) (list ll ur)))
    (setq p1 (vlax-curve-getclosestpointto lw ll))
    (setq p2 (vlax-curve-getclosestpointto lw (list (car ur) (cadr ll))))
    (setq p3 (vlax-curve-getclosestpointto lw ur))
    (setq p4 (vlax-curve-getclosestpointto lw (list (car ll) (cadr ur))))
    (setq p1 (vlax-curve-getparamatpoint lw p1))
    (setq p2 (vlax-curve-getparamatpoint lw p2))
    (setq p3 (vlax-curve-getparamatpoint lw p3))
    (setq p4 (vlax-curve-getparamatpoint lw p4))
    (not
      (or
        (< p1 p2 p3 p4)
        (< p2 p3 p4 p1)
        (< p3 p4 p1 p2)
        (< p4 p1 p2 p3)
      )
    )
  )

  (defun clockwise-p ( p1 p2 p3 )
    (< 
      (* (- (car p2) (car p1)) (- (cadr p3) (cadr p1)))
      (* (- (cadr p2) (cadr p1)) (- (car p3) (car p1)))
    )
  )

  (defun chkttt ( pp1 pp2 flg / ttx ttt tt t1 t3 ip np dl d dd lws1 lws2 lwss1 lwss2 tst lw1 lw2 p1 p2 el lwx n m x y z lws22 lw22 pp pts f r )
    (if (setq ip (inters (caadr pp1) (mapcar (function +) (caadr pp1) (cadadr pp1)) (caadr pp2) (mapcar (function +) (caadr pp2) (cadadr pp2)) nil))
      (if
        (and
          (setq ttt (append (car pp1) (car pp2)))
          (or
            (setq ttx (vl-some (function (lambda ( x ) (if (= (length (vl-remove x ttt)) 2) x))) ttt))
            (setq ttx (vl-some (function (lambda ( x ) (vl-some (function (lambda ( y ) (if (listcollinear-p (append x y) 1e-6) (list x y)))) (vl-remove x ttt)))) ttt))
          )
        )
        (progn
          (setq tt (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-3))) (if (numberp (caar ttx)) (list ttx) ttx)))) ttt))
          (setq dl (mapcar (function (lambda ( x ) (dist ip (car x) (unit (mapcar (function -) (cadr x) (car x)))))) (if (not ttll) (setq ttll (uniquetll tll)) ttll)))
          (foreach d dl
            (if (> (- (length dl) (length (vl-remove-if (function (lambda ( x ) (equal x d (* 250.0 fuzz)))) dl))) 2)
              (setq tst (cons d tst))
              (setq tst (cons nil tst))
            )
          )
          (setq dl (mapcar (function (lambda ( x ) (dist ip (car x) (unit (mapcar (function -) (cadr x) (car x)))))) tt))
          (foreach d dl
            (if (> (- (length dl) (length (vl-remove-if (function (lambda ( x ) (equal x d (* 250.0 fuzz)))) dl))) 1)
              (setq dd (cons d dd))
              (setq dd (cons nil dd))
            )
          )
          (setq d (vl-some (function (lambda ( x ) (if (vl-some (function (lambda ( y ) (equal x y (* 250.0 fuzz)))) (vl-sort (vl-remove nil tst) (function <))) x))) (vl-sort (vl-remove nil dd) (function <))))
          (if (and ip d (= (length tt) 2) (inside-p ip lw lwl) (cichk lw ip d))
            (progn
              (setq t1 (car tt) t3 (cadr tt))
              (setq np
                (list tt
                  (list ip
                    (if
                      (or
                        (equal (unit (mapcar (function -) (cadr t1) (car t1))) (unit (mapcar (function -) (cadr t3) (car t3))) 1e-3)
                        (equal (unit (mapcar (function -) (cadr t1) (car t1))) (unit (mapcar (function -) (car t3) (cadr t3))) 1e-3)
                      )
                      (unit (mapcar (function -) (cadr t1) (car t1)))
                      (unit (mapcar (function -) ip (inters (car t1) (cadr t1) (car t3) (cadr t3) nil)))
                    )
                  )
                )
              )
              (if
                (setq pp (vl-some (function (lambda ( x )
                  (if
                    (and
                      (or (equal (unit (mapcar (function -) ip (caadr x))) (cadadr np) 1e-6) (equal (unit (mapcar (function -) (caadr x) ip)) (cadadr np) 1e-6))
                      (or (equal (cadadr x) (cadadr np) 1e-6) (equal (mapcar (function -) (cadadr x)) (cadadr np) 1e-6))
                      (vl-some (function (lambda ( y ) (equal (car tt) y 1e-6))) (car x))
                      (vl-some (function (lambda ( y ) (equal (cadr tt) y 1e-6))) (car x))
                    ) x
                    )))
                    ppll
                  )
                )
                (progn
                  (setq f t)
                  ;;;(setq lil (cons (list (caadr pp) ip) lil))
                  (setq lil (cons (list (caadr pp1) ip) lil))
                  (setq lil (cons (list (caadr pp2) ip) lil))
                  (setq ppll (vl-remove-if (function (lambda ( x ) (equal x pp 1e-6))) ppll))
                  (setq ppll (vl-remove-if (function (lambda ( x ) (equal x pp1 1e-6))) ppll))
                  (setq ppll (vl-remove-if (function (lambda ( x ) (equal x pp2 1e-6))) ppll))
                )
              )
              (setq el (entlast))
              (if (not (vl-catch-all-error-p (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (* si (- d fuzz))))))
                (while (setq el (entnext el))
                  (setq lws1 (cons el lws1))
                )
                (progn
                  (vla-copy (vlax-ename->vla-object lw))
                  (setq lwx (entlast))
                  (setq el (entlast))
                  (vl-cmdf "_.offset" (- d fuzz) lwx "_non" ip "")
                  (while (setq el (entnext el))
                    (setq lws1 (cons el lws1))
                  )
                )
              )
              (setq lws1 (vl-remove-if (function (lambda ( x ) (/= "LWPOLYLINE" (cdr (assoc 0 (entget x)))))) lws1))
              (setq el (entlast))
              (if (not (vl-catch-all-error-p (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (* si (+ d fuzz))))))
                (while (setq el (entnext el))
                  (setq lws2 (cons el lws2))
                )
                (progn
                  (if (not lwx)
                    (progn
                      (vla-copy (vlax-ename->vla-object lw))
                      (setq lwx (entlast))
                    )
                  )
                  (setq el (entlast))
                  (vl-cmdf "_.offset" (+ d fuzz) lwx "_non" ip "")
                  (while (setq el (entnext el))
                    (setq lws2 (cons el lws2))
                  )
                )
              )
              (setq lws2 (vl-remove-if (function (lambda ( x ) (/= "LWPOLYLINE" (cdr (assoc 0 (entget x)))))) lws2))
              (if lws1
                (progn
                  (setq lwss1 (mapcar (function (lambda ( x ) (list x (rem_coll_pts (unique (getlwpts x)))))) lws1))
                  (setq p1 (car-sort (apply (function append) (mapcar (function cadr) lwss1)) (function (lambda ( a b ) (< (distance ip a) (distance ip b))))))
                  (setq lw1 (vl-some (function (lambda ( x ) (if (vl-position p1 (cadr x)) (car x)))) lwss1))
                )
              )
              (if (and lw1 (< (distance ip (vlax-curve-getclosestpointto lw1 ip)) (* 10.0 fuzz)))
                (setq n (length (rem_coll_pts (unique (getlwpts lw1)))) x (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 10.0 fuzz)))) (getlwpts lw1)))
                (setq n 0)
              )
              (if lws2
                (progn
                  (setq lwss2 (mapcar (function (lambda ( x ) (list x (rem_coll_pts (unique (getlwpts x)))))) lws2))
                  (if p1
                    (setq p2 (car-sort (apply (function append) (mapcar (function cadr) lwss2)) (function (lambda ( a b ) (if (equal (distance ip a) (distance ip b) 1e-3) (< (distance p1 a) (distance p1 b)) (< (distance ip a) (distance ip b)))))))
                    (setq p2 (car-sort (apply (function append) (mapcar (function cadr) lwss2)) (function (lambda ( a b ) (< (distance ip a) (distance ip b))))))
                  )
                  (setq lw2 (vl-some (function (lambda ( x ) (if (vl-position p2 (cadr x)) (car x)))) lwss2))
                )
              )
              (if (and lw2 (< (distance ip (vlax-curve-getclosestpointto lw2 ip)) (* 10.0 fuzz)))
                (setq m (length (rem_coll_pts (unique (getlwpts lw2)))) y (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 10.0 fuzz)))) (getlwpts lw2)))
                (setq m 0)
              )
              (setq lws22 (vl-remove-if-not (function (lambda ( x ) (< (distance ip (vlax-curve-getclosestpointto x ip)) (* 50.0 fuzz)))) lws2))
              (setq lw22 (car (vl-remove lw2 lws22)))
              (if lw22
                (setq z (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 50.0 fuzz)))) (getlwpts lw22)))
              )
              (setq pts (ptss lil))
              (if
                (and
                  (not f)
                  (cond
                    ( (and
                        lw1 lw2 (not ff)
                        (vl-some (function (lambda ( x ) (equal x (caadr pp1) 1e-3))) pl)
                        (vl-some (function (lambda ( x ) (equal x (caadr pp2) 1e-3))) pl)
                        (not (clockwise-p (car (vl-remove (caadr pp1) (apply (function append) (car pp1)))) (caadr pp1) (cadr (vl-remove (caadr pp1) (apply (function append) (car pp1))))))
                        (not (clockwise-p (car (vl-remove (caadr pp2) (apply (function append) (car pp2)))) (caadr pp2) (cadr (vl-remove (caadr pp2) (apply (function append) (car pp2))))))
                      )
                      t
                    )
                    ( (and lw1 lw2)
                      (if ff
                        (if (/= (length x) (length y))
                          t
                          (if (= (length x) 1)
                            (cond
                              ( (and x y (not z))
                                (and (/= n m) (or (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3)))
                              )
                              ( (and x y z)
                                (and (/= n m) (or (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car z) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car z))) (cadadr np) 1e-3)))
                              )
                            )
                            (if (> (length x) 1)
                              (/= n m)
                            )
                          )
                        )
                        (cond
                          ( (and x y (not z))
                            (and (/= n m) (or (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3)))
                          )
                          ( (and x y z)
                            (and (/= n m) (or (equal (unit (mapcar (function -) (car y) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car y) (car x))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car x) (car y))) (cadadr np) 1e-3) (equal (unit (mapcar (function -) (car z) ip)) (cadadr np) 1e-3) (equal (unit (mapcar (function -) ip (car z))) (cadadr np) 1e-3)))
                          )
                        )
                      )
                    )
                    ( (or lw1 lw2)
                      (or (/= n m) (and (vl-some (function (lambda ( x ) (equal x (caadr pp1) 1e-3))) (freepts 2)) (vl-some (function (lambda ( x ) (equal x (caadr pp2) 1e-3))) (freepts 2))))
                    )
                  )
                  (not (vl-some (function (lambda ( x ) (or (and (equal (distance ip (caadr pp1)) (+ (distance ip x) (distance x (caadr pp1))) 1e-3) (not (equal x (caadr pp1) 1e-3))) (and (equal (distance ip (caadr pp2)) (+ (distance ip x) (distance x (caadr pp2))) 1e-3) (not (equal x (caadr pp2) 1e-3)))))) pts))
                  ;;;(not (vl-some (function (lambda ( x / i ) (or (and (setq i (inters (car x) (cadr x) (caadr pp1) ip)) (not (equal i (car x) 1e-3)) (not (equal i (cadr x) 1e-3)) (not (equal i (caadr pp1) 1e-3)) (not (equal i ip 1e-3))) (and (setq i (inters (car x) (cadr x) (caadr pp2) ip)) (not (equal i (car x) 1e-3)) (not (equal i (cadr x) 1e-3)) (not (equal i (caadr pp2) 1e-3)) (not (equal i ip 1e-3)))))) (append lil tll)))
                )
                (progn
                  (if (not ff)
                    (setq ppllx (cons np ppllx))
                  )
                  (setq r (list (if flg (min (distance ip (caadr pp1)) (distance ip (caadr pp2))) d) pp1 np pp2))
                )
              )
              (foreach lw1 lws1 (if (and lw1 (not (vlax-erased-p lw1))) (entdel lw1)))
              (foreach lw2 lws2 (if (and lw2 (not (vlax-erased-p lw2))) (entdel lw2)))
              (if (and lwx (not (vlax-erased-p lwx))) (entdel lwx))
              r
            )
          )
        )
      )
    )
  )

  (defun liloverlapchk ( lll / xxx )
    (setq pts (ptss lll))
    (setq xxx (freepts 4))
    (if (= (length xxx) 2)
      (setq lll (vl-remove-if (function (lambda ( x ) (or (equal (list (car x) (cadr x)) (list (car xxx) (cadr xxx)) 1e-3) (equal (list (car x) (cadr x)) (list (cadr xxx) (car xxx)) 1e-3)))) lll))
    )
    lll
  )

  (defun processchk ( chk )
    (if chk
      (progn
        (setq lil (cons (list (caadr (cadr chk)) (caadr (caddr chk))) lil))
        (setq lil (cons (list (caadr (cadddr chk)) (caadr (caddr chk))) lil))
        (if (not (vl-some (function (lambda ( x ) (equal x (caddr chk) 1e-3))) ppll))
          (setq ppll (cons (caddr chk) ppll))
        )
        (setq ppll (vl-remove-if (function (lambda ( x ) (or (equal x (cadr chk) 1e-3) (equal x (cadddr chk) 1e-3)))) ppll))
      )
    )
  )

  (defun unique ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (equal x a 1e-6))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun uniquelil ( lst / a ll )
    (setq lst (vl-remove-if (function (lambda ( x ) (equal (car x) (cadr x) 1e-3))) lst))
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (or (equal x a 1e-3) (equal x (reverse a) 1e-3)))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (or (equal x a 1e-3) (equal x (reverse a) 1e-3)))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun uniquetll ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (listcollinear-p (append x a) 1e-6))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (listcollinear-p (append x a) 1e-6))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun freepts ( n )
    (unique (vl-remove-if-not (function (lambda ( x ) (= n (- (length pts) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-3))) pts)))))) pts))
  )

  (defun ptss ( lll )
    (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-3))) pl))) (apply (function append) (setq lll (unique lll))))
  )

  (defun process ( flg fuzz / cc chks lilo ip p1 p2 x y ppx ppp rtn pppp done ) ;;; pplll - lexical global variable ;;;
    (while (not done)
      (setq lilo lil)
      (setq pplll (append pplll ppll))
      (setq ppl ppll)
      (foreach pp1 ppl
        (setq ppl (cdr ppl))
        (foreach pp2 ppl
          (if (setq cc (chkttt pp1 pp2 flg))
            (setq chks (cons cc chks))
          )
        )
      )
      (foreach chk (vl-sort chks (function (lambda ( a b ) (< (car a) (car b)))))
        (processchk chk)
      )
      (setq ff t)
      (if (or (not chks) (equal lilo lil 1e-3))
        (setq done t)
      )
      (setq chks nil ppll (unique ppll) lil (uniquelil lil))
      (setq ppll (vl-sort ppll (function (lambda ( a b ) (< (distance (caadr a) (vlax-curve-getclosestpointto lw (caadr a))) (distance (caadr b) (vlax-curve-getclosestpointto lw (caadr b))))))))
      (setq ppx (vl-remove-if-not (function (lambda ( x ) (vl-position (caadr x) pl))) ppll))
      (setq ppp (mapcar (function caadr) (if ppx ppx ppll)))
      (setq rtn nil)
      (while ppp
        (setq p1 (car ppp)
              p2 (car-sort (cdr ppp) (function (lambda ( a b ) (< (distance p1 a) (distance p1 b)))))
              ppp (vl-remove p1 ppp)
              ppp (vl-remove p2 ppp)
        )
        (if (and p1 p2)
          (if (and (setq x (vl-some (function (lambda ( x ) (if (equal p1 (caadr x) 1e-3) x))) ppll)) (setq y (vl-some (function (lambda ( x ) (if (equal p2 (caadr x) 1e-3) x))) ppll)))
            (setq rtn (cons (list x y) rtn))
          )
        )
      )
      (cond
        ( (and p1 (not (vl-some (function (lambda ( x ) (equal p1 (caadr x) 1e-3))) (apply (function append) rtn))))
          (if (setq x (vl-some (function (lambda ( x ) (if (equal p1 (caadr x) 1e-3) x))) ppll))
            (setq rtn (cons (list x nil) rtn))
          )
        )
        ( (and p2 (not (vl-some (function (lambda ( x ) (equal p2 (caadr x) 1e-3))) (apply (function append) rtn))))
          (if (setq x (vl-some (function (lambda ( x ) (if (equal p2 (caadr x) 1e-3) x))) ppll))
            (setq rtn (cons (list x nil) rtn))
          )
        )
      )
      (setq rtn (unique (vl-remove nil (apply (function append) (reverse rtn)))))
      (setq pppp (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-3))) rtn))) ppll))
      (if (= (length ppll) (length (setq rtn (append rtn pppp))))
        (setq ppll rtn)
      )
      (setq pplll (append pplll ppll))
    )
    lil
  )

  (defun lilchk ( lll / pts i )
    (setq pts (ptss (uniquelil lll)))
    (or
      (freepts 1)
      (freepts 2)
      (freepts 4)
      (freepts 5)
      (vl-some (function (lambda ( x )
        (vl-some (function (lambda ( y )
          (and
            (setq i (inters (car x) (cadr x) (car y) (cadr y)))
            (not (equal i (car x) 1e-3))
            (not (equal i (cadr x) 1e-3))
            (not (equal i (car y) 1e-3))
            (not (equal i (cadr y) 1e-3))
          )
        ))
        (vl-remove x (append tll lll))
        )
        ))
        (append tll lll)
      )
      (/=
        (length (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-3))) (unique pl)))) (apply (function append) lll)))
        (length (unique pl))
      )
    )
  )

  ;;; MAIN ROUTINE ;;;

  (setq adoc (vla-get-activedocument (vlax-get-acad-object)))
  (if (= 8 (logand 8 (getvar (quote undoctl))))
    (vla-endundomark adoc)
  )
  (vla-startundomark adoc)
  (setq osm (getvar (quote osmode)))
  (setq cmd (getvar (quote cmdecho)))
  (setvar (quote osmode) 0)
  (setvar (quote cmdecho) 0)
  (initget 6)
  (setq fuzz (getdist "\nPick or specify fuzz distance for LWPOLYLINE offset checking <0.01> : "))
  (if (not fuzz) (setq fuzz 0.01))
  (prompt "\nPick closed polygonal LWPOLYLINE on unlocked Layer...")
  (if (setq s (ssget "_+.:E:S:L" (list (cons 0 "LWPOLYLINE") (cons -4 "&") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
    (progn
      (setq ti (car (_vl-times)))
      (setq lw (ssname s 0))
      (if (clockwiselw-p lw)
        (progn
          (vl-cmdf "_.pedit" lw "_r")
          (while (< 0 (getvar (quote cmdactive)))
            (vl-cmdf "")
          )
        )
      )
      (vl-cmdf "_.zoom" "_ob" lw "" "_.zoom" "0.75xp")
      (vla-offset (vlax-ename->vla-object lw) 1e-3)
      (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
        (progn (entdel (entlast)) (vla-offset (vlax-ename->vla-object lw) -1e-3) (setq si -1.0))
        (setq si 1.0)
      )
      (setq pl (getlwpts lw))
      (setq pl (unique pl))
      (setq pl (rem_coll_pts pl))
      (setq pll (getlwpts (setq lwl (entlast))))
      (setq pll (unique pll))
      (setq pll (rem_coll_pts pll))
      (setq tll (mapcar (function (lambda ( a b ) (list a b))) pl (append (cdr pl) (list (car pl)))))
      (setq ppllo (mapcar (function (lambda ( t1 t2 p pp ) (list (list t1 t2) (list p (unit (mapcar (function -) pp p)))))) (cons (last tll) (reverse (cdr (reverse tll)))) tll pl pll))
      (setq ppll ppllo ff nil)
      (setq lil1 (process nil fuzz))
      (setq ppll ppllo ff nil)
      (setq lil2 (process t fuzz))
      (setq lil (car-sort (list lil1 lil2) (function (lambda ( a b ) (> (progn (setq pts (ptss a)) (length (freepts 3))) (progn (setq pts (ptss b)) (length (freepts 3))))))))
      (setq lil (collinearlilchk lil))
      (setq lil (liloverlapchk lil))
      (setq lil (vl-remove-if (function (lambda ( x ) (or (not (car x)) (not (cadr x))))) lil))
      (setq pts (ptss lil))
      (setq xx (freepts 2))
      (if (< (length xx) 2)
        (setq xx nil)
      )
      (if xx
        (foreach x ppllx
          (if (setq qq (vl-remove-if-not (function (lambda ( a ) (or (equal (unit (mapcar (function -) a (caadr x))) (cadadr x) 1e-3) (equal (unit (mapcar (function -) (caadr x) a)) (cadadr x) 1e-3)))) xx))
            (setq lil (cons (list (caadr x) (car-sort qq (function (lambda ( a b ) (< (distance (caadr x) a) (distance (caadr x) b)))))) lil))
          )
        )
      )
      (setq pts (ptss lil))
      (if (and (setq xx (freepts 1)) (= (length xx) 1) (setq xx (car xx)) (setq li (vl-some (function (lambda ( x ) (if (vl-some (function (lambda ( y ) (equal y xx 1e-3))) x) x))) lil)))
        (if (and (setq qq (freepts 2)) (= (length qq) 1) (setq qq (car qq)) (setq xx (car (vl-remove xx li))))
          (setq lil (subst (list xx qq) li lil))
        )
      )
      (setq pts (ptss lil))
      (setq xx (freepts 4))
      (while xx
        (setq li (list (car xx) (cadr xx)))
        (setq lil (vl-remove-if (function (lambda ( x ) (or (equal x li 1e-3) (equal x (reverse li) 1e-3)))) lil))
        (setq xx (cddr xx))
      )
      (setq pts (ptss lil))
      (setq xx (freepts 2))
      (while xx
        (if (and (car xx) (setq qq (vl-some (function (lambda ( x ) (if (and (vl-position x (mapcar (function caadr) pplll)) (collinear-p x (car xx) (mapcar (function +) x (cadadr (vl-some (function (lambda ( y ) (if (equal x (caadr y) 1e-3) y))) pplll))))) x))) (cdr xx))))
          (setq lil (cons (list (car xx) qq) lil))
        )
        (if qq
          (setq xx (vl-remove qq (cdr xx)))
          (setq xx (cdr xx))
        )
      )
      (setq pts (ptss lil))
      (setq xx (freepts 2))
      (if (= (length xx) 2)
        (if (and (car xx) (cadr xx))
          (setq lil (cons (list (car xx) (cadr xx)) lil))
        )
      )
      ;|
      (if (lilchk lil)
        (setq lil nil)
      )
      |;
      (setq sss (ssadd))
      (if lil
        (foreach li lil
          (ssadd (entmakex (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)))) sss)
        )
      )
    )
    (setq m "Missed picking closed polygonal LWPOLYLINE on unlocked Layer...")
  )
  (*error* (if m m))
)