(defun c:roof-ortho ( / *error* unit inside-p car-sort dist getlwpts_rem_coll getlwpts vxv listcollinear-p chkttt processchk unique foo proc2p uniquelil freepts ptss ffo
                        adoc osm cmd fuzz s ti lw lwl pl pll tll ppl ppll cc chk chks ip lil lilo pp1 pp2 p1 p2 v1 v2 pts si m f xx xxo donex done )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if osm (setvar (quote osmode) osm))
    (if cmd (setvar (quote cmdecho) cmd))
    (if (and lwl (not (vlax-erased-p lwl))) (entdel lwl))
    (setq sss (ssadd))
    (if lil
      (foreach li (uniquelil (reverse lil))
        (ssadd (entmakex (list (cons 0 "LINE") (cons 10 (car li)) (cons 11 (cadr li)))) sss)
      )
    )
    (if adoc
      (if (= 8 (logand 8 (getvar (quote undoctl))))
        (vla-endundomark adoc)
      )
    )
    (if (and ti lil) (progn (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 16)) (prompt " milliseconds...")))
    (if lil (sssetfirst nil sss) (setq sss nil))
    (if m
      (prompt (strcat "\n" m))
      (if lil (prompt "\nSelection set with solution is highlighted and stored in global variable \"sss\"... Invoke it with : !sss, or (sssetfirst nil sss)..."))
    )
    (princ)
  )

  ;;; SUB-FUNCTIONS ;;;

  (defun unit ( v / d )
    (if (and v (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-10)))
      (mapcar (function (lambda ( x ) (/ x d))) v)
    )
  )

  (defun inside-p ( p lw lwl )
    (if (and p (= (type p) (quote list)) (vl-every (function numberp) p))
      (< (distance p (vlax-curve-getclosestpointto lwl p)) (distance p (vlax-curve-getclosestpointto lw p)))
    )
  )

  (defun car-sort ( lst fun / r )
    (setq r (car lst))
    (foreach itm (cdr lst)
      (if (apply fun (list itm r))
        (setq r itm)
      )
    )
    r
  )

  (defun dist ( p pp tt )
    (distance p (inters p (polar p (+ (angle (list 0.0 0.0) tt) (* 0.5 pi)) 1.0) pp (polar pp (angle (list 0.0 0.0) tt) 1.0) nil))
  )

  (defun getlwpts_rem_coll ( lw / pts a ptsp ptsn )
    (setq pts (getlwpts lw))
    (setq a (angle (car pts) (cadr pts)))
    (while (equal a (angle (car pts) (cadr pts)) 1e-8)
      (setq pts (append (cdr pts) (list (car pts))))
    )
    (setq ptsp (cons (last pts) (reverse (cdr (reverse pts)))) ptsn (append (cdr pts) (list (car pts))))
    (unique (vl-remove nil (mapcar (function (lambda ( a b c ) (if (not (equal (distance a c) (+ (distance a b) (distance b c)) 1e-3)) b))) (append ptsp ptsp) (append pts pts) (append ptsn ptsn))))
  )

  (defun getlwpts ( lw )
    (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget lw)))
  )

  (defun vxv ( u v )
    (apply (function +) (mapcar (function *) u v))
  )

  (defun listcollinear-p ( lst )
    (or (null (cddr lst))
      (and
        (equal 1.0
          (abs
            (vxv
              (unit (mapcar (function -) (car lst) (cadr  lst)))
              (unit (mapcar (function -) (car lst) (caddr lst)))
            )
          )
          1e-8
        )
        (listcollinear-p (cdr lst))
      )
    )
  )

  (defun chkttt ( pp1 pp2 si fuzz / t1 t3 t11 t31 t12 t32 t13 t33 t14 t34 ip np dl d d11 d31 d12 d32 d13 d33 d14 d34 el lws1 lws2 lwss1 lwss2 tst lw1 lw2 p1 p2 p1l p2l p1ll p2ll r )
    (if (and (car pp1) (caddr pp1) (car pp2) (caddr pp2) (caadr pp1) (cadadr pp1) (caadr pp2) (cadadr pp2) (setq ip (inters (caadr pp1) (mapcar (function +) (caadr pp1) (cadadr pp1)) (caadr pp2) (mapcar (function +) (caadr pp2) (cadadr pp2)) nil)))
      (progn
        (if (or (equal (car pp1) (caddr pp2) 1e-3) (listcollinear-p (append (car pp1) (caddr pp2))))
          (setq t11 (caddr pp1) t31 (car pp2))
        )
        (if (or (equal (caddr pp1) (car pp2) 1e-3) (listcollinear-p (append (caddr pp1) (car pp2))))
          (setq t12 (car pp1) t32 (caddr pp2))
        )
        (if (or (equal (car pp1) (car pp2) 1e-3) (listcollinear-p (append (car pp1) (car pp2))))
          (setq t13 (caddr pp1) t33 (caddr pp2))
        )
        (if (or (equal (caddr pp1) (caddr pp2) 1e-3) (listcollinear-p (append (caddr pp1) (caddr pp2))))
          (setq t14 (car pp1) t34 (car pp2))
        )
        (if (or (and t11 t31) (and t12 t32) (and t13 t33) (and t14 t34))
          (progn
            (setq dl (mapcar (function (lambda ( x ) (dist ip (car x) (unit (mapcar (function -) (cadr x) (car x)))))) tll))
            (foreach d dl
              (if (>= (- (length dl) (length (vl-remove-if (function (lambda ( x ) (equal x d 1e-3))) dl))) 3)
                (setq tst (cons d tst))
                (setq tst (cons nil tst))
              )
            )
            (if (and t11 t31)
              (setq d11 (dist ip (car t11) (unit (mapcar (function -) (cadr t11) (car t11)))) d31 (dist ip (car t31) (unit (mapcar (function -) (cadr t31) (car t31)))))
            )
            (if (and t12 t32)
              (setq d12 (dist ip (car t12) (unit (mapcar (function -) (cadr t12) (car t12)))) d32 (dist ip (car t32) (unit (mapcar (function -) (cadr t32) (car t32)))))
            )
            (if (and t13 t33)
              (setq d13 (dist ip (car t13) (unit (mapcar (function -) (cadr t13) (car t13)))) d33 (dist ip (car t33) (unit (mapcar (function -) (cadr t33) (car t33)))))
            )
            (if (and t14 t34)
              (setq d14 (dist ip (car t14) (unit (mapcar (function -) (cadr t14) (car t14)))) d34 (dist ip (car t34) (unit (mapcar (function -) (cadr t34) (car t34)))))
            )
            (cond
              ( (and d11 d31 (equal d11 d31 1e-3) (vl-some (function (lambda ( x ) (equal x d11 1e-3))) tst))
                (setq d d11 t1 t11 t3 t31)
              )
              ( (and d12 d32 (equal d12 d32 1e-3) (vl-some (function (lambda ( x ) (equal x d12 1e-3))) tst))
                (setq d d12 t1 t12 t3 t32)
              )
              ( (and d13 d33 (equal d13 d33 1e-3) (vl-some (function (lambda ( x ) (equal x d13 1e-3))) tst))
                (setq d d13 t1 t13 t3 t33)
              )
              ( (and d14 d34 (equal d14 d34 1e-3) (vl-some (function (lambda ( x ) (equal x d14 1e-3))) tst))
                (setq d d14 t1 t14 t3 t34)
              )
            )
            (if (and ip d t1 t3 (inside-p ip lw lwl))
              (progn
                (setq np (list t1 (list ip (if (or (equal (unit (mapcar (function -) (cadr t1) (car t1))) (unit (mapcar (function -) (cadr t3) (car t3))) 1e-3) (equal (unit (mapcar (function -) (cadr t1) (car t1))) (unit (mapcar (function -) (car t3) (cadr t3))) 1e-3)) (unit (mapcar (function -) (cadr t1) (car t1))) (unit (mapcar (function -) ip (inters (car t1) (cadr t1) (car t3) (cadr t3) nil))))) t3))
                (setq el (entlast))
                (if (not (vl-catch-all-error-p (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (* si (- d fuzz))))))
                  (while (setq el (entnext el))
                    (setq lws1 (cons el lws1))
                  )
                )
                (setq el (entlast))
                (if (not (vl-catch-all-error-p (vl-catch-all-apply (function vla-offset) (list (vlax-ename->vla-object lw) (* si (+ d fuzz))))))
                  (while (setq el (entnext el))
                    (setq lws2 (cons el lws2))
                  )
                )
                (if lws1
                  (progn
                    (setq lwss1 (mapcar (function (lambda ( x ) (list x (getlwpts_rem_coll x)))) lws1))
                    (setq p1 (car-sort (apply (function append) (mapcar (function cadr) lwss1)) (function (lambda ( a b ) (< (distance ip a) (distance ip b))))))
                    (if (setq lw1 (vl-some (function (lambda ( x ) (if (vl-position p1 (cadr x)) (car x)))) lwss1))
                      (progn
                        (setq p1ll (apply (function append) (mapcar (function cadr) lwss1)))
                        (setq p1l (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 100.0 fuzz)))) p1ll))
                        (if (and p1l (not (vl-some (function (lambda ( x ) (equal x p1 1e-3))) p1l)))
                          (setq p1 nil)
                          (if (not p1l) (setq p1 nil))
                        )
                      )
                    )
                  )
                )
                (if lws2
                  (progn
                    (setq lwss2 (mapcar (function (lambda ( x ) (list x (getlwpts_rem_coll x)))) lws2))
                    (if p1
                      (setq p2 (car-sort (apply (function append) (mapcar (function cadr) lwss2)) (function (lambda ( a b ) (if (equal (distance ip a) (distance ip b) 1e-3) (< (distance p1 a) (distance p1 b)) (< (distance ip a) (distance ip b)))))))
                      (setq p2 (car-sort (apply (function append) (mapcar (function cadr) lwss2)) (function (lambda ( a b ) (< (distance ip a) (distance ip b))))))
                    )
                    (if (setq lw2 (vl-some (function (lambda ( x ) (if (vl-position p2 (cadr x)) (car x)))) lwss2))
                      (progn
                        (setq p2ll (apply (function append) (mapcar (function cadr) lwss2)))
                        (setq p2l (vl-remove-if-not (function (lambda ( x ) (< (distance ip x) (* 100.0 fuzz)))) p2ll))
                        (if (and p2l (not (vl-some (function (lambda ( x ) (equal x p2 1e-3))) p2l)))
                          (setq p2 nil)
                          (if (not p2l) (setq p2 nil))
                        )
                      )
                    )
                  )
                )
                (if (and p1 p2 (< (distance p1 p2) (* 100.0 fuzz))) (setq p1 (car-sort p1l (function (lambda ( a b ) (< (distance p2 a) (distance p2 b)))))))
                (if
                  (and
                    (or (and p1 (not p2)) (and p1 p2 (not (equal (unit (mapcar (function -) p2 ip)) (unit (mapcar (function -) ip p1)) 1e-3))))
                    (and lw1 (< (distance ip (vlax-curve-getclosestpointto lw1 ip)) (* 1000.0 fuzz)))
                  )
                  (setq r (list d pp1 np pp2))
                )
                (foreach lw1 lws1 (if (and lw1 (not (vlax-erased-p lw1))) (entdel lw1)) )
                (foreach lw2 lws2 (if (and lw2 (not (vlax-erased-p lw2))) (entdel lw2)) )
                r
              )
            )
          )
        )
      )
    )
  )

  (defun processchk ( chk )
    (if chk
      (progn
        (setq lil (cons (list (caadr (cadr chk)) (caadr (caddr chk))) lil))
        (setq lil (cons (list (caadr (cadddr chk)) (caadr (caddr chk))) lil))
        (if (not (vl-some (function (lambda ( x ) (equal x (caddr chk) 1e-3))) ppll))
          (setq ppll (cons (caddr chk) ppll))
        )
        (setq ppll (vl-remove-if (function (lambda ( x ) (or (equal x (cadr chk) 1e-3) (equal x (cadddr chk) 1e-3)))) ppll))
      )
    )
  )

  (defun unique ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (equal x a 1e-3))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (equal x a 1e-3))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun uniquelil ( lst / a ll )
    (while (setq a (car lst))
      (if (vl-some (function (lambda ( x ) (or (equal x a 1e-3) (equal (reverse x) a 1e-3)))) (cdr lst))
        (setq ll (cons a ll) lst (vl-remove-if (function (lambda ( x ) (or (equal x a 1e-3) (equal (reverse x) a 1e-3)))) (cdr lst)))
        (setq ll (cons a ll) lst (cdr lst))
      )
    )
    (reverse ll)
  )

  (defun foo ( p v / fpl pts q )
    (if (setq pts (ptss) fpl (append (freepts 2) (freepts 1)) fpl (vl-remove-if (function (lambda ( x ) (equal x p 1e-3))) fpl))
      (if (setq q (vl-some (function (lambda ( x ) (if (or (equal (unit (mapcar (function -) x p)) v 1e-3) (equal (unit (mapcar (function -) p x)) v 1e-3)) x))) fpl))
        (setq lil (cons (list p q) lil) ppll (vl-remove-if (function (lambda ( x ) (and (equal (caadr x) p 1e-3) (equal (cadadr x) v 1e-3)))) ppll))
      )
    )
  )

  (defun proc2p ( 2p )
    (foreach p1 2p
      (setq p2 (car-sort (vl-remove p1 2p) (function (lambda ( a b ) (< (distance p1 a) (distance p1 b))))))
      (if (and p1 p2 (not (vl-some (function (lambda ( x ) (or (equal (list p1 p2) x 1e-3) (equal (list p2 p1) x 1e-3)))) lil)))
        (setq lil (cons (list p1 p2) lil))
      )
    )
  )

  (defun freepts ( n )
    (unique (vl-remove-if-not (function (lambda ( x ) (= n (- (length pts) (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-3))) pts)))))) pts))
  )

  (defun ptss nil
    (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-3))) pl))) (apply (function append) (setq lil (uniquelil lil))))
  )

  (defun ffo ( / lll 2p 1p pts xx li 4p )
    (foreach li lil
      (if (vl-some (function (lambda ( x ) (and (or (and (equal (distance (car li) (cadr li)) (+ (distance (car li) (car x)) (distance (car x) (cadr li))) 1e-3) (not (equal (car li) (car x) 1e-3)) (not (equal (cadr li) (car x) 1e-3))) (and (equal (distance (car li) (cadr li)) (+ (distance (car li) (cadr x)) (distance (cadr x) (cadr li))) 1e-3) (not (equal (car li) (cadr x) 1e-3)) (not (equal (cadr li) (cadr x) 1e-3)))) (> (distance (car li) (cadr li)) (distance (car x) (cadr x)))))) (vl-remove li lil))
        (setq lil (vl-remove li lil) lll (cons li lll))
      )
    )
    (if (and (setq pts (ptss)) (setq 2p (freepts 2)) (setq 1p (freepts 1)))
      (foreach p1 1p
        (setq xx (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (or (equal (unit (mapcar (function -) p1 x)) (unit (mapcar (function -) (cadr y) (car y))) 1e-3) (equal (unit (mapcar (function -) p1 x)) (unit (mapcar (function -) (car y) (cadr y))) 1e-3)))) lll))) 2p))
        (if (and (= (length 2p) (length 1p)) (not xx)) (setq xx (list (car-sort 2p (function (lambda ( a b ) (< (distance p1 a) (distance p1 b))))))))
        (foreach p2 xx
          (if (and p1 p2)
            (setq lil (cons (list p1 p2) lil))
          )
        )
      )
      (if 2p (proc2p 2p))
    )
    (if (and (setq pts (ptss)) (setq 4p (freepts 4)))
      (progn
        (foreach li lil
          (if (and (vl-some (function (lambda ( x ) (equal x (car li) 1e-3))) 4p) (vl-some (function (lambda ( x ) (equal x (cadr li) 1e-3))) 4p))
            (setq lil (vl-remove li lil))
          )
        )
        (foreach li lil
          (if
            (or
              (and (vl-some (function (lambda ( x ) (equal x (car li) 1e-3))) 4p) (vl-some (function (lambda ( x ) (and (> (distance (car li) (cadr li)) (distance (car x) (cadr x))) (equal (car x) (car li) 1e-3) (or (equal (unit (mapcar (function -) (cadr x) (car x))) (unit (mapcar (function -) (cadr li) (car li))) 1e-3) (equal (unit (mapcar (function -) (car x) (cadr x))) (unit (mapcar (function -) (cadr li) (car li))) 1e-3))))) (vl-remove li lil)))
              (and (vl-some (function (lambda ( x ) (equal x (cadr li) 1e-3))) 4p) (vl-some (function (lambda ( x ) (and (> (distance (car li) (cadr li)) (distance (car x) (cadr x))) (equal (car x) (cadr li) 1e-3) (or (equal (unit (mapcar (function -) (cadr x) (car x))) (unit (mapcar (function -) (cadr li) (car li))) 1e-3) (equal (unit (mapcar (function -) (car x) (cadr x))) (unit (mapcar (function -) (cadr li) (car li))) 1e-3))))) (vl-remove li lil)))
            )
            (setq lil (vl-remove li lil))
          )
        )
      )
    )
    (if (and (setq pts (ptss)) (setq 2p (freepts 2)) (setq 4p (freepts 4)))
      (foreach p1 4p
        (foreach p2 2p
          (if (setq li (vl-some (function (lambda ( x ) (if (and (equal (distance p2 p1) (+ (distance p2 (car x)) (distance (car x) p1)) 1e-3) (equal (distance p2 p1) (+ (distance p2 (cadr x)) (distance (cadr x) p1)) 1e-3) (or (equal (car x) p1 1e-3) (equal (cadr x) p1 1e-3))) x))) lil))
            (progn
              (setq lil (vl-remove li lil))
              (setq pts (ptss) xx (freepts 2))
              (if (and xx (if (= (length xx) 2) (or (equal (unit (mapcar (function -) (car xx) (cadr xx))) (unit (mapcar (function -) (car li) (cadr li))) 1e-3) (equal (unit (mapcar (function -) (cadr xx) (car xx))) (unit (mapcar (function -) (car li) (cadr li))) 1e-3))))
                (proc2p xx)
              )
            )
          )
        )
      )
    )
  )

  ;;; MAIN ROUTINE ;;;

  (setq adoc (vla-get-activedocument (vlax-get-acad-object)))
  (if (= 8 (logand 8 (getvar (quote undoctl))))
    (vla-endundomark adoc)
  )
  (vla-startundomark adoc)
  (setq osm (getvar (quote osmode)))
  (setq cmd (getvar (quote cmdecho)))
  (setvar (quote osmode) 0)
  (setvar (quote cmdecho) 0)
  (initget 6)
  (setq fuzz (getdist "\nPick or specify fuzz distance for LWPOLYLINE offset checking <1e-3> : "))
  (if (not fuzz) (setq fuzz 1e-3))
  (prompt "\nPick closed polygonal LWPOLYLINE on unlocked Layer...")
  (if (setq s (ssget "_+.:E:S:L" (list (cons 0 "LWPOLYLINE") (cons -4 "&=") (cons 70 1) (cons -4 "<not") (cons -4 "<>") (cons 42 0.0) (cons -4 "not>"))))
    (progn
      (setq ti (car (_vl-times)))
      (setq lw (ssname s 0))
      (vl-cmdf "_.zoom" "_ob" lw "" "_.zoom" "0.75xp")
      (vla-offset (vlax-ename->vla-object lw) 1e-3)
      (if (> (vlax-curve-getarea (entlast)) (vlax-curve-getarea lw))
        (progn (entdel (entlast)) (vla-offset (vlax-ename->vla-object lw) -1e-3) (setq si -1.0))
        (setq si 1.0)
      )
      (setq pl (getlwpts lw) pll (getlwpts (setq lwl (entlast))) tll (mapcar (function (lambda ( a b ) (list a b))) pl (append (cdr pl) (list (car pl)))) ppl (mapcar (function (lambda ( t1 p pp t2 ) (list t1 (list p (unit (mapcar (function -) pp p))) t2))) (cons (last tll) (reverse (cdr (reverse tll)))) pl pll tll) ppll ppl)
      (while (not done)
        (setq lilo lil)
        (foreach pp1 ppl
          (setq ppl (vl-remove pp1 ppl))
          (foreach pp2 ppl
            (if (setq cc (chkttt pp1 pp2 si fuzz))
              (setq chks (cons cc chks))
            )
          )
        )
        (foreach chk (vl-sort chks (function (lambda ( a b ) (< (car a) (car b)))))
          (setq chks (vl-remove chk chks))
          (processchk chk)
        )
        (setq ppll (unique ppll) lil (uniquelil lil))
        (if (and ppll (= (length ppll) 2))
          (progn
            (setq p1 (caadr (car ppll)) v1 (cadadr (car ppll)) p2 (caadr (cadr ppll)) v2 (cadadr (cadr ppll)))
            (if 
              (and
                (or (equal (unit (mapcar (function -) p1 p2)) v1 1e-3) (equal (unit (mapcar (function -) p2 p1)) v1 1e-3) (equal (unit (mapcar (function -) p1 p2)) v2 1e-3) (equal (unit (mapcar (function -) p2 p1)) v2 1e-3))
                (and
                  (not (vl-some (function (lambda ( x ) (equal (list p1 p2) x 1e-3))) lil))
                  (not (vl-some (function (lambda ( x ) (equal (list p2 p1) x 1e-3))) lil))
                )
                (not (vl-some (function (lambda ( x ) (and (setq ip (inters p1 p2 (car x) (cadr x))) (not (equal ip p1 1e-3)) (not (equal ip p2 1e-3)) (not (equal ip (car x) 1e-3)) (not (equal ip (cadr x) 1e-3))))) lil))
              )
              (setq lil (cons (list p1 p2) lil) ppll nil)
            )
          )
        )
        (if (and (not donex) (equal lil lilo))
          (if ppll
            (progn
              (foreach x ppll
                (foo (caadr x) (cadadr x))
              )
              (if (= f 3) (setq donex t) (setq f (if (not f) 1 (1+ f))))
            )
            (setq donex t)
          )
        )
        (if (and (not donex) (= (length ppll) 1))
          (progn (foo (caadr (car ppll)) (cadadr (car ppll))) (setq donex t))
        )
        (while
          (and
            donex
            (setq pts (ptss))
            (setq xx (list (freepts 1) (freepts 2) (freepts 4)))
            (if (and (not (equal xx xxo)) (apply (function or) xx)) (setq xxo xx) (setq done t donex nil))
          )
          (ffo)
        )
        (setq ppl ppll)
      )
    )
    (setq m "Missed picking closed polygonal LWPOLYLINE on unlocked Layer...")
  )
  (*error* (if m m))
)