(defun c:roof-simple ( / *error* ucsf cmd ape osm ang ch delob el ell k lin linn p p1 p2 pl pll enx pp ss sss ssn vs ti )

  (defun *error* ( m )
    (if delob
      (setvar 'delobj delob)
    )
    (if osm
      (setvar 'osmode osm)
    )
    (if ape
      (setvar 'aperture ape)
    )
    (if ucsf
      (if command-s
        (command-s "_.ucs" "_p")
        (vl-cmdf "_.ucs" "_p")
      )
    )
    (if (= 8 (logand 8 (getvar 'undoctl)))
      (if command-s
        (command-s "_.undo" "_e")
        (vl-cmdf "_.undo" "_e")
      )
    )
    (if cmd
      (setvar 'cmdecho cmd)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (setq cmd (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (setq delob (getvar 'delobj))
  (setq osm (getvar 'osmode))
  (setvar 'osmode 0)
  (setq ape (getvar 'aperture))
  (setvar 'aperture 15)
  (if (= 0 (getvar 'worlducs))
    (progn
      (vl-cmdf "_.ucs" "_w")
      (setq ucsf t)
    )
  )
  (if (= 8 (logand 8 (getvar 'undoctl)))
    (vl-cmdf "_.undo" "_e")
  )
  (vl-cmdf "_.undo" "_m")
  (setq pll (entsel "\nPick closed polygonal LWPOLYLINE with straight segments..."))
  (if (and pll (= (cdr (assoc 0 (setq enx (entget (car pll))))) "LWPOLYLINE") (= 1 (logand 1 (cdr (assoc 70 enx)))) (vl-every '(lambda ( x ) (= (cdr x) 0.0)) (vl-remove-if '(lambda ( x ) (/= (car x) 42)) enx)))
    (progn
      (setq pl (car pll))
      (setq pp (cadr pll))
      (setq p (getpoint "\nPick point inside picked 2d polyline"))
      (setq p (list (car p) (cadr p) 1e-3))
      (initget "2D 3D")
      (setq ch (cond ( (getkword "\nEnter choice [2D / 3D] < 2D > : ") ) ("2D")))
      (setq ti (car (_vl-times)))
      (if (= ch "2D")
        (progn
          (setvar 'delobj 0)
          (vl-cmdf "_.zoom" "_v")
          (setq vs (getvar 'viewsize))
          (vl-cmdf "_.zoom" "_p")
          (setq el (entlast))
          (vl-cmdf "_.extrude" pl "" "_t" 45.0 0.1)
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          (vl-cmdf "_.solidedit" "_f" "_m" p "" (list 0.0 0.0 0.0) (list 0.0 0.0 vs))
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          (vl-cmdf "_.solidedit" "_b" "_p" (entlast))
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          (while (setq el (entnext el))
            (if (and (= (cdr (assoc 0 (entget el))) "3DSOLID") (not (eq el (ssname (ssget (osnap pp "_nea") '((0 . "3DSOLID"))) 0))))
              (entdel el)
              (setq ell el)
            )
          )
          (if (= (cdr (assoc 0 (entget ell))) "3DSOLID")
            (progn
              (setvar 'delobj 1)
              (setq el (entlast))
              (vl-cmdf "_.xedges" "_l")
              (while (< 0 (getvar 'cmdactive))
                (vl-cmdf "")
              )
              (entdel ell)
              (setq sss (ssadd) ss (ssadd))
              (while (setq el (entnext el))
                (ssadd el ss)
              )
              (repeat (setq ssn (sslength ss))
                (setq lin (ssname ss (setq ssn (1- ssn))))
                (if (and (= (caddr (cdr (assoc 10 (entget lin)))) 0.0) (= (caddr (cdr (assoc 11 (entget lin)))) 0.0))
                  (entdel lin)
                  (progn
                    (setq p1 (cdr (assoc 10 (entget lin))))
                    (setq p2 (cdr (assoc 11 (entget lin))))
                    (setq p1 (list (car p1) (cadr p1) 0.0))
                    (setq p2 (list (car p2) (cadr p2) 0.0))
                    (entmod (subst (cons 10 p1) (assoc 10 (entget lin)) (entget lin)))
                    (setq linn (entupd (cdr (assoc -1 (entmod (subst (cons 11 p2) (assoc 11 (entget lin)) (entget lin)))))))
                    (ssadd linn sss)
                  )
                )
              )
              (repeat (setq ssn (sslength sss))
                (setq lin (ssname sss (setq ssn (1- ssn))))
                (repeat (setq k ssn)
                  (setq linn (ssname sss (setq k (1- k))))
                  (if (or (and (equal (cdr (assoc 10 (entget lin))) (cdr (assoc 10 (entget linn))) 1e-6) (equal (cdr (assoc 11 (entget lin))) (cdr (assoc 11 (entget linn))) 1e-6)) (and (equal (cdr (assoc 10 (entget lin))) (cdr (assoc 11 (entget linn))) 1e-6) (equal (cdr (assoc 11 (entget lin))) (cdr (assoc 10 (entget linn))) 1e-6)))
                    (entdel lin)
                  )
                )
              )
            )
          )
        )
        (progn
          (setvar 'delobj 0)
          (initget 5)
          (setq ang (getreal "\nEnter angle of slope of roof in decimal degrees (0 < ang < 90) : "))
          (setq ang (rem (- 90.0 ang) 90.0))
          (vl-cmdf "_.regen")
          (vl-cmdf "_.zoom" "_v")
          (setq vs (getvar 'viewsize))
          (vl-cmdf "_.zoom" "_p")
          (setq el (entlast))
          (vl-cmdf "_.extrude" pl "" "_t" ang 0.1)
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          (vl-cmdf "_.solidedit" "_f" "_m" p "" (list 0.0 0.0 0.0) (list 0.0 0.0 vs))
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          (vl-cmdf "_.solidedit" "_b" "_p" (entlast))
          (while (< 0 (getvar 'cmdactive))
            (vl-cmdf "")
          )
          (while (setq el (entnext el))
            (if (and (= (cdr (assoc 0 (entget el))) "3DSOLID") (not (eq el (ssname (ssget (osnap pp "_nea") '((0 . "3DSOLID"))) 0))))
              (entdel el)
            )
          )
        )
      )
      (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 15)) (prompt " milliseconds...")
    )
  )
  (*error* nil)
)