(defun c:spheres-build-cube2 ( / *error* unit uniquefuzz uniquefacesfuzz faceseg projfaces2sph allfaces cubef1 cubef2 cubef3 cubef4 cubef5 cubef6 m pt ptcubelst ptcubelstn r rad seg tao2 tao3 cmd d q fc ce c cc pl ss )

  (defun *error* ( m )
    (if (= 8 (logand 8 (getvar (quote undoctl))))
      (if command-s
        (command-s "_.UNDO" "_E")
        (vl-cmdf "_.UNDO" "_E")
      )
    )
    (if cmd
      (setvar (quote cmdecho) cmd)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun unit ( v / d )
    (if (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
      (mapcar (function (lambda ( x ) (/ x d))) v)
      (progn
        (prompt "\nReference vector strength near 0.0... Invalid input specification... Quitting...")
        (exit)
      )
    )
  )

  (defun uniquefuzz ( lst fuzz / a ll )
    (while (setq a (car lst))
      (if
        (vl-some
          (function (lambda ( x )
            (equal x a fuzz)
          ))
          (cdr lst)
        )
        (progn
          (setq ll (cons a ll))
          (setq lst
            (vl-remove-if
              (function (lambda ( x )
                (equal x a fuzz)
              ))
              (cdr lst)
            )
          )
        )
        (progn
          (setq ll (cons a ll))
          (setq lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun uniquefacesfuzz ( lst fuzz / a ll )
    (while (setq a (car lst))
      (if
        (vl-some
          (function (lambda ( x )
            (or
              (equal (list (car x) (cadr x) (caddr x) (cadddr x)) a fuzz)
              (equal (list (car x) (cadr x) (cadddr x) (caddr x)) a fuzz)
              (equal (list (car x) (cadddr x) (caddr x) (cadr x)) a fuzz)
              (equal (list (car x) (caddr x) (cadr x) (cadddr x)) a fuzz)
              (equal (list (cadr x) (car x) (caddr x) (cadddr x)) a fuzz)
              (equal (list (cadr x) (car x) (cadddr x) (caddr x)) a fuzz)
              (equal (list (cadddr x) (car x) (caddr x) (cadr x)) a fuzz)
              (equal (list (caddr x) (car x) (cadr x) (cadddr x)) a fuzz)
              (equal (list (caddr x) (cadr x) (car x) (cadddr x)) a fuzz)
              (equal (list (cadddr x) (cadr x) (car x) (caddr x)) a fuzz)
              (equal (list (caddr x) (cadddr x) (car x) (cadr x)) a fuzz)
              (equal (list (cadr x) (caddr x) (car x) (cadddr x)) a fuzz)
              (equal (list (cadddr x) (cadr x) (caddr x) (car x)) a fuzz)
              (equal (list (caddr x) (cadr x) (cadddr x) (car x)) a fuzz)
              (equal (list (cadr x) (cadddr x) (caddr x) (car x)) a fuzz)
              (equal (list (cadddr x) (caddr x) (cadr x) (car x)) a fuzz)
            )
          ))
          (cdr lst)
        )
        (progn
          (setq ll (cons a ll))
          (setq lst
            (vl-remove-if
              (function (lambda ( x )
                (or
                  (equal (list (car x) (cadr x) (caddr x) (cadddr x)) a fuzz)
                  (equal (list (car x) (cadr x) (cadddr x) (caddr x)) a fuzz)
                  (equal (list (car x) (cadddr x) (caddr x) (cadr x)) a fuzz)
                  (equal (list (car x) (caddr x) (cadr x) (cadddr x)) a fuzz)
                  (equal (list (cadr x) (car x) (caddr x) (cadddr x)) a fuzz)
                  (equal (list (cadr x) (car x) (cadddr x) (caddr x)) a fuzz)
                  (equal (list (cadddr x) (car x) (caddr x) (cadr x)) a fuzz)
                  (equal (list (caddr x) (car x) (cadr x) (cadddr x)) a fuzz)
                  (equal (list (caddr x) (cadr x) (car x) (cadddr x)) a fuzz)
                  (equal (list (cadddr x) (cadr x) (car x) (caddr x)) a fuzz)
                  (equal (list (caddr x) (cadddr x) (car x) (cadr x)) a fuzz)
                  (equal (list (cadr x) (caddr x) (car x) (cadddr x)) a fuzz)
                  (equal (list (cadddr x) (cadr x) (caddr x) (car x)) a fuzz)
                  (equal (list (caddr x) (cadr x) (cadddr x) (car x)) a fuzz)
                  (equal (list (cadr x) (cadddr x) (caddr x) (car x)) a fuzz)
                  (equal (list (cadddr x) (caddr x) (cadr x) (car x)) a fuzz)
                )
              ))
              (cdr lst)
            )
          )
        )
        (progn
          (setq ll (cons a ll))
          (setq lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun faceseg ( p1 p2 p3 p4 seg / 3df 3dfacesl 3dfv d k n p10 p10v p20 p20v p30 p30v p40 p40v v14 )
    (setq d (/ (distance p1 p2) (float seg)))
    (setq k 0)
    (setq v14
      (mapcar (function *)
        (list d d d)
        (mapcar (function /)
          (mapcar (function -) p4 p1)
          (list (distance p1 p4) (distance p1 p4) (distance p1 p4))
        )
      )
    )
    (repeat seg
      (setq p10
        (mapcar (function +)
          p1
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p2 p1)
              (list (distance p1 p2) (distance p1 p2) (distance p1 p2))
            )
          )
        )
      )
      (setq k (1+ k))
      (setq p20
        (mapcar (function +)
          p1
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p2 p1)
              (list (distance p1 p2) (distance p1 p2) (distance p1 p2))
            )
          )
        )
      )
      (setq p30 (mapcar (function +) p20 v14))
      (setq p40 (mapcar (function +) p10 v14))
      (setq 3df (list p10 p20 p30 p40))
      (setq 3dfacesl (cons 3df 3dfacesl))
      (setq n 0)
      (repeat (1- seg)
        (setq n (1+ n))
        (setq p10v (mapcar (function +) p10 (mapcar (function *) (list n n n) v14)))
        (setq p20v (mapcar (function +) p20 (mapcar (function *) (list n n n) v14)))
        (setq p30v (mapcar (function +) p30 (mapcar (function *) (list n n n) v14)))
        (setq p40v (mapcar (function +) p40 (mapcar (function *) (list n n n) v14)))
        (setq 3dfv (list p10v p20v p30v p40v))
        (setq 3dfacesl (cons 3dfv 3dfacesl))
      )
    )
    3dfacesl
  )

  (defun projfaces2sph ( 3dfaces rad / 3dfacesl 3dfp p1 p1p p2 p2p p3 p3p p4 p4p )
    (foreach 3df 3dfaces
      (setq p1 (car 3df))
      (setq p2 (cadr 3df))
      (setq p3 (caddr 3df))
      (setq p4 (cadddr 3df))
      (setq p1p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p1
            (list
              (distance (list 0.0 0.0 0.0) p1)
              (distance (list 0.0 0.0 0.0) p1)
              (distance (list 0.0 0.0 0.0) p1)
            )
          )
        )
      )
      (setq p2p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p2
            (list
              (distance (list 0.0 0.0 0.0) p2)
              (distance (list 0.0 0.0 0.0) p2)
              (distance (list 0.0 0.0 0.0) p2)
            )
          )
        )
      )
      (setq p3p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p3
            (list
              (distance (list 0.0 0.0 0.0) p3)
              (distance (list 0.0 0.0 0.0) p3)
              (distance (list 0.0 0.0 0.0) p3)
            )
          )
        )
      )
      (setq p4p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p4
            (list
              (distance (list 0.0 0.0 0.0) p4)
              (distance (list 0.0 0.0 0.0) p4)
              (distance (list 0.0 0.0 0.0) p4)
            )
          )
        )
      )
      (setq 3dfp (list p1p p2p p3p p4p))
      (setq 3dfacesl (cons 3dfp 3dfacesl))
    )
    3dfacesl
  )

  (setq cmd (getvar (quote cmdecho)))
  (setvar (quote cmdecho) 0)
  (if (= 8 (logand 8 (getvar (quote undoctl))))
    (if command-s
      (command-s "_.UNDO" "_E")
      (vl-cmdf "_.UNDO" "_E")
    )
  )
  (if command-s
    (command-s "_.UNDO" "_M")
    (vl-cmdf "_.UNDO" "_M")
  )
  (setq tao2 (sqrt 2.0))
  (setq tao3 (sqrt 3.0))
  (setq ptcubelst (list 
                     (list 0.0 0.0 (/ tao3 2.0)) 
                     (list 0.0 (cos (atan (/ tao2 2.0))) (/ tao3 6.0))
                     (list (- (/ tao2 2.0)) (* 0.5 (cos (atan (/ tao2 2.0)))) (- (/ tao3 6)))
                     (list (- (/ tao2 2.0)) (* (- 0.5) (cos (atan (/ tao2 2.0)))) (/ tao3 6))
                     (list (/ tao2 2.0) (* (- 0.5) (cos (atan (/ tao2 2.0)))) (/ tao3 6))
                     (list (/ tao2 2.0) (* 0.5 (cos (atan (/ tao2 2.0)))) (- (/ tao3 6)))
                     (list 0.0 0.0 (- (/ tao3 2.0)))
                     (list 0.0 (- (cos (atan (/ tao2 2.0)))) (- (/ tao3 6.0)))
                   )
  )
  (if
    (and
      (setq o (getpoint "\nPick or specify center point : "))
      (not (initget 6))
      (setq rad
        (cond
          ( (getdist o "\nPick or specify radius <1.0> : ") )
          (1.0)
        )
      )
      (setq seg 1)
    )
    (progn
      (setq ss (ssadd))
      (if command-s
        (command-s "_.UCS" "_M" "_non" o)
        (vl-cmdf "_.UCS" "_M" "_non" o)
      )
      (setq r (distance (list 0.0 0.0 0.0) (car ptcubelst)))
      (setq m (/ rad r))
      (setq ptcubelstn
        (mapcar
          (function (lambda ( pt )
            (list (* m (car pt)) (* m (cadr pt)) (* m (caddr pt)))
          ))
          ptcubelst
        )
      )
      (setq cubef1 (projfaces2sph (faceseg (nth 0 ptcubelstn) (nth 1 ptcubelstn) (nth 2 ptcubelstn) (nth 3 ptcubelstn) seg) rad))
      (setq cubef2 (projfaces2sph (faceseg (nth 0 ptcubelstn) (nth 1 ptcubelstn) (nth 5 ptcubelstn) (nth 4 ptcubelstn) seg) rad))
      (setq cubef3 (projfaces2sph (faceseg (nth 1 ptcubelstn) (nth 2 ptcubelstn) (nth 6 ptcubelstn) (nth 5 ptcubelstn) seg) rad))
      (setq cubef4 (projfaces2sph (faceseg (nth 2 ptcubelstn) (nth 3 ptcubelstn) (nth 7 ptcubelstn) (nth 6 ptcubelstn) seg) rad))
      (setq cubef5 (projfaces2sph (faceseg (nth 3 ptcubelstn) (nth 0 ptcubelstn) (nth 4 ptcubelstn) (nth 7 ptcubelstn) seg) rad))
      (setq cubef6 (projfaces2sph (faceseg (nth 4 ptcubelstn) (nth 5 ptcubelstn) (nth 6 ptcubelstn) (nth 7 ptcubelstn) seg) rad))
      (setq allfaces (append cubef1 cubef2 cubef3 cubef4 cubef5 cubef6))
      (setq allfaces (uniquefacesfuzz allfaces 1e-5))
      (setq d (/ (distance (caar allfaces) (cadar allfaces)) 2.0))
      (setq q (- rad d))
      (foreach face allfaces
        (ssadd
          (entmakex
            (list
              (cons 0 "3DFACE")
              (cons 10 (trans (car face) 1 0))
              (cons 11 (trans (cadr face) 1 0))
              (cons 12 (trans (caddr face) 1 0))
              (cons 13 (trans (cadddr face) 1 0))
            )
          )
          ss
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (car face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (car face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (car face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (car face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (cadr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (cadr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (caddr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (caddr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (caddr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (caddr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (cadddr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (cadddr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadddr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadddr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (setq fc
          (uniquefuzz
            (list
              (car face)
              (cadr face)
              (caddr face)
              (cadddr face)
            )
            1e-5
          )
        )
        (cond
          ( (= (length fc) 3)
            (setq ce
              (mapcar
                (function (lambda ( a b c )
                  (/ (+ a b c) 3.0)
                ))
                (car fc)
                (cadr fc)
                (caddr fc)
              )
            )
          )
          ( (= (length fc) 4)
            (setq ce
              (mapcar
                (function (lambda ( a b c d )
                  (/ (+ a b c d) 4.0)
                ))
                (car fc)
                (cadr fc)
                (caddr fc)
                (cadddr fc)
              )
            )
          )
        )
        (setq cc
          (mapcar (function +)
            (list 0.0 0.0 0.0)
            (mapcar (function *)
              (unit
                (mapcar (function -)
                  ce
                  (list 0.0 0.0 0.0)
                )
              )
              (list (+ d rad) (+ d rad) (+ d rad))
            )
          )
        )
        (setq c
          (mapcar (function +)
            cc
            (mapcar (function *)
              (unit
                (mapcar (function -)
                  (list 0.0 0.0 0.0)
                  ce
                )
              )
              (list q q q)
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x c 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons c pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" c)
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" c)
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 (- (+ rad d) q)) q)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 (- (+ rad d) q)) q)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
      )
      (if command-s
        (command-s "_.SPHERE" "_non" (list 0.0 0.0 0.0) (- rad d))
        (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 0.0) (- rad d))
      )
      (ssadd (entlast) ss)
      (if command-s
        (command-s "_.SPHERE" "_non" (list 0.0 0.0 0.0) (+ rad d))
        (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 0.0) (+ rad d))
      )
      (ssadd (entlast) ss)
      (if command-s
        (command-s "_.SCALE" ss "" "_non" (list 0.0 0.0 0.0) (/ rad (+ rad d)))
        (vl-cmdf "_.SCALE" ss "" "_non" (list 0.0 0.0 0.0) (/ rad (+ rad d)))
      )
      (if command-s
        (command-s "_.UCS" "_P")
        (vl-cmdf "_.UCS" "_P")
      )
      (setvar (quote perspective) 1)
      (if command-s
        (command-s "_.ZOOM" "_E")
        (vl-cmdf "_.ZOOM" "_E")
      )
      (if command-s
        (command-s "_.VSCURRENT" "X")
        (vl-cmdf "_.VSCURRENT" "X")
      )
      (if (= "BRICSCAD" (getvar (quote program)))
        (progn
          (vl-cmdf "_.RTROTCTR" "_non" o)
          (while (< 0 (getvar (quote cmdactive)))
            (vl-cmdf "\\")
          )
        )
        (progn
          (if command-s
            (command-s "_.3DORBITCTR" "_non" o)
            (vl-cmdf "_.3DORBITCTR" "_non" o)
          )
        )
      )
      (prompt "\nFor UNDO - type \"UNDO\" - \"Back\" option...")
    )
  )
  (*error* nil)
)