(defun c:spheres-build-dodeca2 ( / *error* unit uniquefuzz uniquefacesfuzz v^v vxs norm prptp cen5gon tg faceseg projfaces2sph allfaces dodecaf1 dodecaf10 dodecaf11 dodecaf12 dodecaf2 dodecaf3 dodecaf4 dodecaf5 dodecaf6 dodecaf7 dodecaf8 dodecaf9 icosaf1 icosaf10 icosaf11 icosaf12 icosaf13 icosaf14 icosaf15 icosaf16 icosaf17 icosaf18 icosaf19 icosaf2 icosaf20 icosaf3 icosaf4 icosaf5 icosaf6 icosaf7 icosaf8 icosaf9 m pt ptdodecalst ptdodecalstn pticosalst r rad seg tao cmd d dd q fc ce c cc pl ss )

  (defun *error* ( m )
    (if (= 8 (logand 8 (getvar (quote undoctl))))
      (if command-s
        (command-s "_.UNDO" "_E")
        (vl-cmdf "_.UNDO" "_E")
      )
    )
    (if cmd
      (setvar (quote cmdecho) cmd)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun unit ( v / d )
    (if (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
      (mapcar (function (lambda ( x ) (/ x d))) v)
      (progn
        (prompt "\nReference vector strength near 0.0... Invalid input specification... Quitting...")
        (exit)
      )
    )
  )

  (defun uniquefuzz ( lst fuzz / a ll )
    (while (setq a (car lst))
      (if
        (vl-some
          (function (lambda ( x )
            (equal x a fuzz)
          ))
          (cdr lst)
        )
        (progn
          (setq ll (cons a ll))
          (setq lst
            (vl-remove-if
              (function (lambda ( x )
                (equal x a fuzz)
              ))
              (cdr lst)
            )
          )
        )
        (progn
          (setq ll (cons a ll))
          (setq lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun uniquefacesfuzz ( lst fuzz / a ll )
    (while (setq a (car lst))
      (if
        (vl-some
          (function (lambda ( x )
            (or
              (equal (list (car x) (cadr x) (caddr x) (cadddr x)) a fuzz)
              (equal (list (car x) (cadr x) (cadddr x) (caddr x)) a fuzz)
              (equal (list (car x) (cadddr x) (caddr x) (cadr x)) a fuzz)
              (equal (list (car x) (caddr x) (cadr x) (cadddr x)) a fuzz)
              (equal (list (cadr x) (car x) (caddr x) (cadddr x)) a fuzz)
              (equal (list (cadr x) (car x) (cadddr x) (caddr x)) a fuzz)
              (equal (list (cadddr x) (car x) (caddr x) (cadr x)) a fuzz)
              (equal (list (caddr x) (car x) (cadr x) (cadddr x)) a fuzz)
              (equal (list (caddr x) (cadr x) (car x) (cadddr x)) a fuzz)
              (equal (list (cadddr x) (cadr x) (car x) (caddr x)) a fuzz)
              (equal (list (caddr x) (cadddr x) (car x) (cadr x)) a fuzz)
              (equal (list (cadr x) (caddr x) (car x) (cadddr x)) a fuzz)
              (equal (list (cadddr x) (cadr x) (caddr x) (car x)) a fuzz)
              (equal (list (caddr x) (cadr x) (cadddr x) (car x)) a fuzz)
              (equal (list (cadr x) (cadddr x) (caddr x) (car x)) a fuzz)
              (equal (list (cadddr x) (caddr x) (cadr x) (car x)) a fuzz)
            )
          ))
          (cdr lst)
        )
        (progn
          (setq ll (cons a ll))
          (setq lst
            (vl-remove-if
              (function (lambda ( x )
                (or
                  (equal (list (car x) (cadr x) (caddr x) (cadddr x)) a fuzz)
                  (equal (list (car x) (cadr x) (cadddr x) (caddr x)) a fuzz)
                  (equal (list (car x) (cadddr x) (caddr x) (cadr x)) a fuzz)
                  (equal (list (car x) (caddr x) (cadr x) (cadddr x)) a fuzz)
                  (equal (list (cadr x) (car x) (caddr x) (cadddr x)) a fuzz)
                  (equal (list (cadr x) (car x) (cadddr x) (caddr x)) a fuzz)
                  (equal (list (cadddr x) (car x) (caddr x) (cadr x)) a fuzz)
                  (equal (list (caddr x) (car x) (cadr x) (cadddr x)) a fuzz)
                  (equal (list (caddr x) (cadr x) (car x) (cadddr x)) a fuzz)
                  (equal (list (cadddr x) (cadr x) (car x) (caddr x)) a fuzz)
                  (equal (list (caddr x) (cadddr x) (car x) (cadr x)) a fuzz)
                  (equal (list (cadr x) (caddr x) (car x) (cadddr x)) a fuzz)
                  (equal (list (cadddr x) (cadr x) (caddr x) (car x)) a fuzz)
                  (equal (list (caddr x) (cadr x) (cadddr x) (car x)) a fuzz)
                  (equal (list (cadr x) (cadddr x) (caddr x) (car x)) a fuzz)
                  (equal (list (cadddr x) (caddr x) (cadr x) (car x)) a fuzz)
                )
              ))
              (cdr lst)
            )
          )
        )
        (progn
          (setq ll (cons a ll))
          (setq lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun v^v ( u v )
    (list
      (- (* (cadr u) (caddr v)) (* (cadr v) (caddr u)))
      (- (* (car  v) (caddr u)) (* (car  u) (caddr v)))
      (- (* (car  u) (cadr  v)) (* (car  v) (cadr  u)))
    )
  )

  (defun vxs ( v s )
    (mapcar
      (function (lambda ( n )
        (* n s)
      ))
      v
    )
  )

  (defun norm ( v )
    (sqrt
      (apply (function +)
        (mapcar (function *) v v)
      )
    )
  )

  (defun prptp ( pt1 pt2 pt3 pt / pt1w pt2w pt3w ptw u v n ptn pt1n pt4n )
    (if (and pt1 pt2 pt3 pt)
      (progn
        (setq pt1w (trans pt1 1 0))
        (setq pt2w (trans pt2 1 0))
        (setq pt3w (trans pt3 1 0))
        (setq ptw  (trans pt 1 0))
        (setq u (mapcar (function -) pt2w pt1w))
        (setq v (mapcar (function -) pt3w pt1w))
        (setq n (unit (v^v u v)))
        (setq ptn (trans ptw 0 n))
        (setq pt1n (trans pt1w 0 n))
        (setq pt4n (list (car ptn) (cadr ptn) (caddr pt1n)))
      )
    )
    (trans pt4n n 0)
  )

  (defun cen5gon ( p1 p2 p3 p4 p5 )
    (mapcar
      (function (lambda (p1 p2 p3 p4 p5)
        (/ (+ p1 p2 p3 p4 p5) 5.0)
      ))
      p1
      p2
      p3
      p4
      p5
    )
  )

  (defun tg ( a )
    (cond
      ( (and
          (not (minusp (- (* 0.5 pi) a)))
          (equal a (* 0.5 pi) 1e-5)
        )
        1e+308
      )
      ( (and
          (minusp (- (* 0.5 pi) a))
          (equal a (* 0.5 pi) 1e-5)
        )
        -1e+308
      )
      ( (and
          (not (minusp (- (* 1.5 pi) a)))
          (equal a (* 1.5 pi) 1e-5)
        )
        1e+308
      )
      ( (and
          (minusp (- (* 1.5 pi) a))
          (equal a (* 1.5 pi) 1e-5)
        )
        -1e+308
      )
      ( t
        (/ (sin a) (cos a))
      )
    )
  )

  (defun faceseg ( p1 p2 p3 p4 p5 seg / 3df 3dfacesl ce d k p1n p10 p11 p12 p13 p2n p20 p21 p22 p23 p3n p30 p31 p32 p33 p4n p40 p41 p42 p43 p5n p50 p51 p52 p53 v1c v2c v3c v4c v5c )
    (setq d (/ (distance p1 p2) (float seg)))
    (setq ce (cen5gon p1 p2 p3 p4 p5))
    (setq k 0)
    (repeat seg
      (setq p10
        (mapcar (function +)
          p1
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p2 p1)
              (list (distance p1 p2) (distance p1 p2) (distance p1 p2))
            )
          )
        )
      )
      (setq k (1+ k))
      (setq p11
        (mapcar (function +)
          p1
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p2 p1)
              (list (distance p1 p2) (distance p1 p2) (distance p1 p2))
            )
          )
        )
      )
      (if (= seg 1)
        (setq p12 ce p13 p12)
        (progn 
          (setq v1c
            (mapcar (function *)
              (list (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))))
              (unit
                (mapcar (function -)
                  ce
                  (mapcar
                    (function (lambda ( p1 p2 )
                      (/ (+ p1 p2) 2.0)
                    ))
                    p1
                    p2
                  )
                )
              )
            )
          )
          (if (= k seg)
            (progn
              (setq p12 (mapcar (function +) p10 v1c))
              (setq p13 p10)
            )
            (progn
              (setq p12 (mapcar (function +) p11 v1c))
              (setq p13 (mapcar (function +) p10 v1c))
            )
          )
          (if (= k 1)
            (setq p1n p12 p13 p10)
            (setq p13 (mapcar (function +) p10 v1c))
          )
        )
      )
      (setq 3df (list p10 p11 p12 p13))
      (setq 3dfacesl (cons 3df 3dfacesl))
      (setq k (1- k))
      (setq p20
        (mapcar (function +)
          p2
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p3 p2)
              (list (distance p2 p3) (distance p2 p3) (distance p2 p3))
            )
          )
        )
      )
      (setq k (1+ k))
      (setq p21
        (mapcar (function +)
          p2
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p3 p2)
              (list (distance p2 p3) (distance p2 p3) (distance p2 p3))
            )
          )
        )
      )
      (if (= seg 1)
        (setq p22 ce p23 p22)
        (progn 
          (setq v2c
            (mapcar (function *)
              (list (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))))
              (unit
                (mapcar (function -)
                  ce
                  (mapcar
                    (function (lambda ( p1 p2 )
                      (/ (+ p1 p2) 2.0)
                    ))
                    p2
                    p3
                  )
                )
              )
            )
          )
          (if (= k seg)
            (progn
              (setq p22 (mapcar (function +) p20 v2c))
              (setq p23 p20)
            )
            (progn
              (setq p22 (mapcar (function +) p21 v2c))
              (setq p23 (mapcar (function +) p20 v2c))
            )
          )
          (if (= k 1)
            (setq p2n p22 p23 p20)
            (setq p23 (mapcar (function +) p20 v2c))
          )
        )
      ) 
      (setq 3df (list p20 p21 p22 p23))
      (setq 3dfacesl (cons 3df 3dfacesl))
      (setq k (1- k))
      (setq p30
        (mapcar (function +)
          p3
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p4 p3)
              (list (distance p3 p4) (distance p3 p4) (distance p3 p4))
            )
          )
        )
      )
      (setq k (1+ k))
      (setq p31
        (mapcar (function +)
          p3
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p4 p3)
              (list (distance p3 p4) (distance p3 p4) (distance p3 p4))
            )
          )
        )
      )
      (if (= seg 1)
        (setq p32 ce p33 p32)
        (progn 
          (setq v3c
            (mapcar (function *)
              (list (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))))
              (unit
                (mapcar (function -)
                  ce
                  (mapcar
                    (function (lambda ( p1 p2 )
                      (/ (+ p1 p2) 2.0)
                    ))
                    p3
                    p4
                  )
                )
              )
            )
          )
          (if (= k seg)
            (progn
              (setq p32 (mapcar (function +) p30 v3c))
              (setq p33 p30)
            )
            (progn
              (setq p32 (mapcar (function +) p31 v3c))
              (setq p33 (mapcar (function +) p30 v3c))
            )
          )
          (if (= k 1)
            (setq p3n p32 p33 p30)
            (setq p33 (mapcar (function +) p30 v3c))
          )
        )
      )
      (setq 3df (list p30 p31 p32 p33))
      (setq 3dfacesl (cons 3df 3dfacesl))
      (setq k (1- k))
      (setq p40
        (mapcar (function +)
          p4
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p5 p4)
              (list (distance p4 p5) (distance p4 p5) (distance p4 p5))
            )
          )
        )
      )
      (setq k (1+ k))
      (setq p41
        (mapcar (function +)
          p4
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p5 p4)
              (list (distance p4 p5) (distance p4 p5) (distance p4 p5))
            )
          )
        )
      )
      (if (= seg 1)
        (setq p42 ce p43 p42)
        (progn 
          (setq v4c
            (mapcar (function *)
              (list (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))))
              (unit
                (mapcar (function -)
                  ce
                  (mapcar
                    (function (lambda ( p1 p2 )
                      (/ (+ p1 p2) 2.0)
                    ))
                    p4
                    p5
                  )
                )
              )
            )
          )
          (if (= k seg)
            (progn
              (setq p42 (mapcar (function +) p40 v4c))
              (setq p43 p40)
            )
            (progn
              (setq p42 (mapcar (function +) p41 v4c))
              (setq p43 (mapcar (function +) p40 v4c))
            )
          )
          (if (= k 1)
            (setq p4n p42 p43 p40)
            (setq p43 (mapcar (function +) p40 v4c))
          )
        )
      ) 
      (setq 3df (list p40 p41 p42 p43))
      (setq 3dfacesl (cons 3df 3dfacesl))
      (setq k (1- k))
      (setq p50
        (mapcar (function +)
          p5
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p1 p5)
              (list (distance p5 p1) (distance p5 p1) (distance p5 p1))
            )
          )
        )
      )
      (setq k (1+ k))
      (setq p51
        (mapcar (function +)
          p5
          (mapcar (function *)
            (list (* d (float k)) (* d (float k)) (* d (float k)))
            (mapcar (function /)
              (mapcar (function -) p1 p5)
              (list (distance p5 p1) (distance p5 p1) (distance p5 p1))
            )
          )
        )
      )
      (if (= seg 1)
        (setq p52 ce p53 p52)
        (progn 
          (setq v5c
            (mapcar (function *)
              (list (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))) (/ d (tg (/ pi 5.0))))
              (unit
                (mapcar (function -)
                  ce
                  (mapcar
                    (function (lambda ( p1 p2 )
                      (/ (+ p1 p2) 2.0)
                    ))
                    p1
                    p5
                  )
                )
              )
            )
          )
          (if (= k seg)
            (progn
              (setq p52 (mapcar (function +) p50 v5c))
              (setq p53 p50)
            )
            (progn
              (setq p52 (mapcar (function +) p51 v5c))
              (setq p53 (mapcar (function +) p50 v5c))
            )
          )
          (if (= k 1)
            (setq p5n p52 p53 p50)
            (setq p53 (mapcar (function +) p50 v5c))
          )
        )
      ) 
      (setq 3df (list p50 p51 p52 p53))
      (setq 3dfacesl (cons 3df 3dfacesl))
    )
    (if (> seg 2) (faceseg p1n p2n p3n p4n p5n (- seg 2)))
    3dfacesl
  )

  (defun projfaces2sph ( 3dfaces rad / 3dfacesl 3dfp p1 p1p p2 p2p p3 p3p p4 p4p )
    (foreach 3df 3dfaces
      (setq p1 (car 3df))
      (setq p2 (cadr 3df))
      (setq p3 (caddr 3df))
      (setq p4 (cadddr 3df))
      (setq p1p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p1
            (list
              (distance (list 0.0 0.0 0.0) p1)
              (distance (list 0.0 0.0 0.0) p1)
              (distance (list 0.0 0.0 0.0) p1)
            )
          )
        )
      )
      (setq p2p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p2
            (list
              (distance (list 0.0 0.0 0.0) p2)
              (distance (list 0.0 0.0 0.0) p2)
              (distance (list 0.0 0.0 0.0) p2)
            )
          )
        )
      )
      (setq p3p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p3
            (list
              (distance (list 0.0 0.0 0.0) p3)
              (distance (list 0.0 0.0 0.0) p3)
              (distance (list 0.0 0.0 0.0) p3)
            )
          )
        )
      )
      (setq p4p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p4
            (list
              (distance (list 0.0 0.0 0.0) p4)
              (distance (list 0.0 0.0 0.0) p4)
              (distance (list 0.0 0.0 0.0) p4)
            )
          )
        )
      )
      (setq 3dfp (list p1p p2p p3p p4p))
      (setq 3dfacesl (cons 3dfp 3dfacesl))
    )
    3dfacesl
  )

  (setq cmd (getvar (quote cmdecho)))
  (setvar (quote cmdecho) 0)
  (if (= 8 (logand 8 (getvar (quote undoctl))))
    (if command-s
      (command-s "_.UNDO" "_E")
      (vl-cmdf "_.UNDO" "_E")
    )
  )
  (if command-s
    (command-s "_.UNDO" "_M")
    (vl-cmdf "_.UNDO" "_M")
  )
  (setq tao (/ (+ (sqrt 5.0) 1.0) 2.0))
  (setq pticosalst (list 
                     (list 0.0 0.0 (sqrt (+ (expt tao 2) 1.0))) 
                     (list (* tao (+ (tg (/ pi 10.0)) (tg (/ pi 5.0)))) 0.0 (/ tao (sqrt (+ (expt tao 2) 1.0))))
                     (list (* tao (tg (/ pi 10.0))) tao (/ tao (sqrt (+ (expt tao 2) 1.0)))) (list (/ (- 1.0) (tg (/ pi 5.0))) 1.0 (/ tao (sqrt (+ (expt tao 2) 1.0))))
                     (list (/ (- 1.0) (tg (/ pi 5.0))) -1.0 (/ tao (sqrt (+ (expt tao 2) 1.0)))) (list (* tao (tg (/ pi 10.0))) (- tao) (/ tao (sqrt (+ (expt tao 2) 1.0))))
                     (list (/ 1.0 (tg (/ pi 5.0))) 1.0 (/ (- tao) (sqrt (+ (expt tao 2) 1.0)))) (list (* (- tao) (tg (/ pi 10.0))) tao (/ (- tao) (sqrt (+ (expt tao 2) 1.0))))
                     (list (* (- tao) (+ (tg (/ pi 10.0)) (tg (/ pi 5.0)))) 0.0 (/ (- tao) (sqrt (+ (expt tao 2) 1.0))))
                     (list (* (- tao) (tg (/ pi 10.0))) (- tao) (/ (- tao) (sqrt (+ (expt tao 2) 1.0)))) (list (/ 1.0 (tg (/ pi 5.0))) -1.0 (/ (- tao) (sqrt (+ (expt tao 2) 1.0))))
                     (list 0.0 0.0 (- (sqrt (+ (expt tao 2) 1.0))))
                   )
  )
  (setq icosaf1 (prptp (nth 0 pticosalst) (nth 1 pticosalst) (nth 2 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf2 (prptp (nth 0 pticosalst) (nth 2 pticosalst) (nth 3 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf3 (prptp (nth 0 pticosalst) (nth 3 pticosalst) (nth 4 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf4 (prptp (nth 0 pticosalst) (nth 4 pticosalst) (nth 5 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf5 (prptp (nth 0 pticosalst) (nth 5 pticosalst) (nth 1 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf6 (prptp (nth 1 pticosalst) (nth 2 pticosalst) (nth 6 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf7 (prptp (nth 2 pticosalst) (nth 6 pticosalst) (nth 7 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf8 (prptp (nth 2 pticosalst) (nth 3 pticosalst) (nth 7 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf9 (prptp (nth 3 pticosalst) (nth 7 pticosalst) (nth 8 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf10 (prptp (nth 3 pticosalst) (nth 4 pticosalst) (nth 8 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf11 (prptp (nth 4 pticosalst) (nth 8 pticosalst) (nth 9 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf12 (prptp (nth 4 pticosalst) (nth 5 pticosalst) (nth 9 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf13 (prptp (nth 5 pticosalst) (nth 9 pticosalst) (nth 10 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf14 (prptp (nth 5 pticosalst) (nth 1 pticosalst) (nth 10 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf15 (prptp (nth 1 pticosalst) (nth 10 pticosalst) (nth 6 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf16 (prptp (nth 11 pticosalst) (nth 6 pticosalst) (nth 7 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf17 (prptp (nth 11 pticosalst) (nth 7 pticosalst) (nth 8 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf18 (prptp (nth 11 pticosalst) (nth 8 pticosalst) (nth 9 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf19 (prptp (nth 11 pticosalst) (nth 9 pticosalst) (nth 10 pticosalst) (list 0.0 0.0 0.0)))
  (setq icosaf20 (prptp (nth 11 pticosalst) (nth 10 pticosalst) (nth 6 pticosalst) (list 0.0 0.0 0.0)))
  (setq ptdodecalst (list icosaf1 icosaf2 icosaf3 icosaf4 icosaf5 icosaf6 icosaf7 icosaf8 icosaf9 icosaf10 icosaf11 icosaf12 icosaf13 icosaf14 icosaf15 icosaf16 icosaf17 icosaf18 icosaf19 icosaf20))
  (if
    (and
      (setq o (getpoint "\nPick or specify center point : "))
      (not (initget 6))
      (setq rad
        (cond
          ( (getdist o "\nPick or specify radius <1.0> : ") )
          (1.0)
        )
      )
      (setq seg 1)
    )
    (progn
      (setq ss (ssadd))
      (if command-s
        (command-s "_.UCS" "_M" "_non" o)
        (vl-cmdf "_.UCS" "_M" "_non" o)
      )
      (setq r (distance (list 0.0 0.0 0.0) (car ptdodecalst)))
      (setq m (/ rad r))
      (setq ptdodecalstn
        (mapcar
          (function (lambda ( pt )
            (list (* m (car pt)) (* m (cadr pt)) (* m (caddr pt)))
          ))
          ptdodecalst
        )
      )
      (setq dodecaf1 (projfaces2sph (faceseg (nth 0 ptdodecalstn) (nth 1 ptdodecalstn) (nth 2 ptdodecalstn) (nth 3 ptdodecalstn) (nth 4 ptdodecalstn) seg) rad))
      (setq dodecaf2 (projfaces2sph (faceseg (nth 1 ptdodecalstn) (nth 0 ptdodecalstn) (nth 5 ptdodecalstn) (nth 6 ptdodecalstn) (nth 7 ptdodecalstn) seg) rad))
      (setq dodecaf3 (projfaces2sph (faceseg (nth 2 ptdodecalstn) (nth 1 ptdodecalstn) (nth 7 ptdodecalstn) (nth 8 ptdodecalstn) (nth 9 ptdodecalstn) seg) rad))
      (setq dodecaf4 (projfaces2sph (faceseg (nth 3 ptdodecalstn) (nth 2 ptdodecalstn) (nth 9 ptdodecalstn) (nth 10 ptdodecalstn) (nth 11 ptdodecalstn) seg) rad))
      (setq dodecaf5 (projfaces2sph (faceseg (nth 4 ptdodecalstn) (nth 3 ptdodecalstn) (nth 11 ptdodecalstn) (nth 12 ptdodecalstn) (nth 13 ptdodecalstn) seg) rad))
      (setq dodecaf6 (projfaces2sph (faceseg (nth 0 ptdodecalstn) (nth 4 ptdodecalstn) (nth 13 ptdodecalstn) (nth 14 ptdodecalstn) (nth 5 ptdodecalstn) seg) rad))
      (setq dodecaf7 (projfaces2sph (faceseg (nth 12 ptdodecalstn) (nth 13 ptdodecalstn) (nth 14 ptdodecalstn) (nth 19 ptdodecalstn) (nth 18 ptdodecalstn) seg) rad))
      (setq dodecaf8 (projfaces2sph (faceseg (nth 12 ptdodecalstn) (nth 11 ptdodecalstn) (nth 10 ptdodecalstn) (nth 17 ptdodecalstn) (nth 18 ptdodecalstn) seg) rad))
      (setq dodecaf9 (projfaces2sph (faceseg (nth 10 ptdodecalstn) (nth 9 ptdodecalstn) (nth 8 ptdodecalstn) (nth 16 ptdodecalstn) (nth 17 ptdodecalstn) seg) rad))
      (setq dodecaf10 (projfaces2sph (faceseg (nth 8 ptdodecalstn) (nth 7 ptdodecalstn) (nth 6 ptdodecalstn) (nth 15 ptdodecalstn) (nth 16 ptdodecalstn) seg) rad))
      (setq dodecaf11 (projfaces2sph (faceseg (nth 6 ptdodecalstn) (nth 5 ptdodecalstn) (nth 14 ptdodecalstn) (nth 19 ptdodecalstn) (nth 15 ptdodecalstn) seg) rad))
      (setq dodecaf12 (projfaces2sph (faceseg (nth 15 ptdodecalstn) (nth 16 ptdodecalstn) (nth 17 ptdodecalstn) (nth 18 ptdodecalstn) (nth 19 ptdodecalstn) seg) rad))
      (setq allfaces (append dodecaf1 dodecaf2 dodecaf3 dodecaf4 dodecaf5 dodecaf6 dodecaf7 dodecaf8 dodecaf9 dodecaf10 dodecaf11 dodecaf12))
      (setq allfaces (uniquefacesfuzz allfaces 1e-5))
      (setq d (/ (distance (caar allfaces) (cadar allfaces)) 2.0))
      (setq dd (* rad 0.159823308345630881177612536703236401081085205078125))
      (setq q (/ d 3.14970230611627233230365163763053715229034423828125))
      (foreach face allfaces
        (ssadd
          (entmakex
            (list
              (cons 0 "3DFACE")
              (cons 10 (trans (car face) 1 0))
              (cons 11 (trans (cadr face) 1 0))
              (cons 12 (trans (caddr face) 1 0))
              (cons 13 (trans (cadddr face) 1 0))
            )
          )
          ss
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (car face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (car face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (car face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (car face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (cadr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (cadr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (caddr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (caddr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (caddr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (caddr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (cadddr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (cadddr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadddr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadddr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (setq fc
          (uniquefuzz
            (list
              (car face)
              (cadr face)
              (caddr face)
              (cadddr face)
            )
            1e-5
          )
        )
        (cond
          ( (= (length fc) 3)
            (setq ce
              (mapcar
                (function (lambda ( a b c )
                  (/ (+ a b c) 3.0)
                ))
                (car fc)
                (cadr fc)
                (caddr fc)
              )
            )
          )
          ( (= (length fc) 4)
            (setq ce
              (mapcar
                (function (lambda ( a b c d )
                  (/ (+ a b c d) 4.0)
                ))
                (car fc)
                (cadr fc)
                (caddr fc)
                (cadddr fc)
              )
            )
          )
        )
        (setq cc
          (mapcar (function +)
            (list 0.0 0.0 0.0)
            (mapcar (function *)
              (unit
                (mapcar (function -)
                  ce
                  (list 0.0 0.0 0.0)
                )
              )
              (list (+ d rad) (+ d rad) (+ d rad))
            )
          )
        )
        (setq c
          (mapcar (function +)
            cc
            (mapcar (function *)
              (unit
                (mapcar (function -)
                  (list 0.0 0.0 0.0)
                  ce
                )
              )
              (list q q q)
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x c 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons c pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" c)
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" c)
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 (- (+ rad d) dd)) dd)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 (- (+ rad d) dd)) dd)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
      )
      (if command-s
        (command-s "_.SPHERE" "_non" (list 0.0 0.0 0.0) (- rad d))
        (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 0.0) (- rad d))
      )
      (ssadd (entlast) ss)
      (if command-s
        (command-s "_.SPHERE" "_non" (list 0.0 0.0 0.0) (+ rad d))
        (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 0.0) (+ rad d))
      )
      (ssadd (entlast) ss)
      (if command-s
        (command-s "_.SCALE" ss "" "_non" (list 0.0 0.0 0.0) (/ rad (+ rad d)))
        (vl-cmdf "_.SCALE" ss "" "_non" (list 0.0 0.0 0.0) (/ rad (+ rad d)))
      )
      (if command-s
        (command-s "_.UCS" "_P")
        (vl-cmdf "_.UCS" "_P")
      )
      (setvar (quote perspective) 1)
      (if command-s
        (command-s "_.ZOOM" "_E")
        (vl-cmdf "_.ZOOM" "_E")
      )
      (if command-s
        (command-s "_.VSCURRENT" "X")
        (vl-cmdf "_.VSCURRENT" "X")
      )
      (if (= "BRICSCAD" (getvar (quote program)))
        (progn
          (vl-cmdf "_.RTROTCTR" "_non" o)
          (while (< 0 (getvar (quote cmdactive)))
            (vl-cmdf "\\")
          )
        )
        (progn
          (if command-s
            (command-s "_.3DORBITCTR" "_non" o)
            (vl-cmdf "_.3DORBITCTR" "_non" o)
          )
        )
      )
      (prompt "\nFor UNDO - type \"UNDO\" - \"Back\" option...")
    )
  )
  (*error* nil)
)