(defun c:spheres-build-octa1 ( / *error* unit uniquefacesfuzz faceseg projfaces2sph allfaces m octaf1 octaf2 octaf3 octaf4 octaf5 octaf6 octaf7 octaf8 pt ptoctalst ptoctalstn r rad seg tao cmd d q ce c cc pl ss )

  (defun *error* ( m )
    (if (= 8 (logand 8 (getvar (quote undoctl))))
      (if command-s
        (command-s "_.UNDO" "_E")
        (vl-cmdf "_.UNDO" "_E")
      )
    )
    (if cmd
      (setvar (quote cmdecho) cmd)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun unit ( v / d )
    (if (not (equal (setq d (distance (list 0.0 0.0 0.0) v)) 0.0 1e-8))
      (mapcar (function (lambda ( x ) (/ x d))) v)
      (progn
        (prompt "\nReference vector strength near 0.0... Invalid input specification... Quitting...")
        (exit)
      )
    )
  )

  (defun uniquefacesfuzz ( lst fuzz / a ll )
    (while (setq a (car lst))
      (if
        (vl-some
          (function (lambda ( x )
            (or
              (equal (list (car x) (cadr x) (caddr x)) a fuzz)
              (equal (list (cadr x) (car x) (caddr x)) a fuzz)
              (equal (list (caddr x) (cadr x) (car x)) a fuzz)
              (equal (list (car x) (caddr x) (cadr x)) a fuzz)
            )
          ))
          (cdr lst)
        )
        (progn
          (setq ll (cons a ll))
          (setq lst
            (vl-remove-if
              (function (lambda ( x )
                (or
                  (equal (list (car x) (cadr x) (caddr x)) a fuzz)
                  (equal (list (cadr x) (car x) (caddr x)) a fuzz)
                  (equal (list (caddr x) (cadr x) (car x)) a fuzz)
                  (equal (list (car x) (caddr x) (cadr x)) a fuzz)
                )
              ))
              (cdr lst)
            )
          )
        )
        (progn
          (setq ll (cons a ll))
          (setq lst (cdr lst))
        )
      )
    )
    (reverse ll)
  )

  (defun faceseg ( p1 p2 p3 seg / 3df 3dfacesl 3dfi 3dfv d k n p12 p12v p30 p30v p30o p31 p31v v12 )
    (setq d (/ (distance p1 p2) (float seg)))
    (setq k 0)
    (setq v12
      (mapcar (function *)
        (list d d d)
        (mapcar (function /)
          (mapcar (function -) p2 p1)
          (list
            (distance p1 p2)
            (distance p1 p2)
            (distance p1 p2)
          )
        )
      )
    )
    (repeat seg
      (setq p30
        (mapcar (function +)
          p3
          (mapcar (function *)
            (list
              (* d (float k))
              (* d (float k))
              (* d (float k))
            )
            (mapcar (function /)
              (mapcar (function -) p1 p3)
              (list
                (distance p1 p3)
                (distance p1 p3)
                (distance p1 p3)
              )
            )
          )
        )
      )
      (setq k (1+ k))
      (setq p31
        (mapcar (function +)
          p3
          (mapcar (function *)
            (list
              (* d (float k))
              (* d (float k))
              (* d (float k))
            )
            (mapcar (function /)
              (mapcar (function -) p1 p3)
              (list
                (distance p1 p3)
                (distance p1 p3)
                (distance p1 p3)
              )
            )
          )
        )
      )
      (setq p12 (mapcar (function +) p31 v12))
      (setq 3df (list p30 p31 p12))
      (setq 3dfacesl (cons 3df 3dfacesl))
      (setq n 0)
      (repeat (1- k)
        (setq n (1+ n))
        (setq p30v
          (mapcar (function +)
            p30
            (mapcar (function *)
              (list n n n)
              v12
            )
          )
        )
        (setq p31v
          (mapcar (function +)
            p31
            (mapcar (function *)
              (list n n n)
              v12
            )
          )
        )
        (setq p12v
          (mapcar (function +)
            p12
            (mapcar (function *)
              (list n n n)
              v12
            )
          )
        )
        (setq p30o
          (mapcar (function +)
            p30
            (mapcar (function *)
              (list (1- n) (1- n) (1- n))
              v12
            )
          )
        )
        (setq 3dfv (list p30v p31v p12v))
        (setq 3dfi (list p30o p31v p30v))
        (setq 3dfacesl (cons 3dfv 3dfacesl))
        (setq 3dfacesl (cons 3dfi 3dfacesl))
      )
    )
    3dfacesl
  )

  (defun projfaces2sph ( 3dfaces rad / 3dfacesl 3dfp p1 p1p p2 p2p p3 p3p )
    (foreach 3df 3dfaces
      (setq p1 (car 3df))
      (setq p2 (cadr 3df))
      (setq p3 (caddr 3df))
      (setq p1p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p1
            (list
              (distance (list 0.0 0.0 0.0) p1)
              (distance (list 0.0 0.0 0.0) p1)
              (distance (list 0.0 0.0 0.0) p1)
            )
          )
        )
      )
      (setq p2p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p2
            (list
              (distance (list 0.0 0.0 0.0) p2)
              (distance (list 0.0 0.0 0.0) p2)
              (distance (list 0.0 0.0 0.0) p2)
            )
          )
        )
      )
      (setq p3p
        (mapcar (function *)
          (list rad rad rad)
          (mapcar (function /)
            p3
            (list
              (distance (list 0.0 0.0 0.0) p3)
              (distance (list 0.0 0.0 0.0) p3)
              (distance (list 0.0 0.0 0.0) p3)
            )
          )
        )
      )
      (setq 3dfp (list p1p p2p p3p))
      (setq 3dfacesl (cons 3dfp 3dfacesl))
    )
    3dfacesl
  )

  (setq cmd (getvar (quote cmdecho)))
  (setvar (quote cmdecho) 0)
  (if (= 8 (logand 8 (getvar (quote undoctl))))
    (if command-s
      (command-s "_.UNDO" "_E")
      (vl-cmdf "_.UNDO" "_E")
    )
  )
  (if command-s
    (command-s "_.UNDO" "_M")
    (vl-cmdf "_.UNDO" "_M")
  )
  (setq tao (sqrt 2.0))
  (setq ptoctalst (list 
                     (list -1.0 -1.0 0.0) (list 1.0 -1.0 0.0) (list 1.0 1.0 0.0) (list -1.0 1.0 0.0)
                     (list 0.0 0.0 tao) (list 0.0 0.0 (- tao))
                   )
  )
  (if
    (and
      (setq o (getpoint "\nPick or specify center point : "))
      (not (initget 6))
      (setq rad
        (cond
          ( (getdist o "\nPick or specify radius <1.0> : ") )
          (1.0)
        )
      )
      (setq seg 1)
    )
    (progn
      (setq ss (ssadd))
      (if command-s
        (command-s "_.UCS" "_M" "_non" o)
        (vl-cmdf "_.UCS" "_M" "_non" o)
      )
      (setq r (distance (list 0.0 0.0 0.0) (car ptoctalst)))
      (setq m (/ rad r))
      (setq ptoctalstn
        (mapcar
          (function (lambda ( pt )
            (list (* m (car pt)) (* m (cadr pt)) (* m (caddr pt)))
          ))
          ptoctalst
        )
      )
      (setq octaf1 (projfaces2sph (faceseg (nth 0 ptoctalstn) (nth 1 ptoctalstn) (nth 4 ptoctalstn) seg) rad))
      (setq octaf2 (projfaces2sph (faceseg (nth 1 ptoctalstn) (nth 2 ptoctalstn) (nth 4 ptoctalstn) seg) rad))
      (setq octaf3 (projfaces2sph (faceseg (nth 2 ptoctalstn) (nth 3 ptoctalstn) (nth 4 ptoctalstn) seg) rad))
      (setq octaf4 (projfaces2sph (faceseg (nth 0 ptoctalstn) (nth 3 ptoctalstn) (nth 4 ptoctalstn) seg) rad))
      (setq octaf5 (projfaces2sph (faceseg (nth 0 ptoctalstn) (nth 1 ptoctalstn) (nth 5 ptoctalstn) seg) rad))
      (setq octaf6 (projfaces2sph (faceseg (nth 1 ptoctalstn) (nth 2 ptoctalstn) (nth 5 ptoctalstn) seg) rad))
      (setq octaf7 (projfaces2sph (faceseg (nth 2 ptoctalstn) (nth 3 ptoctalstn) (nth 5 ptoctalstn) seg) rad))
      (setq octaf8 (projfaces2sph (faceseg (nth 0 ptoctalstn) (nth 3 ptoctalstn) (nth 5 ptoctalstn) seg) rad))
      (setq allfaces (append octaf1 octaf2 octaf3 octaf4 octaf5 octaf6 octaf7 octaf8))
      (setq allfaces (uniquefacesfuzz allfaces 1e-5))
      (setq d (/ (distance (caar allfaces) (cadar allfaces)) 2.0))
      (setq q (/ d 1.8001991549907391032547820941545069217681884765625))
      (foreach face allfaces
        (ssadd
          (entmakex
            (list
              (cons 0 "3DFACE")
              (cons 10 (trans (car face) 1 0))
              (cons 11 (trans (cadr face) 1 0))
              (cons 12 (trans (caddr face) 1 0))
              (cons 13 (trans (caddr face) 1 0))
            )
          )
          ss
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (car face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (car face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (car face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (car face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (cadr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (cadr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (cadr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x (caddr face) 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons (caddr face) pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (caddr face))
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" (caddr face))
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 rad) d)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
        (setq ce
          (mapcar
            (function (lambda ( a b c )
              (/ (+ a b c) 3.0)
            ))
            (car face)
            (cadr face)
            (caddr face)
          )
        )
        (setq cc
          (mapcar (function +)
            (list 0.0 0.0 0.0)
            (mapcar (function *)
              (unit
                (mapcar (function -)
                  ce
                  (list 0.0 0.0 0.0)
                )
              )
              (list (+ d rad) (+ d rad) (+ d rad))
            )
          )
        )
        (setq c
          (mapcar (function +)
            cc
            (mapcar (function *)
              (unit
                (mapcar (function -)
                  (list 0.0 0.0 0.0)
                  ce
                )
              )
              (list q q q)
            )
          )
        )
        (if
          (not
            (vl-some
              (function (lambda ( x )
                (equal x c 1e-5)
              ))
              pl
            )
          )
          (progn
            (setq pl (cons c pl))
            (if command-s
              (command-s "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" c)
              (vl-cmdf "_.UCS" "_ZA" "_non" (list 0.0 0.0 0.0) "_non" c)
            )
            (if command-s
              (command-s "_.SPHERE" "_non" (list 0.0 0.0 (- (+ rad d) q)) q)
              (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 (- (+ rad d) q)) q)
            )
            (ssadd (entlast) ss)
            (if command-s
              (command-s "_.UCS" "_P")
              (vl-cmdf "_.UCS" "_P")
            )
          )
        )
      )
      (if command-s
        (command-s "_.SPHERE" "_non" (list 0.0 0.0 0.0) (- rad d))
        (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 0.0) (- rad d))
      )
      (ssadd (entlast) ss)
      (if command-s
        (command-s "_.SPHERE" "_non" (list 0.0 0.0 0.0) (+ rad d))
        (vl-cmdf "_.SPHERE" "_non" (list 0.0 0.0 0.0) (+ rad d))
      )
      (ssadd (entlast) ss)
      (if command-s
        (command-s "_.SCALE" ss "" "_non" (list 0.0 0.0 0.0) (/ rad (+ rad d)))
        (vl-cmdf "_.SCALE" ss "" "_non" (list 0.0 0.0 0.0) (/ rad (+ rad d)))
      )
      (if command-s
        (command-s "_.UCS" "_P")
        (vl-cmdf "_.UCS" "_P")
      )
      (setvar (quote perspective) 1)
      (if command-s
        (command-s "_.ZOOM" "_E")
        (vl-cmdf "_.ZOOM" "_E")
      )
      (if command-s
        (command-s "_.VSCURRENT" "X")
        (vl-cmdf "_.VSCURRENT" "X")
      )
      (if (= "BRICSCAD" (getvar (quote program)))
        (progn
          (vl-cmdf "_.RTROTCTR" "_non" o)
          (while (< 0 (getvar (quote cmdactive)))
            (vl-cmdf "\\")
          )
        )
        (progn
          (if command-s
            (command-s "_.3DORBITCTR" "_non" o)
            (vl-cmdf "_.3DORBITCTR" "_non" o)
          )
        )
      )
      (prompt "\nFor UNDO - type \"UNDO\" - \"Back\" option...")
    )
  )
  (*error* nil)
)
