(defun c:TSP-MMR ( / *error* tttt ftoa collinear-p chkinters-p chkinters grid make-lwpolyline car-sort MR:ConvexHull-ptsonHull processEE1 processEE2 processLM AHS:TSP tsp-rnd1 tsp-rnd2 tsp-rnd3 tsp-rnd4 tsp-rnd5 tsp-rnd6 tsp-rnd7 tsp-rnd8 tsp-rnd9 tsp-rnd10 tsp-rnd11 tsp-rnd wcs initvalueslst ucsf ti ss i pl d ch pos pl0 pl1 pl2 pl3 pl4 pl5 pl6 pl7 pl8 pl9 pl10 pl11 pla plll dlll dl ent )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if wcs
      (if ucsf
        (while
          (not
            (and
              (equal (getvar (quote ucsxdir)) (car ucsf) 1e-6)
              (equal (getvar (quote ucsydir)) (cadr ucsf) 1e-6)
              (equal (trans (list 0.0 0.0 1.0) 1 0 t) (caddr ucsf) 1e-6)
            )
          )
          (exe (list "_.UCS" "_P"))
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (if (not (exe (list "_.UNDO" "_E")))
        (if doc
          (vla-endundomark doc)
        )
      )
    )
    (if initvalueslst
      (mapcar (function apply_cadr->car) initvalueslst)
    )
    (foreach fun (list (quote tttt) (quote vl-load) (quote exe) (quote cmdfun) (quote cmderr) (quote catch_cont) (quote apply_cadr->car) (quote ftoa))
      (setq fun nil)
    )
    (if doc
      (vla-regen doc acactiveviewport)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun tttt ( wcs / sysvarpreset sysvarlst sysvarvals ) ;;; wcs (T/nil) ;;; cad, doc, alo, spc - global variables (Visual Lisp main VLA-OBJECT pointers) ;;; vl-load exe cmdfun cmderr catch_cont apply_cadr->car ftoa - library sub functions common for standard template initialization ;;;

    (defun vl-load nil
      (or cad
        (if vlax-get-acad-object
          (setq cad (vlax-get-acad-object))
          (progn
            (vl-load-com)
            (setq cad (vlax-get-acad-object))
          )
        )
      )
      (or doc (setq doc (vla-get-activedocument cad)))
      (or alo (setq alo (vla-get-activelayout doc)))
      (or spc (setq spc (vla-get-block alo)))
    )

    ;;; sometimes not needed to use/initialize AxiveX Visual Lisp extensions - (comment/uncomment) following line ;;;
    (or (and cad doc alo spc) (vl-load))

    (defun exe ( tokenslist )
      ( (lambda ( tokenslist / ctch )
          (if (vl-catch-all-error-p (setq ctch (cmdfun tokenslist t)))
            (progn
              (cmderr tokenslist)
              (catch_cont ctch)
            )
            (progn
              (while (< 0 (getvar (quote cmdactive)))
                (vl-cmdf "")
              )
              t
            )
          )
        )
        tokenslist
      )
    )

    (defun cmdfun ( tokenslist flag / ctch ) ;;; tokenslist - command parameters list of strings ;;; flag - if "t" specified, upon successful execution returns t, otherwise if "nil" specified, return is always nil no matter what outcome of function execution is - it should be successful anyway if specified tokenslist was hardcoded correctly... ;;;
      (if command-s
        (if flag
          (if (not (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command-s) tokenslist))))
            flag
            ctch
          )
          (if (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command-s) tokenslist)))
            ctch
          )
        )
        (if flag
          (if (not (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function vl-cmdf) tokenslist))))
            flag
            ctch
          )
          (if (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command) tokenslist)))
            ctch
          )
        )
      )
    )

    (defun cmderr ( tokenslist ) ;;; tokenslist - list of tokens representing command syntax at which used (cmdfun) failed with successful execution ;;;
      (prompt (strcat "\ncommand execution failure... error at used command tokenslist : " (vl-prin1-to-string tokenslist)))
    )

    (defun catch_cont ( ctch / gr )
      (prompt "\nleft mouse click to continue or enter to generate catch error - ESC to break...")
      (while
        (and
          (vl-catch-all-error-p (or ctch (setq ctch (vl-catch-all-apply (function /) (list 1 0)))))
          (setq gr (grread))
          (/= (car gr) 3)
          (not (equal gr (list 2 13)))
        )
      )
      (if (vl-catch-all-error-p ctch)
        ctch
      )
    )

    (defun apply_cadr->car ( sysvarvaluepair / ctch )
      (setq ctch (vl-catch-all-apply (function setvar) sysvarvaluepair))
      (if (vl-catch-all-error-p ctch)
        (progn
          (prompt (strcat "\ncatched error on setting system variable : " (vl-prin1-to-string (vl-symbol-name (car sysvarvaluepair))) " with value : " (vl-prin1-to-string (cadr sysvarvaluepair))))
          (catch_cont ctch)
        )
      )
    )

    (setq sysvarpreset
      (list
        (list (quote cmdecho) 0)
        (list (quote 3dosmode) 0)
        (list (quote osmode) 0)
        (list (quote unitmode) 0)
        (list (quote cmddia) 0)
        (list (quote ucsvp) 0)
        (list (quote ucsortho) 0)
        (list (quote projmode) 0)
        (list (quote orbitautotarget) 0)
        (list (quote insunits) 0)
        (list (quote hpseparate) 0)
        (list (quote hpgaptol) 0)
        (list (quote halogap) 0)
        (list (quote edgemode) 0)
        (list (quote pickdrag) 0)
        (list (quote qtextmode) 0)
        (list (quote dragsnap) 0)
        (list (quote angdir) 0)
        (list (quote aunits) 0)
        (list (quote limcheck) 0)
        (list (quote gridmode) 0)
        (list (quote nomutt) 0)
        (list (quote apbox) 0)
        (list (quote attdia) 0)
        (list (quote blipmode) 0)
        (list (quote copymode) 0)
        (list (quote circlerad) 0.0)
        (list (quote filletrad) 0.0)
        (list (quote filedia) 1)
        (list (quote autosnap) 1)
        (list (quote objectisolationmode) 1)
        (list (quote highlight) 1)
        (list (quote lispinit) 1)
        (list (quote layerpmode) 1)
        (list (quote fillmode) 1)
        (list (quote dragmodeinterrupt) 1)
        (list (quote dispsilh) 1)
        (list (quote fielddisplay) 1)
        (list (quote deletetool) 1)
        (list (quote delobj) 1)
        (list (quote dblclkedit) 1)
        (list (quote attreq) 1)
        (list (quote explmode) 1)
        (list (quote frameselection) 1)
        (list (quote ltgapselection) 1)
        (list (quote pickfirst) 1)
        (list (quote plinegen) 1)
        (list (quote plinetype) 1)
        (list (quote peditaccept) 1)
        (list (quote solidcheck) 1)
        (list (quote visretain) 1)
        (list (quote regenmode) 1)
        (list (quote celtscale) 1.0)
        (list (quote ltscale) 1.0)
        (list (quote osnapcoord) 2)
        (list (quote grips) 2)
        (list (quote dragmode) 2)
        (list (quote lunits) 2)
        (list (quote pickstyle) 3)
        (list (quote navvcubedisplay) 3)
        (list (quote pickauto) 3)
        (list (quote draworderctl) 3)
        (list (quote expert) 5)
        (list (quote auprec) 6)
        (list (quote luprec) 6)
        (list (quote pickbox) 6)
        (list (quote aperture) 6)
        (list (quote osoptions) 7)
        (list (quote dimzin) 8)
        (list (quote pdmode) 35)
        (list (quote pdsize) -1.5)
        (list (quote celweight) -1)
        ;(list (quote cecolor) "BYLAYER")
        ;(list (quote celtype) "ByLayer")
        ;(list (quote clayer) "0")
      )
    )
    (setq sysvarlst (mapcar (function car) sysvarpreset))
    (setq sysvarvals (mapcar (function cadr) sysvarpreset))
    (setq sysvarvals
      (vl-remove nil
        (mapcar
          (function (lambda ( x )
            (if (getvar x) (nth (vl-position x sysvarlst) sysvarvals))
          ))
          sysvarlst
        )
      )
    )
    (setq sysvarlst
      (vl-remove-if-not
        (function (lambda ( x )
          (getvar x)
        ))
        sysvarlst
      )
    )
    (setq initvalueslst
      (apply (function mapcar)
        (cons (function list)
          (list
            sysvarlst
            (mapcar (function getvar) sysvarlst)
          )
        )
      )
    )
    (apply (function mapcar)
      (cons (function setvar)
        (list
          sysvarlst
          sysvarvals
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (if (not (exe (list "_.UNDO" "_E")))
        (if doc
          (vla-endundomark doc)
        )
      )
    )
    (if (not (exe (list "_.UNDO" "_M")))
      (if doc
        (vla-startundomark doc)
      )
    )
    (if wcs
      (if (= 0 (getvar (quote worlducs)))
        (progn
          (setq ucsf
            (list
              (getvar (quote ucsxdir))
              (getvar (quote ucsydir))
              (trans (list 0.0 0.0 1.0) 1 0 t)
            )
          )
          (exe (list "_.UCS" "_W"))
        )
      )
    )
    wcs
  )

  (defun ftoa ( n / m a s b )
    (if (numberp n)
      (progn
        (setq m (fix ((if (< n 0) - +) n 1e-6)))
        (setq a (abs (- n m)))
        (setq m (itoa m))
        (setq s "")
        (while (and (not (equal a 0.0 1e-6)) (setq b (fix (* a 10.0))))
          (setq s (strcat s (itoa b)))
          (setq a (- (* a 10.0) b))
        )
        (if (= (type n) (quote int))
          m
          (if (= s "")
            m
            (if (and (= m "0") (< n 0))
              (strcat "-" m "." s)
              (strcat m "." s)
            )
          )
        )
      )
    )
  )

  (defun collinear-p ( p1 p p2 )
    (equal (distance p1 p2) (+ (distance p1 p) (distance p p2)) 1e-6)
  )

  (defun chkinters-p ( pl / r lil )
    (setq lil (mapcar (function list) pl (append (cdr pl) (list (car pl)))))
    (setq r
      (vl-some
        (function (lambda ( x )
          (vl-some
            (function (lambda ( y )
              (and
                (not (equal (car x) (car y) 1e-6))
                (not (equal (car x) (cadr y) 1e-6))
                (not (equal (cadr x) (car y) 1e-6))
                (not (equal (cadr x) (cadr y) 1e-6))
                (or
                  (inters (car x) (cadr x) (car y) (cadr y))
                  (collinear-p (car x) (car y) (cadr x))
                  (collinear-p (car x) (cadr y) (cadr x))
                  (collinear-p (car y) (car x) (cadr y))
                  (collinear-p (car y) (cadr x) (cadr y))
                )
              )
            ))
            (vl-remove x lil)
          )
        ))
        lil
      )
    )
    r
  )

  (defun chkinters ( pl / processlil done r lill ilil iip )
 
    (defun processlil ( ilil lil / pre mid suf ret )
      (setq pre (reverse (cdr (member (car ilil) (reverse lil)))))
      (setq mid (cdr (member (car ilil) lil)))
      (setq mid (cdr (member (cadr ilil) (reverse mid))))
      (setq mid (mapcar (function reverse) mid))
      (setq suf (cdr (member (cadr ilil) lil)))
      (setq ret (append pre (list (list (car (car ilil)) (car (cadr ilil)))) mid (list (list (cadr (car ilil)) (cadr (cadr ilil)))) suf))
      ret
    )
 
    (or lil (setq lil (mapcar (function list) pl (append (cdr pl) (list (car pl))))))
    (while (not done)
      (setq ilil (vl-some (function (lambda ( a ) (vl-some (function (lambda ( b / ip ) (progn (setq iip (inters (car a) (cadr a) (car b) (cadr b))) (if (and (not (equal (cadr a) (car b) 1e-6)) (not (equal (car a) (cadr b) 1e-6)) (not (or (and (collinear-p (car a) (car b) (cadr a)) (collinear-p (car a) (cadr b) (cadr a))) (and (collinear-p (car b) (car a) (cadr b)) (collinear-p (car b) (cadr a) (cadr b))))) (not (or (and (collinear-p (car a) (car b) (cadr a)) (collinear-p (car b) (cadr a) (cadr b))) (and (collinear-p (car b) (car a) (cadr b)) (collinear-p (car a) (cadr b) (cadr a)))))) (cond ( (collinear-p (car a) (car b) (cadr a)) (setq ip (car b)) ) ( (collinear-p (car a) (cadr b) (cadr a)) (setq ip (cadr b)) ) ( (collinear-p (car b) (car a) (cadr b)) (setq ip (car a)) ) ( (collinear-p (car b) (cadr a) (cadr b)) (setq ip (cadr a)) )) (setq iip nil)) (cond ( iip (list a b iip) ) ( ip (list a b ip) ))))) (vl-remove a lil)))) lil))
      (cond
        ( (and ilil (equal iip (caddr ilil) 1e-6))
          (setq lil (processlil ilil lil))
        )
        ( (and ilil (equal (caar ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (caar ilil) (caadr ilil) 1e-6)) (not (equal (caar ilil) (cadadr ilil) 1e-6)))
              (setq lil (processlil ilil lil))
            )
            ( (equal (caar ilil) (caadr ilil) 1e-6)
              (setq lil (processlil ilil lil))
            )
            ( (equal (caar ilil) (cadadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (cadar ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (cadar ilil) (caadr ilil) 1e-6)) (not (equal (cadar ilil) (cadadr ilil) 1e-6)))
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadar ilil) (caadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadar ilil) (cadadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (caadr ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (caadr ilil) (caar ilil) 1e-6)) (not (equal (caadr ilil) (cadar ilil) 1e-6)))
              (setq lil (processlil ilil lil))
            )
            ( (equal (caadr ilil) (caar ilil) 1e-6)
              (setq lil (processlil ilil lil))
            )
            ( (equal (caadr ilil) (cadar ilil) 1e-6)
              (setq ilil (subst (assoc (caadr ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (cadadr ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (cadadr ilil) (caar ilil) 1e-6)) (not (equal (cadadr ilil) (cadar ilil) 1e-6)))
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadadr ilil) (caar ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadadr ilil) (cadar ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( t (setq done t) )
      )
    )
    (setq r (mapcar (function car) lil))
    (setq lil nil)
    r
  )

  (defun grid ( l / ucsf a b bb d1 d2 a1 a2 e ll p pl an f )
    ;(setq l (vl-sort l (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (cadr a) (cadr b)) (< (car a) (car b)))))))
    (if (= 0 (getvar (quote worlducs)))
      (progn
        (if command-s
          (command-s "_.UCS" "_W")
          (vl-cmdf "_.UCS" "_W")
        )
        (setq ucsf t)
      )
    )
    (if command-s
      (command-s "_.UCS" "_3P" "_non" (car l) "_non" (cadr l) "_non" (polar (car l) (+ (angle (car l) (cadr l)) (* 0.5 pi)) 1.0))
      (vl-cmdf "_.UCS" "_3P" "_non" (car l) "_non" (cadr l) "_non" (polar (car l) (+ (angle (car l) (cadr l)) (* 0.5 pi)) 1.0))
    )
    (setq l (mapcar (function (lambda ( p ) (trans p 0 1))) l))
    (setq ll (last l))
    (setq an 0.0)
    (setq p  (car l)
          pl (list p)
          l  (cdr l)
    )
    (while l
      (setq l (vl-sort l (function (lambda ( a b ) (< (distance p a) (distance p b))))))
      (setq a1 (car l) a2 (cadr l))
      (setq d1 (distance p a1) d2 (if a2 (distance p a2)))
      (if (and d2 (equal d1 d2 1e-6))
        (if (and an (or (equal (angle p a1) an 1e-6) (equal (angle p a1) (rem (+ pi an) (+ pi pi)) 1e-6) (if (or (equal an 0.0 1e-6) (equal an (* 2 pi) 1e-6)) (equal (angle p a1) (* 2 pi) 1e-6))))
          (setq a a1)
          (setq a a2)
        )
        (setq a a1)
      )
      (if (and an (or (equal (angle p a) an 1e-6) (equal (angle p a) (rem (+ pi an) (+ pi pi)) 1e-6) (if (or (equal an 0.0 1e-6) (equal an (* 2 pi) 1e-6)) (equal (angle p a) (* 2 pi) 1e-6))))
        (setq bb a)
        (setq b a)
      )
      (if bb
        (setq b bb)
      )
      (cond
        ( (equal a1 ll 1e-6)
          (setq a a1 b a an (* 0.5 pi) f t)
        )
        ( (equal a2 ll 1e-6)
          (setq a a2 b a an (* 0.5 pi) f t)
        )
      )
      (setq pl (cons b pl)
            l  (vl-remove b l)
            p  b
            b  nil
            bb nil
      )
      (if f
        (cond
          ( (= an 0.0)
            (setq an (* 0.5 pi))
          )
          ( t
            (setq an 0.0)
          )
        )
        (cond
          ( (and (= an 0.0) (equal (car p) (car ll) 1e-6))
            (setq an (* 0.5 pi))
          )
          ( (and (= an (* 0.5 pi)) (equal (cadr p) (cadr ll) 1e-6))
            (setq an 0.0)
          )
          ( (and (= an (* 0.5 pi)) (equal (car p) (car ll) 1e-6))
            (setq an 0.0)
          )
          ( (and (= an 0.0) (equal (cadr p) (cadr ll) 1e-6))
            (setq an (* 0.5 pi))
          )
        )
      )
    )
    (setq pl (reverse pl))
    (setq e  nil
          l  pl
          ll l
    )
    (while (and (not e) ll)
      (setq e  t
            ll l
      )
      (while (and e ll)
        (setq ll (if (listp (caar ll))
                  ll
                  (mapcar (function list) (cons (last ll) ll) ll)
                 )
              a  (car ll)
              pl (vl-remove-if (function (lambda ( b ) (or (member (car a) b) (member (cadr a) b))))
                               (cdr ll)
                 )
              ll (cdr ll)
        )
        (while (and pl (setq b (car pl)) (not (inters (car a) (cadr a) (car b) (cadr b))))
          (setq pl (cdr pl))
        )
        (if pl
          (progn (setq l (append (member (car a) l) (reverse (cdr (member (car a) (reverse l))))) ;;; [(car a) (cadr a) ... ->end] + ((car b) (cadr b)) - in middle of concatenated l + [start ... ->] ... (car a) - don't exist - it was (cdr-ed) 
                       l (append (list (car a)) (member (car b) (reverse (cdr l))) (member (cadr b) l)) ;;; [(car a)] + [(car b) + end<- ... (cadr a)] + [(cadr b) + start ... ->]
                       e nil
                 )
          )
        )
      )
    )
    (setq l (mapcar (function (lambda ( p ) (trans p 1 0))) l))
    (if command-s
      (command-s "_.UCS" "_P")
      (vl-cmdf "_.UCS" "_P")
    )
    (if ucsf
      (if command-s
        (command-s "_.UCS" "_P")
        (vl-cmdf "_.UCS" "_P")
      )
    )
    l
  )

  (defun make-lwpolyline ( lst )
    (entmake
      (append
        (list
          (cons 0 "LWPOLYLINE")
          (cons 100 "AcDbEntity")
          (cons 100 "AcDbPolyline")
          (cons 90 (length lst))
          (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
          (cons 38 0.0)
        )
        (mapcar (function (lambda ( p ) (cons 10 p))) lst)
        (list (list 210 0.0 0.0 1.0))
      )
    )
  )

  (defun car-sort ( lst cmp / rtn )
    (setq rtn (car lst))
    (if (cdr lst)
      (foreach itm (cdr lst)
        (if (apply cmp (list itm rtn))
          (setq rtn itm)
        )
      )
    )
    rtn
  )

  ;; Convex Hull  -  Lee Mac
  ;; Implements the Graham Scan Algorithm to return the Convex Hull of a list of points.
  ;; Mod. by M.R.  -  uses (car-sort) sub...

  (defun MR:ConvexHull-ptsonHull ( lst / ch p0 lstl )
    (cond
      ( (< (length lst) 4) (vl-sort lst (function (lambda ( a b ) (if (= (cadr a) (cadr b)) (< (car a) (car b)) (< (cadr a) (cadr b)))))) )
      ( (setq p0 (car lst))
        (foreach p1 (cdr lst)
          (if (or (< (cadr p1) (cadr p0)) (and (= (cadr p1) (cadr p0)) (< (car p1) (car p0))))
            (setq p0 p1)
          )
        )
        (setq lst (vl-remove p0 lst))
        (setq lst (append (list p0) lst))
        (setq lst
          (vl-sort lst
            (function
              (lambda ( a b / c d )
                (if (or (equal (setq c (angle p0 a)) (setq d (angle p0 b)) 1e-6) (and (or (equal c 0.0 1e-6) (equal c (* 2 pi) 1e-6)) (or (equal d 0.0 1e-6) (equal d (* 2 pi) 1e-6))))
                  (< (distance (list (car p0) (cadr p0)) a) (distance (list (car p0) (cadr p0)) b))
                  (< c d)
                )
              )
            )
          )
        )
        (setq lstl (vl-remove-if-not (function (lambda ( x ) (equal (angle p0 (last lst)) (angle p0 x) 1e-6))) lst))
        (setq lst (vl-remove-if (function (lambda ( x ) (equal (angle p0 (last lst)) (angle p0 x) 1e-6))) lst))
        (setq lstl (vl-sort lstl (function (lambda ( a b ) (> (distance (list (car p0) (cadr p0)) a) (distance (list (car p0) (cadr p0)) b))))))
        (setq lst (append lst lstl))
        (setq ch (list (cadr lst) (car lst)))
        (foreach pt (cddr lst)
          (if (equal pt (last lst))
            (setq ch (cons pt ch))
            (if (or (equal (angle (car ch) pt) (car-sort (mapcar (function (lambda ( x ) (angle (car ch) x))) (member pt lst)) (function <)) 1e-6) (equal (distance pt (cadr ch)) (+ (distance pt (car ch)) (distance (car ch) (cadr ch))) 1e-6))
              (setq ch (cons pt ch))
            )
          )
        )
        (reverse ch)
      )
    )
  )

  (defun tsp-rnd1 ( pl / pllen lst lstt p dl d )

    (defun pllen ( lst )
      (apply (function +) (mapcar (function distance) lst (append (cdr lst) (list (car lst)))))
    )

    (setq lstt (MR:ConvexHull-ptsonHull pl))
    (if (setq lst (vl-remove-if (function (lambda ( x ) (vl-position x lstt))) pl))
      (while lst
        (foreach edg (mapcar (function list) lstt (append (cdr lstt) (list (car lstt))))
          (setq p (car-sort lst (function (lambda ( a b ) (< (pllen (append (reverse (member (car edg) (reverse lstt))) (list a) (member (cadr edg) lstt))) (pllen (append (reverse (member (car edg) (reverse lstt))) (list b) (member (cadr edg) lstt))))))))
          (setq dl (cons (list p edg (pllen (append (reverse (member (car edg) (reverse lstt))) (list p) (member (cadr edg) lstt)))) dl))
        )
        (setq d (car-sort dl (function (lambda ( a b ) (< (caddr a) (caddr b))))))
        (setq dl nil)
        (setq lst (vl-remove (car d) lst))
        (setq lstt (append (reverse (member (caadr d) (reverse lstt))) (list (car d)) (member (cadadr d) lstt)))
      )
    )
    lstt
  )

  (defun processEE1 ( plst ll / ent ls lsx a p e pl )
    (setq ent (entmakex (append (list (cons 0 "LWPOLYLINE")
                                      (cons 100 "AcDbEntity")
                                      (cons 100 "AcDbPolyline")
                                      (cons 90 (length ll))
                                      (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                                )
                                (mapcar (function (lambda ( a ) (cons 10 a))) ll)
                                (list (list 210 0.0 0.0 1.0))
                        )
              )
    )
    (setq ls plst)
    (foreach a ll (setq ls (vl-remove a ls)))
    (repeat (length ls)
      (setq lsx (mapcar (function (lambda ( a / b c d )
                                    (cons (distance a (setq b (vlax-curve-getClosestPointTo ent a)))
                                          (cons
                                                (list (setq c (vlax-curve-getPointAtParam ent (fix (vlax-curve-getParamAtPoint ent b))))
                                                      (setq d (vlax-curve-getPointAtParam ent (1+ (fix (vlax-curve-getParamAtPoint ent b)))))
                                                      (- (+ (distance c a) (distance d a)) (distance c d))
                                                )
                                                a
                                          )
                                    )
                                  )
                        ) ls
                )
      )
      (setq a (car-sort lsx (function (lambda ( a b ) (< (caddr (cadr a)) (caddr (cadr b)))))))
      (setq a (cddr a))
      (setq ls (vl-remove a ls))
      (setq p (vlax-curve-getParamAtPoint ent (vlax-curve-getClosestPointTo ent a))
            p (if (= p (fix p))
                (if (zerop p)
                  (vlax-curve-getEndParam ent)
                  (1- p)
                )
                (fix p)
              )
            p (vlax-curve-getPointAtParam ent p)
            p (list 10 (car p) (cadr p))
      )
      (if (not e)
        (setq e (entget ent))
      )
      (entupd (cdr (assoc -1 (entmod (setq e (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 e)))) (assoc 90 e) e))))
                                                     (list (cons 10 a))
                                                     (cdr (member p e))
                                             )
                                     )
                             )
                   )
              )
      )
    )
    (foreach a plst (setq ll (vl-remove a ll)))
    (setq e (entget ent))
    (entupd (cdr (assoc -1 (entmod (setq e (vl-remove-if (function (lambda ( a ) (vl-position (cdr a) ll))) (subst (cons 90 (length plst)) (assoc 90 e) e)))))))
    (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) e)))
    (entdel (entlast))
    pl
  )

  (defun processEE2 ( plst ll / ent ls lsx a p e pl )
    (setq ent (entmakex (append (list (cons 0 "LWPOLYLINE")
                                      (cons 100 "AcDbEntity")
                                      (cons 100 "AcDbPolyline")
                                      (cons 90 (length ll))
                                      (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                                )
                                (mapcar (function (lambda ( a ) (cons 10 a))) ll)
                                (list (list 210 0.0 0.0 1.0))
                        )
              )
    )
    (setq ls plst)
    (foreach a ll (setq ls (vl-remove a ls)))
    (repeat (length ls)
      (setq lsx (mapcar (function (lambda ( a / b )
                                    (cons (distance a (setq b (vlax-curve-getClosestPointTo ent a)))
                                          a
                                    )
                                  )
                        ) ls
                )
      )
      (setq a (car-sort lsx (function (lambda ( a b ) (< (car a) (car b))))))
      (setq a (cdr a))
      (setq ls (vl-remove a ls))
      (setq p (vlax-curve-getParamAtPoint ent (vlax-curve-getClosestPointTo ent a))
            p (if (= p (fix p))
                (if (zerop p)
                  (vlax-curve-getEndParam ent)
                  (1- p)
                )
                (fix p)
              )
            p (vlax-curve-getPointAtParam ent p)
            p (list 10 (car p) (cadr p))
      )
      (if (not e)
        (setq e (entget ent))
      )
      (entupd (cdr (assoc -1 (entmod (setq e (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 e)))) (assoc 90 e) e))))
                                                     (list (cons 10 a))
                                                     (cdr (member p e))
                                             )
                                     )
                             )
                   )
              )
      )
    )
    (foreach a plst (setq ll (vl-remove a ll)))
    (setq e (entget ent))
    (entupd (cdr (assoc -1 (entmod (setq e (vl-remove-if (function (lambda ( a ) (vl-position (cdr a) ll))) (subst (cons 90 (length plst)) (assoc 90 e) e)))))))
    (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) e)))
    (entdel (entlast))
    pl
  )

  (defun tsp-rnd2 ( plst / ll )
    (processEE1 plst (setq ll (MR:ConvexHull-ptsonHull plst)))
  )

  (defun tsp-rnd3 ( plst / ll )
    (processEE1 plst (setq ll (reverse (MR:ConvexHull-ptsonHull plst))))
  )

  (defun tsp-rnd4 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caadr ll) (cadar ll)) (cadr ll) (list (caar ll) (cadadr ll)))
    )
    (processEE1 plst ll)
  )

  (defun tsp-rnd5 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caar ll) (cadadr ll)) (cadr ll) (list (caadr ll) (cadar ll)))
    )
    (processEE1 plst ll)
  )

  (defun tsp-rnd6 ( plst / ll )
    (processEE2 plst (setq ll (MR:ConvexHull-ptsonHull plst)))
  )

  (defun tsp-rnd7 ( plst / ll )
    (processEE2 plst (setq ll (reverse (MR:ConvexHull-ptsonHull plst))))
  )

  (defun tsp-rnd8 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caadr ll) (cadar ll)) (cadr ll) (list (caar ll) (cadadr ll)))
    )
    (processEE2 plst ll)
  )

  (defun tsp-rnd9 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caar ll) (cadadr ll)) (cadr ll) (list (caadr ll) (cadar ll)))
    )
    (processEE2 plst ll)
  )

  (defun processLM ( lst lw / SubLst remove_nth
                              i x y tmp nlst par ptlst lwx rr nlst nlen )

    (defun SubLst ( lst i j / k )
      (setq k -1)
      (or j (setq j (length lst)))
      (vl-remove-if-not
        (function
          (lambda ( x )
            (<= i (setq k (1+ k)) (+ i (1- j)))
          )
        ) lst
      )
    )

    (defun remove_nth ( k lst / j )
      (setq j -1)
      (vl-remove-if
        (function
          (lambda ( x )
            (= k (setq j (1+ j)))
          )
        ) lst
      )
    )

    (setq lst 
      (vl-sort lst
        (function
          (lambda ( a b ) (< (distance (vlax-curve-getClosestPointto lw a) a)
                             (distance (vlax-curve-getClosestPointto lw b) b)
                          )
          )
        )
      )
    )
    (setq nlst lst)
    (while (setq x (car nLst))
      (setq nLst (cdr nLst) par (fix (vlax-curve-getParamatPoint lw (vlax-curve-getClosestPointto lw x))))
      (setq ptlst (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq lwx (entget lw)))))
      (setq ptlst (append (SubLst ptlst 0 (1+ par)) (list x)
                          (SubLst ptlst   (1+ par) nil)
                  )
      )
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    )
    (setq ptlst
      (vl-remove-if-not
        (function
          (lambda ( x ) (vl-position x lst))
        ) ptlst
      )
    )
    (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    (setq i -1)
    (repeat (length ptlst)
      (setq x (nth (setq i (1+ i)) ptlst))
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length (setq rr (Remove_nth i ptlst)))) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) rr) (list (list 210 0.0 0.0 1.0))))))))
      (setq par (fix (vlax-curve-getParamatPoint lw (vlax-curve-getClosestPointto lw x))))
      (setq ptlst (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq lwx (entget lw)))))
      (setq ptlst (append (SubLst ptlst 0 (1+ par)) (list x)
                          (SubLst ptlst   (1+ par) nil)
                  )
      )
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    )
    (setq i -1)
    (repeat (- (length ptlst) 1)
      (setq x (nth (setq i (1+ i)) ptlst) y (nth (1+ i) ptlst))
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
      (setq len (apply (function +) (mapcar (function distance) ptlst (append (cdr ptlst) (list (car ptlst))))))
      (setq nlst (append (SubLst ptlst 0 i) (list y x)
                         (Sublst ptlst (+ i 2) nil)
                 )
      )
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length nlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) nlst) (list (list 210 0.0 0.0 1.0))))))))
      (if (< (setq nlen (apply (function +) (mapcar (function distance) nlst (append (cdr nlst) (list (car nlst)))))) len)
        (setq ptlst nlst len nlen)
      )
    )
    (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    (entdel (entlast))
    ptlst
  )

  (defun tsp-rnd10 ( plst / mklw miP maP lw )

    (defun mklw ( l )
      (entmakex (append (list (cons 0   "LWPOLYLINE")
                              (cons 100 "AcDbEntity")
                              (cons 100 "AcDbPolyline")
                              (cons 90 (length l))
                              (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                        )
                        (mapcar (function (lambda ( a ) (cons 10 a))) l)
                        (list (list 210 0.0 0.0 1.0))
                )
      )
    )

    (setq miP (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <))))
    (setq maP (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >))))
    (setq lw (mklw (list miP (list (car miP) (cadr maP)) maP (list (car maP) (cadr miP)))))
    (processLM plst lw)
  )

  (defun tsp-rnd11 ( plst / mklw miP maP lw )

    (defun mklw ( l )
      (entmakex (append (list (cons 0   "LWPOLYLINE")
                              (cons 100 "AcDbEntity")
                              (cons 100 "AcDbPolyline")
                              (cons 90 (length l))
                              (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                        )
                        (mapcar (function (lambda ( a ) (cons 10 a))) l)
                        (list (list 210 0.0 0.0 1.0))
                )
      )
    )

    (setq miP (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <))))
    (setq maP (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >))))
    (setq lw (mklw (list miP (list (car miP) (cadr maP)) maP (list (car maP) (cadr miP)))))
    (processLM plst lw)
  )

  (defun AHS:TSP ( pl / AHS:mainprocess AHS:subprocess1 AHS:subprocess2 k li1 li2 lii )

    (defun AHS:mainprocess ( li1 li2 )
      (foreach po li2
        (setq lii (append lii (AHS:subprocess1 po li1)))
      )
      (setq li1 (AHS:subprocess2 li1 lii))
    )

    (defun AHS:subprocess1 ( po li1 / k n po1 po2 lii )
      (setq k 0)
      (repeat (setq n (length li1))
        (setq po1 (nth k li1))
        (if (= k (1- n))
          (setq po2 (nth 0 li1))
          (setq po2 (nth (1+ k) li1))
        )
        (setq lii (append lii (list (list po1 po po2))))
        (setq k (1+ k))
      )
      lii
    )

    (defun AHS:subprocess2 ( li1 lii / n dili dimin k i a po li3 )
      (setq n (length li1))
      (setq dili (mapcar (function (lambda ( a ) (- (+ (distance (car a) (cadr a)) (distance (cadr a) (caddr a))) (distance (car a) (caddr a))))) lii))
      (setq dimin (car-sort dili (function <)))
      (setq k 0)
      (while (and (not i) (< k (length dili)))
        (if (equal dimin (nth k dili) 1e-6)
          (setq i k)
        )
        (setq k (1+ k))
      )
      (setq a (nth i lii) po (cadr a))
      (if (equal (car a) (last li1) 1e-6)
        (setq li1 (cons po li1))
        (progn
          (setq k 0)
          (while (< k n)
            (if (equal (nth k li1) (car a) 1e-6)
              (setq li3 (cons (nth k li1) li3) li3 (cons po li3))
              (setq li3 (cons (nth k li1) li3))
            )
            (setq k (1+ k))
          )
          (setq li1 (reverse li3))
        )
      )
      (if (or (equal (car a) (cadr a) 1e-6) (equal (cadr a) (caddr a) 1e-6) (equal (car a) (caddr a) 1e-6))
        (progn
          (prompt "\nDuplicate points detected... Quitting...") (exit)
        )
      )
      li1
    )

    (setq k 0)
    (foreach po (setq pl (vl-sort pl (function (lambda ( a b ) (if (equal (cadr a) (cadr b) 1e-6) (< (car a) (car b)) (< (cadr a) (cadr b)))))))
      (setq k (1+ k))
      (if (< k 4)
        (setq li1 (append li1 (list po)))
        (setq li2 (append li2 (list po)))
      )
    )
    (if (> k 3)
      (progn
        (while (cadr li2)
          (setq lii nil)
          (setq li1 (AHS:mainprocess li1 li2))
          (setq li2 (vl-remove-if (function (lambda ( p1 ) (vl-some (function (lambda ( p2 ) (equal p1 p2 1e-6))) li1))) pl))
        )
        (setq lii nil)
        (setq lii (AHS:subprocess1 (car li2) li1))
        (setq li1 (AHS:subprocess2 li1 lii))
      )
    )
    li1
  )

  (defun tsp-rnd ( l / f1 f2 d d0 d1 e ent ep a pl n rr )

    (defun f1 ( a ent / p pl pll dl d pos enx )
      (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq enx (entget ent)))))
      (setq pll (mapcar (function list) pl (append (cdr pl) (list (car pl)))))
      (foreach li pll
        (setq dl (cons (- (+ (distance a (car li)) (distance a (cadr li))) (distance (car li) (cadr li))) dl))
      )
      (setq d (car-sort dl (function <)))
      (setq pos (vl-position d dl))
      (setq p (car (nth pos pll)))
      (setq p (list 10 (car p) (cadr p)))
      (entupd (cdr (assoc -1 (entmod (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 enx)))) (assoc 90 enx) enx))))
                                             (list (cons 10 a))
                                             (cdr (member p enx))
                                     )
                             )
                   )
              )
      )
    )

    (defun f2 ( a ent / p enx )
      (setq enx (entget ent))
      (setq p (vlax-curve-getPointAtParam ent (fix (vlax-curve-getParamAtPoint ent (vlax-curve-getClosestPointTo ent a)))))
      (setq p (list 10 (car p) (cadr p)))
      (entupd (cdr (assoc -1 (entmod (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 enx)))) (assoc 90 enx) enx))))
                                             (list (cons 10 a))
                                             (cdr (member p enx))
                                     )
                             )
                   )
              )
      )
    )

    (setq ent (entmakex (append (list (cons 0 "LWPOLYLINE")
                                      (cons 100 "AcDbEntity")
                                      (cons 100 "AcDbPolyline")
                                      (cons 90 (length l))
                                      (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                                )
                                (mapcar (function (lambda ( a ) (cons 10 a))) l)
                                (list (list 210 0.0 0.0 1.0))
                        )
              )
          ep  (length l)
    )
    (setq d0 (vlax-curve-getDistAtParam ent ep))
    (while
      (> d0
        (progn
          (setq n 0
               l (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq e (entget ent))))
               l (mapcar (function list) l (append (cdr l) (list (car l))))
          )
          (repeat ep
            (setq d (vlax-curve-getDistAtParam ent ep)
                 a (nth n (append l l))
            )



            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f1 (car a) ent)
            (f1 (cadr a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )
            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f1 (cadr a) ent)
            (f1 (car a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )



            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f2 (car a) ent)
            (f2 (cadr a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )
            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f2 (cadr a) ent)
            (f2 (car a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )



            (setq n (1+ n))
          )
          d
        )
      )
      (setq d0 d)
    )
    ent
  )

  (setq wcs (tttt t)) ;;; starting "library" template sub function - initialization ;;;
  (prompt "\nSelect points, blocks, or circles...")
  (if (setq ss (ssget (list (cons 0 "POINT,INSERT,CIRCLE"))))
    (progn
      (initget "Grid Rnd")
      (setq ch (cond ( (getkword "\nChoose option of points disposition [Grid / Rnd] <Rnd> : ") ) ( "Rnd" ) ))
      (setq ti (car (_vl-times)))
      (repeat (setq i (sslength ss))
        (setq pl (cons (mapcar (function +) (list 0.0 0.0) (cdr (assoc 10 (entget (ssname ss (setq i (1- i))))))) pl))
      )
      (setq pl (vl-sort pl (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (cadr a) (cadr b)) (< (car a) (car b)))))))
      (if (= ch "Rnd")
        (progn
          (setq pl1 (tsp-rnd1 pl))
          (if (chkinters-p pl1)
            (setq pl1 (chkinters pl1))
          )
          (setq pl2 (tsp-rnd2 pl1))
          (if (chkinters-p pl2)
            (setq pl2 (chkinters pl2))
          )
          (setq pl3 (tsp-rnd3 pl1))
          (if (chkinters-p pl3)
            (setq pl3 (chkinters pl3))
          )
          (setq pl4 (tsp-rnd4 pl1))
          (if (chkinters-p pl4)
            (setq pl4 (chkinters pl4))
          )
          (setq pl5 (tsp-rnd5 pl1))
          (if (chkinters-p pl5)
            (setq pl5 (chkinters pl5))
          )
          (setq pl6 (tsp-rnd6 pl1))
          (if (chkinters-p pl6)
            (setq pl6 (chkinters pl6))
          )
          (setq pl7 (tsp-rnd7 pl1))
          (if (chkinters-p pl7)
            (setq pl7 (chkinters pl7))
          )
          (setq pl8 (tsp-rnd8 pl1))
          (if (chkinters-p pl8)
            (setq pl8 (chkinters pl8))
          )
          (setq pl9 (tsp-rnd9 pl1))
          (if (chkinters-p pl9)
            (setq pl9 (chkinters pl9))
          )
          (setq pl10 (tsp-rnd10 pl1))
          (if (chkinters-p pl10)
            (setq pl10 (chkinters pl10))
          )
          (setq pl11 (tsp-rnd11 pl1))
          (if (chkinters-p pl11)
            (setq pl11 (chkinters pl11))
          )
          (setq pla (AHS:TSP pl1))
          (if (chkinters-p pla)
            (setq pla (chkinters pla))
          )
          (setq dl (list (apply (function +) (mapcar (function distance) pl1 (append (cdr pl1) (list (car pl1))))) (apply (function +) (mapcar (function distance) pl2 (append (cdr pl2) (list (car pl2))))) (apply (function +) (mapcar (function distance) pl3 (append (cdr pl3) (list (car pl3))))) (apply (function +) (mapcar (function distance) pl4 (append (cdr pl4) (list (car pl4))))) (apply (function +) (mapcar (function distance) pl5 (append (cdr pl5) (list (car pl5))))) (apply (function +) (mapcar (function distance) pl6 (append (cdr pl6) (list (car pl6))))) (apply (function +) (mapcar (function distance) pl7 (append (cdr pl7) (list (car pl7))))) (apply (function +) (mapcar (function distance) pl8 (append (cdr pl8) (list (car pl8))))) (apply (function +) (mapcar (function distance) pl9 (append (cdr pl9) (list (car pl9))))) (apply (function +) (mapcar (function distance) pl10 (append (cdr pl10) (list (car pl10))))) (apply (function +) (mapcar (function distance) pl11 (append (cdr pl11) (list (car pl11))))) (apply (function +) (mapcar (function distance) pla (append (cdr pla) (list (car pla)))))))
          (setq pos (vl-position (car-sort dl (function <)) dl))
          (cond
            ( (= pos 0)
              (setq pl pl1 d (nth 0 dl))
            )
            ( (= pos 1)
              (setq pl pl2 d (nth 1 dl))
            )
            ( (= pos 2)
              (setq pl pl3 d (nth 2 dl))
            )
            ( (= pos 3)
              (setq pl pl4 d (nth 3 dl))
            )
            ( (= pos 4)
              (setq pl pl5 d (nth 4 dl))
            )
            ( (= pos 5)
              (setq pl pl6 d (nth 5 dl))
            )
            ( (= pos 6)
              (setq pl pl7 d (nth 6 dl))
            )
            ( (= pos 7)
              (setq pl pl8 d (nth 7 dl))
            )
            ( (= pos 8)
              (setq pl pl9 d (nth 8 dl))
            )
            ( (= pos 9)
              (setq pl pl10 d (nth 9 dl))
            )
            ( (= pos 10)
              (setq pl pl11 d (nth 10 dl))
            )
            ( (= pos 11)
              (setq pl pla d (nth 11 dl))
            )
          )
          (setq ent (vl-catch-all-apply (function tsp-rnd) (list pl)))
          (if (not (vl-catch-all-error-p ent))
            (setq plll (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget ent))))
          )
          (if (and plll (chkinters-p plll))
            (setq plll (chkinters plll))
          )
          (if plll
            (setq dll (apply (function +) (mapcar (function distance) plll (append (cdr plll) (list (car plll))))))
          )
          (if (and d dll (equal d dll 1e-6))
            (alert "Distance 1 equal to Distance 2... Nothing optimized...")
            (if (and d dll (< dll d))
              (alert (strcat "Path optimized for : " (ftoa (- d dll)) " DWG units..."))
              (alert "Nothing optimized...")
            )
          )
          (entdel (entlast))
          (if (not (and d dll (< d dll)))
            (if (and plll dll)
              (setq pl plll d dll)
            )
          )
        )
        (progn
          (setq pl0 (grid pl))
          (if (chkinters-p pl0)
            (setq pl0 (chkinters pl0))
          )
          (setq ent (vl-catch-all-apply (function tsp-rnd) (list pl0)))
          (if (not (vl-catch-all-error-p ent))
            (setq plll (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget ent))))
          )
          (if (and plll (chkinters-p plll))
            (setq plll (chkinters plll))
          )
          (if plll
            (setq dll (apply (function +) (mapcar (function distance) plll (append (cdr plll) (list (car plll))))))
          )
          (if (and d dll (equal d dll 1e-6))
            (alert "Distance 1 equal to Distance 2... Nothing optimized...")
            (if (and d dll (< dll d))
              (alert (strcat "Path optimized for : " (ftoa (- d dll)) " DWG units..."))
              (alert "Nothing optimized...")
            )
          )
          (entdel (entlast))
          (if (not (and d dll (< d dll)))
            (if (and plll dll)
              (setq pl plll d dll)
            )
          )
        )
      )
      (make-lwpolyline pl)
      (prompt "\nDistance - path length : ") (princ (ftoa d))
      (prompt "\nElapsed time : ") (prompt (ftoa (- (car (_vl-times)) ti))) (prompt " milliseconds...")
      (prompt "\nFor UNDO - type \"UNDO\" - \"Back\" option...")
    )
  )
  (*error* nil)
)
