
(defun draw_lwpoly (lst)
  (entmakex 
    (append 
      (list 
        (cons 0 "LWPOLYLINE")
        (cons 100 "AcDbEntity")
        (cons 100 "AcDbPolyline")
        (cons 90 (length lst))
        (cons 70 0)
      )
      (mapcar (function (lambda (p) (cons 10 p))) lst)
    )
  )
)
(defun grdrawline (pointlist / count)
  (setq count 0)
  (repeat (1-(length pointlist))
    (grdraw (nth count pointlist) (nth (1+ count) pointlist) 1 0)
        (setq count (1+ count))
  )
)
(defun c:astar (/ i pointlist pl ss)
  (prompt "\nSelect points, blocks or circles...")
  (if (setq ss (ssget (list (cons 0 "POINT,INSERT,CIRCLE"))))
    (progn
      (repeat (setq i (sslength ss))
        (setq pl (cons (mapcar
                         (function +)
                         (list 0.0 0.0 0.0)
                         (cdr (assoc 10 (entget (ssname ss (setq i (1- i))))))
                       ) pl
                 )
        )
      )
      (setq pointlist (vlce_shortestpathastar -1 (getpoint "1stpnt") (getpoint "2ndPnt") pl))
      (grdrawline pointlist)
    )
  )
  (princ)
)
