(defun c:TSP-cheapestpath ( / make-polyline n ss ti i pl pl1 d1 pl2 d2 d)

  (defun make-polyline ( lst )
    (vl-cmdf "_.3DPOLY")
    (foreach p lst
      (vl-cmdf "_non" p)
    )
    (vl-cmdf "_C")
  )

  (cond
    ( (= "BRICSCAD" (getvar (quote program)))
      (if (findfile "VLCE_NP_Brx25.brx")
        (arxload (findfile "VLCE_NP_Brx25.brx"))
        (prompt "\nVLCE_NP_Brx25.brx not found in SFSP...")
      )
    )
    ( t
      (if (findfile "VLCE_NP_Arx24.arx")
        (arxload (findfile "VLCE_NP_Arx24.arx"))
        (prompt "\nVLCE_NP_Arx24.arx not found in SFSP...")
      )
    )
  )

  (initget 6)
  (setq n
    (cond
      ( (getint "\nSpecify how many seconds for calculation per single algorithm <120> : ") )
      ( 120 )
    )
  )
  (prompt "\nSelect points, blocks or circles...")
  (if (setq ss (ssget (list (cons 0 "POINT,INSERT,CIRCLE"))))
    (progn
      (setq ti (car (_vl-times)))
      (repeat (setq i (sslength ss))
        (setq pl (cons (mapcar (function +) (list 0.0 0.0 0.0) (cdr (assoc 10 (entget (ssname ss (setq i (1- i))))))) pl))
      )
      (setq pl1 (vlce_cheapestpathlsm 3 n -1 pl))
      (setq pl2 (vlce_cheapestpathfss 2 -1 pl))
      (setq d1 (apply (function +) (mapcar (function distance) pl1 (append (cdr pl1) (list (car pl1))))))
      (setq d2 (apply (function +) (mapcar (function distance) pl2 (append (cdr pl2) (list (car pl2))))))
      (cond
        ( (< d1 d2)
          (setq d d1)
          (setq pl pl1)
        )
        ( t
          (setq d d2)
          (setq pl pl2)
        )
      )
      (make-polyline pl)
      (prompt "\nDistance - path length : ") (princ (rtos d 2 20))
      (prompt "\nElapsed time : ") (princ (rtos (- (car (_vl-times)) ti) 2 20))
      (prompt "\nUNDO - type \"U\"...")
    )
  )
  (princ)
)