#pragma once
#include "delaunator.h"
class AStarShortestPathSolver
{
public:
    AStarShortestPathSolver(int64_t _startidx, int64_t _endidx, double _alpha, const std::vector<AcGePoint3d>& inputPoints);
    bool visited(const std::pair<size_t, size_t>& item) const;
    void setVisited(const std::pair<size_t, size_t>& item);
    void intertLastEdge(size_t i, size_t j, size_t x);
    bool initTriangles();
    std::vector<AcGePoint3d> solveShortestPathAStar();
    static int shortestPathAstarLispFunc();

private:
    double alpha = -1;
    int64_t startidx = -1;
    int64_t endidx = -1;
    std::vector<AcGePoint3d> inputPoints;
    std::unordered_set <std::pair<size_t, size_t>, SizeTpairHasher> edgemap;
    std::unordered_map <std::pair<size_t, size_t>, std::vector<size_t>, SizeTpairHasher> lastedgemap;
    std::unique_ptr<delaunator::Delaunator> pDelaunator;
};

