// (C) Copyright 2002-2007 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

//-----------------------------------------------------------------------------
//- StdAfx.h : include file for standard system include files,
//-      or project specific include files that are used frequently,
//-      but are changed infrequently
//-----------------------------------------------------------------------------
#pragma once

#pragma pack (push, 8)
#pragma warning(disable: 4786 4996 26812)

//#pragma warning(disable: 4098)

//-----------------------------------------------------------------------------
#define STRICT
#define NOMINMAX
#ifndef VC_EXTRALEAN
#define VC_EXTRALEAN			//- Exclude rarely-used stuff from Windows headers
#endif

//- Modify the following defines if you have to target a platform prior to the ones specified below.
//- Refer to MSDN for the latest info on corresponding values for different platforms.
#ifndef WINVER					//- Allow use of features specific to Windows 95 and Windows NT 4 or later.
#define WINVER 0x0601			//- Change this to the appropriate value to target Windows 98 and Windows 2000 or later.
#endif

#ifndef _WIN32_WINNT			//- Allow use of features specific to Windows NT 4 or later.
#define _WIN32_WINNT 0x0601		//- Change this to the appropriate value to target Windows 2000 or later.
#endif						

#ifndef _WIN32_WINDOWS			//- Allow use of features specific to Windows 98 or later.
#define _WIN32_WINDOWS 0x0610	//- Change this to the appropriate value to target Windows Me or later.
#endif

#ifndef _WIN32_IE				//- Allow use of features specific to IE 4.0 or later.
#define _WIN32_IE 0x0601		//- Change this to the appropriate value to target IE 5.0 or later.
#endif


#define SETBIT(flags, bit, value) ((value) ? (flags |= (bit)) : (flags &= ~(bit)))
#define GETBIT(flags, bit) (((flags) & (bit)) ? true : false)

#define CEXTDEVMODE

//- ObjectARX and OMF headers needs this
#include <map>
#include <vector>
#include <array>
#include <functional>
#include <memory>
#include <variant>
#include <string>
#include <sstream>
#include <algorithm>
#include <filesystem>
#include <optional>
#include <cmath>
#include <cstdint>
#include <sstream>
#include <execution>
#include <fstream>
#include <unordered_set>
#include <set>
#include <format>

//-----------------------------------------------------------------------------
#include <afxwin.h>				//- MFC core and standard components
#include <afxext.h>				//- MFC extensions

#ifndef _AFX_NO_OLE_SUPPORT
#include <afxole.h>				//- MFC OLE classes
#include <afxodlgs.h>			//- MFC OLE dialog classes
#include <afxdisp.h>			//- MFC Automation classes
#endif // _AFX_NO_OLE_SUPPORT

#ifndef _AFX_NO_DB_SUPPORT
#include <afxdb.h>				//- MFC ODBC database classes
#endif // _AFX_NO_DB_SUPPORT

#ifndef _AFX_NO_DAO_SUPPORT
#include <afxdao.h>				//- MFC DAO database classes
#endif // _AFX_NO_DAO_SUPPORT

#include <afxdtctl.h>			//- MFC support for Internet Explorer 4 Common Controls
#ifndef _AFX_NO_AFXCMN_SUPPORT
#include <afxcmn.h>				//- MFC support for Windows Common Controls
#endif // _AFX_NO_AFXCMN_SUPPORT

//-----------------------------------------------------------------------------
//- Include ObjectDBX/ObjectARX headers
//- Uncomment one of the following lines to bring a given library in your project.
//#define _BREP_SUPPORT_			//- Support for the BRep API
//#define _HLR_SUPPORT_				//- Support for the Hidden Line Removal API
//#define _AMODELER_SUPPORT_		//- Support for the AModeler API
//#define _ASE_SUPPORT_				//- Support for the ASI/ASE API
//#define _RENDER_SUPPORT_			//- Support for the AutoCAD Render API
//#define _ARX_CUSTOM_DRAG_N_DROP_	//- Support for the ObjectARX Drag'n Drop API
//#define _INC_LEAGACY_HEADERS_		//- Include legacy headers in this project
#include "arxHeaders.h"
#include "axlock.h"

#ifdef GRXAPP
#pragma comment( lib , "gcad.lib" )
#pragma comment( lib , "gcbase.lib" )
#pragma comment( lib , "gcax.lib" )
#pragma comment( lib , "gcbr.lib" )
#pragma comment( lib , "gccore.lib" )
#pragma comment( lib , "gcdb.lib" )
#endif

#if defined(ARXAPP)
#pragma comment( lib , "AcPal.lib" )
#endif


//-----------------------------------------------------------------------------
#include "DocData.h" //- Your document specific data class holder

//- Declare it as an extern here so that it becomes available in all modules
extern AcApDataManager<CDocData> DocVars;

inline const TCHAR* getappname()
{
#ifdef ZRXAPP
    return _T("ZRX");
#endif
#ifdef BRXAPP
    return _T("BRX");
#endif
#ifdef ARXAPP
    return _T("ARX");
#endif
#ifdef GRXAPP
    return _T("GRX");
#endif
#ifdef IRXAPP
    return _T("IRX");
#endif
}


template<typename IteratorType>
constexpr auto makeIterator = [](const auto& record)
{
    IteratorType* pIter = nullptr;
    Acad::ErrorStatus es = record.newIterator(pIter);
    return std::make_tuple(es, std::unique_ptr<IteratorType>(pIter));
};
constexpr auto makeBlockTableIterator = makeIterator<AcDbBlockTableIterator>;
constexpr auto makeBlockTableRecordIterator = makeIterator<AcDbBlockTableRecordIterator>;

using AcResBufPtr = std::unique_ptr < resbuf, decltype([](resbuf* ptr) noexcept
{
    if (ptr != nullptr)
        acutRelRb(ptr);
}) > ;


using BYTES = std::basic_string<std::byte, std::char_traits<std::byte>, std::allocator<std::byte>>;

template<typename T>
struct RbVal
{
    union Data
    {
        T val;
        std::byte buf[sizeof(T)];
    } data;

    inline constexpr size_t size()
    {
        return sizeof(T);
    }
};


class PerfTimer
{
private:
    LARGE_INTEGER frequency{ 0 };
    LARGE_INTEGER t1{ 0 };
    LARGE_INTEGER t2{ 0 };
    double elapsedTime = 0;
public:
    PerfTimer(const CString& funcName);
    ~PerfTimer();
private:
    CString m_funcName;
};

inline PerfTimer::PerfTimer(const CString& funcName)
    : m_funcName(funcName)
{
    QueryPerformanceFrequency(&frequency);
    QueryPerformanceCounter(&t1);
}

inline PerfTimer::~PerfTimer()
{
    QueryPerformanceCounter(&t2);
    elapsedTime = (float)(t2.QuadPart - t1.QuadPart) / frequency.QuadPart;
    acutPrintf(_T("\n%ls - %ls, Time = %lf"), getappname(), (const TCHAR*)m_funcName, elapsedTime);
}

inline std::string wstr_to_utf8(const wchar_t* utf16wc) {
    const std::wstring wstr{ utf16wc };
    const int count = WideCharToMultiByte(CP_UTF8, 0, wstr.c_str(), wstr.length(), NULL, 0, NULL, NULL);
    std::string str(count, 0);
    WideCharToMultiByte(CP_UTF8, 0, wstr.c_str(), -1, &str[0], count, NULL, NULL);
    return str;
}


inline std::vector<std::vector<int64_t>> ComputeEuclideanDistanceMatrix(const std::vector<AcGePoint3d>& locations, double scale) noexcept
{
    std::vector<std::vector<int64_t>> distances = std::vector<std::vector<int64_t>>(locations.size(), std::vector<int64_t>(locations.size(), int64_t{ 0 }));

    for (size_t fromNode = 0; fromNode < locations.size(); fromNode++)
    {
        for (size_t toNode = 0; toNode < locations.size(); toNode++)
        {
            if (fromNode != toNode)
            {
                distances[fromNode][toNode] = static_cast<int64_t>(locations[fromNode].distanceTo(locations[toNode]) * scale);
            }
        }
    }
    return distances;
}

inline std::vector<std::vector<int64_t>> ComputeEuclideanDistanceMatrix(const std::vector<AcGePoint2d>& locations, double scale) noexcept
{
    std::vector<std::vector<int64_t>> distances = std::vector<std::vector<int64_t>>(locations.size(), std::vector<int64_t>(locations.size(), int64_t{ 0 }));
    for (size_t fromNode = 0; fromNode < locations.size(); fromNode++)
    {
        for (size_t toNode = 0; toNode < locations.size(); toNode++)
        {
            if (fromNode != toNode)
            {
                distances[fromNode][toNode] = static_cast<int64_t>(locations[fromNode].distanceTo(locations[toNode]) * scale);
            }
        }
    }
    return distances;
}


template <typename... Rest>
inline void hash_combine(std::size_t& seed, std::size_t v, const Rest&... rest)
{
    seed ^= v + 0x9e3779b9 + (seed << 6) + (seed >> 2);
    (hash_combine(seed, rest), ...);
}

struct AcGePoint3dHasher
{
    inline size_t hash(const AcGePoint3d& pnt) const
    {
        std::size_t h = 0;
        std::hash<double_t>dh;
        auto hx = dh(pnt.x);
        auto hy = dh(pnt.y);
        auto hz = dh(pnt.z);
        hash_combine(h, hx, hy, hz);
        return h;
    }

    inline size_t operator()(const AcGePoint3d& pnt) const
    {
        return hash(pnt);
    }
};

struct SizeTpairHasher
{
    inline size_t operator()(const std::pair<size_t, size_t>& h) const noexcept
    {
        return hash(h);
    }

    inline size_t hash(const std::pair<size_t, size_t>& h) const noexcept
    {
        std::size_t h0 = 0;
        std::size_t h1 = std::hash<size_t>{}(h.first);
        std::size_t h2 = std::hash<size_t>{}(h.second);
        hash_combine(h0, h1, h2);
        return h0;
    }

    static size_t makehashKeyFromIndexes(size_t l, size_t r, size_t arSize) noexcept
    {
        if (l > r)
            std::swap(l, r);
         const std::size_t h1 = std::hash<size_t>{}(l);
         const std::size_t h2 = std::hash<size_t>{}(r+arSize);
         return h1 ^ (h2 << 1);
    }
};


//Voronoiator
namespace delaunator 
{
    struct Edge
    {
        AcGePoint3d a;
        AcGePoint3d b;
    };
    using Edges = std::vector<Edge>;
}


//google or
#pragma comment( lib , "absl_bad_any_cast_impl.lib" )
#pragma comment( lib , "absl_bad_optional_access.lib" )
#pragma comment( lib , "absl_bad_variant_access.lib" )
#pragma comment( lib , "absl_base.lib" )
#pragma comment( lib , "absl_city.lib" )
#pragma comment( lib , "absl_civil_time.lib" )
#pragma comment( lib , "absl_cord.lib" )
#pragma comment( lib , "absl_cordz_functions.lib" )
#pragma comment( lib , "absl_cordz_handle.lib" )
#pragma comment( lib , "absl_cordz_info.lib" )
#pragma comment( lib , "absl_cordz_sample_token.lib" )
#pragma comment( lib , "absl_cord_internal.lib" )
#pragma comment( lib , "absl_debugging_internal.lib" )
#pragma comment( lib , "absl_demangle_internal.lib" )
#pragma comment( lib , "absl_examine_stack.lib" )
#pragma comment( lib , "absl_exponential_biased.lib" )
#pragma comment( lib , "absl_failure_signal_handler.lib" )
#pragma comment( lib , "absl_flags.lib" )
#pragma comment( lib , "absl_flags_commandlineflag.lib" )
#pragma comment( lib , "absl_flags_commandlineflag_internal.lib" )
#pragma comment( lib , "absl_flags_config.lib" )
#pragma comment( lib , "absl_flags_internal.lib" )
#pragma comment( lib , "absl_flags_marshalling.lib" )
#pragma comment( lib , "absl_flags_parse.lib" )
#pragma comment( lib , "absl_flags_private_handle_accessor.lib" )
#pragma comment( lib , "absl_flags_program_name.lib" )
#pragma comment( lib , "absl_flags_reflection.lib" )
#pragma comment( lib , "absl_flags_usage.lib" )
#pragma comment( lib , "absl_flags_usage_internal.lib" )
#pragma comment( lib , "absl_graphcycles_internal.lib" )
#pragma comment( lib , "absl_hash.lib" )
#pragma comment( lib , "absl_hashtablez_sampler.lib" )
#pragma comment( lib , "absl_int128.lib" )
#pragma comment( lib , "absl_leak_check.lib" )
#pragma comment( lib , "absl_log_severity.lib" )
#pragma comment( lib , "absl_low_level_hash.lib" )
#pragma comment( lib , "absl_malloc_internal.lib" )
#pragma comment( lib , "absl_periodic_sampler.lib" )
#pragma comment( lib , "absl_random_distributions.lib" )
#pragma comment( lib , "absl_random_internal_distribution_test_util.lib" )
#pragma comment( lib , "absl_random_internal_platform.lib" )
#pragma comment( lib , "absl_random_internal_pool_urbg.lib" )
#pragma comment( lib , "absl_random_internal_randen.lib" )
#pragma comment( lib , "absl_random_internal_randen_hwaes.lib" )
#pragma comment( lib , "absl_random_internal_randen_hwaes_impl.lib" )
#pragma comment( lib , "absl_random_internal_randen_slow.lib" )
#pragma comment( lib , "absl_random_internal_seed_material.lib" )
#pragma comment( lib , "absl_random_seed_gen_exception.lib" )
#pragma comment( lib , "absl_random_seed_sequences.lib" )
#pragma comment( lib , "absl_raw_hash_set.lib" )
#pragma comment( lib , "absl_raw_logging_internal.lib" )
#pragma comment( lib , "absl_scoped_set_env.lib" )
#pragma comment( lib , "absl_spinlock_wait.lib" )
#pragma comment( lib , "absl_stacktrace.lib" )
#pragma comment( lib , "absl_status.lib" )
#pragma comment( lib , "absl_statusor.lib" )
#pragma comment( lib , "absl_strerror.lib" )
#pragma comment( lib , "absl_strings.lib" )
#pragma comment( lib , "absl_strings_internal.lib" )
#pragma comment( lib , "absl_str_format_internal.lib" )
#pragma comment( lib , "absl_symbolize.lib" )
#pragma comment( lib , "absl_synchronization.lib" )
#pragma comment( lib , "absl_throw_delegate.lib" )
#pragma comment( lib , "absl_time.lib" )
#pragma comment( lib , "absl_time_zone.lib" )
#pragma comment( lib , "Cbc.lib" )
#pragma comment( lib , "CbcSolver.lib" )
#pragma comment( lib , "Cgl.lib" )
#pragma comment( lib , "Clp.lib" )
#pragma comment( lib , "ClpSolver.lib" )
#pragma comment( lib , "CoinUtils.lib" )
#pragma comment( lib , "libprotobuf-lite.lib" )
#pragma comment( lib , "libprotobuf.lib" )
#pragma comment( lib , "libprotoc.lib" )
#pragma comment( lib , "libscip.lib" )
#pragma comment( lib , "ortools.lib" )
#pragma comment( lib , "ortools_flatzinc.lib" )
#pragma comment( lib , "ortools_full.lib" )
#pragma comment( lib , "Osi.lib" )
#pragma comment( lib , "OsiCbc.lib" )
#pragma comment( lib , "OsiClp.lib" )
#pragma comment( lib , "re2.lib" )
#pragma comment( lib , "zlib.lib" )


//boost

//#pragma comment( lib , "libboost_graph-vc142-mt-x64-1_81.lib")

#pragma pack (pop)
