#pragma once

typedef std::map<AcString, AcResBufPtr> UserStrMap;
typedef std::map<AcString, UserStrMap> GlobalStrMap;

typedef std::map<int32_t, AcResBufPtr> UserIntMap;
typedef std::map<AcString, UserIntMap> GlobalIntMap;

#ifndef BRXAPP
class VlceMapController
{
public:
    bool createStrMap(const AcString& name);
    bool insertStrMap(const AcString& name, const AcString& key, const resbuf* value);
    const resbuf* valueStrMap(const AcString& name, const AcString& key);
    bool eraseStrMap(const AcString& name);

    bool createIntMap(const AcString& name);
    bool insertIntMap(const AcString& name, int key, const resbuf* value);
    const resbuf* valueIntMap(const AcString& name, int key);
    bool eraseIntMap(const AcString& name);


    static VlceMapController& get();

public:
    GlobalStrMap mStrMap;
    GlobalIntMap mIntMap;

};
#endif
