#include "stdafx.h"
#include "VlceMapFuncs.h"
#include "VlceMapController.h"
#include <boost/functional/hash.hpp>


#ifndef BRXAPP
static resbuf* normalizeResBuf(resbuf* src)
{
    if (src == nullptr)
        return src;
    if (src->restype != RTLB)
        return src;
    int parenthesis = 0;
    resbuf* pTail = src;
    for (; pTail != nullptr; pTail = pTail->rbnext)
    {
        switch (pTail->restype)
        {
            case RTLB:
                parenthesis++;
                break;
            case RTLE:
                parenthesis--;
                break;
            default:
                break;
        }
        if (parenthesis == 0)
            break;
    }
    if (pTail != nullptr && pTail->rbnext != nullptr)
    {
        acutRelRb(pTail->rbnext);
        pTail->rbnext = nullptr;
    }
    return src;
}

int VlceMapFuncs::createstrmap()
{
    AcResBufPtr pArgs(acedGetArgs());
    if (pArgs->restype == RTSTR)
        return VlceMapController::get().createStrMap(pArgs->resval.rstring) ? acedRetT() : acedRetNil();
    acedRetNil();
    return (RSRSLT);
}

int VlceMapFuncs::erasestrmap()
{
    AcResBufPtr pArgs(acedGetArgs());
    if (pArgs->restype == RTSTR)
        return VlceMapController::get().eraseStrMap(pArgs->resval.rstring) ? acedRetT() : acedRetNil();
    acedRetNil();
    return (RSRSLT);
}

int VlceMapFuncs::strmapinsert()
{
    AcResBufPtr pArgs(acedGetArgs());
    AcString name;
    AcString key;
    int argCount = 0;
    resbuf* pTail = pArgs.get();
    for (; pTail != nullptr; pTail = pTail->rbnext)
    {
        if (argCount == 0 && pTail->restype == RTSTR)
            name = pTail->resval.rstring;
        else if (argCount == 1 && pTail->restype == RTSTR)
            key = pTail->resval.rstring;
        else
            break;
        argCount++;
    }
    resbuf* pBuf = normalizeResBuf(pTail);
    if (pBuf != nullptr)
        VlceMapController::get().insertStrMap(name, key, pBuf) ? acedRetT() : acedRetNil();
    else
        acedRetNil();
    return (RSRSLT);
}

int VlceMapFuncs::strmapvalue()
{
    AcResBufPtr pArgs(acedGetArgs());
    AcString name;
    AcString key;
    int argCount = 0;
    for (resbuf* pTail = pArgs.get(); pTail != nullptr; pTail = pTail->rbnext)
    {
        if (argCount == 0 && pTail->restype == RTSTR)
            name = pTail->resval.rstring;
        else if (argCount == 1 && pTail->restype == RTSTR)
            key = pTail->resval.rstring;
        else
            break;
        argCount++;
    }
    const resbuf* pBuf = VlceMapController::get().valueStrMap(name, key);
    if (pBuf == nullptr)
    {
        acedRetNil();
        return (RSRSLT);
    }
    if (pBuf->restype == RTPOINT || pBuf->restype == RT3DPOINT)
        acedRetPoint(pBuf->resval.rpoint);
    else
        acedRetList(pBuf);
    return (RSRSLT);
}

int VlceMapFuncs::createintmap()
{
    AcResBufPtr pArgs(acedGetArgs());
    if (pArgs->restype == RTSTR)
        return VlceMapController::get().createIntMap(pArgs->resval.rstring) ? acedRetT() : acedRetNil();
    acedRetNil();
    return (RSRSLT);
}

int VlceMapFuncs::eraseintmap()
{
    AcResBufPtr pArgs(acedGetArgs());
    if (pArgs->restype == RTSTR)
        return VlceMapController::get().eraseIntMap(pArgs->resval.rstring) ? acedRetT() : acedRetNil();
    acedRetNil();
    return (RSRSLT);
}

int VlceMapFuncs::intmapinsert()
{
    AcResBufPtr pArgs(acedGetArgs());
    AcString name;
    int key = -1;
    int argCount = 0;
    resbuf* pTail = pArgs.get();
    for (; pTail != nullptr; pTail = pTail->rbnext)
    {
        if (argCount == 0 && pTail->restype == RTSTR)
            name = pTail->resval.rstring;
        else if (argCount == 1 && (pTail->restype == RTSHORT || pTail->restype == RTLONG))
            key = pTail->resval.rlong;
        else
            break;
        argCount++;
    }
    if (key == -1)
    {
        acedRetNil();
        return (RSRSLT);
    }
    resbuf* pBuf = normalizeResBuf(pTail);
    if (pBuf != nullptr)
        VlceMapController::get().insertIntMap(name, key, pBuf) ? acedRetT() : acedRetNil();
    else
        acedRetNil();
    return (RSRSLT);
}

int VlceMapFuncs::intmapvalue()
{
    AcResBufPtr pArgs(acedGetArgs());
    AcString name;
    int key = -1;
    int argCount = 0;
    for (resbuf* pTail = pArgs.get(); pTail != nullptr; pTail = pTail->rbnext)
    {
        if (argCount == 0 && pTail->restype == RTSTR)
            name = pTail->resval.rstring;
        else if (argCount == 1 && (pTail->restype == RTSHORT || pTail->restype == RTLONG))
            key = pTail->resval.rlong;
        else
            break;
        argCount++;
    }
    if (key == -1)
    {
        acedRetNil();
        return (RSRSLT);
    }
    const resbuf* pBuf = VlceMapController::get().valueIntMap(name, key);
    if (pBuf == nullptr)
    {
        acedRetNil();
        return (RSRSLT);
    }
    if (pBuf->restype == RTPOINT || pBuf->restype == RT3DPOINT)
        acedRetPoint(pBuf->resval.rpoint);
    else
        acedRetList(pBuf);
    return (RSRSLT);
}

int VlceMapFuncs::makekey()
{
    BYTES bytes;
    AcResBufPtr pArgs(acedGetArgs());

    for (resbuf* pTail = pArgs.get(); pTail != nullptr; pTail = pTail->rbnext)
    {
        switch (pTail->restype)
        {
            case RTSHORT:
            {
                RbVal<int16_t> var{ pTail->resval.rint };
                bytes.append(var.data.buf, var.size());
            }
            break;
            case RTLONG:
            {
                RbVal<int32_t> var{ pTail->resval.rlong };
                bytes.append(var.data.buf, var.size());
            }
            break;
            case RTENAME:
            {
                RbVal<int64_t> var{ pTail->resval.mnInt64 };
                bytes.append(var.data.buf, var.size());
            }
            break;
            case RTREAL:
            {
                RbVal<double_t> var{ pTail->resval.rreal };
                bytes.append(var.data.buf, var.size());
            }
            break;
            case RTPOINT:
            {
                {
                    RbVal<double_t> var{ pTail->resval.rpoint[0] };
                    bytes.append(var.data.buf, var.size());
                }
                {
                    RbVal<double_t> var{ pTail->resval.rpoint[1] };
                    bytes.append(var.data.buf, var.size());
                }
            }
            break;
            case RT3DPOINT:
            {
                {
                    RbVal<double_t> var{ pTail->resval.rpoint[0] };
                    bytes.append(var.data.buf, var.size());
                }
                {
                    RbVal<double_t> var{ pTail->resval.rpoint[1] };
                    bytes.append(var.data.buf, var.size());
                }
                {
                    RbVal<double_t> var{ pTail->resval.rpoint[2] };
                    bytes.append(var.data.buf, var.size());
                }
            }
            break;
            case RTSTR:
            {
                for (const auto ch : wstr_to_utf8(pTail->resval.rstring))
                    bytes.push_back(std::byte(ch));
            }
            break;
            default:
                break;
        }
    }
    std::size_t hash = boost::hash_range(bytes.begin(), bytes.end());
    acedRetStr(std::format(L"{:x}", hash).c_str());
    return (RSRSLT);
}

int VlceMapFuncs::strmapkeys()
{
    AcResBufPtr pArgs(acedGetArgs());
    if (pArgs != nullptr && pArgs->restype == RTSTR)
    {
        if (VlceMapController::get().mStrMap.contains(pArgs->resval.rstring))
        {
            const auto& mmap = VlceMapController::get().mStrMap.at(pArgs->resval.rstring);
            if (mmap.size())
            {
                AcResBufPtr pHead(acutNewRb(RTLB));
                resbuf* pTail = pHead.get();
                for (const auto& item : mmap)
                {
                    pTail = pTail->rbnext = acutNewRb(RTSTR);
                    pTail->resval.rstring = StrDupW(item.first);
                }
                pTail = pTail->rbnext = acutNewRb(RTLE);
                acedRetList(pHead.get());
                return (RSRSLT);
            }
        }
    }
    acedRetNil();
    return (RSRSLT);
}

int VlceMapFuncs::intmapkeys()
{
    AcResBufPtr pArgs(acedGetArgs());
    if (pArgs != nullptr && pArgs->restype == RTSTR)
    {
        if (VlceMapController::get().mIntMap.contains(pArgs->resval.rstring))
        {
            const auto& mmap = VlceMapController::get().mIntMap.at(pArgs->resval.rstring);
            if (mmap.size())
            {
                AcResBufPtr pHead(acutNewRb(RTLB));
                resbuf* pTail = pHead.get();
                for (const auto& item : mmap)
                {
                    pTail = pTail->rbnext = acutNewRb(RTLONG);
                    pTail->resval.rlong = item.first;
                }
                pTail = pTail->rbnext = acutNewRb(RTLE);
                acedRetList(pHead.get());
                return (RSRSLT);
            }
        }
    }
    acedRetNil();
    return (RSRSLT);
}

#endif