(defun c:TSP ( / *error* tttt ftoa collinear-p chkinters-p chkinters grid make-polyline make-lwpolyline car-sort tsp-rnd wcs initvalueslst ucsf ch chh ti ss i pl pl1 pl2 d0 d1 d2 d ent )

  (defun *error* ( m )
    (if wcs
      (if ucsf
        (while
          (not
            (and
              (equal (getvar (quote ucsxdir)) (car ucsf) 1e-6)
              (equal (getvar (quote ucsydir)) (cadr ucsf) 1e-6)
              (equal (trans (list 0.0 0.0 1.0) 1 0 t) (caddr ucsf) 1e-6)
            )
          )
          (exe (list "_.UCS" "_P"))
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (if (not (exe (list "_.UNDO" "_E")))
        (if doc
          (vla-endundomark doc)
        )
      )
    )
    (if initvalueslst
      (mapcar (function apply_cadr->car) initvalueslst)
    )
    (foreach fun (list (quote tttt) (quote vl-load) (quote exe) (quote cmdfun) (quote cmderr) (quote catch_cont) (quote apply_cadr->car) (quote ftoa))
      (setq fun nil)
    )
    (if doc
      (vla-regen doc acactiveviewport)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (cond
    ( (= "BRICSCAD" (getvar (quote program)))
      (if (findfile "VLCE_NP_Brx25.brx")
        (arxload (findfile "VLCE_NP_Brx25.brx"))
        (prompt "\nVLCE_NP_Brx25.brx not found in SFSP...")
      )
    )
    ( t
      (if (findfile "VLCE_NP_Arx24.arx")
        (arxload (findfile "VLCE_NP_Arx24.arx"))
        (prompt "\nVLCE_NP_Arx24.arx not found in SFSP...")
      )
    )
  )

  (defun tttt ( wcs / sysvarpreset sysvarlst sysvarvals ) ;;; wcs (T/nil) ;;; cad, doc, alo, spc - global variables (Visual Lisp main VLA-OBJECT pointers) ;;; vl-load exe cmdfun cmderr catch_cont apply_cadr->car ftoa - library sub functions common for standard template initialization ;;;

    (defun vl-load nil
      (or cad
        (if vlax-get-acad-object
          (setq cad (vlax-get-acad-object))
          (progn
            (vl-load-com)
            (setq cad (vlax-get-acad-object))
          )
        )
      )
      (or doc (setq doc (vla-get-activedocument cad)))
      (or alo (setq alo (vla-get-activelayout doc)))
      (or spc (setq spc (vla-get-block alo)))
    )

    ;;; sometimes not needed to use/initialize AxiveX Visual Lisp extensions - (comment/uncomment) following line ;;;
    (or (and cad doc alo spc) (vl-load))

    (defun exe ( tokenslist )
      ( (lambda ( tokenslist / ctch )
          (if (vl-catch-all-error-p (setq ctch (cmdfun tokenslist t)))
            (progn
              (cmderr tokenslist)
              (catch_cont ctch)
            )
            (progn
              (while (< 0 (getvar (quote cmdactive)))
                (vl-cmdf "")
              )
              t
            )
          )
        )
        tokenslist
      )
    )

    (defun cmdfun ( tokenslist flag / ctch ) ;;; tokenslist - command parameters list of strings ;;; flag - if "t" specified, upon successful execution returns t, otherwise if "nil" specified, return is always nil no matter what outcome of function execution is - it should be successful anyway if specified tokenslist was hardcoded correctly... ;;;
      (if command-s
        (if flag
          (if (not (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command-s) tokenslist))))
            flag
            ctch
          )
          (if (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command-s) tokenslist)))
            ctch
          )
        )
        (if flag
          (if (not (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function vl-cmdf) tokenslist))))
            flag
            ctch
          )
          (if (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command) tokenslist)))
            ctch
          )
        )
      )
    )

    (defun cmderr ( tokenslist ) ;;; tokenslist - list of tokens representing command syntax at which used (cmdfun) failed with successful execution ;;;
      (prompt (strcat "\ncommand execution failure... error at used command tokenslist : " (vl-prin1-to-string tokenslist)))
    )

    (defun catch_cont ( ctch / gr )
      (prompt "\nleft mouse click to continue or enter to generate catch error - ESC to break...")
      (while
        (and
          (vl-catch-all-error-p (or ctch (setq ctch (vl-catch-all-apply (function /) (list 1 0)))))
          (setq gr (grread))
          (/= (car gr) 3)
          (not (equal gr (list 2 13)))
        )
      )
      (if (vl-catch-all-error-p ctch)
        ctch
      )
    )

    (defun apply_cadr->car ( sysvarvaluepair / ctch )
      (setq ctch (vl-catch-all-apply (function setvar) sysvarvaluepair))
      (if (vl-catch-all-error-p ctch)
        (progn
          (prompt (strcat "\ncatched error on setting system variable : " (vl-prin1-to-string (vl-symbol-name (car sysvarvaluepair))) " with value : " (vl-prin1-to-string (cadr sysvarvaluepair))))
          (catch_cont ctch)
        )
      )
    )

    (setq sysvarpreset
      (list
        (list (quote cmdecho) 0)
        (list (quote 3dosmode) 0)
        (list (quote osmode) 0)
        (list (quote unitmode) 0)
        (list (quote cmddia) 0)
        (list (quote ucsvp) 0)
        (list (quote ucsortho) 0)
        (list (quote projmode) 0)
        (list (quote orbitautotarget) 0)
        (list (quote insunits) 0)
        (list (quote hpseparate) 0)
        (list (quote hpgaptol) 0)
        (list (quote halogap) 0)
        (list (quote edgemode) 0)
        (list (quote pickdrag) 0)
        (list (quote qtextmode) 0)
        (list (quote dragsnap) 0)
        (list (quote angdir) 0)
        (list (quote aunits) 0)
        (list (quote limcheck) 0)
        (list (quote gridmode) 0)
        (list (quote nomutt) 0)
        (list (quote apbox) 0)
        (list (quote attdia) 0)
        (list (quote blipmode) 0)
        (list (quote copymode) 0)
        (list (quote circlerad) 0.0)
        (list (quote filletrad) 0.0)
        (list (quote filedia) 1)
        (list (quote autosnap) 1)
        (list (quote objectisolationmode) 1)
        (list (quote highlight) 1)
        (list (quote lispinit) 1)
        (list (quote layerpmode) 1)
        (list (quote fillmode) 1)
        (list (quote dragmodeinterrupt) 1)
        (list (quote dispsilh) 1)
        (list (quote fielddisplay) 1)
        (list (quote deletetool) 1)
        (list (quote delobj) 1)
        (list (quote dblclkedit) 1)
        (list (quote attreq) 1)
        (list (quote explmode) 1)
        (list (quote frameselection) 1)
        (list (quote ltgapselection) 1)
        (list (quote pickfirst) 1)
        (list (quote plinegen) 1)
        (list (quote plinetype) 1)
        (list (quote peditaccept) 1)
        (list (quote solidcheck) 1)
        (list (quote visretain) 1)
        (list (quote regenmode) 1)
        (list (quote celtscale) 1.0)
        (list (quote ltscale) 1.0)
        (list (quote osnapcoord) 2)
        (list (quote grips) 2)
        (list (quote dragmode) 2)
        (list (quote lunits) 2)
        (list (quote pickstyle) 3)
        (list (quote navvcubedisplay) 3)
        (list (quote pickauto) 3)
        (list (quote draworderctl) 3)
        (list (quote expert) 5)
        (list (quote auprec) 6)
        (list (quote luprec) 6)
        (list (quote pickbox) 6)
        (list (quote aperture) 6)
        (list (quote osoptions) 7)
        (list (quote dimzin) 8)
        (list (quote pdmode) 35)
        (list (quote pdsize) -1.5)
        (list (quote celweight) -1)
        ;(list (quote cecolor) "BYLAYER")
        ;(list (quote celtype) "ByLayer")
        ;(list (quote clayer) "0")
      )
    )
    (setq sysvarlst (mapcar (function car) sysvarpreset))
    (setq sysvarvals (mapcar (function cadr) sysvarpreset))
    (setq sysvarvals
      (vl-remove nil
        (mapcar
          (function (lambda ( x )
            (if (getvar x) (nth (vl-position x sysvarlst) sysvarvals))
          ))
          sysvarlst
        )
      )
    )
    (setq sysvarlst
      (vl-remove-if-not
        (function (lambda ( x )
          (getvar x)
        ))
        sysvarlst
      )
    )
    (setq initvalueslst
      (apply (function mapcar)
        (cons (function list)
          (list
            sysvarlst
            (mapcar (function getvar) sysvarlst)
          )
        )
      )
    )
    (apply (function mapcar)
      (cons (function setvar)
        (list
          sysvarlst
          sysvarvals
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (if (not (exe (list "_.UNDO" "_E")))
        (if doc
          (vla-endundomark doc)
        )
      )
    )
    (if (not (exe (list "_.UNDO" "_M")))
      (if doc
        (vla-startundomark doc)
      )
    )
    (if wcs
      (if (= 0 (getvar (quote worlducs)))
        (progn
          (setq ucsf
            (list
              (getvar (quote ucsxdir))
              (getvar (quote ucsydir))
              (trans (list 0.0 0.0 1.0) 1 0 t)
            )
          )
          (exe (list "_.UCS" "_W"))
        )
      )
    )
    wcs
  )

  (defun ftoa ( n / m a s b )
    (if (numberp n)
      (progn
        (setq m (fix ((if (< n 0) - +) n 1e-8)))
        (setq a (abs (- n m)))
        (setq m (itoa m))
        (setq s "")
        (while (and (not (equal a 0.0 1e-6)) (setq b (fix (* a 10.0))))
          (setq s (strcat s (itoa b)))
          (setq a (- (* a 10.0) b))
        )
        (if (= (type n) (quote int))
          m
          (if (= s "")
            m
            (if (and (= m "0") (< n 0))
              (strcat "-" m "." s)
              (strcat m "." s)
            )
          )
        )
      )
    )
  )

  (defun collinear-p ( p1 p p2 )
    (equal (distance p1 p2) (+ (distance p1 p) (distance p p2)) 1e-6)
  )

  (defun chkinters-p ( pl / r lil )
    (setq lil (mapcar (function list) pl (append (cdr pl) (list (car pl)))))
    (setq r
      (vl-some
        (function (lambda ( x )
          (vl-some
            (function (lambda ( y )
              (and
                (not (equal (car x) (car y) 1e-6))
                (not (equal (car x) (cadr y) 1e-6))
                (not (equal (cadr x) (car y) 1e-6))
                (not (equal (cadr x) (cadr y) 1e-6))
                (or
                  (inters (car x) (cadr x) (car y) (cadr y))
                  (collinear-p (car x) (car y) (cadr x))
                  (collinear-p (car x) (cadr y) (cadr x))
                  (collinear-p (car y) (car x) (cadr y))
                  (collinear-p (car y) (cadr x) (cadr y))
                )
              )
            ))
            (vl-remove x lil)
          )
        ))
        lil
      )
    )
    r
  )

  (defun chkinters ( pl / processlil done r lill ilil iip )
 
    (defun processlil ( ilil lil / pre mid suf ret )
      (setq pre (reverse (cdr (member (car ilil) (reverse lil)))))
      (setq mid (cdr (member (car ilil) lil)))
      (setq mid (cdr (member (cadr ilil) (reverse mid))))
      (setq mid (mapcar (function reverse) mid))
      (setq suf (cdr (member (cadr ilil) lil)))
      (setq ret (append pre (list (list (car (car ilil)) (car (cadr ilil)))) mid (list (list (cadr (car ilil)) (cadr (cadr ilil)))) suf))
      ret
    )
 
    (or lil (setq lil (mapcar (function list) pl (append (cdr pl) (list (car pl))))))
    (while (not done)
      (setq ilil (vl-some (function (lambda ( a ) (vl-some (function (lambda ( b / ip ) (progn (setq iip (inters (car a) (cadr a) (car b) (cadr b))) (if (and (not (equal (cadr a) (car b) 1e-6)) (not (equal (car a) (cadr b) 1e-6)) (not (or (and (collinear-p (car a) (car b) (cadr a)) (collinear-p (car a) (cadr b) (cadr a))) (and (collinear-p (car b) (car a) (cadr b)) (collinear-p (car b) (cadr a) (cadr b))))) (not (or (and (collinear-p (car a) (car b) (cadr a)) (collinear-p (car b) (cadr a) (cadr b))) (and (collinear-p (car b) (car a) (cadr b)) (collinear-p (car a) (cadr b) (cadr a)))))) (cond ( (collinear-p (car a) (car b) (cadr a)) (setq ip (car b)) ) ( (collinear-p (car a) (cadr b) (cadr a)) (setq ip (cadr b)) ) ( (collinear-p (car b) (car a) (cadr b)) (setq ip (car a)) ) ( (collinear-p (car b) (cadr a) (cadr b)) (setq ip (cadr a)) )) (setq iip nil)) (cond ( iip (list a b iip) ) ( ip (list a b ip) ))))) (vl-remove a lil)))) lil))
      (cond
        ( (and ilil (equal iip (caddr ilil) 1e-6))
          (setq lil (processlil ilil lil))
        )
        ( (and ilil (equal (caar ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (caar ilil) (caadr ilil) 1e-6)) (not (equal (caar ilil) (cadadr ilil) 1e-6)))
              (setq lil (processlil ilil lil))
            )
            ( (equal (caar ilil) (caadr ilil) 1e-6)
              (setq lil (processlil ilil lil))
            )
            ( (equal (caar ilil) (cadadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (cadar ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (cadar ilil) (caadr ilil) 1e-6)) (not (equal (cadar ilil) (cadadr ilil) 1e-6)))
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadar ilil) (caadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadar ilil) (cadadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (caadr ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (caadr ilil) (caar ilil) 1e-6)) (not (equal (caadr ilil) (cadar ilil) 1e-6)))
              (setq lil (processlil ilil lil))
            )
            ( (equal (caadr ilil) (caar ilil) 1e-6)
              (setq lil (processlil ilil lil))
            )
            ( (equal (caadr ilil) (cadar ilil) 1e-6)
              (setq ilil (subst (assoc (caadr ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (cadadr ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (cadadr ilil) (caar ilil) 1e-6)) (not (equal (cadadr ilil) (cadar ilil) 1e-6)))
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadadr ilil) (caar ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadadr ilil) (cadar ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( t (setq done t) )
      )
    )
    (setq r (mapcar (function car) lil))
    (setq lil nil)
    r
  )

  (defun grid ( l / ucsf a b bb d1 d2 a1 a2 e ll p pl an f )
    ;(setq l (vl-sort l (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (cadr a) (cadr b)) (< (car a) (car b)))))))
    (if (= 0 (getvar (quote worlducs)))
      (progn
        (if command-s
          (command-s "_.UCS" "_W")
          (vl-cmdf "_.UCS" "_W")
        )
        (setq ucsf t)
      )
    )
    (if command-s
      (command-s "_.UCS" "_3P" "_non" (car l) "_non" (cadr l) "_non" (polar (car l) (+ (angle (car l) (cadr l)) (* 0.5 pi)) 1.0))
      (vl-cmdf "_.UCS" "_3P" "_non" (car l) "_non" (cadr l) "_non" (polar (car l) (+ (angle (car l) (cadr l)) (* 0.5 pi)) 1.0))
    )
    (setq l (mapcar (function (lambda ( p ) (trans p 0 1))) l))
    (setq ll (last l))
    (setq an 0.0)
    (setq p  (car l)
          pl (list p)
          l  (cdr l)
    )
    (while l
      (setq l (vl-sort l (function (lambda ( a b ) (< (distance p a) (distance p b))))))
      (setq a1 (car l) a2 (cadr l))
      (setq d1 (distance p a1) d2 (if a2 (distance p a2)))
      (if (and d2 (equal d1 d2 1e-6))
        (if (and an (or (equal (angle p a1) an 1e-6) (equal (angle p a1) (rem (+ pi an) (+ pi pi)) 1e-6) (if (or (equal an 0.0 1e-6) (equal an (* 2 pi) 1e-6)) (equal (angle p a1) (* 2 pi) 1e-6))))
          (setq a a1)
          (setq a a2)
        )
        (setq a a1)
      )
      (if (and an (or (equal (angle p a) an 1e-6) (equal (angle p a) (rem (+ pi an) (+ pi pi)) 1e-6) (if (or (equal an 0.0 1e-6) (equal an (* 2 pi) 1e-6)) (equal (angle p a) (* 2 pi) 1e-6))))
        (setq bb a)
        (setq b a)
      )
      (if bb
        (setq b bb)
      )
      (cond
        ( (equal a1 ll 1e-6)
          (setq a a1 b a an (* 0.5 pi) f t)
        )
        ( (equal a2 ll 1e-6)
          (setq a a2 b a an (* 0.5 pi) f t)
        )
      )
      (setq pl (cons b pl)
            l  (vl-remove b l)
            p  b
            b  nil
            bb nil
      )
      (if f
        (cond
          ( (= an 0.0)
            (setq an (* 0.5 pi))
          )
          ( t
            (setq an 0.0)
          )
        )
        (cond
          ( (and (= an 0.0) (equal (car p) (car ll) 1e-6))
            (setq an (* 0.5 pi))
          )
          ( (and (= an (* 0.5 pi)) (equal (cadr p) (cadr ll) 1e-6))
            (setq an 0.0)
          )
          ( (and (= an (* 0.5 pi)) (equal (car p) (car ll) 1e-6))
            (setq an 0.0)
          )
          ( (and (= an 0.0) (equal (cadr p) (cadr ll) 1e-6))
            (setq an (* 0.5 pi))
          )
        )
      )
    )
    (setq pl (reverse pl))
    (setq e  nil
          l  pl
          ll l
    )
    (while (and (not e) ll)
      (setq e  t
            ll l
      )
      (while (and e ll)
        (setq ll (if (listp (caar ll))
                  ll
                  (mapcar (function list) (cons (last ll) ll) ll)
                 )
              a  (car ll)
              pl (vl-remove-if (function (lambda ( b ) (or (member (car a) b) (member (cadr a) b))))
                               (cdr ll)
                 )
              ll (cdr ll)
        )
        (while (and pl (setq b (car pl)) (not (inters (car a) (cadr a) (car b) (cadr b))))
          (setq pl (cdr pl))
        )
        (if pl
          (progn (setq l (append (member (car a) l) (reverse (cdr (member (car a) (reverse l))))) ;;; [(car a) (cadr a) ... ->end] + ((car b) (cadr b)) - in middle of concatenated l + [start ... ->] ... (car a) - don't exist - it was (cdr-ed) 
                       l (append (list (car a)) (member (car b) (reverse (cdr l))) (member (cadr b) l)) ;;; [(car a)] + [(car b) + end<- ... (cadr a)] + [(cadr b) + start ... ->]
                       e nil
                 )
          )
        )
      )
    )
    (setq l (mapcar (function (lambda ( p ) (trans p 1 0))) l))
    (if command-s
      (command-s "_.UCS" "_P")
      (vl-cmdf "_.UCS" "_P")
    )
    (if ucsf
      (if command-s
        (command-s "_.UCS" "_P")
        (vl-cmdf "_.UCS" "_P")
      )
    )
    l
  )

  (defun make-polyline ( lst )
    (vl-cmdf "_.3DPOLY")
    (foreach p lst
      (vl-cmdf "_non" p)
    )
    (vl-cmdf "_C")
  )

  (defun make-lwpolyline ( lst )
    (entmake
      (append
        (list
          (cons 0 "LWPOLYLINE")
          (cons 100 "AcDbEntity")
          (cons 100 "AcDbPolyline")
          (cons 90 (length lst))
          (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
          (cons 38 0.0)
        )
        (mapcar (function (lambda ( p ) (cons 10 p))) lst)
        (list (list 210 0.0 0.0 1.0))
      )
    )
  )

  (defun car-sort ( lst cmp / rtn )
    (setq rtn (car lst))
    (if (cdr lst)
      (foreach itm (cdr lst)
        (if (apply cmp (list itm rtn))
          (setq rtn itm)
        )
      )
    )
    rtn
  )

  (defun tsp-rnd ( l / f1 f2 d d0 d1 e ent ep a pl n rr )

    (defun f1 ( a ent / p pl pll dl d pos enx )
      (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq enx (entget ent)))))
      (setq pll (mapcar (function list) pl (append (cdr pl) (list (car pl)))))
      (foreach li pll
        (setq dl (cons (- (+ (distance a (car li)) (distance a (cadr li))) (distance (car li) (cadr li))) dl))
      )
      (setq d (car-sort dl (function <)))
      (setq pos (vl-position d dl))
      (setq p (car (nth pos pll)))
      (setq p (list 10 (car p) (cadr p)))
      (entupd (cdr (assoc -1 (entmod (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 enx)))) (assoc 90 enx) enx))))
                                             (list (cons 10 a))
                                             (cdr (member p enx))
                                     )
                             )
                   )
              )
      )
    )

    (defun f2 ( a ent / p enx )
      (setq enx (entget ent))
      (setq p (vlax-curve-getPointAtParam ent (fix (vlax-curve-getParamAtPoint ent (vlax-curve-getClosestPointTo ent a)))))
      (setq p (list 10 (car p) (cadr p)))
      (entupd (cdr (assoc -1 (entmod (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 enx)))) (assoc 90 enx) enx))))
                                             (list (cons 10 a))
                                             (cdr (member p enx))
                                     )
                             )
                   )
              )
      )
    )

    (setq ent (entmakex (append (list (cons 0 "LWPOLYLINE")
                                      (cons 100 "AcDbEntity")
                                      (cons 100 "AcDbPolyline")
                                      (cons 90 (length l))
                                      (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                                )
                                (mapcar (function (lambda ( a ) (cons 10 a))) l)
                                (list (list 210 0.0 0.0 1.0))
                        )
              )
          ep  (length l)
    )
    (setq d0 (vlax-curve-getDistAtParam ent ep))
    (while
      (> d0
        (progn
          (setq n 0
               l (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq e (entget ent))))
               l (mapcar (function list) l (append (cdr l) (list (car l))))
          )
          (repeat ep
            (setq d (vlax-curve-getDistAtParam ent ep)
                 a (nth n (append l l))
            )



            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f1 (car a) ent)
            (f1 (cadr a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )
            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f1 (cadr a) ent)
            (f1 (car a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )



            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f2 (car a) ent)
            (f2 (cadr a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )
            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f2 (cadr a) ent)
            (f2 (car a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )



            (setq n (1+ n))
          )
          d
        )
      )
      (setq d0 d)
    )
    ent
  )

  (setq wcs (tttt t)) ;;; starting "library" template sub function - initialization ;;;
  (prompt "\nSelect points, inserts or circles...")
  (if (setq ss (ssget (list (cons 0 "POINT,INSERT,CIRCLE"))))
    (progn
      (initget "Grid Rnd")
      (setq ch (cond ( (getkword "\nChoose option of points disposition [Grid / Rnd] <Rnd> : ") ) ( "Rnd" ) )) 
      (if (or (= ch "Rnd") (= ch "Grid"))
        (progn
          (initget 6)
          (setq n
            (cond
              ( (getint "\nSpecify how many seconds for calculation per ARX algorithm <180> : ") )
              ( 180 )
            )
          )
        )
      )
      (initget "2D 3D")
      (setq chh (cond ( (getkword "\nChoose point disposition [2D / 3D] <2D> : ") ) ( "2D" ) ))
      (setq ti (car (_vl-times)))
      (repeat (setq i (sslength ss))
        (setq pl (cons (cdr (assoc 10 (entget (ssname ss (setq i (1- i)))))) pl))
      )
      (setq pl (vl-sort pl (function (lambda ( a b ) (< (angle a b) (angle b a))))))
      (cond
        ( (= ch "Grid")
          (setq pl (grid pl))
          (setq pl1 (vlce_cheapestpathlsm 3 n -1 pl))
          (setq pl2 (vlce_cheapestpathfss 2 -1 pl))
          (if (chkinters-p pl)
            (setq pl (chkinters pl))
          )
          (setq d0 (apply (function +) (mapcar (function distance) pl (append (cdr pl) (list (car pl))))))
          (if (chkinters-p pl1)
            (setq pl1 (chkinters pl1))
          )
          (setq d1 (apply (function +) (mapcar (function distance) pl1 (append (cdr pl1) (list (car pl1))))))
          (if (chkinters-p pl2)
            (setq pl2 (chkinters pl2))
          )
          (setq d2 (apply (function +) (mapcar (function distance) pl2 (append (cdr pl2) (list (car pl2))))))
          (cond
            ( (= d0 (min d0 d1 d2))
              (setq d d0)
            )
            ( (= d1 (min d0 d1 d2))
              (setq d d1 pl pl1)
            )
            ( (= d2 (min d0 d1 d2))
              (setq d d2 pl pl2)
            )
          )
        )
        ( t
          (cond
            ( (= chh "3D")
              (setq pl1 (vlce_cheapestpathlsm 3 n -1 pl))
              (if (chkinters-p pl1)
                (setq pl1 (chkinters pl1))
              )
              (setq pl2 (vlce_cheapestpathfss 2 -1 pl))
              (if (chkinters-p pl2)
                (setq pl2 (chkinters pl2))
              )
              (setq d1 (apply (function +) (mapcar (function distance) pl1 (append (cdr pl1) (list (car pl1))))))
              (setq d2 (apply (function +) (mapcar (function distance) pl2 (append (cdr pl2) (list (car pl2))))))
              (if (< d1 d2)
                (setq d d1 pl pl1)
                (setq d d2 pl pl2)
              )
            )
            ( t
              (setq pl1 (vlce_cheapestpathlsm 3 n -1 pl))
              (setq ent (tsp-rnd pl1))
              (setq pl1 (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget ent))))
              (entdel ent)
              (if (chkinters-p pl1)
                (setq pl1 (chkinters pl1))
              )
              (setq pl2 (vlce_cheapestpathfss 2 -1 pl))
              (setq ent (tsp-rnd pl2))
              (setq pl2 (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget ent))))
              (entdel ent)
              (if (chkinters-p pl2)
                (setq pl2 (chkinters pl2))
              )
              (setq d1 (apply (function +) (mapcar (function distance) pl1 (append (cdr pl1) (list (car pl1))))))
              (setq d2 (apply (function +) (mapcar (function distance) pl2 (append (cdr pl2) (list (car pl2))))))
              (if (< d1 d2)
                (setq d d1 pl pl1)
                (setq d d2 pl pl2)
              )
            )
          )
        )
      )
      (if (= chh "3D")
        (make-polyline pl)
        (make-lwpolyline pl)
      )
      (prompt "\nDistance - path length : ") (princ (ftoa d))
      (prompt "\nElapsed time : ") (prompt (ftoa (- (car (_vl-times)) ti))) (prompt " milliseconds...")
      (prompt "\nFor UNDO - type \"UNDO\" - \"Back\" option...")
    )
  )
  (*error* nil)
)