#include "stdafx.h"
#include "PolyPointSolver.h"

void PolyPointSolver::solve(std::vector<AcGePoint3d>& inputPoints)
{
    for (auto iter = inputPoints.begin(); iter != inputPoints.end(); ++iter)
    {
        std::sort(std::execution::par, iter, inputPoints.end(), [&](const AcGePoint3d& a, const AcGePoint3d& b) -> bool
        {
            return iter->distanceTo(a) < iter->distanceTo(b);
        });
    }
}

int PolyPointSolver::polyPointLispFunc()
{
    std::vector<AcGePoint3d> points;
    AcResBufPtr pArgs(acedGetArgs());
    for (resbuf* pTail = pArgs.get(); pTail != nullptr; pTail = pTail->rbnext)
    {
        switch (pTail->restype)
        {
            case RTPOINT:
            case RT3DPOINT:
            {
                points.push_back(asPnt3d(pTail->resval.rpoint));
                break;
            }
            default:
                break;
        }
    }
    PolyPointSolver::solve(points);
    if (points.size())
    {
        AcResBufPtr pRes(acutNewRb(RTLB));
        resbuf* pResTail = pRes.get();
        for (auto& item : points)
        {
            pResTail = pResTail->rbnext = acutNewRb(RT3DPOINT);
            memcpy(pResTail->resval.rpoint, asDblArray(item), sizeof(pResTail->resval.rpoint));
        }
        pResTail = pResTail->rbnext = acutNewRb(RTLE);
        acedRetList(pRes.get());
    }
    return (RSRSLT);
}

