#pragma once

using Point3ds = std::vector<AcGePoint3d>;
using DistMatrix = std::vector<std::vector<int64_t>>;
class TSPSolver
{
    static int luprc();
    static double defaultPrecision();
    static std::vector<AcGePoint3d> solveFirstSolutionStrategy(Point3ds inputPoints, double scale, int stratagy);
    static std::vector<AcGePoint3d> solveLocalSearchMetaheuristicStrategy(Point3ds inputPoints, double scale, int stratagy, int64_t timeInSeconds);

public:
    static int solveFirstSolutionStrategyLispFunc();
    static int solveLocalSearchMetaheuristicStrategyLispFunc();
};

