#include "stdafx.h"
#include "VlceMapController.h"

#ifndef BRXAPP

bool VlceMapController::createStrMap(const AcString& name)
{
    mStrMap[name];
    return  mStrMap.contains(name);
}

bool VlceMapController::insertStrMap(const AcString& name, const AcString& key, const resbuf* src)
{
    auto& usermap = mStrMap[name];
    if (usermap.size() > 2000)
    {
        acutPrintf(_T("\nVlceMapController out of memory: "));
        return false;
    }
    resbuf* pDest = NULL;
    if (acutRbDup(src, &pDest) == RTNORM && pDest != nullptr)
    {
        usermap[key].reset(pDest);
        return true;
    }
    return false;
}

const resbuf* VlceMapController::valueStrMap(const AcString& name, const AcString& key)
{
    if (mStrMap.contains(name))
    {
        const auto& usermap = mStrMap.at(name);
        if (usermap.contains(key))
            return usermap.at(key).get();
    }
    return nullptr;
}

bool VlceMapController::eraseStrMap(const AcString& name)
{
    if (mStrMap.contains(name))
        mStrMap.erase(name);
    return true;
}

//
bool VlceMapController::createIntMap(const AcString& name)
{
    mIntMap[name];
    return mIntMap.contains(name);
}

bool VlceMapController::insertIntMap(const AcString& name, int key, const resbuf* src)
{
    auto& usermap = mIntMap[name];
    if (usermap.size() > 2000)
    {
        acutPrintf(_T("\nVlceMapController out of memory: "));
        return false;
    }
    resbuf* pDest = NULL;
    if (acutRbDup(src, &pDest) == RTNORM && pDest != nullptr)
    {
        usermap[key].reset(pDest);
        return true;
    }
    return false;
}

const resbuf* VlceMapController::valueIntMap(const AcString& name, int key)
{
    if (mIntMap.contains(name))
    {
        const auto& usermap = mIntMap.at(name);
        if (usermap.contains(key))
            return usermap.at(key).get();
    }
    return nullptr;
}

bool VlceMapController::eraseIntMap(const AcString& name)
{
    if (mIntMap.contains(name))
    {
        mIntMap.clear();
        mIntMap.erase(name);
    }
    return true;
}

VlceMapController& VlceMapController::get()
{
    static VlceMapController mthis;
    return mthis;
}

#endif