(defun c:TSP-MMR+ALL ( / *error* tttt ftoa collinear-p chkinters-p chkinters grid makelw car-sort MR:ConvexHull-ptsonHull processEE1 processEE2 processLM AHS:TSP tsp-all tsp-rnd1 tsp-rnd2 tsp-rnd3 tsp-rnd4 tsp-rnd5 tsp-rnd6 tsp-rnd7 tsp-rnd8 tsp-rnd9 tsp-rnd10 tsp-rnd11 tsp-rnd wcs initvalueslst ucsf ti ss i pl d ch pos pl0 pl1 pl2 pl3 pl4 pl5 pl6 pl7 pl8 pl9 pl10 pl11 pl12 pla plll dlll dl ent flag n )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com))

  (defun *error* ( m )
    (if wcs
      (if ucsf
        (while
          (not
            (and
              (equal (getvar (quote ucsxdir)) (car ucsf) 1e-6)
              (equal (getvar (quote ucsydir)) (cadr ucsf) 1e-6)
              (equal (trans (list 0.0 0.0 1.0) 1 0 t) (caddr ucsf) 1e-6)
            )
          )
          (exe (list "_.UCS" "_P"))
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (if (not (exe (list "_.UNDO" "_E")))
        (if doc
          (vla-endundomark doc)
        )
      )
    )
    (if initvalueslst
      (mapcar (function apply_cadr->car) initvalueslst)
    )
    (foreach fun (list (quote tttt) (quote vl-load) (quote exe) (quote cmdfun) (quote cmderr) (quote catch_cont) (quote apply_cadr->car) (quote ftoa))
      (setq fun nil)
    )
    (if doc
      (vla-regen doc acactiveviewport)
    )
    (if m
      (prompt m)
    )
    (princ)
  )

  (defun tttt ( wcs / sysvarpreset sysvarlst sysvarvals ) ;;; wcs (T/nil) ;;; cad, doc, alo, spc - global variables (Visual Lisp main VLA-OBJECT pointers) ;;; vl-load exe cmdfun cmderr catch_cont apply_cadr->car ftoa - library sub functions common for standard template initialization ;;;

    (defun vl-load nil
      (or cad
        (if vlax-get-acad-object
          (setq cad (vlax-get-acad-object))
          (progn
            (vl-load-com)
            (setq cad (vlax-get-acad-object))
          )
        )
      )
      (or doc (setq doc (vla-get-activedocument cad)))
      (or alo (setq alo (vla-get-activelayout doc)))
      (or spc (setq spc (vla-get-block alo)))
    )

    ;;; sometimes not needed to use/initialize AxiveX Visual Lisp extensions - (comment/uncomment) following line ;;;
    (or (and cad doc alo spc) (vl-load))

    (defun exe ( tokenslist )
      ( (lambda ( tokenslist / ctch )
          (if (vl-catch-all-error-p (setq ctch (cmdfun tokenslist t)))
            (progn
              (cmderr tokenslist)
              (catch_cont ctch)
            )
            (progn
              (while (< 0 (getvar (quote cmdactive)))
                (vl-cmdf "")
              )
              t
            )
          )
        )
        tokenslist
      )
    )

    (defun cmdfun ( tokenslist flag / ctch ) ;;; tokenslist - command parameters list of strings ;;; flag - if "t" specified, upon successful execution returns t, otherwise if "nil" specified, return is always nil no matter what outcome of function execution is - it should be successful anyway if specified tokenslist was hardcoded correctly... ;;;
      (if command-s
        (if flag
          (if (not (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command-s) tokenslist))))
            flag
            ctch
          )
          (if (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command-s) tokenslist)))
            ctch
          )
        )
        (if flag
          (if (not (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function vl-cmdf) tokenslist))))
            flag
            ctch
          )
          (if (vl-catch-all-error-p (setq ctch (vl-catch-all-apply (function command) tokenslist)))
            ctch
          )
        )
      )
    )

    (defun cmderr ( tokenslist ) ;;; tokenslist - list of tokens representing command syntax at which used (cmdfun) failed with successful execution ;;;
      (prompt (strcat "\ncommand execution failure... error at used command tokenslist : " (vl-prin1-to-string tokenslist)))
    )

    (defun catch_cont ( ctch / gr )
      (prompt "\nleft mouse click to continue or enter to generate catch error - ESC to break...")
      (while
        (and
          (vl-catch-all-error-p (or ctch (setq ctch (vl-catch-all-apply (function /) (list 1 0)))))
          (setq gr (grread))
          (/= (car gr) 3)
          (not (equal gr (list 2 13)))
        )
      )
      (if (vl-catch-all-error-p ctch)
        ctch
      )
    )

    (defun apply_cadr->car ( sysvarvaluepair / ctch )
      (setq ctch (vl-catch-all-apply (function setvar) sysvarvaluepair))
      (if (vl-catch-all-error-p ctch)
        (progn
          (prompt (strcat "\ncatched error on setting system variable : " (vl-prin1-to-string (vl-symbol-name (car sysvarvaluepair))) " with value : " (vl-prin1-to-string (cadr sysvarvaluepair))))
          (catch_cont ctch)
        )
      )
    )

    (setq sysvarpreset
      (list
        (list (quote cmdecho) 0)
        (list (quote 3dosmode) 0)
        (list (quote osmode) 0)
        (list (quote unitmode) 0)
        (list (quote cmddia) 0)
        (list (quote ucsvp) 0)
        (list (quote ucsortho) 0)
        (list (quote projmode) 0)
        (list (quote orbitautotarget) 0)
        (list (quote insunits) 0)
        (list (quote hpseparate) 0)
        (list (quote hpgaptol) 0)
        (list (quote halogap) 0)
        (list (quote edgemode) 0)
        (list (quote pickdrag) 0)
        (list (quote qtextmode) 0)
        (list (quote dragsnap) 0)
        (list (quote angdir) 0)
        (list (quote aunits) 0)
        (list (quote limcheck) 0)
        (list (quote gridmode) 0)
        (list (quote nomutt) 0)
        (list (quote apbox) 0)
        (list (quote attdia) 0)
        (list (quote blipmode) 0)
        (list (quote copymode) 0)
        (list (quote circlerad) 0.0)
        (list (quote filletrad) 0.0)
        (list (quote filedia) 1)
        (list (quote autosnap) 1)
        (list (quote objectisolationmode) 1)
        (list (quote highlight) 1)
        (list (quote lispinit) 1)
        (list (quote layerpmode) 1)
        (list (quote fillmode) 1)
        (list (quote dragmodeinterrupt) 1)
        (list (quote dispsilh) 1)
        (list (quote fielddisplay) 1)
        (list (quote deletetool) 1)
        (list (quote delobj) 1)
        (list (quote dblclkedit) 1)
        (list (quote attreq) 1)
        (list (quote explmode) 1)
        (list (quote frameselection) 1)
        (list (quote ltgapselection) 1)
        (list (quote pickfirst) 1)
        (list (quote plinegen) 1)
        (list (quote plinetype) 1)
        (list (quote peditaccept) 1)
        (list (quote solidcheck) 1)
        (list (quote visretain) 1)
        (list (quote regenmode) 1)
        (list (quote celtscale) 1.0)
        (list (quote ltscale) 1.0)
        (list (quote osnapcoord) 2)
        (list (quote grips) 2)
        (list (quote dragmode) 2)
        (list (quote lunits) 2)
        (list (quote pickstyle) 3)
        (list (quote navvcubedisplay) 3)
        (list (quote pickauto) 3)
        (list (quote draworderctl) 3)
        (list (quote expert) 5)
        (list (quote auprec) 6)
        (list (quote luprec) 6)
        (list (quote pickbox) 6)
        (list (quote aperture) 6)
        (list (quote osoptions) 7)
        (list (quote dimzin) 8)
        (list (quote pdmode) 35)
        (list (quote pdsize) -1.5)
        (list (quote celweight) -1)
        ;(list (quote cecolor) "BYLAYER")
        ;(list (quote celtype) "ByLayer")
        ;(list (quote clayer) "0")
      )
    )
    (setq sysvarlst (mapcar (function car) sysvarpreset))
    (setq sysvarvals (mapcar (function cadr) sysvarpreset))
    (setq sysvarvals
      (vl-remove nil
        (mapcar
          (function (lambda ( x )
            (if (getvar x) (nth (vl-position x sysvarlst) sysvarvals))
          ))
          sysvarlst
        )
      )
    )
    (setq sysvarlst
      (vl-remove-if-not
        (function (lambda ( x )
          (getvar x)
        ))
        sysvarlst
      )
    )
    (setq initvalueslst
      (apply (function mapcar)
        (cons (function list)
          (list
            sysvarlst
            (mapcar (function getvar) sysvarlst)
          )
        )
      )
    )
    (apply (function mapcar)
      (cons (function setvar)
        (list
          sysvarlst
          sysvarvals
        )
      )
    )
    (while (= 8 (logand 8 (getvar (quote undoctl))))
      (if (not (exe (list "_.UNDO" "_E")))
        (if doc
          (vla-endundomark doc)
        )
      )
    )
    (if (not (exe (list "_.UNDO" "_M")))
      (if doc
        (vla-startundomark doc)
      )
    )
    (if wcs
      (if (= 0 (getvar (quote worlducs)))
        (progn
          (setq ucsf
            (list
              (getvar (quote ucsxdir))
              (getvar (quote ucsydir))
              (trans (list 0.0 0.0 1.0) 1 0 t)
            )
          )
          (exe (list "_.UCS" "_W"))
        )
      )
    )
    wcs
  )

  (defun ftoa ( n / m a s b )
    (if (numberp n)
      (progn
        (setq m (fix ((if (< n 0) - +) n 1e-6)))
        (setq a (abs (- n m)))
        (setq m (itoa m))
        (setq s "")
        (while (and (not (equal a 0.0 1e-6)) (setq b (fix (* a 10.0))))
          (setq s (strcat s (itoa b)))
          (setq a (- (* a 10.0) b))
        )
        (if (= (type n) (quote int))
          m
          (if (= s "")
            m
            (if (and (= m "0") (< n 0))
              (strcat "-" m "." s)
              (strcat m "." s)
            )
          )
        )
      )
    )
  )

  (defun collinear-p ( p1 p p2 )
    (equal (distance p1 p2) (+ (distance p1 p) (distance p p2)) 1e-6)
  )

  (defun chkinters-p ( pl / r lil )
    (setq lil (mapcar (function list) pl (append (cdr pl) (list (car pl)))))
    (setq r
      (vl-some
        (function (lambda ( x )
          (vl-some
            (function (lambda ( y )
              (and
                (not (equal (car x) (car y) 1e-6))
                (not (equal (car x) (cadr y) 1e-6))
                (not (equal (cadr x) (car y) 1e-6))
                (not (equal (cadr x) (cadr y) 1e-6))
                (or
                  (inters (car x) (cadr x) (car y) (cadr y))
                  (collinear-p (car x) (car y) (cadr x))
                  (collinear-p (car x) (cadr y) (cadr x))
                  (collinear-p (car y) (car x) (cadr y))
                  (collinear-p (car y) (cadr x) (cadr y))
                )
              )
            ))
            (vl-remove x lil)
          )
        ))
        lil
      )
    )
    r
  )

  (defun chkinters ( pl / processlil done r lill ilil iip )
 
    (defun processlil ( ilil lil / pre mid suf ret )
      (setq pre (reverse (cdr (member (car ilil) (reverse lil)))))
      (setq mid (cdr (member (car ilil) lil)))
      (setq mid (cdr (member (cadr ilil) (reverse mid))))
      (setq mid (mapcar (function reverse) mid))
      (setq suf (cdr (member (cadr ilil) lil)))
      (setq ret (append pre (list (list (car (car ilil)) (car (cadr ilil)))) mid (list (list (cadr (car ilil)) (cadr (cadr ilil)))) suf))
      ret
    )
 
    (or lil (setq lil (mapcar (function list) pl (append (cdr pl) (list (car pl))))))
    (while (not done)
      (setq ilil (vl-some (function (lambda ( a ) (vl-some (function (lambda ( b / ip ) (progn (setq iip (inters (car a) (cadr a) (car b) (cadr b))) (if (and (not (equal (cadr a) (car b) 1e-6)) (not (equal (car a) (cadr b) 1e-6)) (not (or (and (collinear-p (car a) (car b) (cadr a)) (collinear-p (car a) (cadr b) (cadr a))) (and (collinear-p (car b) (car a) (cadr b)) (collinear-p (car b) (cadr a) (cadr b))))) (not (or (and (collinear-p (car a) (car b) (cadr a)) (collinear-p (car b) (cadr a) (cadr b))) (and (collinear-p (car b) (car a) (cadr b)) (collinear-p (car a) (cadr b) (cadr a)))))) (cond ( (collinear-p (car a) (car b) (cadr a)) (setq ip (car b)) ) ( (collinear-p (car a) (cadr b) (cadr a)) (setq ip (cadr b)) ) ( (collinear-p (car b) (car a) (cadr b)) (setq ip (car a)) ) ( (collinear-p (car b) (cadr a) (cadr b)) (setq ip (cadr a)) )) (setq iip nil)) (cond ( iip (list a b iip) ) ( ip (list a b ip) ))))) (vl-remove a lil)))) lil))
      (cond
        ( (and ilil (equal iip (caddr ilil) 1e-6))
          (setq lil (processlil ilil lil))
        )
        ( (and ilil (equal (caar ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (caar ilil) (caadr ilil) 1e-6)) (not (equal (caar ilil) (cadadr ilil) 1e-6)))
              (setq lil (processlil ilil lil))
            )
            ( (equal (caar ilil) (caadr ilil) 1e-6)
              (setq lil (processlil ilil lil))
            )
            ( (equal (caar ilil) (cadadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (cadar ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (cadar ilil) (caadr ilil) 1e-6)) (not (equal (cadar ilil) (cadadr ilil) 1e-6)))
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadar ilil) (caadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadar ilil) (cadadr ilil) 1e-6)
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (caadr ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (caadr ilil) (caar ilil) 1e-6)) (not (equal (caadr ilil) (cadar ilil) 1e-6)))
              (setq lil (processlil ilil lil))
            )
            ( (equal (caadr ilil) (caar ilil) 1e-6)
              (setq lil (processlil ilil lil))
            )
            ( (equal (caadr ilil) (cadar ilil) 1e-6)
              (setq ilil (subst (assoc (caadr ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( (and ilil (equal (cadadr ilil) (caddr ilil) 1e-6))
          (cond
            ( (and (not (equal (cadadr ilil) (caar ilil) 1e-6)) (not (equal (cadadr ilil) (cadar ilil) 1e-6)))
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadadr ilil) (caar ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq lil (processlil ilil lil))
            )
            ( (equal (cadadr ilil) (cadar ilil) 1e-6)
              (setq ilil (subst (assoc (cadadr ilil) lil) (cadr ilil) ilil))
              (setq ilil (subst (assoc (cadar ilil) lil) (car ilil) ilil))
              (setq lil (processlil ilil lil))
            )
          )
        )
        ( t (setq done t) )
      )
    )
    (setq r (mapcar (function car) lil))
    (setq lil nil)
    r
  )

  (defun grid ( l / ucsf a b bb d1 d2 a1 a2 e ll p pl an f )
    ;(setq l (vl-sort l (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (cadr a) (cadr b)) (< (car a) (car b)))))))
    (if (= 0 (getvar (quote worlducs)))
      (progn
        (if command-s
          (command-s "_.UCS" "_W")
          (vl-cmdf "_.UCS" "_W")
        )
        (setq ucsf t)
      )
    )
    (if command-s
      (command-s "_.UCS" "_3P" "_non" (car l) "_non" (cadr l) "_non" (polar (car l) (+ (angle (car l) (cadr l)) (* 0.5 pi)) 1.0))
      (vl-cmdf "_.UCS" "_3P" "_non" (car l) "_non" (cadr l) "_non" (polar (car l) (+ (angle (car l) (cadr l)) (* 0.5 pi)) 1.0))
    )
    (setq l (mapcar (function (lambda ( p ) (trans p 0 1))) l))
    (setq ll (last l))
    (setq an 0.0)
    (setq p  (car l)
          pl (list p)
          l  (cdr l)
    )
    (while l
      (setq l (vl-sort l (function (lambda ( a b ) (< (distance p a) (distance p b))))))
      (setq a1 (car l) a2 (cadr l))
      (setq d1 (distance p a1) d2 (if a2 (distance p a2)))
      (if (and d2 (equal d1 d2 1e-6))
        (if (and an (or (equal (angle p a1) an 1e-6) (equal (angle p a1) (rem (+ pi an) (+ pi pi)) 1e-6) (if (or (equal an 0.0 1e-6) (equal an (* 2 pi) 1e-6)) (equal (angle p a1) (* 2 pi) 1e-6))))
          (setq a a1)
          (setq a a2)
        )
        (setq a a1)
      )
      (if (and an (or (equal (angle p a) an 1e-6) (equal (angle p a) (rem (+ pi an) (+ pi pi)) 1e-6) (if (or (equal an 0.0 1e-6) (equal an (* 2 pi) 1e-6)) (equal (angle p a) (* 2 pi) 1e-6))))
        (setq bb a)
        (setq b a)
      )
      (if bb
        (setq b bb)
      )
      (cond
        ( (equal a1 ll 1e-6)
          (setq a a1 b a an (* 0.5 pi) f t)
        )
        ( (equal a2 ll 1e-6)
          (setq a a2 b a an (* 0.5 pi) f t)
        )
      )
      (setq pl (cons b pl)
            l  (vl-remove b l)
            p  b
            b  nil
            bb nil
      )
      (if f
        (cond
          ( (= an 0.0)
            (setq an (* 0.5 pi))
          )
          ( t
            (setq an 0.0)
          )
        )
        (cond
          ( (and (= an 0.0) (equal (car p) (car ll) 1e-6))
            (setq an (* 0.5 pi))
          )
          ( (and (= an (* 0.5 pi)) (equal (cadr p) (cadr ll) 1e-6))
            (setq an 0.0)
          )
          ( (and (= an (* 0.5 pi)) (equal (car p) (car ll) 1e-6))
            (setq an 0.0)
          )
          ( (and (= an 0.0) (equal (cadr p) (cadr ll) 1e-6))
            (setq an (* 0.5 pi))
          )
        )
      )
    )
    (setq pl (reverse pl))
    (setq e  nil
          l  pl
          ll l
    )
    (while (and (not e) ll)
      (setq e  t
            ll l
      )
      (while (and e ll)
        (setq ll (if (listp (caar ll))
                  ll
                  (mapcar (function list) (cons (last ll) ll) ll)
                 )
              a  (car ll)
              pl (vl-remove-if (function (lambda ( b ) (or (member (car a) b) (member (cadr a) b))))
                               (cdr ll)
                 )
              ll (cdr ll)
        )
        (while (and pl (setq b (car pl)) (not (inters (car a) (cadr a) (car b) (cadr b))))
          (setq pl (cdr pl))
        )
        (if pl
          (progn (setq l (append (member (car a) l) (reverse (cdr (member (car a) (reverse l))))) ;;; [(car a) (cadr a) ... ->end] + ((car b) (cadr b)) - in middle of concatenated l + [start ... ->] ... (car a) - don't exist - it was (cdr-ed) 
                       l (append (list (car a)) (member (car b) (reverse (cdr l))) (member (cadr b) l)) ;;; [(car a)] + [(car b) + end<- ... (cadr a)] + [(cadr b) + start ... ->]
                       e nil
                 )
          )
        )
      )
    )
    (setq l (mapcar (function (lambda ( p ) (trans p 1 0))) l))
    (if command-s
      (command-s "_.UCS" "_P")
      (vl-cmdf "_.UCS" "_P")
    )
    (if ucsf
      (if command-s
        (command-s "_.UCS" "_P")
        (vl-cmdf "_.UCS" "_P")
      )
    )
    l
  )

  (defun makelw ( lst )
    (entmake
      (append
        (list
          (cons 0 "LWPOLYLINE")
          (cons 100 "AcDbEntity")
          (cons 100 "AcDbPolyline")
          (cons 90 (length lst))
          (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
          (cons 38 0.0)
        )
        (mapcar (function (lambda ( p ) (cons 10 p))) lst)
        (list (list 210 0.0 0.0 1.0))
      )
    )
  )

  (defun car-sort ( lst cmp / rtn )
    (setq rtn (car lst))
    (if (cdr lst)
      (foreach itm (cdr lst)
        (if (apply cmp (list itm rtn))
          (setq rtn itm)
        )
      )
    )
    rtn
  )

  ;; Convex Hull  -  Lee Mac
  ;; Implements the Graham Scan Algorithm to return the Convex Hull of a list of points.
  ;; Mod. by M.R.  -  uses (car-sort) sub...

  (defun MR:ConvexHull-ptsonHull ( lst / ch p0 lstl )
    (cond
      ( (< (length lst) 4) (vl-sort lst (function (lambda ( a b ) (if (= (cadr a) (cadr b)) (< (car a) (car b)) (< (cadr a) (cadr b)))))) )
      ( (setq p0 (car lst))
        (foreach p1 (cdr lst)
          (if (or (< (cadr p1) (cadr p0)) (and (= (cadr p1) (cadr p0)) (< (car p1) (car p0))))
            (setq p0 p1)
          )
        )
        (setq lst (vl-remove p0 lst))
        (setq lst (append (list p0) lst))
        (setq lst
          (vl-sort lst
            (function
              (lambda ( a b / c d )
                (if (or (equal (setq c (angle p0 a)) (setq d (angle p0 b)) 1e-6) (and (or (equal c 0.0 1e-6) (equal c (* 2 pi) 1e-6)) (or (equal d 0.0 1e-6) (equal d (* 2 pi) 1e-6))))
                  (< (distance (list (car p0) (cadr p0)) a) (distance (list (car p0) (cadr p0)) b))
                  (< c d)
                )
              )
            )
          )
        )
        (setq lstl (vl-remove-if-not (function (lambda ( x ) (equal (angle p0 (last lst)) (angle p0 x) 1e-6))) lst))
        (setq lst (vl-remove-if (function (lambda ( x ) (equal (angle p0 (last lst)) (angle p0 x) 1e-6))) lst))
        (setq lstl (vl-sort lstl (function (lambda ( a b ) (> (distance (list (car p0) (cadr p0)) a) (distance (list (car p0) (cadr p0)) b))))))
        (setq lst (append lst lstl))
        (setq ch (list (cadr lst) (car lst)))
        (foreach pt (cddr lst)
          (if (equal pt (last lst))
            (setq ch (cons pt ch))
            (if (or (equal (angle (car ch) pt) (car-sort (mapcar (function (lambda ( x ) (angle (car ch) x))) (member pt lst)) (function <)) 1e-6) (equal (distance pt (cadr ch)) (+ (distance pt (car ch)) (distance (car ch) (cadr ch))) 1e-6))
              (setq ch (cons pt ch))
            )
          )
        )
        (reverse ch)
      )
    )
  )

  (defun tsp-rnd1 ( pl / pllen lst lstt p dl d )

    (defun pllen ( lst )
      (apply (function +) (mapcar (function distance) lst (append (cdr lst) (list (car lst)))))
    )

    (setq lstt (MR:ConvexHull-ptsonHull pl))
    (if (setq lst (vl-remove-if (function (lambda ( x ) (vl-position x lstt))) pl))
      (while lst
        (foreach edg (mapcar (function list) lstt (append (cdr lstt) (list (car lstt))))
          (setq p (car-sort lst (function (lambda ( a b ) (< (pllen (append (reverse (member (car edg) (reverse lstt))) (list a) (member (cadr edg) lstt))) (pllen (append (reverse (member (car edg) (reverse lstt))) (list b) (member (cadr edg) lstt))))))))
          (setq dl (cons (list p edg (pllen (append (reverse (member (car edg) (reverse lstt))) (list p) (member (cadr edg) lstt)))) dl))
        )
        (setq d (car-sort dl (function (lambda ( a b ) (< (caddr a) (caddr b))))))
        (setq dl nil)
        (setq lst (vl-remove (car d) lst))
        (setq lstt (append (reverse (member (caadr d) (reverse lstt))) (list (car d)) (member (cadadr d) lstt)))
      )
    )
    lstt
  )

  (defun processEE1 ( plst ll / ent ls lsx a p e pl )
    (setq ent (entmakex (append (list (cons 0 "LWPOLYLINE")
                                      (cons 100 "AcDbEntity")
                                      (cons 100 "AcDbPolyline")
                                      (cons 90 (length ll))
                                      (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                                )
                                (mapcar (function (lambda ( a ) (cons 10 a))) ll)
                                (list (list 210 0.0 0.0 1.0))
                        )
              )
    )
    (setq ls plst)
    (foreach a ll (setq ls (vl-remove a ls)))
    (repeat (length ls)
      (setq lsx (mapcar (function (lambda ( a / b c d )
                                    (cons (distance a (setq b (vlax-curve-getClosestPointTo ent a)))
                                          (cons
                                                (list (setq c (vlax-curve-getPointAtParam ent (fix (vlax-curve-getParamAtPoint ent b))))
                                                      (setq d (vlax-curve-getPointAtParam ent (1+ (fix (vlax-curve-getParamAtPoint ent b)))))
                                                      (- (+ (distance c a) (distance d a)) (distance c d))
                                                )
                                                a
                                          )
                                    )
                                  )
                        ) ls
                )
      )
      (setq a (car-sort lsx (function (lambda ( a b ) (< (caddr (cadr a)) (caddr (cadr b)))))))
      (setq a (cddr a))
      (setq ls (vl-remove a ls))
      (setq p (vlax-curve-getParamAtPoint ent (vlax-curve-getClosestPointTo ent a))
            p (if (= p (fix p))
                (if (zerop p)
                  (vlax-curve-getEndParam ent)
                  (1- p)
                )
                (fix p)
              )
            p (vlax-curve-getPointAtParam ent p)
            p (list 10 (car p) (cadr p))
      )
      (if (not e)
        (setq e (entget ent))
      )
      (entupd (cdr (assoc -1 (entmod (setq e (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 e)))) (assoc 90 e) e))))
                                                     (list (cons 10 a))
                                                     (cdr (member p e))
                                             )
                                     )
                             )
                   )
              )
      )
    )
    (foreach a plst (setq ll (vl-remove a ll)))
    (setq e (entget ent))
    (entupd (cdr (assoc -1 (entmod (setq e (vl-remove-if (function (lambda ( a ) (vl-position (cdr a) ll))) (subst (cons 90 (length plst)) (assoc 90 e) e)))))))
    (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) e)))
    (entdel (entlast))
    pl
  )

  (defun processEE2 ( plst ll / ent ls lsx a p e pl )
    (setq ent (entmakex (append (list (cons 0 "LWPOLYLINE")
                                      (cons 100 "AcDbEntity")
                                      (cons 100 "AcDbPolyline")
                                      (cons 90 (length ll))
                                      (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                                )
                                (mapcar (function (lambda ( a ) (cons 10 a))) ll)
                                (list (list 210 0.0 0.0 1.0))
                        )
              )
    )
    (setq ls plst)
    (foreach a ll (setq ls (vl-remove a ls)))
    (repeat (length ls)
      (setq lsx (mapcar (function (lambda ( a / b )
                                    (cons (distance a (setq b (vlax-curve-getClosestPointTo ent a)))
                                          a
                                    )
                                  )
                        ) ls
                )
      )
      (setq a (car-sort lsx (function (lambda ( a b ) (< (car a) (car b))))))
      (setq a (cdr a))
      (setq ls (vl-remove a ls))
      (setq p (vlax-curve-getParamAtPoint ent (vlax-curve-getClosestPointTo ent a))
            p (if (= p (fix p))
                (if (zerop p)
                  (vlax-curve-getEndParam ent)
                  (1- p)
                )
                (fix p)
              )
            p (vlax-curve-getPointAtParam ent p)
            p (list 10 (car p) (cadr p))
      )
      (if (not e)
        (setq e (entget ent))
      )
      (entupd (cdr (assoc -1 (entmod (setq e (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 e)))) (assoc 90 e) e))))
                                                     (list (cons 10 a))
                                                     (cdr (member p e))
                                             )
                                     )
                             )
                   )
              )
      )
    )
    (foreach a plst (setq ll (vl-remove a ll)))
    (setq e (entget ent))
    (entupd (cdr (assoc -1 (entmod (setq e (vl-remove-if (function (lambda ( a ) (vl-position (cdr a) ll))) (subst (cons 90 (length plst)) (assoc 90 e) e)))))))
    (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) e)))
    (entdel (entlast))
    pl
  )

  (defun tsp-rnd2 ( plst / ll )
    (processEE1 plst (setq ll (MR:ConvexHull-ptsonHull plst)))
  )

  (defun tsp-rnd3 ( plst / ll )
    (processEE1 plst (setq ll (reverse (MR:ConvexHull-ptsonHull plst))))
  )

  (defun tsp-rnd4 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caadr ll) (cadar ll)) (cadr ll) (list (caar ll) (cadadr ll)))
    )
    (processEE1 plst ll)
  )

  (defun tsp-rnd5 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caar ll) (cadadr ll)) (cadr ll) (list (caadr ll) (cadar ll)))
    )
    (processEE1 plst ll)
  )

  (defun tsp-rnd6 ( plst / ll )
    (processEE2 plst (setq ll (MR:ConvexHull-ptsonHull plst)))
  )

  (defun tsp-rnd7 ( plst / ll )
    (processEE2 plst (setq ll (reverse (MR:ConvexHull-ptsonHull plst))))
  )

  (defun tsp-rnd8 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caadr ll) (cadar ll)) (cadr ll) (list (caar ll) (cadadr ll)))
    )
    (processEE2 plst ll)
  )

  (defun tsp-rnd9 ( plst / ll )
    (setq ll  (list (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <)))
                    (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >)))
              )
          ll  (list (car ll) (list (caar ll) (cadadr ll)) (cadr ll) (list (caadr ll) (cadar ll)))
    )
    (processEE2 plst ll)
  )

  (defun processLM ( lst lw / SubLst remove_nth
                              i x y tmp nlst par ptlst lwx rr nlst nlen )

    (defun SubLst ( lst i j / k )
      (setq k -1)
      (or j (setq j (length lst)))
      (vl-remove-if-not
        (function
          (lambda ( x )
            (<= i (setq k (1+ k)) (+ i (1- j)))
          )
        ) lst
      )
    )

    (defun remove_nth ( k lst / j )
      (setq j -1)
      (vl-remove-if
        (function
          (lambda ( x )
            (= k (setq j (1+ j)))
          )
        ) lst
      )
    )

    (setq lst 
      (vl-sort lst
        (function
          (lambda ( a b ) (< (distance (vlax-curve-getClosestPointto lw a) a)
                             (distance (vlax-curve-getClosestPointto lw b) b)
                          )
          )
        )
      )
    )
    (setq nlst lst)
    (while (setq x (car nLst))
      (setq nLst (cdr nLst) par (fix (vlax-curve-getParamatPoint lw (vlax-curve-getClosestPointto lw x))))
      (setq ptlst (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq lwx (entget lw)))))
      (setq ptlst (append (SubLst ptlst 0 (1+ par)) (list x)
                          (SubLst ptlst   (1+ par) nil)
                  )
      )
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    )
    (setq ptlst
      (vl-remove-if-not
        (function
          (lambda ( x ) (vl-position x lst))
        ) ptlst
      )
    )
    (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    (setq i -1)
    (repeat (length ptlst)
      (setq x (nth (setq i (1+ i)) ptlst))
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length (setq rr (Remove_nth i ptlst)))) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) rr) (list (list 210 0.0 0.0 1.0))))))))
      (setq par (fix (vlax-curve-getParamatPoint lw (vlax-curve-getClosestPointto lw x))))
      (setq ptlst (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq lwx (entget lw)))))
      (setq ptlst (append (SubLst ptlst 0 (1+ par)) (list x)
                          (SubLst ptlst   (1+ par) nil)
                  )
      )
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    )
    (setq i -1)
    (repeat (- (length ptlst) 1)
      (setq x (nth (setq i (1+ i)) ptlst) y (nth (1+ i) ptlst))
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
      (setq len (apply (function +) (mapcar (function distance) ptlst (append (cdr ptlst) (list (car ptlst))))))
      (setq nlst (append (SubLst ptlst 0 i) (list y x)
                         (Sublst ptlst (+ i 2) nil)
                 )
      )
      (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length nlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) nlst) (list (list 210 0.0 0.0 1.0))))))))
      (if (< (setq nlen (apply (function +) (mapcar (function distance) nlst (append (cdr nlst) (list (car nlst)))))) len)
        (setq ptlst nlst len nlen)
      )
    )
    (entupd (cdr (assoc -1 (setq lwx (entmod (append (subst (cons 90 (length ptlst)) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))) (mapcar (function (lambda ( x ) (cons 10 x))) ptlst) (list (list 210 0.0 0.0 1.0))))))))
    (entdel (entlast))
    ptlst
  )

  (defun tsp-rnd10 ( plst / mklw miP maP lw )

    (defun mklw ( l )
      (entmakex (append (list (cons 0   "LWPOLYLINE")
                              (cons 100 "AcDbEntity")
                              (cons 100 "AcDbPolyline")
                              (cons 90 (length l))
                              (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                        )
                        (mapcar (function (lambda ( a ) (cons 10 a))) l)
                        (list (list 210 0.0 0.0 1.0))
                )
      )
    )

    (setq miP (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <))))
    (setq maP (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >))))
    (setq lw (mklw (list miP (list (car miP) (cadr maP)) maP (list (car maP) (cadr miP)))))
    (processLM plst lw)
  )

  (defun tsp-rnd11 ( plst / mklw miP maP lw )

    (defun mklw ( l )
      (entmakex (append (list (cons 0   "LWPOLYLINE")
                              (cons 100 "AcDbEntity")
                              (cons 100 "AcDbPolyline")
                              (cons 90 (length l))
                              (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                        )
                        (mapcar (function (lambda ( a ) (cons 10 a))) l)
                        (list (list 210 0.0 0.0 1.0))
                )
      )
    )

    (setq miP (list (car-sort (mapcar (function car) plst) (function <)) (car-sort (mapcar (function cadr) plst) (function <))))
    (setq maP (list (car-sort (mapcar (function car) plst) (function >)) (car-sort (mapcar (function cadr) plst) (function >))))
    (setq lw (mklw (list miP (list (car miP) (cadr maP)) maP (list (car maP) (cadr miP)))))
    (processLM plst lw)
  )

  (defun AHS:TSP ( pl / AHS:mainprocess AHS:subprocess1 AHS:subprocess2 k li1 li2 lii )

    (defun AHS:mainprocess ( li1 li2 )
      (foreach po li2
        (setq lii (append lii (AHS:subprocess1 po li1)))
      )
      (setq li1 (AHS:subprocess2 li1 lii))
    )

    (defun AHS:subprocess1 ( po li1 / k n po1 po2 lii )
      (setq k 0)
      (repeat (setq n (length li1))
        (setq po1 (nth k li1))
        (if (= k (1- n))
          (setq po2 (nth 0 li1))
          (setq po2 (nth (1+ k) li1))
        )
        (setq lii (append lii (list (list po1 po po2))))
        (setq k (1+ k))
      )
      lii
    )

    (defun AHS:subprocess2 ( li1 lii / n dili dimin k i a po li3 )
      (setq n (length li1))
      (setq dili (mapcar (function (lambda ( a ) (- (+ (distance (car a) (cadr a)) (distance (cadr a) (caddr a))) (distance (car a) (caddr a))))) lii))
      (setq dimin (car-sort dili (function <)))
      (setq k 0)
      (while (and (not i) (< k (length dili)))
        (if (equal dimin (nth k dili) 1e-6)
          (setq i k)
        )
        (setq k (1+ k))
      )
      (setq a (nth i lii) po (cadr a))
      (if (equal (car a) (last li1) 1e-6)
        (setq li1 (cons po li1))
        (progn
          (setq k 0)
          (while (< k n)
            (if (equal (nth k li1) (car a) 1e-6)
              (setq li3 (cons (nth k li1) li3) li3 (cons po li3))
              (setq li3 (cons (nth k li1) li3))
            )
            (setq k (1+ k))
          )
          (setq li1 (reverse li3))
        )
      )
      (if (or (equal (car a) (cadr a) 1e-6) (equal (cadr a) (caddr a) 1e-6) (equal (car a) (caddr a) 1e-6))
        (progn
          (prompt "\nDuplicate points detected... Quitting...") (exit)
        )
      )
      li1
    )

    (setq k 0)
    (foreach po (setq pl (vl-sort pl (function (lambda ( a b ) (if (equal (cadr a) (cadr b) 1e-6) (< (car a) (car b)) (< (cadr a) (cadr b)))))))
      (setq k (1+ k))
      (if (< k 4)
        (setq li1 (append li1 (list po)))
        (setq li2 (append li2 (list po)))
      )
    )
    (if (> k 3)
      (progn
        (while (cadr li2)
          (setq lii nil)
          (setq li1 (AHS:mainprocess li1 li2))
          (setq li2 (vl-remove-if (function (lambda ( p1 ) (vl-some (function (lambda ( p2 ) (equal p1 p2 1e-6))) li1))) pl))
        )
        (setq lii nil)
        (setq lii (AHS:subprocess1 (car li2) li1))
        (setq li1 (AHS:subprocess2 li1 lii))
      )
    )
    li1
  )

  (defun tsp-all ( pl n flag / fooo TSP chlh_jd-process permutate rotatelst get-closedpolygon-length trimlst ncdrlst get-closest-i f1 ins-lst ch-para-lst get-minadddist-i foo mindist-eea-MR unique process1 process2 process3 foo1 foo2 foo3 foo4 foo5 processfoos genetic1 genetic2 greedy grid generic makelw main ss i pl plst inpl chulls lst out r1 r2 r3 r4 r5 r6 r7 r8 r9 r11 r12 r21 r22 r31 r32 r41 r42 r51 r52 r61 r62 d11 d12 d21 d22 d31 d32 d41 d42 d51 d52 d61 d62 rr r d )

    (defun fooo ( l n / l1 l2 ll b d d1 f ff fff ffff loop )
      (setq loop t)
      (setq ffff (cons t ffff))
      (while loop
        (setq b (trimlst l n))
        (setq d (get-closedpolygon-length l))
        (setq ll l)
        (setq fff (cons nil fff))
        (foreach bb (permutate b)
          (setq l1 ll)
          (repeat n
            (setq l1 (cdr l1))
          )
          (setq l2 (append bb l1))
          (foreach x bb
            (setq l1 (f1 x l1))
          )
          (if (and (> d (setq d1 (get-closedpolygon-length l1))) (not (equal d d1 1e-6)))
            (setq d d1
                  l l1
                  f t
            )
            (if (<= d d1)
              (setq f nil)
            )
          )
          (if (and (> d (setq d1 (get-closedpolygon-length l2))) (not (equal d d1 1e-6)))
            (setq d d1
                  l l2
                  ff t
            )
            (if (<= d d1)
              (setq ff nil)
            )
          )
          (if (or f ff)
            (setq fff (cons t fff))
          )
        )
        (if (apply (function or) fff)
          (setq ffff (cons t ffff))
          (setq ffff (cons nil ffff))
        )
        (setq fff nil)
        (setq l (append (cdr l) (list (car l))))
        (if (and (>= (length ffff) (length l)) (null (vl-remove nil (trimlst ffff (length l)))))
          (setq loop nil)
        )
      )
      l
    )

    (defun TSP ( lst out n / plst l p m d dd nn )
      (while out
        (setq l (mapcar (function list) lst (append (cdr lst) (list (car lst)))))
        (setq p (car-sort out (function (lambda ( a b ) (< (apply (function min) (mapcar (function (lambda ( x ) (- (+ (distance (car x) a) (distance (cadr x) a)) (distance (car x) (cadr x))))) l)) (apply (function min) (mapcar (function (lambda ( x ) (- (+ (distance (car x) b) (distance (cadr x) b)) (distance (car x) (cadr x))))) l)))))))
        (setq out (vl-remove p out))
        (setq m (get-minadddist-i lst p))
        (setq lst (ins-lst p m lst))
      )
      (setq dd 1e+99 nn 0)
      (repeat (1- (length lst))
        (setq lstt (foo lst (setq nn (1+ nn))))
        (if (chkinters-p lstt)
          (setq lstt (chkinters lstt))
        )
        (setq d (get-closedpolygon-length lstt))
        (if (< d dd)
          (setq dd d plst lstt)
        )
      )
      ;(setq plst (chlh_jd-process plst n))
      (setq plst (fooo plst n))
      (if (chkinters-p plst)
        (setq plst (chkinters plst))
      )
      plst
    )

    (defun chlh_jd-process ( lst n / m l ll d0 d1 l1 i )
      (setq d0 (get-closedpolygon-length lst))
      (setq i 0 l lst)
      (if (/= n 1)
        (while (/= i (length lst))
          (setq ll (trimlst l n))
          (setq m (permutate ll))
          (setq l1
            (car-sort
              (mapcar
                (function
                  (lambda ( x )
                    (ch-para-lst x l)
                  )
                )
                m
              )
              (function
                (lambda ( e1 e2 )
                  (< (get-closedpolygon-length e1)
                     (get-closedpolygon-length e2)
                  )
                )
              )
            )
          )
          (setq d1 (get-closedpolygon-length l1))
          (if (< d1 d0)
            (setq d0  d1
                  lst l1
                  l   l1
            )
          )
          (setq l (rotatelst l))
          (setq i (1+ i))
        )
      )
      lst
    )

    (defun permutate ( l / al ll )
      (cond
        ( (null l)
          nil
        )
        ( (= (length l) 1)
          (list l)
        )
        ( (> (length l) 1)
          (apply (function append) (mapcar (function (lambda ( x ) (setq al (cons x al) ll (if (null ll) (cdr l) (cdr ll))) (mapcar (function (lambda ( y ) (cons x y))) (permutate (append (reverse (cdr al)) ll))))) l))
        )
      )
    )

    (defun rotatelst ( l )
      (append (cdr l) (list (car l)))
    )

    (defun get-closedpolygon-length ( l )
      (apply (function +) (mapcar (function distance) l (append (cdr l) (list (car l)))))
    )

    (defun trimlst ( lst n / l )
      (repeat n
        (setq l (cons (car lst) l))
        (setq lst (cdr lst))
      )
      (reverse l)
    )

    (defun ncdrlst ( lst n )
      (repeat n
        (setq lst (cdr lst))
      )
      lst
    )
  ;|
    (defun get-closest-i ( lst p )
      (car
        (vl-sort-i
          (mapcar
            (function
              (lambda ( p1 p2 / pt d d1 d2 )
                (setq pt (inters p (polar p (+ (/ pi 2.0) (angle p1 p2)) 1.0) p1 p2 nil)
                      d  (distance p1 p2)
                      d1 (distance p p1)
                      d2 (distance p p2)
                )
                (if (equal (+ (distance pt p1) (distance pt p2)) d 1e-8)
                  (distance p pt)
                  d1
                )
              )
            )
            lst
            (append (cdr lst) (list (car lst)))
          )
          (function <)
        )
      )
    )
  |;
    (defun f1 ( a l )
      (ins-lst a (get-minadddist-i l a) l)
    )

    (defun ins-lst ( new i lst )
      (append (reverse (member (nth i lst) (reverse lst))) (list new) (cdr (member (nth i lst) lst)))
    )

    (defun ch-para-lst ( para lst / n )
      (setq n (length para))
      (append para (ncdrlst lst n))
    )

    (defun get-minadddist-i ( lst p / dl )
      (vl-position
        (car-sort
          (setq dl
            (mapcar
              (function
                (lambda ( p1 p2 )
                  (- (+ (distance p p1) (distance p p2)) (distance p1 p2))
                )
              )
              lst
              (append (cdr lst) (list (car lst)))
            )
          )
          (function <)
        )
        dl
      )
    )

    (defun foo ( l n / d d0 d1 )
      (setq l0 (mapcar (function list) l (append (member (nth n l) l) (reverse (cdr (member (nth n l) (reverse l)))))))
      (setq d0 (get-closedpolygon-length l))
      (while
        (> d0
          (progn
            (foreach a l0
              (setq d (get-closedpolygon-length l))
              (setq l1 (vl-remove (car a) (vl-remove (cadr a) l)))
              (setq l1 (f1 (car a) l1))
              (setq l1 (f1 (cadr a) l1))
              (if (> d (setq d1 (get-closedpolygon-length l1)))
                (setq d d1
                      l l1
                )
              )
              (setq l1 (vl-remove (car a) (vl-remove (cadr a) l)))
              (setq l1 (f1 (cadr a) l1))
              (setq l1 (f1 (car a) l1))
              (if (> d (setq d1 (get-closedpolygon-length l1)))
                (setq d d1
                      l l1
                )
              )
            )
            d
          )
        )
        (setq d0 d)
      )   
      (setq d (get-closedpolygon-length l))   
      l
    )

    (defun mindist-eea-MR ( l / f d q )

      (defun f ( p l / di )
        (while l
          (if (equal p (car l) (+ d 1e-8))
            (cond ((= (setq di (distance p (car l))) d) (setq q (list p (car l))))
                  ((< di d)
                   (setq d di
                         q (list p (car l))
                   )
                  )
            )
          )
          (setq l (cdr l))
        )
      )

      (setq d (distance (car l) (cadr l)))
      (foreach a l
        (f a (cdr l))
        (setq l (cdr l))
      )
      q
    )

    (defun unique ( l / a ll )
      (while (setq a (car l))
        (if (vl-some (function (lambda ( x ) (equal x a 1e-6))) (cdr l))
          (setq ll (cons a ll) l (vl-remove-if (function (lambda ( x ) (equal x a 1e-6))) (cdr l)))
          (setq ll (cons a ll) l (cdr l))
        )
      )
      (reverse ll)
    )

    (defun process1 ( lst out / dd edgs edges edgesn1 edgesn2 lstt1 lstt2 lstt d r dd1 dd2 rr1 rr2 )
      (setq dd 1e+99)
      (foreach pedge (setq edgs (mapcar (function list) lst (append (cdr lst) (list (car lst)))))
        (foreach ppedge (setq edges (mapcar (function list) out (append (cdr out) (list (car out)))))
          (setq edgesn1 (subst pedge ppedge edges))
          (setq edgesn2 (subst (reverse pedge) ppedge edges))
          (setq edgesn1 (apply (function append) (mapcar (function (lambda ( x y ) (if (not (equal (cadr x) (car y) 1e-6)) (list x (list (cadr x) (car y))) (list x)))) edgesn1 (append (cdr edgesn1) (list (car edgesn1))))))
          (setq edgesn2 (apply (function append) (mapcar (function (lambda ( x y ) (if (not (equal (cadr x) (car y) 1e-6)) (list x (list (cadr x) (car y))) (list x)))) edgesn2 (append (cdr edgesn2) (list (car edgesn2))))))
          (if (and (or (cdr (member pedge edgs)) (cdr (member pedge (reverse edgs)))) (or (cdr (member pedge (reverse edgs))) (cdr (member pedge edgs))))
            (progn
              (setq edgesn1 (apply (function append) (mapcar (function (lambda ( x ) (if (equal x pedge 1e-6) (mapcar (function reverse) (append (cdr (member pedge edgs)) (cdr (member pedge (reverse edgs))))) (list x)))) edgesn1)))
              (setq edgesn2 (apply (function append) (mapcar (function (lambda ( x ) (if (equal x (reverse pedge) 1e-6) (append (cdr (member pedge (reverse edgs))) (cdr (member pedge edgs))) (list x)))) edgesn2)))
              (setq lstt1 (mapcar (function car) edgesn1))
              (setq lstt2 (mapcar (function car) edgesn2))
              (if (< (get-closedpolygon-length lstt1) (get-closedpolygon-length lstt2))
                (setq lstt lstt1)
                (setq lstt lstt2)
              )
              (if (< (setq d (get-closedpolygon-length lstt)) dd)
                (setq r lstt dd d)
              )
            )
          )
        )
      )
      (if r
        (progn
          (setq dd1 (get-closedpolygon-length r) rr1 (unique r))
          (setq r (reverse r))
          (setq dd2 (get-closedpolygon-length r) rr2 (unique r))
          (if (< dd1 dd2)
            (setq r rr1)
            (setq r rr2)
          )
        )
      )
      r
    )

    (defun process2 ( lst out / q qq edgs qqq inpl singles xxx aaa ggg bbb gqqq dd edges edgesn1 edgesn2 lstt1 lstt2 lstt d r lil li dd1 dd2 rr1 rr2 )
      (setq q (MR:ConvexHull-ptsonHull lst))
      (setq qq (mapcar (function list) q (append (cdr q) (list (car q)))))
      (setq qqq (vl-remove-if (function (lambda ( x ) (or (vl-position x qq) (vl-position (reverse x) qq)))) (setq edgs (mapcar (function list) lst (append (cdr lst) (list (car lst)))))))
      (setq inpl (vl-remove-if (function (lambda ( x ) (vl-position x (apply (function append) qqq)))) q))
      (setq singles (vl-remove-if-not (function (lambda ( x ) (= (length (vl-remove-if (function (lambda ( y ) (equal x y 1e-6))) (apply (function append) qqq))) (1- (length (apply (function append) qqq)))))) (apply (function append) qqq)))
      (foreach x singles
        (setq xxx x)
        (if (setq aaa (vl-some (function (lambda ( y ) (if (vl-position x y) y))) qqq))
          (progn
            (setq ggg (cons aaa ggg))
            (while (setq bbb (vl-some (function (lambda ( y ) (if (vl-position (setq xxx (car (vl-remove xxx aaa))) y) y))) (setq qqq (vl-remove aaa qqq))))
              (setq ggg (cons bbb ggg))
              (setq aaa bbb)
            )
            (setq gqqq (cons (reverse ggg) gqqq))
            (setq ggg nil)
          )
        )
      )
      (setq gqqq (reverse gqqq))
      (setq outlst out)
      (if gqqq
        (repeat (length gqqq)
          (setq dd 1e+99)
          (foreach g gqqq
            (foreach ppedge (setq edges (mapcar (function list) outlst (append (cdr outlst) (list (car outlst)))))
              (setq edgesn1 (append (reverse (cdr (member ppedge (reverse edges)))) g (cdr (member ppedge edges))))
              (setq edgesn2 (append (reverse (cdr (member ppedge (reverse edges)))) (reverse (mapcar (function reverse) g)) (cdr (member ppedge edges))))
              (setq edgesn1 (apply (function append) (mapcar (function (lambda ( x y ) (if (not (equal (cadr x) (car y) 1e-6)) (list x (list (cadr x) (car y))) (list x)))) edgesn1 (append (cdr edgesn1) (list (car edgesn1))))))
              (setq edgesn2 (apply (function append) (mapcar (function (lambda ( x y ) (if (not (equal (cadr x) (car y) 1e-6)) (list x (list (cadr x) (car y))) (list x)))) edgesn2 (append (cdr edgesn2) (list (car edgesn2))))))
              (setq lstt1 (mapcar (function car) edgesn1))
              (setq lstt2 (mapcar (function car) edgesn2))
              (if (< (get-closedpolygon-length lstt1) (get-closedpolygon-length lstt2))
                (setq lstt lstt1)
                (setq lstt lstt2)
              )
              (if (< (setq d (get-closedpolygon-length lstt)) dd)
                (setq r lstt dd d)
              )
            )
          )
          (setq outlst r)
          (setq gqqq (vl-remove-if-not (function (lambda ( x ) (vl-some (function (lambda ( y ) (not (vl-position y r)))) (apply (function append) x)))) gqqq))
        )
      )
      (foreach pp inpl
        (if (null lil)
          (setq lil (mapcar (function list) outlst (append (cdr outlst) (list (car outlst)))))
        )
        (setq li (car-sort lil (function (lambda ( a b ) (< (- (+ (distance (car a) pp) (distance pp (cadr a))) (distance (car a) (cadr a))) (- (+ (distance (car b) pp) (distance pp (cadr b))) (distance (car b) (cadr b))))))))
        (setq lil (apply (function append) (mapcar (function (lambda ( x ) (if (equal x li 1e-6) (list (list (car li) pp) (list pp (cadr li))) (list x)))) lil)))
      )
      (if inpl
        (setq r (mapcar (function car) lil))
      )
      (if r
        (progn
          (setq dd1 (get-closedpolygon-length r) rr1 (unique r))
          (setq r (reverse r))
          (setq dd2 (get-closedpolygon-length r) rr2 (unique r))
          (if (< dd1 dd2)
            (setq r rr1)
            (setq r rr2)
          )
        )
      )
      r
    )

    (defun process3 ( lst out / lil li r dd1 dd2 rr1 rr2 )
      (foreach pp lst
        (if (null lil)
          (setq lil (mapcar (function list) out (append (cdr out) (list (car out)))))
        )
        (setq li (car-sort lil (function (lambda ( a b ) (< (- (+ (distance (car a) pp) (distance pp (cadr a))) (distance (car a) (cadr a))) (- (+ (distance (car b) pp) (distance pp (cadr b))) (distance (car b) (cadr b))))))))
        (setq lil (apply (function append) (mapcar (function (lambda ( x ) (if (equal x li 1e-6) (list (list (car li) pp) (list pp (cadr li))) (list x)))) lil)))
      )
      (setq r (mapcar (function car) lil))
      (if r
        (progn
          (setq dd1 (get-closedpolygon-length r) rr1 (unique r))
          (setq r (reverse r))
          (setq dd2 (get-closedpolygon-length r) rr2 (unique r))
          (if (< dd1 dd2)
            (setq r rr1)
            (setq r rr2)
          )
        )
      )
      r
    )

    (defun foo1 ( plst / l )
      (setq l plst)
      (while (and (null xxx1) (vl-some (function (lambda ( a b / l1 l2 c ) (setq l1 l c (vl-some (function (lambda ( x ) (if (< (distance a x) (distance a b)) x))) (vl-remove a (vl-remove b l)))) (if c (setq l2 (append (reverse (member a (reverse (vl-remove c l)))) (list c) (if (/= (vl-position a l) (1- (length l))) (member b (vl-remove c l))))) (setq l2 nil)) (if (and l2 (or (< (length (unique l2)) (length l2)) (< (length l2) (length l1)))) (setq xxx1 (list l1 l2 c (list a b)))) (if (and l2 (not (chkinters-p l2)) (> (get-closedpolygon-length l1) (get-closedpolygon-length l2))) (setq l l2) (if l2 (progn (setq l (append (cdr l) (list (car l)))) nil))))) l (append (cdr l) (list (car l))))))
      l
    )

    (defun foo2 ( plst / l )
      (setq l plst)
      (while (and (null xxx2) (vl-some (function (lambda ( a b / l1 l2 c d e ) (setq l1 l c (vl-some (function (lambda ( x ) (if (< (- (+ (distance a x) (distance x b)) (distance a b)) (- (+ (distance (setq d (if (= (vl-position x l) 0) (last l) (nth (1- (vl-position x l)) l))) x) (distance x (setq e (if (= (vl-position x l) (1- (length l))) (car l) (nth (1+ (vl-position x l)) l))))) (distance d e))) x))) (vl-remove a (vl-remove b l)))) (if c (setq l2 (append (reverse (member a (reverse (vl-remove c l)))) (list c) (if (/= (vl-position a l) (1- (length l))) (vl-remove c (member b l))))) (setq l2 nil)) (if (and l2 (or (< (length (unique l2)) (length l2)) (< (length l2) (length l1)))) (setq xxx2 (list l1 l2 c d e (list a b)))) (if (and l2 (not (chkinters-p l2)) (> (get-closedpolygon-length l1) (get-closedpolygon-length l2))) (setq l l2) (if l2 (progn (setq l (append (cdr l) (list (car l)))) nil))))) l (append (cdr l) (list (car l))))))
      l
    )

    (defun foo3 ( plst / l )
      (setq l plst)
      (while (and (null xxx3) (vl-some (function (lambda ( a b c / l1 l2 ) (setq l1 l l2 (append (cond ( (= (vl-position a l) (- (length l) 2)) (cdr (reverse (member (cdr (reverse l))))) ) ( (= (vl-position a l) (1- (length l))) (cddr l) ) ( t (reverse (member a (reverse l))) )) (list c b) (cdddr (member a l)))) (if (or (< (length (unique l2)) (length l2)) (< (length l2) (length l1))) (setq xxx3 (list l1 l2 (list a b c)))) (if (and (not (chkinters-p l2)) (> (get-closedpolygon-length l1) (get-closedpolygon-length l2))) (setq l l2) (progn (setq l (append (cdr l) (list (car l)))) nil)))) l (append (cdr l) (list (car l))) (append (cddr l) (list (car l) (cadr l))))))
      l
    )

    (defun foo4 ( plst / l )
      (setq l plst)
      (while (and (null xxx4) (vl-some (function (lambda ( a b c / l1 l2 edge ) (setq l1 l edge (vl-some (function (lambda ( x ) (if (< (- (+ (distance (car x) b) (distance b (cadr x))) (distance (car x) (cadr x))) (- (+ (distance a b) (distance b c)) (distance a c))) x))) (vl-remove (list a b) (vl-remove (list b c) (mapcar (function list) (append l l) (append (append (cdr l) (list (car l))) (append (cdr l) (list (car l))))))))) (if edge (setq l2 (append (if (/= (vl-position (car edge) l) (1- (length l))) (reverse (member (car edge) (reverse (vl-remove b l))))) (list b) (member (cadr edge) (vl-remove b l)))) (setq l2 nil)) (if (and l2 (or (< (length (unique l2)) (length l2)) (< (length l2) (length l1)))) (setq xxx4 (list l1 l2 edge (list a b c)))) (if (and l2 (not (chkinters-p l2)) (> (get-closedpolygon-length l1) (get-closedpolygon-length l2))) (setq l l2) (if l2 (progn (setq l (append (cdr l) (list (car l)))) nil))))) l (append (cdr l) (list (car l))) (append (cddr l) (list (car l) (cadr l))))))
      l
    )

    (defun foo5 ( plst / l )
      (setq l plst)
      (while (and (null xxx5) (vl-some (function (lambda ( a b c / l1 l2 edge x ) (setq l1 l edge (vl-some (function (lambda ( x ) (if (and (not (equal (car x) b 1e-6)) (not (equal b (cadr x) 1e-6)) (< (- (+ (distance (car x) b) (distance b (cadr x))) (distance (car x) (cadr x))) (- (+ (distance a b) (distance b c)) (distance a c)))) x))) (mapcar (function list) (append l l) (append (append (cddr l) (list (car l) (cadr l))) (append (cddr l) (list (car l) (cadr l))))))) (if edge (setq x (vl-some (function (lambda ( y ) (if (< (vl-position (car edge) (append l l)) (vl-position y (append l l)) (vl-position (cadr edge) (append l l))) y))) (append l l)))) (if (and edge x) (setq l2 (append (if (/= (vl-position (car edge) l) (1- (length l))) (reverse (member (car edge) (reverse (vl-remove x (vl-remove b l)))))) (list b (cadr edge)) (cons x (cdr (member (cadr edge) (vl-remove x (vl-remove b l))))))) (setq l2 nil)) (if (and l2 (or (< (length (unique l2)) (length l2)) (< (length l2) (length l1)))) (setq xxx5 (list l1 l2 edge x (list a b c)))) (if (and l2 (not (chkinters-p l2)) (> (get-closedpolygon-length l1) (get-closedpolygon-length l2))) (setq l l2) (if l2 (progn (setq l (append (cdr l) (list (car l)))) nil))))) l (append (cdr l) (list (car l))) (append (cddr l) (list (car l) (cadr l))))))
      l
    )

    (defun foon ( plst n / argl argvl l args aaa func )

      (defun argl ( n / k ll )
        (setq k -1)
        (repeat n
          (setq ll (cons (setq k (1+ k)) ll))
        )
        (foreach x (setq ll (reverse ll))
          (setq ll (subst (strcat "a" (itoa x)) x ll))
        )
        (setq ll (mapcar (function read) ll))
      )

      (defun argvl ( n / buildargv k ll )

        (defun buildargv ( kk / d a )
          (setq d 0 dd -1)
          (if (zerop kk)
            'l
            (list 'append
              (read
                (strcat "(member (nth "
                  (repeat kk
                    (itoa (setq d (1+ d)))
                  )
                  " l) l)"
                )
              )
              (cons
                'list
                (repeat kk
                  (setq a (append a (list (list 'nth (setq dd (1+ dd)) 'l))))
                )
              )
            )
          )
        )

        (setq k -1)
        (repeat n
          (setq ll (cons (setq k (1+ k)) ll))
        )
        (foreach x (setq ll (reverse ll))
          (setq ll (subst (buildargv x) x ll))
        )
        ll
      )

      (setq l plst args (append (cdr (setq aaa (cons 'list (argl n)))) (list '/ 'l1 'l2 'edge)) func (list 'function (list 'lambda args (list 'setq 'l1 'l 'edge (list 'vl-some (list 'function (list 'lambda (list 'x) (list 'if (list '< (list '- (list '+ (list 'distance (list 'car 'x) (list 'nth (list '- n 1) aaa)) (list 'apply (list 'function (quote +)) (list 'mapcar (list 'function (quote distance)) (list 'cdr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa)))) (list 'cddr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa)))))) (list 'distance (list 'cadr aaa) (list 'cadr 'x))) (list 'distance (list 'car 'x) (list 'cadr 'x))) (list '- (list 'apply (list 'function (quote +)) (list 'mapcar (list 'function (quote distance)) (list 'cdr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa)))) (list 'cddr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa)))))) (list 'distance (list 'car aaa) (list 'nth (list '- n 1) aaa)))) 'x))) (list 'vl-remove-if (list 'function (list 'lambda (list 'z) (list 'or (list 'vl-position (list 'car 'z) (list 'cdr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa))))) (list 'vl-position (list 'cadr 'z) (list 'cdr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa)))))))) (list 'mapcar (list 'function (list 'lambda (list 'j 'k) (list 'list 'j 'k))) 'l (list 'append (list 'cdr 'l) (list 'list (list 'car 'l))))))) (list 'if 'edge (list 'setq 'l2 (list 'append (list 'reverse (list 'member (list 'car 'edge) (list 'reverse (list 'vl-remove-if (list 'function (list 'lambda (list 'q) (list 'vl-position 'q (list 'cdr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa))))))) 'l)))) (list 'reverse (list 'cdr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa))))) (list 'member (list 'cadr 'edge) (list 'vl-remove-if (list 'function (list 'lambda (list 'q) (list 'vl-position 'q (list 'cdr (list 'reverse (list 'member (list 'nth (list '- n 2) aaa) (list 'reverse aaa))))))) 'l))))) (list 'if (list 'and 'l2 (list '> (list 'apply (list 'function (quote +)) (list 'mapcar (list 'function (quote distance)) 'l1 (list 'append (list 'cdr 'l1) (list 'list (list 'car 'l1))))) (list 'apply (list 'function (quote +)) (list 'mapcar (list 'function (quote distance)) 'l2 (list 'append (list 'cdr 'l2) (list 'list (list 'car 'l2))))))) (list 'setq 'l 'l2)))))
      (while (eval (cons 'vl-some (append (list func) (argvl n)))))
      l
    )

    (defun processfoos ( plst / d dd ddd plst0 plst1 plst2 plst3 plst4 plst5 plst6 plst7 d0 d1 d2 d3 d4 d5 d6 d7 n d00 plst00 )
      (if (< (length (unique plst)) (length plst))
        (progn
          (prompt "\nError in reference list for processing (foo) subs - it contains duplicate points... Quitting...")
          (exit)
        )
      )
      (setq d 1e+99 dd 0 n 0 d0 1e+99 plst00 plst)
      (while (> d dd)
        (repeat (1- (length lst))
          (setq plst00 (foo plst (setq n (1+ n))))
          (if (or (< (length (unique plst00)) (length plst00)) (< (length plst00) (length plst)))
            (progn
              (prompt "\nError in (foo) - return list has less points than reference one or output list contains duplicate points... Quitting...")
              (exit)
            )
          )
          (if (chkinters-p plst00)
            (setq plst00 (chkinters plst00))
          )
          (setq d00 (get-closedpolygon-length plst00))
          (if (< d00 d0)
            (setq d0 d00 plst0 plst00)
          )
        )
        (setq plst1 (foo1 plst))
        (if (or (< (length (unique plst1)) (length plst1)) (< (length plst1) (length plst)))
          (progn
            (prompt "\nError in (foo1) - return list has less points than reference one or output list contains duplicate points... Quitting...")
            (exit)
          )
        )
        (if (chkinters-p plst1)
          (setq plst1 (chkinters plst1))
        )
        (setq d1 (get-closedpolygon-length plst1))
        (setq plst2 (foo2 plst))
        (if (or (< (length (unique plst2)) (length plst2)) (< (length plst2) (length plst)))
          (progn
            (prompt "\nError in (foo2) - return list has less points than reference one or output list contains duplicate points... Quitting...")
            (exit)
          )
        )
        (if (chkinters-p plst2)
          (setq plst2 (chkinters plst2))
        )
        (setq d2 (get-closedpolygon-length plst2))
        (setq plst3 (foo3 plst))
        (if (or (< (length (unique plst3)) (length plst3)) (< (length plst3) (length plst)))
          (progn
            (prompt "\nError in (foo3) - return list has less points than reference one or output list contains duplicate points... Quitting...")
            (exit)
          )
        )
        (if (chkinters-p plst3)
          (setq plst3 (chkinters plst3))
        )
        (setq d3 (get-closedpolygon-length plst3))
        (setq plst4 (foo4 plst))
        (if (or (< (length (unique plst4)) (length plst4)) (< (length plst4) (length plst)))
          (progn
            (prompt "\nError in (foo4) - return list has less points than reference one or output list contains duplicate points... Quitting...")
            (exit)
          )
        )
        (if (chkinters-p plst4)
          (setq plst4 (chkinters plst4))
        )
        (setq d4 (get-closedpolygon-length plst4))
        (setq plst5 (foo5 plst))
        (if (or (< (length (unique plst5)) (length plst5)) (< (length plst5) (length plst)))
          (progn
            (prompt "\nError in (foo5) - return list has less points than reference one or output list contains duplicate points... Quitting...")
            (exit)
          )
        )
        (if (chkinters-p plst5)
          (setq plst5 (chkinters plst5))
        )
        (setq d5 (get-closedpolygon-length plst5))
        ;| ;;; (foon) can sometimes break...
        (setq plst6 (foon plst 4))
        (if (or (< (length (unique plst6)) (length plst6)) (< (length plst6) (length plst)))
          (progn
            (prompt "\nError in (foo6) - return list has less points than reference one or output list contains duplicate points... Quitting...")
            (exit)
          )
        )
        (if (chkinters-p plst6)
          (setq plst6 (chkinters plst6))
        )
        (setq d6 (get-closedpolygon-length plst6))
        (setq plst7 (foon plst 5))
        (if (or (< (length (unique plst7)) (length plst7)) (< (length plst7) (length plst)))
          (progn
            (prompt "\nError in (foo7) - return list has less points than reference one or output list contains duplicate points... Quitting...")
            (exit)
          )
        )
        (if (chkinters-p plst7)
          (setq plst7 (chkinters plst7))
        )
        (setq d7 (get-closedpolygon-length plst7))
        |;
        ;(setq dd (min d0 d1 d2 d3 d4 d5 d6 d7))
        (setq dd (car-sort (list d0 d1 d2 d3 d4 d5) (function <))) ;;; excluded d6 and d7
        (cond
          ( (= dd d0)
            (setq plst plst0)
          )
          ( (= dd d1)
            (setq plst plst1)
          )
          ( (= dd d2)
            (setq plst plst2)
          )
          ( (= dd d3)
            (setq plst plst3)
          )
          ( (= dd d4)
            (setq plst plst4)
          )
          ( (= dd d5)
            (setq plst plst5)
          )
          ( (= dd d6)
            (setq plst plst6)
          )
          ( (= dd d7)
            (setq plst plst7)
          )
        )
        (if (equal ddd dd 1e-6)
          (setq d dd)
          (setq ddd dd)
        )
      )
      plst
    )

    (defun genetic1 ( pl / plst inpl epl e d )
      (setq plst (MR:ConvexHull-ptsonHull pl))
      (setq inpl (vl-remove-if (function (lambda ( x ) (vl-position x plst))) pl))
      (while inpl
        (setq epl nil)
        (foreach e (mapcar (function list) plst (append (cdr plst) (list (car plst))))
          (setq epl (cons (list (car e) (car-sort inpl (function (lambda ( a b ) (< (- (+ (distance (car e) a) (distance (cadr e) a)) (distance (car e) (cadr e))) (- (+ (distance (car e) b) (distance (cadr e) b)) (distance (car e) (cadr e))))))) (cadr e)) epl))
        )
        (setq e (car-sort epl (function (lambda ( a b ) (< (- (+ (distance (car a) (cadr a)) (distance (cadr a) (caddr a))) (distance (car a) (caddr a))) (- (+ (distance (car b) (cadr b)) (distance (cadr b) (caddr b))) (distance (car b) (caddr b))))))))
        (setq inpl (vl-remove (cadr e) inpl))
        (setq plst (apply (function append) (mapcar (function (lambda ( x ) (if (equal (car e) x) (list (car e) (cadr e)) (list x)))) plst)))
      )
      plst
    )

    (defun genetic2 ( pl / plst pp p p1 p2 inpl in inn epl lil e dd1 dd2 rr1 rr2 xx )
      (setq pl (vl-sort pl (function (lambda ( a b ) (if (= (cadr a) (cadr b)) (< (car a) (car b)) (< (cadr a) (cadr b)))))))
      (setq plst (MR:ConvexHull-ptsonHull (unique pl)))
      (if (caddr pl)
        (progn
          (setq pp (car plst))
          (foreach x plst
            (if (or (> (car x) (car pp)) (and (= (car x) (car pp)) (< (cadr x) (cadr pp))))
              (setq pp x)
            )
          )
          (if (> (vl-position (setq p (car-sort (cdr pl) (function (lambda ( a b ) (< (distance (car pl) a) (distance (car pl) b)))))) pl) (vl-position (car-sort (vl-remove p (cdr pl)) (function (lambda ( a b ) (< (distance (car pl) a) (distance (car pl) b))))) pl))
            (setq p1 (mapcar (function +) (car pl) (list 0.0 5e-2)) p2 (mapcar (function +) (last pl) (list 0.0 5e-2)))
            (setq plst (append (member pp plst) (reverse (cdr (member pp (reverse plst))))) p1 (mapcar (function +) (list (car (last pl)) (cadar pl)) (list -5e-2 0.0)) p2 (mapcar (function +) (list (caar pl) (cadr (last pl))) (list -5e-2 0.0)))
          )
          (setq inpl (vl-remove-if (function (lambda ( x ) (vl-position x plst))) pl))
          (setq in inpl)
          (setq inpl nil)
          (while in
            (setq inn (MR:ConvexHull-ptsonHull in))
            (setq in (vl-remove-if (function (lambda ( x ) (vl-position x inn))) in))
            (setq inpl (append inn inpl))
          )
          (while inpl
            (setq epl nil)
            (setq lil (mapcar (function list) plst (append (cdr plst) (list (car plst)))))
            (foreach e lil
              (setq epl (cons (list (car e) (car-sort inpl (function (lambda ( a b ) (if (equal (- (+ (distance (car e) a) (distance (cadr e) a)) (distance (car e) (cadr e))) (- (+ (distance (car e) b) (distance (cadr e) b)) (distance (car e) (cadr e))) 1e-3) (< (vl-position a inpl) (vl-position b inpl)) (< (- (+ (distance (car e) a) (distance (cadr e) a)) (distance (car e) (cadr e))) (- (+ (distance (car e) b) (distance (cadr e) b)) (distance (car e) (cadr e)))))))) (cadr e)) epl))
            )
            (setq epl (reverse epl))
            (setq e (car-sort (if (setq xx (vl-remove-if (function (lambda ( x ) (or (inters (car x) (cadr x) p1 p2) (inters (cadr x) (caddr x) p1 p2)))) epl)) xx epl) (function (lambda ( a b ) (if (equal (- (+ (distance (car a) (cadr a)) (distance (cadr a) (caddr a))) (distance (car a) (caddr a))) (- (+ (distance (car b) (cadr b)) (distance (cadr b) (caddr b))) (distance (car b) (caddr b))) 1e-3) (< (vl-position (car a) plst) (vl-position (car b) plst)) (< (- (+ (distance (car a) (cadr a)) (distance (cadr a) (caddr a))) (distance (car a) (caddr a))) (- (+ (distance (car b) (cadr b)) (distance (cadr b) (caddr b))) (distance (car b) (caddr b)))))))))
            (setq inpl (vl-remove (cadr e) inpl))
            (setq plst (apply (function append) (mapcar (function (lambda ( x ) (if (equal (car e) x) (list (car e) (cadr e)) (list x)))) plst)))
            (setq plst (append (member (caddr e) plst) (reverse (cdr (member (caddr e) (reverse plst))))))
            (setq plst (append (cdr plst) (list (car plst))))
            ;|
            (progn
              (redraw)
              (mapcar (function (lambda ( a b ) (grdraw a b 2 0))) plst (append (cdr plst) (list (car plst))))
              (getstring "\nENTER TO CONTINUE...")
            )
            |;
            ;;; debugging...
          )
          (setq rr1 (unique plst) dd1 (get-closedpolygon-length plst))
          (setq plst (reverse plst))
          (setq rr2 (unique plst) dd2 (get-closedpolygon-length plst))
          (if (< dd1 dd2)
            (setq plst rr1)
            (setq plst rr2)
          )
          (if (chkinters-p plst)
            (setq plst (chkinters plst))
          )
          plst
        )
        pl
      )
    )

    (defun greedy ( pl / c p1 p2 lst pp1 pp2 )
      (gc)
      (if (vl-every (function null) (mapcar (function caddr) pl))
        (setq pl (mapcar (function (lambda ( p ) (list (car p) (cadr p) 0.0))) pl))
      )
      (setq lst (mindist-eea-MR pl))
      (setq p1 (car lst) p2 (cadr lst))
      (setq pl (vl-remove-if (function (lambda ( x ) (vl-some (function (lambda ( y ) (equal x y 1e-6))) lst))) pl))
      (while pl
        (setq pp1 (car-sort pl (function (lambda ( q p ) (< (distance p1 q) (distance p1 p))))))
        (setq pp2 (car-sort pl (function (lambda ( q p ) (< (distance p2 q) (distance p2 p))))))
        (if
          (or
            (< (distance p1 pp1) (distance p2 pp2))
            (equal (distance p1 pp1) (distance p2 pp2) 1e-6)
          )
          (progn
            (if (< (distance (car lst) pp1) (distance (last lst) pp1))
              (setq lst (cons pp1 lst))
              (setq lst (append lst (list pp1)))
            )
            (setq pl (vl-remove pp1 pl))
          )
          (progn
            (if (< (distance (car lst) pp2) (distance (last lst) pp2))
              (setq lst (cons pp2 lst))
              (setq lst (append lst (list pp2)))
            )
            (setq pl (vl-remove pp2 pl))
          )
        )
        (setq p1 (car lst) p2 (last lst))
      )
      lst
    )

    (defun generic ( l / ch inpts lil d p lilp lip )
      (setq ch (MR:ConvexHull-ptsonHull l))
      (setq inpts (vl-remove-if (function (lambda ( x ) (vl-position x ch))) l))
      (while inpts
        (setq lil (mapcar (function list) ch (append (cdr ch) (list (car ch)))))
        (foreach li lil
          (setq d (distance (car li) (cadr li)))
          (setq p (car-sort inpts (function (lambda ( a b ) (< (- (+ (distance (car li) a) (distance a (cadr li))) d) (- (+ (distance (car li) b) (distance b (cadr li))) d))))))
          (setq lilp (cons (list li p) lilp))
        )
        (setq lip (car-sort lilp (function (lambda ( a b ) (< (- (+ (distance (caar a) (cadr a)) (distance (cadr a) (cadar a))) (distance (caar a) (cadar a))) (- (+ (distance (caar b) (cadr b)) (distance (cadr b) (cadar b))) (distance (caar b) (cadar b))))))))
        (setq lil (subst (list (caar lip) (cadr lip) (cadar lip)) (car lip) lil))
        (setq ch (unique (apply (function append) lil)))
        (setq inpts (vl-remove (cadr lip) inpts))
        (setq lilp nil)
      )
      ch
    )

    (defun main ( chulls )
      (while (cadr chulls)
        (setq lst (car chulls) out (cadr chulls) chulls (cdr chulls))
        (if flag
          (progn
            (setq r1 (process1 lst out))
            (if (and r1 (chkinters-p r1)) (setq r1 (chkinters r1)))
            (if r1 (setq r1 (processfoos r1)))
            (if (and r1 (chkinters-p r1)) (setq r1 (chkinters r1)))
          )
          (progn
            (setq r1 (process1 lst out))
            (if (and r1 (chkinters-p r1)) (setq r1 (chkinters r1)))
          )
        )
        (if flag
          (progn
            (setq r2 (process2 lst out))
            (if (and r2 (chkinters-p r2)) (setq r2 (chkinters r2)))
            (if r2 (setq r2 (processfoos r2)))
            (if (and r2 (chkinters-p r2)) (setq r2 (chkinters r2)))
          )
          (progn
            (setq r2 (process2 lst out))
            (if (and r2 (chkinters-p r2)) (setq r2 (chkinters r2)))
          )
        )
        (if flag
          (progn
            (setq r3 (process3 lst out))
            (if (and r3 (chkinters-p r3)) (setq r3 (chkinters r3)))
            (if r3 (setq r3 (processfoos r3)))
            (if (and r3 (chkinters-p r3)) (setq r3 (chkinters r3)))
          )
          (progn
            (setq r3 (process3 lst out))
            (if (and r3 (chkinters-p r3)) (setq r3 (chkinters r3)))
          )
        )
        (if flag
          (progn
            (setq r4 (genetic1 (append lst out)))
            (if (and r4 (chkinters-p r4)) (setq r4 (chkinters r4)))
            (if r4 (setq r4 (processfoos r4)))
            (if (and r4 (chkinters-p r4)) (setq r4 (chkinters r4)))
          )
          (progn
            (setq r4 (genetic1 (append lst out)))
            (if (and r4 (chkinters-p r4)) (setq r4 (chkinters r4)))
          )
        )
        (if flag
          (progn
            (setq r5 (genetic2 (append lst out)))
            (if (and r5 (chkinters-p r5)) (setq r5 (chkinters r5)))
            (if r5 (setq r5 (processfoos r5)))
            (if (and r5 (chkinters-p r5)) (setq r5 (chkinters r5)))
          )
          (progn
            (setq r5 (genetic2 (append lst out)))
            (if (and r5 (chkinters-p r5)) (setq r5 (chkinters r5)))
          )
        )
        (setq r6 (TSP lst out n))
        (if (and r6 (chkinters-p r6)) (setq r6 (chkinters r6)))
        (setq r11 (unique r1) r12 (unique (reverse r1)) r21 (unique r2) r22 (unique (reverse r2)) r31 (unique r3) r32 (unique (reverse r3)) r41 (unique r4) r42 (unique (reverse r4)) r51 (unique r5) r52 (unique (reverse r5)) r61 (unique r6) r62 (unique (reverse r6)))
        (if r11
          (setq d11 (get-closedpolygon-length r11))
          (setq d11 nil)
        )
        (if r12
          (setq d12 (get-closedpolygon-length r12))
          (setq d12 nil)
        )
        (if r21
          (setq d21 (get-closedpolygon-length r21))
          (setq d21 nil)
        )
        (if r22
          (setq d22 (get-closedpolygon-length r22))
          (setq d22 nil)
        )
        (if r31
          (setq d31 (get-closedpolygon-length r31))
          (setq d31 nil)
        )
        (if r32
          (setq d32 (get-closedpolygon-length r32))
          (setq d32 nil)
        )
        (if r41
          (setq d41 (get-closedpolygon-length r41))
          (setq d41 nil)
        )
        (if r42
          (setq d42 (get-closedpolygon-length r42))
          (setq d42 nil)
        )
        (if r51
          (setq d51 (get-closedpolygon-length r51))
          (setq d51 nil)
        )
        (if r52
          (setq d52 (get-closedpolygon-length r52))
          (setq d52 nil)
        )
        (if r61
          (setq d61 (get-closedpolygon-length r61))
          (setq d61 nil)
        )
        (if r62
          (setq d62 (get-closedpolygon-length r62))
          (setq d62 nil)
        )
        (setq d (apply (function min) (vl-remove nil (list d11 d12 d21 d22 d31 d32 d41 d42 d51 d52 d61 d62))))
        (setq r (nth (vl-position d (list d11 d12 d21 d22 d31 d32 d41 d42 d51 d52 d61 d62)) (list r11 r12 r21 r22 r31 r32 r41 r42 r51 r52 r61 r62)))
        (setq chulls (subst r (car chulls) chulls))
      )
      r
    )

    (setq plst (MR:ConvexHull-ptsonHull (setq pl (unique pl))))
    (setq inpl (vl-remove-if (function (lambda ( x ) (vl-position x plst))) pl))
    (setq chulls (cons plst chulls))
    (while (and inpl (> (length inpl) 2))
      (setq plst (MR:ConvexHull-ptsonHull inpl))
      (setq inpl (vl-remove-if (function (lambda ( x ) (vl-position x plst))) inpl))
      (setq chulls (cons plst chulls))
    )
    (setq lst (car chulls))
    (if inpl
      (setq lst (process3 inpl lst))
    )
    (setq chulls (subst lst (car chulls) chulls))
    (if (cadr chulls)
      (setq rr (main chulls))
      (setq rr lst)
    )
    (if flag
      (progn
        (setq r7 (generic pl))
        (if (and r7 (chkinters-p r7)) (setq r7 (chkinters r7)))
        (if r7 (setq r7 (processfoos r7)))
        (if (and r7 (chkinters-p r7)) (setq r7 (chkinters r7)))
      )
      (progn
        (setq r7 (generic pl))
        (if (and r7 (chkinters-p r7)) (setq r7 (chkinters r7)))
      )
    )
    (if flag
      (progn
        (setq r8 (greedy pl))
        (if (and r8 (chkinters-p r8)) (setq r8 (chkinters r8)))
        (if r8 (setq r8 (processfoos r8)))
        (if (and r8 (chkinters-p r8)) (setq r8 (chkinters r8)))
      )
      (progn
        (setq r8 (greedy pl))
        (if (and r8 (chkinters-p r8)) (setq r8 (chkinters r8)))
      )
    )
    ;|
    (if flag
      (progn
        (setq r9 (grid pl))
        (if (and r9 (chkinters-p r9)) (setq r9 (chkinters r9)))
        (if r9 (setq r9 (processfoos r9)))
        (if (and r9 (chkinters-p r9)) (setq r9 (chkinters r9)))
      )
      (progn
        (setq r9 (grid pl))
        (if (and r9 (chkinters-p r9)) (setq r9 (chkinters r9)))
      )
    )
    |;
    ;(setq r (car-sort (list rr r7 r8 r9) (function (lambda ( a b ) (< (get-closedpolygon-length a) (get-closedpolygon-length b))))))
    (setq r (car-sort (list rr r7 r8) (function (lambda ( a b ) (< (get-closedpolygon-length a) (get-closedpolygon-length b))))))
  )

  (defun tsp-rnd ( l / f1 f2 d d0 d1 e ent ep a pl n rr )

    (defun f1 ( a ent / p pl pll dl d pos enx )
      (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq enx (entget ent)))))
      (setq pll (mapcar (function list) pl (append (cdr pl) (list (car pl)))))
      (foreach li pll
        (setq dl (cons (- (+ (distance a (car li)) (distance a (cadr li))) (distance (car li) (cadr li))) dl))
      )
      (setq d (car-sort dl (function <)))
      (setq pos (vl-position d dl))
      (setq p (car (nth pos pll)))
      (setq p (list 10 (car p) (cadr p)))
      (entupd (cdr (assoc -1 (entmod (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 enx)))) (assoc 90 enx) enx))))
                                             (list (cons 10 a))
                                             (cdr (member p enx))
                                     )
                             )
                   )
              )
      )
    )

    (defun f2 ( a ent / p enx )
      (setq enx (entget ent))
      (setq p (vlax-curve-getPointAtParam ent (fix (vlax-curve-getParamAtPoint ent (vlax-curve-getClosestPointTo ent a)))))
      (setq p (list 10 (car p) (cadr p)))
      (entupd (cdr (assoc -1 (entmod (append (reverse (member p (reverse (subst (cons 90 (1+ (cdr (assoc 90 enx)))) (assoc 90 enx) enx))))
                                             (list (cons 10 a))
                                             (cdr (member p enx))
                                     )
                             )
                   )
              )
      )
    )

    (setq ent (entmakex (append (list (cons 0 "LWPOLYLINE")
                                      (cons 100 "AcDbEntity")
                                      (cons 100 "AcDbPolyline")
                                      (cons 90 (length l))
                                      (cons 70 (1+ (* 128 (getvar (quote plinegen)))))
                                )
                                (mapcar (function (lambda ( a ) (cons 10 a))) l)
                                (list (list 210 0.0 0.0 1.0))
                        )
              )
          ep  (length l)
    )
    (setq d0 (vlax-curve-getDistAtParam ent ep))
    (while
      (> d0
        (progn
          (setq n 0
               l (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (setq e (entget ent))))
               l (mapcar (function list) l (append (cdr l) (list (car l))))
          )
          (repeat ep
            (setq d (vlax-curve-getDistAtParam ent ep)
                 a (nth n (append l l))
            )



            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f1 (car a) ent)
            (f1 (cadr a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )
            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f1 (cadr a) ent)
            (f1 (car a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )



            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f2 (car a) ent)
            (f2 (cadr a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )
            (entupd (cdr (assoc -1 (entmod (vl-remove (cons 10 (car a)) (vl-remove (cons 10 (cadr a)) (subst (cons 90 (- (cdr (assoc 90 e)) 2)) (assoc 90 e) e)))))))
            (f2 (cadr a) ent)
            (f2 (car a) ent)
            (if (<= d (setq d1 (vlax-curve-getDistAtParam ent (vlax-curve-getEndParam ent))))
              (entupd (cdr (assoc -1 (entmod e))))
              (setq d d1
                    e (entget ent)
              )
            )



            (setq n (1+ n))
          )
          d
        )
      )
      (setq d0 d)
    )
    ent
  )

  (setq wcs (tttt t)) ;;; starting "library" template sub function - initialization ;;;
  (prompt "\nSelect points, blocks, or circles...")
  (if (setq ss (ssget (list (cons 0 "POINT,INSERT,CIRCLE"))))
    (progn
      (initget "Grid Rnd")
      (setq ch (cond ( (getkword "\nChoose option of points disposition [Grid / Rnd] <Rnd> : ") ) ( "Rnd" ) ))
      (if (= ch "Rnd")
        (progn
          (initget "Yes No")
          (if (= (setq flag (getkword "\nProcess (foo) subs [Yes/No] <Yes> : ")) "No")
            (setq flag nil)
            (setq flag t)
          )
          (initget 7)
          (setq n (getint "\nSpecify depth - point clouds list length for permutation processing (type 1 for no permutations) - strongly suggestion is 5 - even 6 is too much - it won't finish at decent time limits, but result will be very good : "))
          (while (> n 8)
            (prompt "\nCrazy input... PC can't permutate that list in reasonable time (it's length is above 8)...")
            (initget 7)
            (setq n (getint "\nSpecify depth - point clouds list length for permutation processing (type 1 for no permutations) - strongly suggestion is 5 - even 6 is too much - it won't finish at decent time limits, but result will be very good : "))
          )
        )
      )
      (setq ti (car (_vl-times)))
      (repeat (setq i (sslength ss))
        (setq pl (cons (mapcar (function +) (list 0.0 0.0) (cdr (assoc 10 (entget (ssname ss (setq i (1- i))))))) pl))
      )
      (setq pl (vl-sort pl (function (lambda ( a b ) (if (equal (car a) (car b) 1e-6) (< (cadr a) (cadr b)) (< (car a) (car b)))))))
      (if (= ch "Rnd")
        (progn
          (setq pl1 (tsp-rnd1 pl))
          (if (chkinters-p pl1)
            (setq pl1 (chkinters pl1))
          )
          (setq pl2 (tsp-rnd2 pl1))
          (if (chkinters-p pl2)
            (setq pl2 (chkinters pl2))
          )
          (setq pl3 (tsp-rnd3 pl1))
          (if (chkinters-p pl3)
            (setq pl3 (chkinters pl3))
          )
          (setq pl4 (tsp-rnd4 pl1))
          (if (chkinters-p pl4)
            (setq pl4 (chkinters pl4))
          )
          (setq pl5 (tsp-rnd5 pl1))
          (if (chkinters-p pl5)
            (setq pl5 (chkinters pl5))
          )
          (setq pl6 (tsp-rnd6 pl1))
          (if (chkinters-p pl6)
            (setq pl6 (chkinters pl6))
          )
          (setq pl7 (tsp-rnd7 pl1))
          (if (chkinters-p pl7)
            (setq pl7 (chkinters pl7))
          )
          (setq pl8 (tsp-rnd8 pl1))
          (if (chkinters-p pl8)
            (setq pl8 (chkinters pl8))
          )
          (setq pl9 (tsp-rnd9 pl1))
          (if (chkinters-p pl9)
            (setq pl9 (chkinters pl9))
          )
          (setq pl10 (tsp-rnd10 pl1))
          (if (chkinters-p pl10)
            (setq pl10 (chkinters pl10))
          )
          (setq pl11 (tsp-rnd11 pl1))
          (if (chkinters-p pl11)
            (setq pl11 (chkinters pl11))
          )
          (setq pl12 (tsp-all pl1 n flag))
          (if (chkinters-p pl12)
            (setq pl12 (chkinters pl12))
          )
          (setq pla (AHS:TSP pl1))
          (if (chkinters-p pla)
            (setq pla (chkinters pla))
          )
          (setq dl (list (apply (function +) (mapcar (function distance) pl1 (append (cdr pl1) (list (car pl1))))) (apply (function +) (mapcar (function distance) pl2 (append (cdr pl2) (list (car pl2))))) (apply (function +) (mapcar (function distance) pl3 (append (cdr pl3) (list (car pl3))))) (apply (function +) (mapcar (function distance) pl4 (append (cdr pl4) (list (car pl4))))) (apply (function +) (mapcar (function distance) pl5 (append (cdr pl5) (list (car pl5))))) (apply (function +) (mapcar (function distance) pl6 (append (cdr pl6) (list (car pl6))))) (apply (function +) (mapcar (function distance) pl7 (append (cdr pl7) (list (car pl7))))) (apply (function +) (mapcar (function distance) pl8 (append (cdr pl8) (list (car pl8))))) (apply (function +) (mapcar (function distance) pl9 (append (cdr pl9) (list (car pl9))))) (apply (function +) (mapcar (function distance) pl10 (append (cdr pl10) (list (car pl10))))) (apply (function +) (mapcar (function distance) pl11 (append (cdr pl11) (list (car pl11))))) (apply (function +) (mapcar (function distance) pl12 (append (cdr pl12) (list (car pl12))))) (apply (function +) (mapcar (function distance) pla (append (cdr pla) (list (car pla)))))))
          (setq pos (vl-position (car-sort dl (function <)) dl))
          (cond
            ( (= pos 0)
              (setq pl pl1 d (nth 0 dl))
            )
            ( (= pos 1)
              (setq pl pl2 d (nth 1 dl))
            )
            ( (= pos 2)
              (setq pl pl3 d (nth 2 dl))
            )
            ( (= pos 3)
              (setq pl pl4 d (nth 3 dl))
            )
            ( (= pos 4)
              (setq pl pl5 d (nth 4 dl))
            )
            ( (= pos 5)
              (setq pl pl6 d (nth 5 dl))
            )
            ( (= pos 6)
              (setq pl pl7 d (nth 6 dl))
            )
            ( (= pos 7)
              (setq pl pl8 d (nth 7 dl))
            )
            ( (= pos 8)
              (setq pl pl9 d (nth 8 dl))
            )
            ( (= pos 9)
              (setq pl pl10 d (nth 9 dl))
            )
            ( (= pos 10)
              (setq pl pl11 d (nth 10 dl))
            )
            ( (= pos 11)
              (setq pl pl12 d (nth 11 dl))
            )
            ( (= pos 12)
              (setq pl pla d (nth 12 dl))
            )
          )
          (setq ent (vl-catch-all-apply (function tsp-rnd) (list pl)))
          (if (not (vl-catch-all-error-p ent))
            (setq plll (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget ent))))
          )
          (if (and plll (chkinters-p plll))
            (setq plll (chkinters plll))
          )
          (if plll
            (setq dll (apply (function +) (mapcar (function distance) plll (append (cdr plll) (list (car plll))))))
          )
          (if (and d dll (equal d dll 1e-6))
            (alert "Distance 1 equal to Distance 2... Nothing optimized...")
            (if (and d dll (< dll d))
              (alert (strcat "Path optimized for : " (ftoa (- d dll)) " DWG units..."))
              (alert "Nothing optimized...")
            )
          )
          (entdel (entlast))
          (if (not (and d dll (< d dll)))
            (if (and plll dll)
              (setq pl plll d dll)
            )
          )
        )
        (progn
          (setq pl0 (grid pl))
          (if (chkinters-p pl0)
            (setq pl0 (chkinters pl0))
          )
          (setq ent (vl-catch-all-apply (function tsp-rnd) (list pl0)))
          (if (not (vl-catch-all-error-p ent))
            (setq plll (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) (entget ent))))
          )
          (if (and plll (chkinters-p plll))
            (setq plll (chkinters plll))
          )
          (if plll
            (setq dll (apply (function +) (mapcar (function distance) plll (append (cdr plll) (list (car plll))))))
          )
          (if (and d dll (equal d dll 1e-6))
            (alert "Distance 1 equal to Distance 2... Nothing optimized...")
            (if (and d dll (< dll d))
              (alert (strcat "Path optimized for : " (ftoa (- d dll)) " DWG units..."))
              (alert "Nothing optimized...")
            )
          )
          (entdel (entlast))
          (if (not (and d dll (< d dll)))
            (if (and plll dll)
              (setq pl plll d dll)
            )
          )
        )
      )
      (makelw pl)
      (prompt "\nDistance - path length : ") (princ (ftoa d))
      (prompt "\nElapsed time : ") (prompt (ftoa (- (car (_vl-times)) ti))) (prompt " milliseconds...")
      (prompt "\nFor UNDO - type \"UNDO\" - \"Back\" option...")
    )
  )
  (*error* nil)
)
