// (C) Copyright 2002-2007 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//

//-----------------------------------------------------------------------------
//----- acrxEntryPoint.cpp
//-----------------------------------------------------------------------------
#include "StdAfx.h"
#include "resource.h"
#include "TSPSolver.h"
#include "VlceMapFuncs.h"
#include "DelaunaySolver.h"
#include "AStarShortestPathSolver.h"
#include "PolyPointSolver.h"
#include "MinimumSpanningTreeSolver.h"
#include "TestSolver.h"
#include "VoronoiSolver.h"

#define VLCE_TESTMODE

//----- zrx grx
#ifdef ZRXAPP
#define ADS_PREFIX(X) zds##X
#elif GRXAPP
#define ADS_PREFIX(X) gds##X
#else
#define ADS_PREFIX(X) ads##X
#endif

#define ADS_TRY try {
#define ADS_CATCH } catch (...) { return (RSERR); }

//-----------------------------------------------------------------------------
//----- ObjectARX EntryPoint
class LispContainerApp : public AcRxArxApp
{
    bool On_kLoadDwgMsgCallOnce = false;

public:
    LispContainerApp() : AcRxArxApp()
    {
    }

    virtual AcRx::AppRetCode On_kInitAppMsg(void* pkt) override
    {
        AcRx::AppRetCode retCode = AcRxArxApp::On_kInitAppMsg(pkt);

        return (retCode);
    }

    virtual AcRx::AppRetCode On_kUnloadAppMsg(void* pkt)  override
    {
        AcRx::AppRetCode retCode = AcRxArxApp::On_kUnloadAppMsg(pkt);

        return (retCode);
    }

    virtual AcRx::AppRetCode On_kLoadDwgMsg(void* pkt) override
    {
        AcRx::AppRetCode retCode = AcRxArxApp::On_kLoadDwgMsg(pkt);
        if (!On_kLoadDwgMsgCallOnce)
        {
            acutPrintf(_T("\nCEXT_NP version <%ls>:\n"), (const TCHAR*)VER());
            On_kLoadDwgMsgCallOnce = true;
        }
        return (retCode);
    }

    virtual AcRx::AppRetCode On_kUnloadDwgMsg(void* pkt) override
    {
        AcRx::AppRetCode retCode = AcRxArxApp::On_kUnloadDwgMsg(pkt);
        return (retCode);
    }

    virtual void RegisterServerComponents()
    {
    }
    static AcString VER()
    {
        static constexpr TCHAR MAJOR1 = '1';
        static constexpr TCHAR MINOR1 = '1';
        static constexpr TCHAR REVISION1 = '0', REVISION2 = '1', REVISION3 = '8';

        static constexpr unsigned int compileYear = (__DATE__[7] - '0') * 1000 + (__DATE__[8] - '0') * 100 + (__DATE__[9] - '0') * 10 + (__DATE__[10] - '0');
        static constexpr unsigned int compileMonth = (__DATE__[0] == 'J') ? ((__DATE__[1] == 'a') ? 1 : ((__DATE__[2] == 'n') ? 6 : 7))    // Jan, Jun or Jul
            : (__DATE__[0] == 'F') ? 2                                                              // Feb
            : (__DATE__[0] == 'M') ? ((__DATE__[2] == 'r') ? 3 : 5)                                 // Mar or May
            : (__DATE__[0] == 'A') ? ((__DATE__[2] == 'p') ? 4 : 8)                                 // Apr or Aug
            : (__DATE__[0] == 'S') ? 9                                                              // Sep
            : (__DATE__[0] == 'O') ? 10                                                             // Oct
            : (__DATE__[0] == 'N') ? 11                                                             // Nov
            : (__DATE__[0] == 'D') ? 12                                                             // Dec
            : 0;
        static constexpr unsigned int compileDay = (__DATE__[4] == ' ') ? (__DATE__[5] - '0') : (__DATE__[4] - '0') * 10 + (__DATE__[5] - '0');

        static constexpr TCHAR IsoDate[] =
        {
           MAJOR1, '.' , MINOR1 , '.', REVISION1, REVISION2, REVISION3,
           '.', compileYear / 1000 + '0', (compileYear % 1000) / 100 + '0', (compileYear % 100) / 10 + '0', compileYear % 10 + '0',
           compileMonth / 10 + '0', compileMonth % 10 + '0',
           compileDay / 10 + '0', compileDay % 10 + '0', 0
        };
        AcString _ver = IsoDate;
        return _ver;
    }

    static int ADS_PREFIX(_vlce_test())
    {
        ADS_TRY
            return TestSolver::testSolverLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_test2())
    {
        ADS_TRY
            return TestSolver::testSolverLispFunc2();
        ADS_CATCH
    }

    static void CrxTest_doit()
    {
        acutPrintf(_T("\ntestint 1 2 3, thank you for playing"));
    }

#ifndef BRXAPP
    static int ADS_PREFIX(_vlce_createstrmap())
    {
        ADS_TRY
            return VlceMapFuncs::createstrmap();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_erasestrmap())
    {
        ADS_TRY
            return VlceMapFuncs::erasestrmap();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_strmapinsert())
    {
        ADS_TRY
            return VlceMapFuncs::strmapinsert();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_strmapvalue())
    {
        ADS_TRY
            return VlceMapFuncs::strmapvalue();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_createintmap())
    {
        ADS_TRY
            return VlceMapFuncs::createintmap();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_eraseintmap())
    {
        ADS_TRY
            return VlceMapFuncs::eraseintmap();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_intmapinsert())
    {
        ADS_TRY
            return VlceMapFuncs::intmapinsert();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_intmapvalue())
    {
        ADS_TRY
            return VlceMapFuncs::intmapvalue();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_makekey())
    {
        ADS_TRY
            return VlceMapFuncs::makekey();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_strmapkeys())
    {
        ADS_TRY
            return VlceMapFuncs::strmapkeys();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_intmapkeys())
    {
        ADS_TRY
            return VlceMapFuncs::intmapkeys();
        ADS_CATCH
    }
#endif

    static int ADS_PREFIX(_vlce_npver())
    {
        ADS_TRY
            acedRetStr(VER());
        return (RSRSLT);
        ADS_CATCH
    }
    static int ADS_PREFIX(_vlce_cheapestpathfss())
    {
        ADS_TRY
            return TSPSolver::solveFirstSolutionStrategyLispFunc();
        ADS_CATCH
    }
    static int ADS_PREFIX(_vlce_cheapestpathlsm())
    {
        ADS_TRY
            return TSPSolver::solveLocalSearchMetaheuristicStrategyLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_delaunay())
    {
        ADS_TRY
            return DelaunaySolver::delaunaySolverLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_delaunayhalfedges())
    {
        ADS_TRY
            return DelaunaySolver::delaunaySolverLispHalfEdgesFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_delaunaytriangles())
    {
        ADS_TRY
            return DelaunaySolver::delaunaySolverLispTrianglesFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_delaunayconstrained())
    {
        ADS_TRY
            return DelaunaySolver::delaunayConstrainedSolverLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_shortestpathastar())
    {
        ADS_TRY
            return AStarShortestPathSolver::shortestPathAstarLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_polypoints())
    {
        ADS_TRY
            return PolyPointSolver::polyPointLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_mst())
    {
        ADS_TRY
            return MinimumSpanningTreeSolver::minimumSpanningTreeSolverLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_voronoiccm())
    {
        ADS_TRY
            return VoronoiSolver::voronoiCCMSolverLispFunc();
        ADS_CATCH
    }

    static int ADS_PREFIX(_vlce_voronoicen())
    {
        ADS_TRY
            return VoronoiSolver::voronoiCENSolverLispFunc();
        ADS_CATCH
    }
};

//-----------------------------------------------------------------------------
IMPLEMENT_ARX_ENTRYPOINT(LispContainerApp)
#pragma warning( disable: 4838 )
#ifndef BRXAPP
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_npver, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_createstrmap, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_strmapinsert, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_strmapvalue, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_erasestrmap, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_createintmap, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_intmapinsert, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_intmapvalue, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_eraseintmap, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_makekey, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_strmapkeys, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_intmapkeys, false)
#endif

#ifdef VLCE_TESTMODE
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_test, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_test2, false)
ACED_ARXCOMMAND_ENTRY_AUTO(LispContainerApp, CrxTest, _doit, doit, ACRX_CMD_TRANSPARENT, NULL)
#endif

ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_cheapestpathfss, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_cheapestpathlsm, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_delaunay, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_delaunayhalfedges, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_delaunaytriangles, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_delaunayconstrained, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_polypoints, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_mst, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_shortestpathastar, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_voronoiccm, false)
ACED_ADSSYMBOL_ENTRY_AUTO(LispContainerApp, vlce_voronoicen, false)


#pragma warning( pop )
