(defun c:TSP-MR-AROUND-CONCAVE ( / LM:ConvexHull-ptsonHull LM:Clockwise-p processlw _do-events cmde ss i p ppp ppl ppll pplll pl xpl xx d pll plll lw lwx lil k ilil pre mid suf )

  ;; Convex Hull  -  Lee Mac
  ;; Implements the Graham Scan Algorithm to return the Convex Hull of a list of points.

  (defun LM:ConvexHull-ptsonHull ( lst / ch p0 lstl )
    (cond
      ( (< (length lst) 4) lst)
      ( (setq p0 (car lst))
        (foreach p1 (cdr lst)
          (if (or (< (cadr p1) (cadr p0))
                  (and (= (cadr p1) (cadr p0)) (< (car p1) (car p0)))
              )
              (setq p0 p1)
          )
        )
        (setq lst (vl-remove p0 lst))
        (setq lst (append (list p0) lst))
        (setq lst
          (vl-sort lst
            (function
              (lambda ( a b / c d )
                (if (or (equal (setq c (angle p0 a)) (setq d (angle p0 b)) 1e-8) (and (or (equal c 0.0 1e-8) (equal c (* 2 pi) 1e-8)) (or (equal d 0.0 1e-8) (equal d (* 2 pi) 1e-8))))
                  (< (distance (list (car p0) (cadr p0)) a) (distance (list (car p0) (cadr p0)) b))
                  (< c d)
                )
              )
            )
          )
        )
        (setq lstl (vl-remove-if-not (function (lambda ( x ) (equal (angle p0 (last lst)) (angle p0 x) 1e-8))) lst))
        (setq lst (vl-remove-if (function (lambda ( x ) (equal (angle p0 (last lst)) (angle p0 x) 1e-8))) lst))
        (setq lstl (vl-sort lstl (function (lambda ( a b ) (> (distance p0 a) (distance p0 b))))))
        (setq lst (append lst lstl))
        (setq ch (list (cadr lst) (car lst)))
        (foreach pt (cddr lst)
          (setq ch (cons pt ch))
          (while (and (caddr ch) (LM:Clockwise-p (caddr ch) (cadr ch) pt))
            (setq ch (cons pt (cddr ch)))
          )
        )
        (reverse ch)
      )
    )
  )

  ;; Clockwise-p  -  Lee Mac
  ;; Returns T if p1,p2,p3 are clockwise oriented or [s]collinear[/s]

  (defun LM:Clockwise-p ( p1 p2 p3 )
    (<  (-  (* (- (car  p2) (car  p1)) (- (cadr p3) (cadr p1)))
            (* (- (cadr p2) (cadr p1)) (- (car  p3) (car  p1)))
        )
        0.0
    )
  )

  (defun processlw ( pl p xpl d / lwx pl pp pll plll )
    (foreach pp (vl-remove-if (function (lambda ( x ) (vl-position x xpl))) pl)
      (setq pll (append (member pp pl) (reverse (cdr (member pp (reverse pl))))))
      (setq pll (list (+ (distance p pp) (distance p (cadr pll))) (append (list pp) (list p) (cdr pll))))
      (setq plll (cons pll plll))
    )
    (setq pll (car (vl-sort plll (function (lambda ( a b ) (if d (< (abs (- d (car a))) (abs (- d (car b)))) (< (apply (function +) (mapcar (function (lambda ( c d ) (distance c d))) (cadr a) (append (cdr (cadr a)) (list (car (cadr a)))))) (apply (function +) (mapcar (function (lambda ( c d ) (distance c d))) (cadr b) (append (cdr (cadr b)) (list (car (cadr b)))))))))))))
  )

  (defun _do-events nil
    (gc)
    (repeat 2 (vl-cmdf "_.DELAY" 0) (princ ""))
  )

  (prompt "\nSelect points, blocks or circles in WCS...")
  (setq cmde (getvar 'cmdecho))
  (setvar 'cmdecho 0)
  (if (setq ss (ssget '((0 . "POINT,CIRCLE,INSERT"))))
    (progn
      (repeat (setq i (sslength ss))
        (setq p (cdr (assoc 10 (entget (ssname ss (setq i (1- i)))))))
        (setq pl (cons (mapcar (function +) '(0 0) p) pl))
      )
      (setq ppl pl)
      (while ppl
        (setq ppll (LM:ConvexHull-ptsonHull ppl))
        (setq ppl (vl-remove-if (function (lambda ( x ) (vl-position x ppll))) ppl))
        (setq pplll (cons ppll pplll))
      )
      (setq pplll (reverse pplll))
      (setq pplll (cdr pplll))
      (setq pll (LM:ConvexHull-ptsonHull pl))
      (setq lw
        (entmakex
          (append
            (list
              '(0 . "LWPOLYLINE")
              '(100 . "AcDbEntity")
              '(100 . "AcDbPolyline")
              (cons 90 (length pll))
              (cons 70 (1+ (* 128 (getvar 'plinegen))))
              '(38 . 0.0)
            )
            (mapcar (function (lambda ( x ) (cons 10 x))) pll)
            '((210 0.0 0.0 1.0))
          )
        )
      )
      (setq lwx (entget lw))
      (setq pl (vl-remove-if (function (lambda ( x ) (vl-position x pll))) pl))
      (setq ppp pll ppll (car pplll))
      (while pl
        (foreach p ppll
          (setq plll (cons (processlw ppp p xpl d) plll))
        )
        (setq plll (cadar (vl-sort plll (function (lambda ( a b ) (if d (< (abs (- d (car a))) (abs (- d (car b)))) (< (apply (function +) (mapcar (function (lambda ( c d ) (distance c d))) (cadr a) (append (cdr (cadr a)) (list (car (cadr a)))))) (apply (function +) (mapcar (function (lambda ( c d ) (distance c d))) (cadr b) (append (cdr (cadr b)) (list (car (cadr b)))))))))))))
        (if plll
          (progn
            (entupd
              (cdr
                (assoc -1
                  (entmod
                    (setq lwx
                      (append
                        (subst (cons 90 (1+ (cdr (assoc 90 lwx)))) (assoc 90 lwx) (reverse (cdr (member (assoc 10 lwx) (reverse lwx)))))
                        (mapcar (function (lambda ( x ) (cons 10 x))) plll)
                      )
                    )
                  )
                )
              )
            )
            (setq pl (vl-remove-if (function (lambda ( x ) (if (vl-position x plll) (setq xx x)))) pl))
            (setq ppll (vl-remove-if (function (lambda ( x ) (vl-position x plll))) ppll))
            (setq pre (cadr (member xx (reverse (append plll plll)))) suf (cadr (member xx (append plll plll))))
            (setq xpl (cons xx xpl))
            (setq d (+ (distance pre xx) (distance xx suf)))
            (if (null ppll)
              (setq pplll (cdr pplll) ppll (car pplll) xpl nil d nil)
            )
            (setq ppp plll)
            (_do-events)
            (redraw lw)
          )
        )
        (setq plll nil)
      )
      (setq pl (mapcar (function cdr) (vl-remove-if (function (lambda ( x ) (/= (car x) 10))) lwx)))
      (setq lil (mapcar (function list) pl (append (cdr pl) (list (car pl)))))
      (setq k -1)
      (while (and (< (setq k (1+ k)) (length lil)) (setq a (nth k lil)))
        (setq ilil (vl-some (function (lambda ( b / ip ) (setq ip (inters (car a) (cadr a) (car b) (cadr b))) (if (and ip (setq ip (mapcar (function +) '(0 0) ip)) (or (and (or (equal ip (car a) 1e-6) (equal ip (cadr a) 1e-6)) (not (equal ip (car b) 1e-6)) (not (equal ip (cadr b) 1e-6))) (and (or (equal ip (car b) 1e-6) (equal ip (cadr b) 1e-6)) (not (equal ip (car a) 1e-6)) (not (equal ip (cadr a) 1e-6))) (and (not (equal ip (car a) 1e-6)) (not (equal ip (cadr a) 1e-6)) (not (equal ip (car b) 1e-6)) (not (equal ip (cadr b) 1e-6))))) (list a b)))) (vl-remove a lil)))
        (if ilil
          (progn
            (setq pre (reverse (cdr (member (car ilil) (reverse lil)))))
            (setq mid (cdr (member (car ilil) lil)))
            (setq mid (cdr (member (cadr ilil) (reverse mid))))
            (setq mid (mapcar (function reverse) mid))
            (setq suf (cdr (member (cadr ilil) lil)))
            (setq lil (append pre (list (list (car (car ilil)) (car (cadr ilil)))) mid (list (list (cadr (car ilil)) (cadr (cadr ilil)))) suf))
            (setq pre nil mid nil suf nil)
            (setq pl (mapcar (function car) lil))
            (entupd
              (cdr
                (assoc -1
                  (entmod
                    (append
                      (reverse (cdr (member (assoc 10 lwx) (reverse lwx))))
                      (mapcar (function (lambda ( x ) (cons 10 x))) pl)
                    )
                  )
                )
              )
            )
            (_do-events)
            (redraw lw)
            (setq ilil nil k -1)
          )
        )
      )
    )
  )
  (setvar 'cmdecho cmde)
  (princ)
)
