(defun c:blockflips ( / *error* osm cmd s gr p el bl0 bl1 bl2 bl3 )

  (vl-load-com)

  (defun *error* ( m )
    (if (= 8 (logand 8 (getvar 'undoctl)))
      (if command-s
        (command-s "_.UNDO" "_E")
        (vl-cmdf "_.UNDO" "_E")
      )
    )
    (if osm (setvar 'osmode osm))
    (if cmd (setvar 'cmdecho cmd))
    (if m (prompt m))
    (princ)
  )

  (alert "Place block insertion point on place that differs from WCS origin 0,0,0 (alignment must be different than WCS - moved or rotated)...")
  (vl-cmdf "_.UCS" "_W")
  (if (setq osm (getvar 'osmode)) (setvar 'osmode 0))
  (if (setq cmd (getvar 'cmdecho)) (setvar 'cmdecho 0))
  (if (= 8 (logand 8 (getvar 'undoctl)))
    (vl-cmdf "_.UNDO" "_E")
  )
  (vl-cmdf "_.UNDO" "_BE")
  (prompt "\nPick block for flipping...")
  (if (setq s (ssget "_+.:E:S:L" '((0 . "INSERT"))))
    (progn
      (setq bl0 (ssname s 0))
      (while (= 1 (getvar 'worlducs))
        (vl-cmdf "_.UCS" "_E" (cadr (grread t)))
        (entupd bl0)
      )
      (setq el (entlast))
      (repeat 3
        (vl-cmdf "_.COPY" bl0 "" "_non" (list 0.0 0.0 0.0) "_non" (list 0.0 0.0 0.0))
      )
      (setq el (entnext el))
      (vl-cmdf "_.MIRROR" el "" "_non" (list 0.0 0.0 0.0) "_non" (list 0.0 1.0 0.0) "_Y")
      (setq bl1 el)
      (setq el (entnext el))
      (vl-cmdf "_.MIRROR" el "" "_non" (list 1.0 0.0 0.0) "_non" (list 0.0 0.0 0.0) "_Y")
      (setq bl2 el)
      (setq el (entnext el))
      (vl-cmdf "_.MIRROR" el "" "_non" (list 0.0 0.0 0.0) "_non" (list 0.0 1.0 0.0) "_Y")   
      (vl-cmdf "_.MIRROR" el "" "_non" (list 1.0 0.0 0.0) "_non" (list 0.0 0.0 0.0) "_Y")
      (setq bl3 el)
      (if (= (getvar 'program) "BRICSCAD")
        (progn
          (setq s (ssadd))
          (ssadd bl1 s)
          (ssadd bl2 s)
          (ssadd bl3 s)
          (vl-cmdf "_.HIDEOBJECTS" s "")
        )
        (progn
          (redraw bl0 1)
          (redraw bl1 2)
          (redraw bl2 2)
          (redraw bl3 2)
        )
      )
      (prompt "\nPress any key from keyboard or right mouse click to finish...")
      (while (vl-position (car (setq gr (grread t))) (list 3 5))
        (if (and (listp (setq p (cadr gr))) (= (length p) 3) (vl-every 'numberp p))
          (cond
            ( (and (> (car p) 0.0) (> (cadr p) 0.0))
              (if (= (getvar 'program) "BRICSCAD")
                (progn
                  (vl-cmdf "_.UNISOLATEOBJECTS")
                  (setq s (ssadd))
                  (ssadd bl1 s)
                  (ssadd bl2 s)
                  (ssadd bl3 s)
                  (vl-cmdf "_.HIDEOBJECTS" s "")
                )
                (progn
                  (redraw bl0 1)
                  (redraw bl1 2)
                  (redraw bl2 2)
                  (redraw bl3 2)
                )
              )
            )
            ( (and (< (car p) 0.0) (> (cadr p) 0.0))
              (if (= (getvar 'program) "BRICSCAD")
                (progn
                  (vl-cmdf "_.UNISOLATEOBJECTS")
                  (setq s (ssadd))
                  (ssadd bl0 s)
                  (ssadd bl2 s)
                  (ssadd bl3 s)
                  (vl-cmdf "_.HIDEOBJECTS" s "")
                )
                (progn
                  (redraw bl0 2)
                  (redraw bl1 1)
                  (redraw bl2 2)
                  (redraw bl3 2)
                )
              )
            )
            ( (and (< (car p) 0.0) (< (cadr p) 0.0))
              (if (= (getvar 'program) "BRICSCAD")
                (progn
                  (vl-cmdf "_.UNISOLATEOBJECTS")
                  (setq s (ssadd))
                  (ssadd bl0 s)
                  (ssadd bl1 s)
                  (ssadd bl2 s)
                  (vl-cmdf "_.HIDEOBJECTS" s "")
                )
                (progn
                  (redraw bl0 2)
                  (redraw bl1 2)
                  (redraw bl2 2)
                  (redraw bl3 1)
                )
              )
            )
            ( (and (> (car p) 0.0) (< (cadr p) 0.0))
              (if (= (getvar 'program) "BRICSCAD")
                (progn
                  (vl-cmdf "_.UNISOLATEOBJECTS")
                  (setq s (ssadd))
                  (ssadd bl0 s)
                  (ssadd bl1 s)
                  (ssadd bl3 s)
                  (vl-cmdf "_.HIDEOBJECTS" s "")
                )
                (progn
                  (redraw bl0 2)
                  (redraw bl1 2)
                  (redraw bl2 1)
                  (redraw bl3 2)
                )
              )
            )
          )
        )
      )
      (cond
        ( (and (> (car p) 0.0) (> (cadr p) 0.0))
          (entdel bl1)
          (entdel bl2)
          (entdel bl3)
        )
        ( (and (< (car p) 0.0) (> (cadr p) 0.0))
          (entdel bl0)
          (entdel bl2)
          (entdel bl3)
        )
        ( (and (< (car p) 0.0) (< (cadr p) 0.0))
          (entdel bl0)
          (entdel bl1)
          (entdel bl2)
        )
        ( (and (> (car p) 0.0) (< (cadr p) 0.0))
          (entdel bl0)
          (entdel bl1)
          (entdel bl3)
        )
      )
    )
  )
  (vl-cmdf "_.UCS" "_P")
  (*error* nil)
)