;By Juan Villarreal
;Program will allow filtered object selection
;and provides dialog control for Unit Conversion and Unit precision
;allowing an additional conversion to be included in parenthesis as well.
;Output formats available include LineText Table, Autocad Table, txt and csv.

;Major mod. by M.R. [ Marko Ribar, d.i.a. (architect) ; @ribarm ; (ribarm@gmail.com) ] ; DATE : March 2022.

(defun C:AC ( / *error* ;;; error handler ;;;
                GetObjectId conv Ac_MakeList AcAddLtTable AcAddTable acwidthlist GetTableWidths LM:str->lst lst->str list->string Strlcat ac_dialog ;;; used sub functions ;;;
                Tot ss obj txtfieldstring vla-obj sarea labelkword pfa alst arealist ts wlist oldin Entpick ar sty *ActDoc* *Space* reportlist wpath ptlst vlaobjlst oldcmdecho fieldstring fname n pt count ll ur dcl_id pf fields from to sfx selprec unitlist conversionlist inverseconversionlist fn inc ids rprt labellist textename newnumb userclick realconversion realconversion2 oldluprec ;;; used variables ;;;
            )

  (or (not (vl-catch-all-error-p (vl-catch-all-apply (function vlax-get-acad-object) nil))) (vl-load-com)) ;;; load AciveX extensions (VLA FUNCTIONS) ;;;

  (defun *error* ( m )
    (if oldcmdecho
      (setvar 'cmdecho oldcmdecho)
    )
    (if oldluprec
      (setvar 'luprec oldluprec)
    )
    (if fname
      (vl-file-delete fname)
    )
    (vla-EndUndoMark *ActDoc*)
    (vla-Regen *ActDoc* acactiveviewport)
    (princ)
  )

  ;;; PRE SETTINGS ;;;

  ;--------------------------------------------------------------------------------------------------

  ;UNIT SELECTION
  ;0 = Inch
  ;1 = Foot
  ;2 = Yard
  ;3 = Acre
  ;4 = Mile
  ;5 = Millimeter
  ;6 = Centimeter
  ;7 = Meter
  ;8 = Kilometer
  ;9 = Microinch
  ;10 = Mil
  ;11 = Angstrom
  ;12 = Nanometer
  ;13 = Micron
  ;14 = Decimeter
  ;15 = Dekameter
  ;16 = Hectometer
  ;17 = Gigameter
  ;18 = Astronomical Unit
  ;19 = Light Year
  ;20 = Parsec

  ;-------------------------------------------------------------------------------------------------

  ;PRECISION SELECTION
  ;"0" thru "8"
  ;NIL to use luprec variable
  ;Example - "1" = 0.0
  ;        - "8" = 0.00000000

  (setq selprec nil) ;Default 'Convert to' Precision = (getvar 'luprec)

  ;-------------------------------------------------------------------------------------------------

  ;Report Type
  ;"LineText" "Table" "Txt" "Csv"
  ;Nil = "LineText"

  (or *reporttype* (setq *reporttype* "Table")) ;Default report type (global variable)

  (if (vl-position *reporttype* (list "txt" "csv"))
    (setq fields "0")
  )

  ;-------------------------------------------------------------------------------------------------

  ;;; USED SUB FUNCTIONS ;;;

  (defun GetObjectId ( obj doc )
    (if (vlax-method-applicable-p (vla-get-Utility doc) 'GetObjectIdString)
      (vlax-invoke-method (vla-get-Utility doc) 'GetObjectIdString obj :vlax-false)
      (itoa (vla-get-ObjectId obj))
    )
  )

  (defun conv ( conv1 conv2 )
    (* (nth conv1 inverseconversionlist) (nth conv2 conversionlist))
  )

  (defun Ac_MakeList ( key lst )
    (start_list key)
    (mapcar (function add_list) lst)
    (end_list)
  )

  (defun AcAddLtTable ( Title HeaderList listoflists / ts n p0 p1 p2 el1 dl cmpt oset wlist acwlist linelist string )
    (if (eq (setq ts (cdr (assoc 40 sty))) 0.0) (setq ts (getvar 'textsize)))
    (setq wlist (GetTableWidths listoflists ts))
    (setq p0 (getpoint "\nPick or specify point to place table : ")
          p1 (polar p0 0.0 (apply (function +) wlist))
    )
    (setq el1
      (vla-addline
        *Space*
        (vlax-3d-point (trans p0 1 0))
        (vlax-3d-point (trans p1 1 0))
      )
    )
    (vla-ArrayRectangular el1 (+ (length listoflists) 3) 1 1 (* -2.5 ts) 0.0 0.0)
    (setq dl (* (+ (length listoflists) 2) (* 2.5 ts))
          p2 (polar p0 (* pi 1.5) dl)
          el1 (vla-addline
                *Space*
                (vlax-3d-point (trans p0 1 0))
                (vlax-3d-point (trans p2 1 0))
              )
    )
    (setq linelist
      (list
        (setq el1
          (vla-addline
            *Space*
            (vlax-3d-point (trans (polar p0 (* pi 1.5) (* 2.5 ts)) 1 0))
            (vlax-3d-point (trans p2 1 0))
          )
        )
      )
    )
    (setq n 0)
    (repeat (length wlist)
      (and
        (nth n wlist)
        (vla-ArrayRectangular el1 1 2 1 0.0 (nth n wlist) 0.0)
        (setq el1 (vlax-ename->vla-object (entlast))
              n (1+ n)
        )
        (setq linelist (append linelist (list el1)))
      )
    )
    (mapcar (function vla-delete) (list (car linelist) (last linelist)))
    (vla-addline
      *Space*
      (vlax-3d-point (trans p1 1 0))
      (vlax-3d-point (trans (polar p2 0.0 (apply (function +) wlist)) 1 0))
    )
    (setq p2 (polar p0 (* pi 1.5) (* 6.25 ts))
          p2 (polar p2 0.0 (* ts 0.5 (cdr (assoc 41 sty))))
          cmpt 0
          oset (* ts -0.5)
    )
    (setq acwlist (acwidthlist wlist))
    (repeat (length listoflists)
      (setq n 0)
      (repeat (length Headerlist)
        (setq tloc (list
                     (car (polar p2 0.0 (- (nth n acwlist) (nth n wlist))))
                     (+ (cadr (polar p2 0.0 (- (nth n acwlist) (nth n wlist)))) oset)
                   )
              string (nth n (nth cmpt listoflists))
              n (1+ n)
        )
        (vla-addMtext
          *Space*
          (vlax-3d-point (trans (polar tloc (* 0.5 pi) ts) 1 0))
          0.0
          string
        )
        (vla-put-height (vlax-ename->vla-object (entlast)) (getvar 'textsize))
        (vla-put-attachmentpoint (vlax-ename->vla-object (entlast)) acAttachmentPointTopLeft)
      )
      (setq cmpt (1+ cmpt)
            oset (- oset (* 2.5 ts))
      )
    )
    (setq p0 (polar p0 (* pi 1.5) (* 1.75 ts))
          p0 (polar p0 0.0 (* ts 0.5 (cdr (assoc 41 sty))))
    )
    (vla-addMtext
      *Space*
      (vlax-3d-point
        (trans
          (polar
            (polar p0 0.0
              (- (/ (car (reverse acwlist)) 2)
                 (/ (car (mapcar (function (lambda ( x ) (distance (car x) (cadr x)))) (list (textbox (list (cons 1 Title) (assoc 41 sty)))))) 2)
              )
            )
            (* 0.5 pi)
            ts
          )
          1 0
        )
      )
      0.0
      Title
    )
    (vla-put-height (vlax-ename->vla-object (entlast)) (getvar 'textsize))
    (vla-put-attachmentpoint (vlax-ename->vla-object (entlast)) acAttachmentPointTopLeft)
    (setq p0 (polar p0 (* pi 1.5) (* 2.5 ts)))
    (setq n 0)
    (repeat (length Headerlist)
      (vla-addMtext
        *Space*
        (vlax-3d-point (trans (polar (polar p0 0.0 (- (nth n acwlist) (nth n wlist))) (* 0.5 pi) ts) 1 0))
        0.0
        (nth n HeaderList)
      )
      (vla-put-height (vlax-ename->vla-object (entlast)) (getvar 'textsize))
      (vla-put-attachmentpoint (vlax-ename->vla-object (entlast)) acAttachmentPointTopLeft)
      (setq n (1+ n))
    )
  )

  (defun AcAddTable ( comparelist Title Headerlist listoflists / ts i n p0 wlist ots )
    (setq ots (getvar 'textsize)
          ts (vla-gettextheight (vla-item (vla-item (vla-get-dictionaries *ActDoc*) "ACAD_TABLESTYLE") "Standard") acDataRow)
    )
    (if ts
      (setvar 'textsize ts)
    )
    (setq p0 (getpoint "\nPick or specify point to place table : ")
          tblObj
          (vla-addTable
            *Space*
            (vlax-3D-point (trans p0 1 0))
            (+ (length listoflists) 2) 
            (length comparelist)
            (* 2.5 ts)
            (* 50.0 ts)
          )
    )
    (vla-put-StyleName tblObj "Standard")
    (vla-setText tblObj 0 0 Title)
    (setq wlist (GetTableWidths listoflists ts))
    (setq n 0)
    (repeat (length comparelist)
      (vla-setText tblobj 1 n (nth (nth n comparelist) Headerlist))
      (setq n (1+ n))
    )
    (setq i 1)
    (foreach x listoflists
      (setq n 0 i (1+ i))
      (repeat (length comparelist)
        (vla-setText tblobj i n (nth (nth n comparelist) x))
        (setq n (1+ n))
      )
    )
    (setq i -1)
    (mapcar
      (function
        (lambda ( x )
          (vla-setcolumnwidth tblobj (setq i (1+ i)) x)
        )
      )
      wlist
    )
    (setvar 'textsize ots)
  )

  (defun acwidthlist ( wlist / acwlist )
    (repeat (length wlist)
      (setq acwlist (cons (apply (function +) wlist) acwlist)
            wlist (reverse (cdr (reverse wlist)))
      )
    )
    acwlist
  )

  (defun GetTableWidths ( alst ts / gw wlist )

    (defun gw ( ind hdr )
      (+
        (apply (function max)
          (mapcar
            (function
              (lambda ( x )
                (- (caadr x) (caar x))
              )
            )
            (cons
              (textbox (list (cons 1 hdr)))
              (mapcar
                (function
                  (lambda ( y )
                    (textbox (list (cons 1 (nth ind y))))
                  )
                )
                alst
              )
            )
          )
        )
        (* 2 ts)
      )
    )

    (setq wlist
      (list
        (gw 3 "ID")
        (gw 4 (nth from unitlist))
      )
    )
    (if (/= from to)
      (setq wlist
        (append
          wlist
          (list
            (gw 5 (nth to unitlist))
          )
        )
      )
    )
    wlist
  )

  (defun LM:str->lst ( str del / len lst pos ) ;(Lee Mac)
    (setq len (1+ (strlen del)))
    (while (setq pos (vl-string-search del str))
      (setq lst (cons (substr str 1 pos) lst)
            str (substr str (+ pos len))
      )
    )
    (reverse (cons str lst))
  )

  (defun lst->str ( lst d1 d2 ) ;(Lee Mac)
    (if (cdr lst)
      (strcat d1 (car lst) d2 (lst->str (cdr lst) d1 d2))
      (strcat d1 (car lst))
    )
  )

  (defun list->string ( lst ) ;(Tony Tanzillo)
    (strlcat ","
      (mapcar
        (function
          (lambda ( s )
            (if (numberp s) 
              (rtos s) 
              (strcat (chr 34) s (chr 34))
            )
          )
        )
        lst
      )
    )
  )

  (defun Strlcat ( delim strlst ) ;(Tony Tanzillo)
    (apply (function strcat)
      (cons 
        (car strlst)
        (mapcar
          (function
            (lambda ( s )
              (strcat delim s)
            )
          )
          (cdr strlst)
        )
      )
    )
  )

  (defun ac_dialog ( fname / fn )
    (if (findfile fname)
      (setq fn (open fname "w"))
      (if
        (and
          (setq wPath
            (car
              (LM:str->lst (vla-get-supportpath (vla-get-files (vla-get-preferences (vlax-get-acad-object)))) ";")
            )
          )
          (or
            (eq "\\" (substr wPath (strlen wPath)))
            (setq wPath (strcat wPath "\\"))
          )
        )
        (setq fn (open (strcat wPath fname) "w"))
      )
    )
    (foreach ssss
      (list
        "button07 : button   { width = 7; alignment = centered; fixed_width = true; }"
        "text18 : text   { width = 18; alignment = centered; fixed_width = true; }"
        "text12 : text   { width = 12; alignment = centered; fixed_width = true; }"
        "text10 : text   { width = 10; alignment = centered; fixed_width = true; }"
        "AreaCalc : dialog { label = \"Results\";"
        "   :row {"
        "     :text { label = \"Prefix:\"; alignment = centered; }"
        "     :text { label = \"Initial #:\"; alignment = centered; }"
        "   }"
        "   :row {"
        "     :edit_box { key = \"Pfx\"; alignment = centered; edit_limit = 20; edit_width = 20; }"
        "     :edit_box { key = \"init\"; alignment = centered; edit_limit = 20; edit_width = 20; }"
        "   }"
        "   :row {"
        "     :toggle { key = \"kword\"; label = \"Label Areas\"; alignment = centered; }"
        "     :toggle { key = \"fields\"; label = \"Use Fields\"; alignment = centered; }"
        "   }"
        "  :boxed_column { label = \"Area Conversion and Precision\";"
        "   :row {"
        "   :column {"
        "     spacer;"
        "     :text12 { label = \"Convert From :\"; }"
        "     spacer;"
        "     :text12 { label = \"Convert To :\"; }"
        "     spacer;"
        "     :toggle { key = \"include\"; label = \"Scale Factor :\"; alignment = centered; }"
        "     spacer;"
        "     :text12 { label = \"Total :\"; }"
        "     :text12 { label = \"Converted :\"; }"
        "   }"
        "   :column {"
        "     spacer;"
        "     :popup_list { key = \"Selection1\"; alignment = left; edit_width = 10; }"
        "     spacer;"
        "     :popup_list { key = \"Selection2\"; alignment = left; edit_width = 10; }"
        "     spacer;"
        "     :edit_box { key = \"scf\"; alignment = left; edit_width = 10; }"
        "     spacer;"
        "     :text12 { key = \"Original\"; }"
        "     :text12 { key = \"Converted\"; }"
        "   }"
        "  }}"
        "   :boxed_row { label = \"Precision\"; alignment = left;"
        "     :popup_list { key = \"CurrPrec\"; alignment = left; edit_width = 10; }"
        "  }"
        "  :boxed_row { label = \"Report Format\"; alignment = left;"
        "     :popup_list { key = \"Selection4\"; alignment = left; edit_width = 18; }"
        "  }"
        "  ok_cancel;"
        "}"
      )
      (write-line ssss fn)
    )
    (close fn)
  )



  ;;; MAIN ROUTINE ;;;



  (setq oldcmdecho (getvar 'cmdecho)
        oldluprec (getvar 'luprec)
        fname "xxxx.dcl" ;;; any name for DCL file ;;;
        ts (getvar 'textsize)
        sty (tblsearch "STYLE" (getvar 'textstyle))
        *ActDoc* (vla-get-ActiveDocument (vlax-get-Acad-Object))
        *Space* (vla-get-Block (vla-get-ActiveLayout *ActDoc*))
  )
  (vla-Regen *ActDoc* acactiveviewport)
  (if (= 8 (logand 8 (getvar 'undoctl)))
    (vla-EndUndoMark *ActDoc*)
  )
  (vla-StartUndoMark *ActDoc*)
  (setvar 'cmdecho 0)
  (initget "ANY POLYLINE CIRCLE ELLIPSE REGION SPLINE HATCH")
  (setq Entpick (getkword "\nObject Filter [ ANY / POLYLINE / CIRCLE / ELLIPSE / REGION / SPLINE / HATCH ] <ANY> : "))
  (while (not ss)
    (setq ss
      (ssget
        (list
          (if (vl-position Entpick '("ANY" nil))
            (cons 0 "*POLYLINE,CIRCLE,ELLIPSE,REGION,SPLINE,HATCH")
            (cons 0 (strcat "*" Entpick))
          )
        )
      )
    )
  )
  (setq n (sslength ss))
  (setq Tot 0.0)
  (while (setq obj (ssname ss (setq n (1- n))))
    (if (setq ar (vlax-curve-getarea obj))
      (progn
        (setq Tot (+ Tot ar)
              arealist (append arealist (list ar))
              vlaobjlst (append vlaobjlst (list (setq vla-obj (vlax-ename->vla-object obj))))
        )
        (vla-getboundingbox vla-obj 'll 'ur)
        (setq ll (safearray-value ll)
              ur (safearray-value ur)
              pt (mapcar (function (lambda ( a b ) (/ (+ a b) 2.0))) ll ur)
        )
        (setq ptlst (append ptlst (list pt)))
      )
    )
  )
  (or arealist (progn (*error* "\nNo closed objects selected... Quitting...") (exit)))
  (ac_dialog fname)
  (if (< 0 (setq dcl_id (load_dialog fname)))
    (if (not (new_dialog "AreaCalc" dcl_id "" '(-1 -1)))
      (progn (*error* "\nUnable to create dialog : (new_dialog) error... Quitting...") (exit))
    )
    (progn (*error* "\nUnable to load dialog : (load_dialog) returned negative value error... Quitting...") (exit))
  )
  (or pf (setq pf "Area"))
  (or fields (setq fields "0"))
  (or oldin (setq oldin 1))
  (or from (setq from 0))
  (or to (setq to 0))
  (or sfx (setq sfx 1.0))
  (or inc (setq inc 0))
  (or selprec (setq selprec (itoa (getvar 'luprec))))
  (setq labelkword "Yes"
        unitlist (list "SQ IN" "SQ FT" "SQ YDS" "ACRES" "SQ MILES"
                       "SQ MM" "SQ CM" "SQ M" "SQ KM" "SQ MICROIN"
                       "SQ MILS" "SQ ANGSTROMS" "SQ NANOM"
                       "SQ MICRONS" "SQ DECIM" "SQ DEKAM" "SQ HECTOM"
                       "SQ GIGAM" "SQ ASTRO UNITS" "SQ LIGHT YEARS" "SQ PARSECS")
        conversionlist
          (append
            (mapcar
              (function
                (lambda ( x )
                  (expt x 2)
                )
              )
              (list
                1.0                        ;Inch 1
                (/ 1.0 12)                 ;Foot 2
                (/ 1.0 (* 3 12))           ;Yard 10
                (/ 1.0 (* (sqrt 43560) 12));Acre ;extra unit included
                (/ 1.0 (* 5280 12))        ;Mile 3
                (* 10.0 2.54)              ;Millimeter 4
                2.54                       ;Centimeter 5
                (* (expt 10.0 -2) 2.54)    ;Meter 6
                (* (expt 10.0 -5) 2.54)    ;Kilometer 7
                (expt 10.0 6)              ;Microinch 8
                (expt 10.0 3)              ;Mil 9
                (* (expt 10.0 8) 2.54)     ;Angstrom 11
                (* (expt 10.0 7) 2.54)     ;Nanometer 12
                (* (expt 10.0 4) 2.54)     ;Micron 13
                (* (expt 10.0 -1) 2.54)    ;Decimeter 14
                (* (expt 10.0 -3) 2.54)    ;Dekameter 15
                (* (expt 10.0 -4) 2.54)    ;Hectometer 16
                (* (expt 10.0 -11) 2.54)   ;Gigameter 17
              )
            )
            (list (* (expt 10.0 -26) 2.88280893);Astronomical Unit 18
                  (* (expt 10.0 -36) 7.20836294);Light Year 19
                  (* (expt 10.0 -37) 6.77587822);Parsec 20
            )
          )
        inverseconversionlist
          (mapcar
            (function
              (lambda ( x )
                (/ 1.0 x)
              )
            )
            conversionlist
          )
  )
  (set_tile "fields" fields)
  (set_tile "Pfx" pf)
  (set_tile "init" (itoa oldin))
  (set_tile "kword" "1")
  (set_tile "Converted" (rtos Tot 2 (atoi selprec)))
  (set_tile "include" (itoa inc))
  (Ac_MakeList "CurrPrec" (list "0" "0.0" "0.00" "0.000" "0.0000" "0.00000" "0.000000" "0.0000000" "0.00000000"))
  (set_tile "CurrPrec" selprec)
  (foreach key (list "Selection1" "Selection2")
    (Ac_MakeList key unitlist)
  )
  (if from
    (set_tile "Selection1" (itoa from))
  )
  (if to
    (set_tile "Selection2" (itoa to))
  )
  (if sfx
    (set_tile "scf" (rtos sfx 2 2))
  )
  (setq realconversion (conv from to))
  (set_tile "Converted" (rtos (* realconversion Tot) 2 (atoi selprec)))
  (set_tile "Original" (rtos Tot 2 (atoi selprec)))
  (Ac_MakeList "Selection4" (setq reportlist (list "LineText" "Table" "txt" "csv")))
  (set_tile "Selection4" (itoa (vl-position *reporttype* reportlist)))
  (action_tile "Pfx"
    (vl-prin1-to-string
      (quote
        (setq pf $value)
      )
    )
  )
  (action_tile "init"
    (vl-prin1-to-string
      (quote
        (if (= $value "")
          (setq oldin 1)
          (setq oldin (atoi $value))
        )
      )
    )
  )
  (action_tile "kword"
    (vl-prin1-to-string
      (quote
        (setq labelkword (if (= $value "1") "Yes" "No"))
      )
    )
  )
  (action_tile "fields"
    (vl-prin1-to-string
      (quote
        (if (vl-position *reporttype* (list "txt" "csv"))
          (set_tile "fields" (setq fields "0"))
          (setq fields $value)
        )
      )
    )
  )
  (action_tile "Selection1"
    (vl-prin1-to-string
      (quote
        (progn
          (setq from (atoi $value)
                to (atoi (get_tile "Selection2"))
                realconversion (conv from to)
                realconversion2 (if (= (get_tile "include") "1") (atof (get_tile "scf")) 1.0)
          )
          (set_tile "Original" (rtos Tot 2 (atoi selprec)))
          (set_tile "Converted" (rtos (* Tot realconversion realconversion2) 2 (atoi selprec)))
        )
      )
    )
  )
  (action_tile "Selection2"
    (vl-prin1-to-string
      (quote
        (progn
          (setq to (atoi $value)
                from (atoi (get_tile "Selection1"))
                realconversion (conv from to)
                realconversion2 (if (= (get_tile "include") "1") (atof (get_tile "scf")) 1.0)
          )
          (set_tile "Original" (rtos Tot 2 (atoi selprec)))
          (set_tile "Converted" (rtos (* Tot realconversion realconversion2) 2 (atoi selprec)))
        )
      )
    )
  )
  (action_tile "scf"
    (vl-prin1-to-string
      (quote
        (progn
          (if (= (atoi (get_tile "include")) 1)
            (setq sfx (atof $value))
            (setq sfx 1.0)
          )
          (setq realconversion2 sfx
                realconversion (conv from to)
          )
          (set_tile "Original" (rtos Tot 2 (atoi selprec)))
          (set_tile "Converted" (rtos (* Tot realconversion realconversion2) 2 (atoi selprec)))
        )
      )
    )
  )
  (action_tile "CurrPrec"
    (vl-prin1-to-string
      (quote
        (progn
          (setq selprec $value
                realconversion (conv from to)
                realconversion2 (if (= (get_tile "include") "1") (atof (get_tile "scf")) 1.0)
          )
          (set_tile "Original" (rtos Tot 2 (atoi selprec)))
          (set_tile "Converted" (rtos (* Tot realconversion realconversion2) 2 (atoi selprec)))
        )
      )
    )
  )
  (action_tile "include"
    (vl-prin1-to-string
      (quote
        (if (= (setq inc (atoi $value)) 1)
          (progn
            (setq sfx (atof (get_tile "scf"))
                  realconversion2 sfx
                  realconversion (conv from to)
            )
            (set_tile "Original" (rtos Tot 2 (atoi selprec)))
            (set_tile "Converted" (rtos (* Tot realconversion realconversion2) 2 (atoi selprec)))
          )
          (progn
            (setq from (atoi (get_tile "Selection1"))
                  to (atoi (get_tile "Selection2"))
                  realconversion (conv from to)
                  realconversion2 1.0
            )
            (set_tile "Original" (rtos Tot 2 (atoi selprec)))
            (set_tile "Converted" (rtos (* Tot realconversion realconversion2) 2 (atoi selprec)))
          )
        )
      )
    )
  )
  (action_tile "Selection4"
    (vl-prin1-to-string
      (quote
        (progn
          (setq *reporttype* (nth (atoi $value) reportlist))
          (if (vl-position *reporttype* (list "txt" "csv"))
            (setq fields "0")
          )
          (set_tile "fields" fields)
        )
      )
    )
  )
  (action_tile "accept"
    (vl-prin1-to-string
      (quote
        (progn
          (setq userclick t)
          (done_dialog)
        )
      )
    )
  )
  (start_dialog)
  (unload_dialog dcl_id)
  (if userclick
    (progn
      (or realconversion2 (setq realconversion2 1.0))
      (setq count 0)
      (if (= labelkword "Yes")
        (foreach x ptlst
          (setq textename
            (vla-addMText
              *Space*
              (vlax-3d-point x)
              0.0
              (strcat pf " " (itoa (+ oldin count)))
            )
            count (1+ count)
          )
          (vla-put-height textename (getvar 'textsize))
          (vla-put-attachmentpoint textename acAttachmentPointMiddleCenter)
          (setq labellist (append labellist (list textename)))
        )
      )
      (setq n -1)
      (repeat (sslength ss)
        (setq n (1+ n)
              sarea (nth n arealist)
              fieldstring (GetObjectId (nth n vlaobjlst) *ActDoc*)
              ar (list
                   (if (= labelkword "Yes")
                     (if (= fields "1")
                       (strcat "%<\\AcObjProp.16.2 Object(%<\\_ObjId " (GetObjectId (nth n labellist) *ActDoc*) ">%).TextString>%")
                       (progn
                         (vla-put-textstring (nth n labellist) (strcat pf " " (itoa (+ oldin n))))
                         (strcat pf " " (itoa (+ oldin n)))
                       )
                     )
                     (if labellist
                       (vla-delete (nth n labellist))
                       ""
                     )
                   )
                   (if (= fields "1")
                     (strcat
                       "%<\\AcObjProp Object(%<\\_ObjId "
                       fieldstring
                       (strcat
                         ">%).Area \\f \"%lu2%pr"
                         selprec
                         "%ct8["
                         "1.0" ;;;(rtos realconversion2 2 30)
                         "]\">%"
                       )
                     )
                     (rtos (setq newnumb sarea ;|(* realconversion sarea)|;) 2 (atoi selprec))
                   )
                   (if (= fields "1")
                     (strcat
                       "%<\\AcObjProp Object(%<\\_ObjId "
                       fieldstring
                       (strcat
                         ">%).Area \\f \"%lu2%pr"
                         selprec
                         "%ct8["
                         (rtos (* realconversion realconversion2) 2 30)
                         "]\">%"
                       )
                     )
                     (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
                   )
                   (strcat pf " " (itoa (1- (+ oldin n))))
                   (rtos (setq newnumb sarea ;|(* realconversion2 sarea)|;) 2 (atoi selprec))
                   (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
                 )
              alst (append alst (list ar))
              ids (append ids (list fieldstring))
        )
      )
      (if (= *reporttype* "LineText")
        (setq alst
          (append alst
            (list
              (list
                "TOTAL" 
                (if (= fields "1")
                  (if (= (length ids) 1)
                    (strcat
                      "%<\\AcObjProp Object(%<\\_ObjId "
                      fieldstring
                      (strcat
                        ">%).Area \\f \"%lu2%pr"
                        selprec
                        "%ct8["
                        "1.0" ;;;(rtos realconversion2 2 30)
                        "]\">%"
                      )
                    )
                    (strcat
                      "%<\\AcExpr ("
                      (lst->str
                        ids
                        "%<\\AcObjProp Object(%<\\_ObjId "
                        ">%).Area>%+"
                      )
                      (strcat
                        ">%).Area>%) \\f \"%lu2%pr"
                        selprec
                        "%ct8["
                        "1.0" ;;;(rtos realconversion2 2 30)
                        "]\">%"
                      )
                    )
                  )
                  (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                )
                (if (= fields "1")
                  (if (= (length ids) 1)
                    (strcat
                      "%<\\AcObjProp Object(%<\\_ObjId "
                      fieldstring
                      (strcat
                        ">%).Area \\f \"%lu2%pr"
                        selprec
                        "%ct8["
                        (rtos (* realconversion realconversion2) 2 30)
                        "]\">%"
                      )
                    )
                    (strcat "%<\\AcExpr ("
                      (lst->str
                        ids
                        "%<\\AcObjProp Object(%<\\_ObjId "
                        ">%).Area>%+"
                      )
                      (strcat
                        ">%).Area>%) \\f \"%lu2%pr"
                        selprec
                        "%ct8["
                        (rtos (* realconversion realconversion2) 2 30)
                        "]\">%"
                      )
                    )
                  )
                  (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
                )
                "TOTAL"
                (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
              )
            )
          )
        )
      )
      (cond
        ( (= *reporttype* "txt")
          (setq rprt (vl-filename-mktemp (strcat "Area Report." *reporttype*)))
          (setq fn (open rprt "w"))
          (foreach x alst
            (write-line
              (if (/= from to)
                (strcat
                  "\n"
                  (car x)
                  " = "
                  (cadr x)
                  " "
                  (nth from unitlist)
                  " "
                  (caddr x)
                  " "
                  (nth to unitlist)
                )
                (strcat
                  "\n"
                  (car x)
                  " = "
                  (cadr x)
                  " "
                  (nth from unitlist)
                )
              )
              fn
            )
          )
          (write-line
            (if (/= from to)
              (strcat
                "\nTotal = "
                (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                " "
                (nth from unitlist)
                " "
                (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
                " "
                (nth to unitlist)
              )
              (strcat
                "\nTotal = "
                (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                " "
                (nth from unitlist)
              )
            )
            fn
          )
          (close fn)
          (startapp "EXPLORER" rprt)
        )
        ( (= *reporttype* "csv")
          (setq rprt (vl-filename-mktemp (strcat "Area Report." *reporttype*)))
          (setq fn (open rprt "w"))
          (write-line "Area Report" fn)
          (write-line (list->string (if (/= from to) (list "ID" (nth from unitlist) (nth to unitlist)) (list "ID" (nth from unitlist)))) fn)
          (foreach x alst
            (write-line (list->string (if (/= from to) (list (car x) (cadr x) (caddr x)) (list (car x) (cadr x)))) fn)
          )
          (write-line (list->string (if (/= from to)
                                      (list
                                        "Total"
                                        (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                                        (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
                                      )
                                      (list
                                        "Total"
                                        (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                                      )
                                    )
                      )
                      fn
          )
          (close fn)
          (startapp "EXPLORER" rprt)
        )
        ( (= *reporttype* "LineText")
          (AcAddLtTable
            "AREA TABLE"
            (if (/= from to) (list "ID" (nth from unitlist) (nth to unitlist)) (list "ID" (nth to unitlist)))
            alst
          )
        )
        ( (= *reporttype* "Table")
          (AcAddTable
            (if (/= from to) '(0 1 2) '(0 1))
            "AREA TABLE"
            (if (/= from to) (list "ID" (nth from unitlist) (nth to unitlist)) (list "ID" (nth to unitlist)))
            (append alst
                    (list
                      (list
                        "TOTAL"
                        (if (= fields "1")
                          (strcat "%<\\AcExpr (" (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 30) ") \\f \"%lu2%pr" selprec "\">%")
                          (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                        )
                        (if (= fields "1")
                          (strcat "%<\\AcExpr (" (rtos (* realconversion realconversion2 newnumb) 2 30) ") \\f \"%lu2%pr" selprec "\">%")
                          (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
                        )
                        "TOTAL"
                        (rtos (setq newnumb Tot ;|(* Tot realconversion2)|;) 2 (atoi selprec))
                        (rtos (* realconversion realconversion2 newnumb) 2 (atoi selprec))
                      )
                    )
            )
          )
        )
      )
    )
  )
  (*error* nil)
)
